/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model.dotcorpus;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.uima.caseditor.core.model.dotcorpus.DotCorpus;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.util.XMLSerializer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DotCorpusSerializer {
    private static final String CONFIG_ELEMENT = "config";
    private static final String CORPUS_ELEMENT = "corpus";
    private static final String CORPUS_FOLDER_ATTRIBUTE = "folder";
    private static final String STYLE_ELEMENT = "style";
    private static final String STYLE_TYPE_ATTRIBUTE = "type";
    private static final String STYLE_STYLE_ATTRIBUTE = "style";
    private static final String STYLE_COLOR_ATTRIBUTE = "color";
    private static final String STYLE_LAYER_ATTRIBUTE = "layer";
    private static final String STYLE_CONFIG_ATTRIBUTE = "config";
    private static final String TYPESYSTEM_ELEMENT = "typesystem";
    private static final String TYPESYTEM_FILE_ATTRIBUTE = "file";
    private static final String CAS_PROCESSOR_ELEMENT = "processor";
    private static final String CAS_PROCESSOR_FOLDER_ATTRIBUTE = "folder";
    private static final String EDITOR_ELEMENT = "editor";
    private static final String EDITOR_LINE_LENGTH_ATTRIBUTE = "line-length-hint";
    private static final String SHOWN_ELEMENT = "shown";
    private static final String SHOWN_TYPE_ATTRIBUTE = "type";
    private static final String SHOWN_IS_VISISBLE_ATTRIBUTE = "visible";

    public static DotCorpus parseDotCorpus(InputStream dotCorpusStream) throws CoreException {
        Document dotCorpusDOM;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFacoty = XMLUtils.createDocumentBuilderFactory();
        try {
            documentBuilder = documentBuilderFacoty.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String message = "This should never happen:" + (e.getMessage() != null ? e.getMessage() : "");
            Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        try {
            dotCorpusDOM = documentBuilder.parse(dotCorpusStream);
        }
        catch (SAXException e) {
            String message = e.getMessage() != null ? e.getMessage() : "";
            Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        catch (IOException e) {
            String message = e.getMessage() != null ? e.getMessage() : "";
            Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        DotCorpus dotCorpus = new DotCorpus();
        Element configElement = dotCorpusDOM.getDocumentElement();
        if ("config".equals(configElement.getNodeName())) {
            // empty if block
        }
        NodeList corporaChildNodes = configElement.getChildNodes();
        for (int i = 0; i < corporaChildNodes.getLength(); ++i) {
            String type;
            Node corporaChildNode = corporaChildNodes.item(i);
            if (!(corporaChildNode instanceof Element)) continue;
            Element corporaChildElement = (Element)corporaChildNode;
            if (TYPESYSTEM_ELEMENT.equals(corporaChildElement.getNodeName())) {
                dotCorpus.setTypeSystemFilename(corporaChildElement.getAttribute(TYPESYTEM_FILE_ATTRIBUTE));
                continue;
            }
            if (CORPUS_ELEMENT.equals(corporaChildElement.getNodeName())) {
                String corpusFolderName = corporaChildElement.getAttribute("folder");
                dotCorpus.addCorpusFolder(corpusFolderName);
                continue;
            }
            if ("style".equals(corporaChildElement.getNodeName())) {
                int drawingLayer;
                type = corporaChildElement.getAttribute("type");
                String styleString = corporaChildElement.getAttribute("style");
                int colorInteger = Integer.parseInt(corporaChildElement.getAttribute(STYLE_COLOR_ATTRIBUTE));
                Color color = new Color(colorInteger);
                String drawingLayerString = corporaChildElement.getAttribute(STYLE_LAYER_ATTRIBUTE);
                String drawingConfigString = corporaChildElement.getAttribute("config");
                if (drawingConfigString.length() == 0) {
                    drawingConfigString = null;
                }
                try {
                    drawingLayer = Integer.parseInt(drawingLayerString);
                }
                catch (NumberFormatException e) {
                    drawingLayer = 0;
                }
                AnnotationStyle style = new AnnotationStyle(type, AnnotationStyle.Style.valueOf(styleString), color, drawingLayer, drawingConfigString);
                dotCorpus.setStyle(style);
                continue;
            }
            if (CAS_PROCESSOR_ELEMENT.equals(corporaChildElement.getNodeName())) {
                dotCorpus.addCasProcessorFolder(corporaChildElement.getAttribute("folder"));
                continue;
            }
            if (EDITOR_ELEMENT.equals(corporaChildElement.getNodeName())) {
                String lineLengthHintString = corporaChildElement.getAttribute(EDITOR_LINE_LENGTH_ATTRIBUTE);
                int lineLengthHint = Integer.parseInt(lineLengthHintString);
                dotCorpus.setEditorLineLength(lineLengthHint);
                continue;
            }
            if (SHOWN_ELEMENT.equals(corporaChildElement.getNodeName())) {
                type = corporaChildElement.getAttribute("type");
                String isVisisbleString = corporaChildElement.getAttribute(SHOWN_IS_VISISBLE_ATTRIBUTE);
                boolean isVisible = Boolean.parseBoolean(isVisisbleString);
                if (!isVisible) continue;
                dotCorpus.setShownType(type);
                continue;
            }
            String message = "Unexpected element: " + corporaChildElement.getNodeName();
            Status s = new Status(4, "org.apache.uima.caseditor", 0, message, null);
            throw new CoreException((IStatus)s);
        }
        return dotCorpus;
    }

    public static void serialize(DotCorpus dotCorpus, OutputStream out) throws CoreException {
        XMLSerializer xmlSerializer = new XMLSerializer(out, true);
        ContentHandler xmlSerHandler = xmlSerializer.getContentHandler();
        try {
            xmlSerHandler.startDocument();
            xmlSerHandler.startElement("", "config", "config", new AttributesImpl());
            for (String corpusFolder : dotCorpus.getCorpusFolderNameList()) {
                AttributesImpl corpusFolderAttributes = new AttributesImpl();
                corpusFolderAttributes.addAttribute("", "", "folder", "", corpusFolder);
                xmlSerHandler.startElement("", CORPUS_ELEMENT, CORPUS_ELEMENT, corpusFolderAttributes);
                xmlSerHandler.endElement("", CORPUS_ELEMENT, CORPUS_ELEMENT);
            }
            for (AnnotationStyle style : dotCorpus.getAnnotationStyles()) {
                AttributesImpl styleAttributes = new AttributesImpl();
                styleAttributes.addAttribute("", "", "type", "", style.getAnnotation());
                styleAttributes.addAttribute("", "", "style", "", style.getStyle().name());
                Color color = style.getColor();
                Integer colorInt = new Color(color.getRed(), color.getGreen(), color.getBlue()).getRGB();
                styleAttributes.addAttribute("", "", STYLE_COLOR_ATTRIBUTE, "", colorInt.toString());
                styleAttributes.addAttribute("", "", STYLE_LAYER_ATTRIBUTE, "", Integer.toString(style.getLayer()));
                if (style.getConfiguration() != null) {
                    styleAttributes.addAttribute("", "", "config", "", style.getConfiguration());
                }
                xmlSerHandler.startElement("", "style", "style", styleAttributes);
                xmlSerHandler.endElement("", "style", "style");
            }
            for (String type : dotCorpus.getShownTypes()) {
                AttributesImpl shownAttributes = new AttributesImpl();
                shownAttributes.addAttribute("", "", "type", "", type);
                shownAttributes.addAttribute("", "", SHOWN_IS_VISISBLE_ATTRIBUTE, "", "true");
                xmlSerHandler.startElement("", SHOWN_ELEMENT, SHOWN_ELEMENT, shownAttributes);
                xmlSerHandler.endElement("", SHOWN_ELEMENT, SHOWN_ELEMENT);
            }
            if (dotCorpus.getTypeSystemFileName() != null) {
                AttributesImpl typeSystemFileAttributes = new AttributesImpl();
                typeSystemFileAttributes.addAttribute("", "", TYPESYTEM_FILE_ATTRIBUTE, "", dotCorpus.getTypeSystemFileName());
                xmlSerHandler.startElement("", TYPESYSTEM_ELEMENT, TYPESYSTEM_ELEMENT, typeSystemFileAttributes);
                xmlSerHandler.endElement("", TYPESYSTEM_ELEMENT, TYPESYSTEM_ELEMENT);
            }
            for (String folder : dotCorpus.getCasProcessorFolderNames()) {
                AttributesImpl taggerConfigAttributes = new AttributesImpl();
                taggerConfigAttributes.addAttribute("", "", "folder", "", folder);
                xmlSerHandler.startElement("", CAS_PROCESSOR_ELEMENT, CAS_PROCESSOR_ELEMENT, taggerConfigAttributes);
                xmlSerHandler.endElement("", CAS_PROCESSOR_ELEMENT, CAS_PROCESSOR_ELEMENT);
            }
            if (dotCorpus.getEditorLineLengthHint() != 80) {
                AttributesImpl editorLineLengthHintAttributes = new AttributesImpl();
                editorLineLengthHintAttributes.addAttribute("", "", EDITOR_LINE_LENGTH_ATTRIBUTE, "", Integer.toString(dotCorpus.getEditorLineLengthHint()));
                xmlSerHandler.startElement("", EDITOR_ELEMENT, EDITOR_ELEMENT, editorLineLengthHintAttributes);
                xmlSerHandler.endElement("", EDITOR_ELEMENT, EDITOR_ELEMENT);
            }
            xmlSerHandler.endElement("", "config", "config");
            xmlSerHandler.endDocument();
        }
        catch (SAXException e) {
            String message = e.getMessage() != null ? e.getMessage() : "";
            Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
            throw new CoreException((IStatus)s);
        }
    }
}

