/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.explain.matched;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.explain.apply.ApplyView;
import org.apache.uima.ruta.explain.matched.MatchedTreeContentProvider;
import org.apache.uima.ruta.explain.matched.MatchedTreeLabelProvider;
import org.apache.uima.ruta.explain.rulelist.RuleListView;
import org.apache.uima.ruta.explain.selection.ExplainSelectionView;
import org.apache.uima.ruta.explain.tree.BlockApplyNode;
import org.apache.uima.ruta.explain.tree.IExplainTreeNode;
import org.apache.uima.ruta.explain.tree.MatchedRootNode;
import org.apache.uima.ruta.explain.tree.RuleApplyNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;

public class MatchedViewPage
extends Page
implements ISelectionListener {
    private IExplainTreeNode node;
    private CheckboxTreeViewer treeView;
    private int current;
    private Map<String, Image> images;
    private AnnotationEditor editor;
    private ICasDocument document;

    public MatchedViewPage(AnnotationEditor editor) {
        this.editor = editor;
        this.document = editor.getDocument();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        if (this.images != null) {
            for (Image each : this.images.values()) {
                each.dispose();
            }
        }
    }

    private void initImages() {
        this.images = new HashMap<String, Image>();
        ImageDescriptor desc = RutaAddonsPlugin.getImageDescriptor("/icons/accept.png");
        Image image = desc.createImage();
        String name = "matched";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/cancel.png");
        image = desc.createImage();
        name = "failed";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/font_add.png");
        image = desc.createImage();
        name = "org.apache.uima.ruta.type.DebugMatchedRuleMatch";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/font_delete.png");
        image = desc.createImage();
        name = "org.apache.uima.ruta.type.DebugFailedRuleMatch";
        this.images.put(name, image);
    }

    public Image getImage(String name) {
        if (this.images == null) {
            this.initImages();
        }
        return this.images.get(name);
    }

    public void createControl(Composite parent) {
        this.treeView = new CheckboxTreeViewer(parent, 772);
        this.treeView.setContentProvider((IContentProvider)new MatchedTreeContentProvider());
        this.treeView.setLabelProvider((IBaseLabelProvider)new MatchedTreeLabelProvider(this));
        this.treeView.setInput((Object)this.node);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeView);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public Control getControl() {
        return this.treeView.getControl();
    }

    public void setFocus() {
        this.treeView.getControl().setFocus();
    }

    public void inputChange(Object newInput) {
        if (newInput != null && newInput instanceof MatchedRootNode && this.treeView != null && newInput != this.treeView.getInput()) {
            this.treeView.setInput(newInput);
            this.treeView.refresh();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof TreeSelection && (part instanceof ApplyView || part instanceof RuleListView || part instanceof ExplainSelectionView)) {
            TreeSelection ts = (TreeSelection)selection;
            Object firstElement = ts.getFirstElement();
            if (firstElement instanceof BlockApplyNode) {
                BlockApplyNode block = (BlockApplyNode)firstElement;
                this.inputChange(block.getBlockRuleNode().getMatchedChild());
            } else if (firstElement instanceof RuleApplyNode) {
                RuleApplyNode rule = (RuleApplyNode)firstElement;
                this.inputChange(rule.getMatchedChild());
            }
        }
    }
}

