/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.ruta.caseditor.view.tree.ITreeNode;

public abstract class AbstractTreeNode
implements ITreeNode {
    private static final ITreeNode[] emptyArray = new ITreeNode[0];
    private ITreeNode parent;
    protected List<ITreeNode> children;
    protected final CAS cas;

    public AbstractTreeNode(CAS cas) {
        this(cas, null);
    }

    public AbstractTreeNode(CAS cas, ITreeNode parent) {
        this.parent = parent;
        this.cas = cas;
    }

    @Override
    public void addChild(ITreeNode child) {
        if (this.children == null) {
            this.children = new ArrayList<ITreeNode>();
        }
        this.children.add(child);
    }

    @Override
    public ITreeNode[] getChildren() {
        if (this.children == null) {
            return emptyArray;
        }
        return this.children.toArray(emptyArray);
    }

    @Override
    public ITreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        if (this.children == null) {
            return false;
        }
        return this.children.size() > 0;
    }

    @Override
    public void sort(Comparator<ITreeNode> cp) {
        Collections.sort(this.children, cp);
    }
}

