/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.check;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SelectTypesDialogCheck
extends TitleAreaDialog
implements Listener {
    private boolean featureMode;
    private Text typeNameUI;
    public Tree tree;
    public String typeName = "error-TypeName-never-set";
    private List<String> allTypes;
    private Map<String, List<String>> allTypesMapping;
    private Map<String, Set<String>> selectedTypes;
    private int swtTreeModeFlag;
    private boolean check;
    private String choosenType;

    public SelectTypesDialogCheck(Shell shell, TypeSystemDescription tsd, Map<String, Set<String>> selectedTypes, boolean featureMode, int swtTreeModeFlag, boolean check) {
        super(shell);
        TypeDescription[] systemTypes;
        this.check = check;
        this.swtTreeModeFlag = swtTreeModeFlag;
        this.allTypes = new LinkedList<String>();
        this.allTypesMapping = new HashMap<String, List<String>>();
        for (TypeDescription typeDescription : systemTypes = tsd.getTypes()) {
            TypeDescription superTypeDesc;
            LinkedList<String> typeFeatures = new LinkedList<String>();
            for (FeatureDescription fd : typeDescription.getFeatures()) {
                typeFeatures.add(fd.getName());
            }
            String supertypeName = typeDescription.getSupertypeName();
            if (supertypeName != null && (superTypeDesc = tsd.getType(supertypeName)) != null) {
                for (FeatureDescription fd : superTypeDesc.getFeatures()) {
                    typeFeatures.add(fd.getName());
                }
            }
            String name = typeDescription.getName();
            this.allTypes.add(name);
            this.allTypesMapping.put(name, typeFeatures);
        }
        this.selectedTypes = selectedTypes != null ? selectedTypes : new HashMap<String, Set<String>>();
        this.featureMode = featureMode;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.check) {
            this.setMessage("Please select the new type:");
            this.setTitle("Type selection dialog!");
        } else if (!this.featureMode) {
            this.setMessage("Select the types that should be copied unchecked:");
            this.setTitle("Type selection dialog!");
        } else {
            this.setMessage("Select the types and features that you want to check:");
            this.setTitle("Type and feature selection dialog");
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.typeNameUI = this.newText(composite, 4, "Specify the type name");
        this.typeNameUI.addListener(24, (Listener)this);
        this.createWideLabel(composite, "  Matching Types:");
        this.tree = this.check ? this.newTree(composite, 32) : this.newTree(composite, 0);
        this.tree.setBounds(10, 10, 50, 50);
        this.displayFilteredTypes("");
        return composite;
    }

    public void handleEvent(Event event) {
        Widget item;
        if (event.widget == this.typeNameUI && event.type == 24) {
            this.displayFilteredTypes(this.typeNameUI.getText());
        } else if (event.widget == this.tree && (item = event.item) instanceof TreeItem) {
            TreeItem ti = (TreeItem)item;
            this.choosenType = ti.getText();
            int level = this.getLevel(ti);
            TreeItem[] selection = this.tree.getSelection();
            String text = ti.getText();
            if (level == 1) {
                for (TreeItem treeItem : selection) {
                    if (treeItem == ti) continue;
                    if (ti.getChecked()) {
                        treeItem.setChecked(true);
                        this.selectedTypes.put(treeItem.getText(), null);
                        continue;
                    }
                    this.selectedTypes.remove(treeItem.getText());
                    treeItem.setChecked(false);
                }
                if (ti.getChecked()) {
                    this.selectedTypes.put(text, new HashSet());
                } else {
                    this.selectedTypes.remove(text);
                }
            }
            if (level == 2) {
                Set<String> set;
                TreeItem parentItem = ti.getParentItem();
                String parentName = parentItem.getText();
                if (!this.selectedTypes.keySet().contains(parentName)) {
                    this.selectedTypes.put(parentName, new HashSet());
                }
                if ((set = this.selectedTypes.get(parentName)) == null) {
                    set = new HashSet<String>();
                    this.selectedTypes.put(parentName, set);
                }
                if (ti.getChecked()) {
                    if (!set.contains(text)) {
                        set.add(text);
                    }
                    parentItem.setChecked(true);
                } else {
                    set.remove(text);
                }
            }
        }
    }

    private int getLevel(TreeItem ti) {
        int level = 1;
        TreeItem parent = ti.getParentItem();
        while (parent != null) {
            parent = parent.getParentItem();
            ++level;
        }
        return level;
    }

    protected Label createWideLabel(Composite parent, String message) {
        Label label = null;
        label = new Label(parent, 64);
        label.setText(null != message ? message : "");
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        data.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text newText(Composite parent, int style, String tip) {
        Text t = new Text(parent, style | 0x800);
        t.setToolTipText(tip);
        t.setLayoutData((Object)new GridData(768));
        t.addListener(2, (Listener)this);
        t.addListener(4, (Listener)this);
        return t;
    }

    protected Tree newTree(Composite parent, int style) {
        Tree tree = new Tree(parent, style | 0x800 | this.swtTreeModeFlag);
        GridData gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        tree.addListener(13, (Listener)this);
        tree.addListener(2, (Listener)this);
        tree.addListener(3, (Listener)this);
        return tree;
    }

    public boolean isValid() {
        return true;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(450, 450);
    }

    public Map<String, Set<String>> getSelectedTypes() {
        return this.selectedTypes;
    }

    public Set<String> getSelectedTypesSet() {
        return this.selectedTypes.keySet();
    }

    public void setSelectedTypes(Map<String, Set<String>> selectedTypes) {
        this.selectedTypes = selectedTypes;
    }

    private void displayFilteredTypes(String aTypeName) {
        this.tree.setRedraw(false);
        this.tree.removeAll();
        String topEntry = "";
        aTypeName = aTypeName.toLowerCase();
        for (String type : this.allTypes) {
            String candidateTypeName = type.toLowerCase();
            if (!StringUtils.isBlank((CharSequence)aTypeName) && candidateTypeName.toLowerCase().indexOf(aTypeName.toLowerCase()) == -1) continue;
            if (StringUtils.isEmpty((CharSequence)topEntry)) {
                topEntry = type;
            }
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText(type);
            if (this.selectedTypes.keySet().contains(item.getText())) {
                item.setChecked(true);
            }
            if (!this.featureMode) continue;
            List<String> featuresType = this.allTypesMapping.get(type);
            Set<String> selectedFeaturesType = this.selectedTypes.get(type);
            for (String feature : featuresType) {
                TreeItem itemFeat = new TreeItem(item, 0);
                itemFeat.setText(feature);
                if (selectedFeaturesType == null || !selectedFeaturesType.contains(feature)) continue;
                itemFeat.setChecked(true);
            }
        }
        this.tree.setRedraw(true);
    }

    public String getChoosenType() {
        return this.choosenType;
    }
}

