/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import jakarta.annotation.ManagedBean;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.annotation.Resources;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.annotation.security.RunAs;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.annotation.sql.DataSourceDefinitions;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.ejb.AccessTimeout;
import jakarta.ejb.AfterBegin;
import jakarta.ejb.AfterCompletion;
import jakarta.ejb.ApplicationException;
import jakarta.ejb.Asynchronous;
import jakarta.ejb.BeforeCompletion;
import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.DependsOn;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import jakarta.ejb.EJBs;
import jakarta.ejb.Init;
import jakarta.ejb.Local;
import jakarta.ejb.LocalBean;
import jakarta.ejb.LocalHome;
import jakarta.ejb.Lock;
import jakarta.ejb.LockType;
import jakarta.ejb.MessageDriven;
import jakarta.ejb.PostActivate;
import jakarta.ejb.PrePassivate;
import jakarta.ejb.Remote;
import jakarta.ejb.RemoteHome;
import jakarta.ejb.Remove;
import jakarta.ejb.Schedule;
import jakarta.ejb.Schedules;
import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import jakarta.ejb.Stateful;
import jakarta.ejb.StatefulTimeout;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.enterprise.concurrent.ContextServiceDefinition;
import jakarta.enterprise.concurrent.ManagedExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedThreadFactoryDefinition;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Model;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Stereotype;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.ExcludeClassInterceptors;
import jakarta.interceptor.ExcludeDefaultInterceptors;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.Interceptors;
import jakarta.jms.JMSConnectionFactoryDefinition;
import jakarta.jms.JMSConnectionFactoryDefinitions;
import jakarta.jms.JMSDestinationDefinition;
import jakarta.jms.JMSDestinationDefinitions;
import jakarta.jms.Queue;
import jakarta.jws.HandlerChain;
import jakarta.jws.WebService;
import jakarta.persistence.Converter;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContexts;
import jakarta.persistence.PersistenceUnits;
import jakarta.resource.spi.Activation;
import jakarta.resource.spi.AdministeredObject;
import jakarta.resource.spi.ConnectionDefinitions;
import jakarta.resource.spi.SecurityPermission;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceProvider;
import jakarta.xml.ws.WebServiceRef;
import jakarta.xml.ws.WebServiceRefs;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.api.LocalClient;
import org.apache.openejb.api.Proxy;
import org.apache.openejb.api.RemoteClient;
import org.apache.openejb.cdi.CdiBeanInfo;
import org.apache.openejb.config.AdditionalBeanDiscoverer;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.BuiltInEnvironmentEntries;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.CompManagedBean;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.ContextRef;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.EnvEntriesPropertiesDeployer;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.LegacyProcessor;
import org.apache.openejb.config.MBeanDeployer;
import org.apache.openejb.config.MergeWebappJndiContext;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.PersistenceContextAnn;
import org.apache.openejb.config.PersistenceContextAnnFactory;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WebappAggregatedArchive;
import org.apache.openejb.config.event.DataSourceDefinitionUrlBuild;
import org.apache.openejb.config.rules.CheckClasses;
import org.apache.openejb.core.EmptyResourcesClassLoader;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.TempClassLoader;
import org.apache.openejb.core.webservices.JaxWsUtils;
import org.apache.openejb.dyni.DynamicSubclass;
import org.apache.openejb.jee.ActivationConfig;
import org.apache.openejb.jee.ActivationSpec;
import org.apache.openejb.jee.AdminObject;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.AroundInvoke;
import org.apache.openejb.jee.AroundTimeout;
import org.apache.openejb.jee.AssemblyDescriptor;
import org.apache.openejb.jee.AsyncMethod;
import org.apache.openejb.jee.AuthenticationMechanism;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.ConcurrencyManagementType;
import org.apache.openejb.jee.ConcurrentLockType;
import org.apache.openejb.jee.ConcurrentMethod;
import org.apache.openejb.jee.ConfigProperty;
import org.apache.openejb.jee.ConnectionDefinition;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.ContainerConcurrency;
import org.apache.openejb.jee.ContainerTransaction;
import org.apache.openejb.jee.ContextService;
import org.apache.openejb.jee.DataSource;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EjbReference;
import org.apache.openejb.jee.Empty;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.ExcludeList;
import org.apache.openejb.jee.Filter;
import org.apache.openejb.jee.Handler;
import org.apache.openejb.jee.HandlerChains;
import org.apache.openejb.jee.Icon;
import org.apache.openejb.jee.InboundResourceadapter;
import org.apache.openejb.jee.InitMethod;
import org.apache.openejb.jee.Injectable;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.InterceptorBinding;
import org.apache.openejb.jee.Invokable;
import org.apache.openejb.jee.IsolationLevel;
import org.apache.openejb.jee.JMSConnectionFactory;
import org.apache.openejb.jee.JMSDestination;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.License;
import org.apache.openejb.jee.Lifecycle;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.openejb.jee.Listener;
import org.apache.openejb.jee.ManagedExecutor;
import org.apache.openejb.jee.ManagedScheduledExecutor;
import org.apache.openejb.jee.ManagedThreadFactory;
import org.apache.openejb.jee.MessageAdapter;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.MessageListener;
import org.apache.openejb.jee.Method;
import org.apache.openejb.jee.MethodAttribute;
import org.apache.openejb.jee.MethodParams;
import org.apache.openejb.jee.MethodPermission;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.OutboundResourceAdapter;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceContextSynchronization;
import org.apache.openejb.jee.PersistenceContextType;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.PortComponent;
import org.apache.openejb.jee.Property;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.RemoveMethod;
import org.apache.openejb.jee.ResAuth;
import org.apache.openejb.jee.ResSharingScope;
import org.apache.openejb.jee.ResourceAdapter;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.SecurityIdentity;
import org.apache.openejb.jee.SecurityRoleRef;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.ServletMapping;
import org.apache.openejb.jee.Session;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.SingletonBean;
import org.apache.openejb.jee.StatefulBean;
import org.apache.openejb.jee.StatelessBean;
import org.apache.openejb.jee.Tag;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.Timeout;
import org.apache.openejb.jee.Timer;
import org.apache.openejb.jee.TimerConsumer;
import org.apache.openejb.jee.TimerSchedule;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.TransAttribute;
import org.apache.openejb.jee.TransactionSupportType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.jee.jba.JndiName;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.jpa.unit.TransactionType;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SuperProperties;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.proxy.DynamicProxyImplFactory;
import org.apache.xbean.finder.Annotated;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.MetaAnnotatedClass;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;

public class AnnotationDeployer
implements DynamicDeployer {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, AnnotationDeployer.class.getPackage().getName());
    public static final Logger startupLogger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");
    public static final String OPENEJB_JPA_AUTO_SCAN = "openejb.jpa.auto-scan";
    public static final String OPENEJB_JPA_AUTO_SCAN_PACKAGE = "openejb.jpa.auto-scan.package";
    private static final ThreadLocal<DeploymentModule> currentModule = new ThreadLocal();
    private static final Set<String> lookupMissing = new HashSet<String>(2);
    private static final String[] JSF_CLASSES = new String[]{"jakarta.faces.application.ResourceDependencies", "jakarta.faces.application.ResourceDependency", "jakarta.faces.component.FacesComponent", "jakarta.faces.component.UIComponent", "jakarta.faces.component.behavior.FacesBehavior", "jakarta.faces.convert.Converter", "jakarta.faces.convert.FacesConverter", "jakarta.faces.event.ListenerFor", "jakarta.faces.event.ListenersFor", "jakarta.faces.event.NamedEvent", "jakarta.faces.render.FacesBehaviorRenderer", "jakarta.faces.render.FacesRenderer", "jakarta.faces.render.Renderer", "jakarta.faces.validator.FacesValidator", "jakarta.faces.validator.Validator"};
    private static final String[] WEB_CLASSES = new String[]{"jakarta.servlet.annotation.WebServlet", "jakarta.servlet.annotation.WebFilter", "jakarta.servlet.annotation.WebListener", "jakarta.websocket.server.ServerEndpoint", "jakarta.websocket.server.ServerApplicationConfig", "jakarta.websocket.Endpoint"};
    private static final Collection<String> API_CLASSES = new ArrayList<String>(WEB_CLASSES.length + JSF_CLASSES.length);
    public static final Set<String> knownResourceEnvTypes;
    public static final Set<String> knownEnvironmentEntries;
    private final DiscoverAnnotatedBeans discoverAnnotatedBeans = new DiscoverAnnotatedBeans();
    private final ProcessAnnotatedBeans processAnnotatedBeans = new ProcessAnnotatedBeans(SystemInstance.get().getOptions().get("openejb.jaxws.add-remote", false));
    private final EnvEntriesPropertiesDeployer envEntriesPropertiesDeployer;
    private final MBeanDeployer mBeanDeployer;
    private final BuiltInEnvironmentEntries builtInEnvironmentEntries = new BuiltInEnvironmentEntries(SystemInstance.get().getOptions().get("openejb.environment.default", false));
    private final MergeWebappJndiContext mergeWebappJndiContext;

    public AnnotationDeployer() {
        this.envEntriesPropertiesDeployer = new EnvEntriesPropertiesDeployer();
        this.mBeanDeployer = new MBeanDeployer();
        this.mergeWebappJndiContext = new MergeWebappJndiContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(appModule.getClassLoader());
        AnnotationDeployer.setModule(appModule);
        try {
            appModule = this.discoverAnnotatedBeans.deploy(appModule);
            appModule = this.envEntriesPropertiesDeployer.deploy(appModule);
            appModule = this.mergeWebappJndiContext.deploy(appModule);
            appModule = this.builtInEnvironmentEntries.deploy(appModule);
            appModule = this.processAnnotatedBeans.deploy(appModule);
            appModule = this.mergeWebappJndiContext.deploy(appModule);
            AppModule appModule2 = appModule = this.mBeanDeployer.deploy(appModule);
            return appModule2;
        }
        finally {
            this.envEntriesPropertiesDeployer.resetAdditionalEnvEntries();
            Thread.currentThread().setContextClassLoader(classLoader);
            AnnotationDeployer.removeModule();
        }
    }

    public void deploy(CdiBeanInfo beanInfo) throws OpenEJBException {
        this.processAnnotatedBeans.deploy(beanInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebModule deploy(WebModule webModule) throws OpenEJBException {
        AnnotationDeployer.setModule(webModule);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(webModule.getClassLoader());
        try {
            webModule = this.discoverAnnotatedBeans.deploy(webModule);
            webModule = this.envEntriesPropertiesDeployer.deploy(webModule);
            WebModule webModule2 = webModule = this.processAnnotatedBeans.deploy(webModule);
            return webModule2;
        }
        finally {
            this.envEntriesPropertiesDeployer.resetAdditionalEnvEntries();
            Thread.currentThread().setContextClassLoader(classLoader);
            AnnotationDeployer.removeModule();
        }
    }

    public static DeploymentModule getModule() {
        return currentModule.get();
    }

    private static void setModule(DeploymentModule module) {
        currentModule.set(module);
    }

    private static void removeModule() {
        currentModule.remove();
    }

    private static ValidationContext getValidationContext() {
        return AnnotationDeployer.getModule().getValidation();
    }

    private static void mergeApplicationExceptionAnnotation(AssemblyDescriptor assemblyDescriptor, Class<?> exceptionClass, ApplicationException annotation) {
        org.apache.openejb.jee.ApplicationException applicationException = assemblyDescriptor.getApplicationException(exceptionClass);
        if (applicationException.getRollback() == null) {
            applicationException.setRollback(Boolean.valueOf(annotation.rollback()));
        }
        if (applicationException.getInherited() == null) {
            applicationException.setInherited(Boolean.valueOf(annotation.inherited()));
        }
    }

    public static boolean isKnownEnvironmentEntryType(Class type) {
        return knownEnvironmentEntries.contains(type.getName()) || type.isEnum();
    }

    public static boolean isShareableJNDINamespace(String jndiName) {
        return jndiName.startsWith("java:global/") || jndiName.startsWith("java:app/") || jndiName.startsWith("java:module/");
    }

    public static void autoJpa(EjbModule ejbModule) {
        IAnnotationFinder finder = ejbModule.getFinder();
        if (ejbModule.getAppModule() != null) {
            for (PersistenceModule pm : ejbModule.getAppModule().getPersistenceModules()) {
                for (PersistenceUnit pu : pm.getPersistence().getPersistenceUnit()) {
                    if (pu.isExcludeUnlistedClasses() != null && pu.isExcludeUnlistedClasses().booleanValue() || !"true".equalsIgnoreCase(pu.getProperties().getProperty(OPENEJB_JPA_AUTO_SCAN))) continue;
                    AnnotationDeployer.doAutoJpa(finder, pu);
                }
            }
        }
    }

    public static void doAutoJpa(IAnnotationFinder finder, PersistenceUnit pu) {
        String packageName = pu.getProperties().getProperty(OPENEJB_JPA_AUTO_SCAN_PACKAGE);
        String[] packageNames = null;
        if (packageName != null) {
            packageNames = packageName.split(",");
        }
        ArrayList classes = new ArrayList();
        classes.addAll(finder.findAnnotatedClasses(Entity.class));
        classes.addAll(finder.findAnnotatedClasses(Embeddable.class));
        classes.addAll(finder.findAnnotatedClasses(MappedSuperclass.class));
        classes.addAll(finder.findAnnotatedClasses(Converter.class));
        List existingClasses = pu.getClazz();
        for (Class clazz : classes) {
            String name = clazz.getName();
            if (existingClasses.contains(name)) continue;
            if (packageNames == null) {
                pu.getClazz().add(name);
                continue;
            }
            for (String pack : packageNames) {
                if (!name.startsWith(pack)) continue;
                pu.getClazz().add(name);
            }
        }
        pu.setScanned(true);
    }

    private static void failIfCdiProducer(Member member, String type) {
        if (FieldMember.class.isInstance(member) && ((FieldMember)FieldMember.class.cast((Object)member)).field.getAnnotation(Produces.class) != null) {
            throw new DefinitionException(String.valueOf(((FieldMember)FieldMember.class.cast((Object)member)).field) + " is not a " + type);
        }
    }

    private static void addRestClassesToScannedClasses(WebModule webModule, Set<Class> classes, ClassLoader classLoader) throws OpenEJBException {
        for (String rawClassName : webModule.getRestClasses()) {
            String className = AnnotationDeployer.realClassName(rawClassName);
            if (className == null) continue;
            try {
                Class<?> clazz = classLoader.loadClass(className);
                classes.add(clazz);
            }
            catch (ClassNotFoundException e) {
                logger.debug("Could not load REST class {1} for web module {2} / {3}", className, webModule.getJarLocation(), webModule.getFile().getName());
                throw new OpenEJBException("Unable to load REST class: " + className, e);
            }
        }
    }

    public static List<Annotated<Class<?>>> sortClasses(List<Annotated<Class<?>>> list) {
        list.sort(new Comparator<Annotated<Class<?>>>(){

            @Override
            public int compare(Annotated<Class<?>> o1, Annotated<Class<?>> o2) {
                return AnnotationDeployer.compareClasses((Class)o1.get(), (Class)o2.get());
            }
        });
        return list;
    }

    public static List<Class<?>> sortClassesParentFirst(List<Class<?>> list) {
        list.sort(new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return AnnotationDeployer.compareClasses(o2, o1);
            }
        });
        return list;
    }

    public static List<Annotated<java.lang.reflect.Method>> sortMethods(List<Annotated<java.lang.reflect.Method>> list) {
        list.sort(new Comparator<Annotated<java.lang.reflect.Method>>(){

            @Override
            public int compare(Annotated<java.lang.reflect.Method> o1, Annotated<java.lang.reflect.Method> o2) {
                return AnnotationDeployer.compareClasses(((java.lang.reflect.Method)o1.get()).getDeclaringClass(), ((java.lang.reflect.Method)o2.get()).getDeclaringClass());
            }
        });
        return list;
    }

    private static int compareClasses(Class<?> a, Class<?> b) {
        if (a == b) {
            return 0;
        }
        if (a.isAssignableFrom(b)) {
            return 1;
        }
        if (b.isAssignableFrom(a)) {
            return -1;
        }
        return 0;
    }

    public static Collection<String> findRestClasses(WebModule webModule, IAnnotationFinder finder) {
        HashSet<String> classes = new HashSet<String>();
        List annotatedClasses = finder.findMetaAnnotatedClasses(Path.class);
        for (Annotated aClazz : annotatedClasses) {
            Class clazz = (Class)aClazz.get();
            if (AnnotationDeployer.isInstantiable(clazz)) {
                if (!AnnotationDeployer.isEJB(clazz)) {
                    classes.add(clazz.getName());
                    continue;
                }
                webModule.getEjbRestServices().add(clazz.getName());
                continue;
            }
            if (clazz.isInterface()) {
                Class api = clazz;
                List impl = finder.findImplementations(api);
                if (impl == null || impl.size() != 1) continue;
                Class implClass = (Class)impl.iterator().next();
                String name = implClass.getName();
                if (!AnnotationDeployer.isEJB(implClass)) {
                    classes.add(name);
                    continue;
                }
                webModule.getEjbRestServices().add(name);
                continue;
            }
            if (!AnnotationDeployer.isEJB(clazz) || !DynamicSubclass.isDynamic(clazz)) continue;
            classes.add(clazz.getName());
        }
        if ("true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.jaxrs.scanning.methods", "false"))) {
            List methods = finder.findMetaAnnotatedMethods(Path.class);
            for (Annotated aMethod : methods) {
                java.lang.reflect.Method method = (java.lang.reflect.Method)aMethod.get();
                Class<?> clazz = method.getDeclaringClass();
                if (AnnotationDeployer.isInstantiable(clazz)) {
                    if (!AnnotationDeployer.isEJB(clazz)) {
                        classes.add(clazz.getName());
                        continue;
                    }
                    webModule.getEjbRestServices().add(clazz.getName());
                    continue;
                }
                if (!AnnotationDeployer.isEJB(clazz) || !DynamicSubclass.isDynamic(clazz)) continue;
                classes.add(clazz.getName());
            }
        }
        return classes;
    }

    public static boolean isInstantiable(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && (clazz.getEnclosingClass() == null || Modifier.isStatic(modifiers)) && Modifier.isPublic(modifiers) && !clazz.isEnum();
    }

    private static boolean isEJB(Class<?> clazz) {
        return clazz.isAnnotationPresent(Stateless.class) || clazz.isAnnotationPresent(Singleton.class) || clazz.isAnnotationPresent(ManagedBean.class) || clazz.isAnnotationPresent(Stateful.class);
    }

    private static String realClassName(String rawClassName) {
        if (rawClassName == null) {
            return null;
        }
        if (rawClassName.contains("/")) {
            return rawClassName.replace("/", ".");
        }
        return rawClassName;
    }

    private static Collection<Class<?>> metaToClass(List<Annotated<Class<?>>> found) {
        ArrayList classes = new ArrayList(found.size());
        for (Annotated<Class<?>> clazz : found) {
            classes.add((Class)clazz.get());
        }
        return classes;
    }

    private static Map<String, Set<String>> addWebAnnotatedClassInfo(Map<String, String> urlByClasses, Map<String, Set<String>> classes, List<Annotated<Class<?>>> found) {
        for (Annotated<Class<?>> clazz : found) {
            Class loadedClass = (Class)clazz.get();
            String name = loadedClass.getName();
            String url = null;
            if (urlByClasses != null) {
                url = urlByClasses.get(name);
            }
            if (url == null) {
                try {
                    url = JarLocation.jarLocation(loadedClass).toURI().toURL().toExternalForm();
                }
                catch (MalformedURLException e) {
                    url = AnnotationDeployer.classLocation(loadedClass).toExternalForm();
                }
            }
            Set list = classes.computeIfAbsent(url, k -> new HashSet());
            try {
                File dir = new File(new URL(url).toURI());
                if (dir.isDirectory()) {
                    File fileClazz = new File(dir, name.replace('.', '/') + ".class");
                    if (fileClazz.exists()) {
                        list.add(fileClazz.toURI().toURL().toExternalForm());
                        continue;
                    }
                    list.add(AnnotationDeployer.classLocation(loadedClass).toExternalForm());
                    continue;
                }
                if (url.endsWith(".jar") && url.startsWith("file:")) {
                    list.add("jar:" + url + "!/" + name.replace('.', '/') + ".class");
                    continue;
                }
                list.add(AnnotationDeployer.classLocation(loadedClass).toExternalForm());
            }
            catch (Exception e) {
                list.add(AnnotationDeployer.classLocation(loadedClass).toExternalForm());
            }
        }
        return classes;
    }

    public static URL classLocation(Class clazz) {
        try {
            String classFileName = clazz.getName().replace(".", "/") + ".class";
            ClassLoader loader = clazz.getClassLoader();
            URL url = loader != null ? (TempClassLoader.class.isInstance(loader) ? ((TempClassLoader)TempClassLoader.class.cast(loader)).getInternalResource(classFileName) : loader.getResource(classFileName)) : clazz.getResource(classFileName);
            if (url == null) {
                throw new IllegalStateException("classloader.getResource(classFileName) returned a null URL");
            }
            return url;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public EnvEntriesPropertiesDeployer getEnvEntriesPropertiesDeployer() {
        return this.envEntriesPropertiesDeployer;
    }

    static {
        API_CLASSES.addAll(Arrays.asList(JSF_CLASSES));
        API_CLASSES.addAll(Arrays.asList(WEB_CLASSES));
        knownResourceEnvTypes = new TreeSet<String>(Arrays.asList("jakarta.ejb.EJBContext", "jakarta.ejb.SessionContext", "jakarta.ejb.EntityContext", "jakarta.ejb.MessageDrivenContext", "jakarta.transaction.UserTransaction", "jakarta.jms.Queue", "jakarta.jms.Topic", "jakarta.xml.ws.WebServiceContext", "jakarta.ejb.TimerService", "jakarta.enterprise.inject.spi.BeanManager", "jakarta.validation.Validator", "jakarta.validation.ValidatorFactory"));
        knownEnvironmentEntries = new TreeSet<String>(Arrays.asList("boolean", "java.lang.Boolean", "char", "java.lang.Character", "byte", "java.lang.Byte", "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long", "float", "java.lang.Float", "double", "java.lang.Double", "java.lang.String", "java.lang.Class"));
    }

    public static class DiscoverAnnotatedBeans
    implements DynamicDeployer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppModule deploy(AppModule appModule) throws OpenEJBException {
            if (!appModule.isWebapp() && !appModule.getWebModules().isEmpty()) {
                try {
                    appModule.setEarLibFinder(FinderFactory.createFinder(appModule));
                }
                catch (Exception e) {
                    logger.error("Can't create a finder for ear libs", e);
                }
            }
            for (EjbModule ejbModule : appModule.getEjbModules()) {
                ejbModule.initAppModule(appModule);
                AnnotationDeployer.setModule(ejbModule);
                try {
                    this.deploy(ejbModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (ClientModule clientModule : appModule.getClientModules()) {
                clientModule.initAppModule(appModule);
                AnnotationDeployer.setModule(clientModule);
                try {
                    this.deploy(clientModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (ConnectorModule connectorModule : appModule.getConnectorModules()) {
                connectorModule.initAppModule(appModule);
                AnnotationDeployer.setModule(connectorModule);
                try {
                    this.deploy(connectorModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (WebModule webModule : appModule.getWebModules()) {
                webModule.initAppModule(appModule);
                AnnotationDeployer.setModule(webModule);
                try {
                    this.deploy(webModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            AdditionalBeanDiscoverer discoverer = SystemInstance.get().getComponent(AdditionalBeanDiscoverer.class);
            if (discoverer != null) {
                appModule = discoverer.discover(appModule);
            }
            return appModule;
        }

        public ClientModule deploy(ClientModule clientModule) throws OpenEJBException {
            if (clientModule.getApplicationClient() == null) {
                clientModule.setApplicationClient(new ApplicationClient());
            }
            if (clientModule.getFinder() == null && clientModule.getAltDDs().containsKey("application-client.xml") && clientModule.getApplicationClient() != null && clientModule.getApplicationClient().isMetadataComplete().booleanValue()) {
                return clientModule;
            }
            IAnnotationFinder finder = clientModule.getFinder();
            if (finder == null) {
                try {
                    finder = FinderFactory.createFinder(clientModule);
                }
                catch (MalformedURLException e) {
                    startupLogger.warning("startup.scrapeFailedForClientModule.url", clientModule.getJarLocation());
                    return clientModule;
                }
                catch (Exception e) {
                    startupLogger.warning("startup.scrapeFailedForClientModule", e, clientModule.getJarLocation());
                    return clientModule;
                }
            }
            for (Annotated clazz : finder.findMetaAnnotatedClasses(LocalClient.class)) {
                clientModule.getLocalClients().add(((Class)clazz.get()).getName());
            }
            for (Annotated clazz : finder.findMetaAnnotatedClasses(RemoteClient.class)) {
                clientModule.getRemoteClients().add(((Class)clazz.get()).getName());
            }
            if (clientModule.getApplicationClient() == null && (clientModule.getRemoteClients().size() > 0 || clientModule.getLocalClients().size() > 0)) {
                clientModule.setApplicationClient(new ApplicationClient());
            }
            return clientModule;
        }

        /*
         * WARNING - void declaration
         */
        public ConnectorModule deploy(ConnectorModule connectorModule) throws OpenEJBException {
            MessageAdapter messageAdapter;
            Connector connector = connectorModule.getConnector();
            if (connector == null) {
                connector = new Connector();
            }
            float specVersion = 0.0f;
            try {
                specVersion = Float.parseFloat(connector.getVersion());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((double)specVersion < 1.6 || Boolean.TRUE.equals(connector.isMetadataComplete())) {
                return connectorModule;
            }
            IAnnotationFinder finder = connectorModule.getFinder();
            if (finder == null) {
                try {
                    finder = FinderFactory.createFinder(connectorModule);
                    connectorModule.setFinder(finder);
                }
                catch (Exception e) {
                    return connectorModule;
                }
            }
            List connectorClasses = finder.findAnnotatedClasses(jakarta.resource.spi.Connector.class);
            if (connector.getResourceAdapter() == null || connector.getResourceAdapter().getResourceAdapterClass() == null || connector.getResourceAdapter().getResourceAdapterClass().length() == 0) {
                if (connectorClasses.size() == 0) {
                    // empty if block
                }
                if (connectorClasses.size() > 1) {
                    // empty if block
                }
            }
            Class connectorClass = null;
            if (connectorClasses.size() == 1) {
                connectorClass = (Class)connectorClasses.get(0);
            }
            if (connectorClasses.size() > 1) {
                for (Class cls : connectorClasses) {
                    if (!cls.getName().equals(connector.getResourceAdapter().getResourceAdapterClass())) continue;
                    connectorClass = cls;
                    break;
                }
            }
            if (connectorClass != null) {
                OutboundResourceAdapter outboundResourceAdapter;
                if (connector.getResourceAdapter() == null) {
                    connector.setResourceAdapter(new ResourceAdapter());
                }
                if (connector.getResourceAdapter().getResourceAdapterClass() == null || connector.getResourceAdapter().getResourceAdapterClass().length() == 0) {
                    connector.getResourceAdapter().setResourceAdapterClass(connectorClass.getName());
                }
                jakarta.resource.spi.Connector connectorAnnotation = connectorClass.getAnnotation(jakarta.resource.spi.Connector.class);
                connector.setDisplayNames(this.getTexts(connector.getDisplayNames(), connectorAnnotation.displayName()));
                connector.setDescriptions(this.getTexts(connector.getDescriptions(), connectorAnnotation.description()));
                connector.setEisType(this.getString(connector.getEisType(), connectorAnnotation.eisType()));
                connector.setVendorName(this.getString(connector.getVendorName(), connectorAnnotation.vendorName()));
                connector.setResourceAdapterVersion(this.getString(connector.getResourceAdapterVersion(), connectorAnnotation.version()));
                if (connector.getIcons().isEmpty()) {
                    int smallIcons = connectorAnnotation.smallIcon().length;
                    int largeIcons = connectorAnnotation.largeIcon().length;
                    for (int i = 0; i < smallIcons && i < largeIcons; ++i) {
                        Icon icon = new Icon();
                        icon.setLang(Locale.getDefault().getLanguage());
                        if (i < smallIcons) {
                            icon.setSmallIcon(connectorAnnotation.smallIcon()[i]);
                        }
                        if (i < largeIcons) {
                            icon.setLargeIcon(connectorAnnotation.largeIcon()[i]);
                        }
                        connector.getIcons().add(icon);
                    }
                }
                if (connector.getLicense() == null) {
                    License license = new License();
                    connector.setLicense(license);
                    license.setLicenseRequired(connectorAnnotation.licenseRequired());
                }
                connector.getLicense().setDescriptions(this.getTexts(connector.getLicense().getDescriptions(), connectorAnnotation.licenseDescription()));
                SecurityPermission[] annotationSecurityPermissions = connectorAnnotation.securityPermissions();
                List securityPermission = connector.getResourceAdapter().getSecurityPermission();
                if (securityPermission == null || securityPermission.size() == 0) {
                    for (SecurityPermission sp : annotationSecurityPermissions) {
                        org.apache.openejb.jee.SecurityPermission permission = new org.apache.openejb.jee.SecurityPermission();
                        permission.setSecurityPermissionSpec(sp.permissionSpec());
                        permission.setDescriptions(this.stringsToTexts(sp.description()));
                        securityPermission.add(permission);
                    }
                }
                Class[] annotationRequiredWorkContexts = connectorAnnotation.requiredWorkContexts();
                List requiredWorkContext = connector.getRequiredWorkContext();
                if (requiredWorkContext.size() == 0) {
                    for (Class clazz : annotationRequiredWorkContexts) {
                        requiredWorkContext.add(clazz.getName());
                    }
                }
                if ((outboundResourceAdapter = connector.getResourceAdapter().getOutboundResourceAdapter()) == null) {
                    outboundResourceAdapter = new OutboundResourceAdapter();
                    connector.getResourceAdapter().setOutboundResourceAdapter(outboundResourceAdapter);
                }
                List authenticationMechanisms = outboundResourceAdapter.getAuthenticationMechanism();
                jakarta.resource.spi.AuthenticationMechanism[] authMechanisms = connectorAnnotation.authMechanisms();
                if (authenticationMechanisms.size() == 0) {
                    for (jakarta.resource.spi.AuthenticationMechanism am : authMechanisms) {
                        AuthenticationMechanism authMechanism = new AuthenticationMechanism();
                        authMechanism.setAuthenticationMechanismType(am.authMechanism());
                        authMechanism.setCredentialInterface(am.credentialInterface().toString());
                        authMechanism.setDescriptions(this.stringsToTexts(am.description()));
                        authenticationMechanisms.add(authMechanism);
                    }
                }
                if (outboundResourceAdapter.getTransactionSupport() == null) {
                    outboundResourceAdapter.setTransactionSupport(TransactionSupportType.fromValue((String)connectorAnnotation.transactionSupport().toString()));
                }
                if (outboundResourceAdapter.isReauthenticationSupport() == null) {
                    outboundResourceAdapter.setReauthenticationSupport(Boolean.valueOf(connectorAnnotation.reauthenticationSupport()));
                }
            }
            List classes = finder.findAnnotatedClasses(ConnectionDefinitions.class);
            for (Class cls : classes) {
                OutboundResourceAdapter definitions;
                ConnectionDefinitions connectionDefinitionsAnnotation = cls.getAnnotation(ConnectionDefinitions.class);
                for (jakarta.resource.spi.ConnectionDefinition connectionDefinition : definitions = connectionDefinitionsAnnotation.value()) {
                    this.processConnectionDescription(connector.getResourceAdapter(), connectionDefinition, cls);
                }
            }
            classes = finder.findAnnotatedClasses(jakarta.resource.spi.ConnectionDefinition.class);
            for (Class cls : classes) {
                jakarta.resource.spi.ConnectionDefinition connectionDefinitionAnnotation = cls.getAnnotation(jakarta.resource.spi.ConnectionDefinition.class);
                this.processConnectionDescription(connector.getResourceAdapter(), connectionDefinitionAnnotation, cls);
            }
            InboundResourceadapter inboundResourceAdapter = connector.getResourceAdapter().getInboundResourceAdapter();
            if (inboundResourceAdapter == null) {
                inboundResourceAdapter = new InboundResourceadapter();
                connector.getResourceAdapter().setInboundResourceAdapter(inboundResourceAdapter);
            }
            if ((messageAdapter = inboundResourceAdapter.getMessageAdapter()) == null) {
                messageAdapter = new MessageAdapter();
                inboundResourceAdapter.setMessageAdapter(messageAdapter);
            }
            classes = finder.findAnnotatedClasses(Activation.class);
            for (Object cls : classes) {
                Class[] classArray;
                MessageListener messageListener = null;
                Activation activationAnnotation = ((Class)cls).getAnnotation(Activation.class);
                List messageListeners = messageAdapter.getMessageListener();
                for (MessageListener ml : messageListeners) {
                    if (!((Class)cls).getName().equals(ml.getActivationSpec().getActivationSpecClass())) continue;
                    messageListener = ml;
                    break;
                }
                if (messageListener != null) continue;
                for (Class listener : classArray = activationAnnotation.messageListeners()) {
                    messageAdapter.addMessageListener(new MessageListener(listener.getName(), ((Class)cls).getName()));
                }
            }
            classes = finder.findAnnotatedClasses(AdministeredObject.class);
            List adminObjects = connector.getResourceAdapter().getAdminObject();
            for (Class cls : classes) {
                void var15_52;
                AdministeredObject administeredObjectAnnotation = cls.getAnnotation(AdministeredObject.class);
                Class[] adminObjectInterfaces = administeredObjectAnnotation.adminObjectInterfaces();
                Object var15_51 = null;
                for (AdminObject admObj : adminObjects) {
                    if (!admObj.getAdminObjectClass().equals(cls.getName())) continue;
                    AdminObject adminObject = admObj;
                }
                if (var15_52 != null) continue;
                for (Class iface : adminObjectInterfaces) {
                    AdminObject newAdminObject = new AdminObject();
                    newAdminObject.setAdminObjectClass(cls.getName());
                    newAdminObject.setAdminObjectInterface(iface.getName());
                    adminObjects.add(newAdminObject);
                }
            }
            String raCls = connector.getResourceAdapter().getResourceAdapterClass();
            this.process(connectorModule.getClassLoader(), raCls, connector.getResourceAdapter());
            if (connector.getResourceAdapter() != null && connector.getResourceAdapter().getOutboundResourceAdapter() != null) {
                List connectionDefinitions = connector.getResourceAdapter().getOutboundResourceAdapter().getConnectionDefinition();
                for (ConnectionDefinition connectionDefinition : connectionDefinitions) {
                    this.process(connectorModule.getClassLoader(), connectionDefinition.getManagedConnectionFactoryClass(), connectionDefinition);
                }
            }
            if (connector.getResourceAdapter() != null) {
                List raAdminObjects = connector.getResourceAdapter().getAdminObject();
                for (AdminObject raAdminObject : raAdminObjects) {
                    this.process(connectorModule.getClassLoader(), raAdminObject.getAdminObjectClass(), raAdminObject);
                }
            }
            if (connector.getResourceAdapter() != null && connector.getResourceAdapter().getInboundResourceAdapter() != null && connector.getResourceAdapter().getInboundResourceAdapter().getMessageAdapter() != null) {
                List messageListeners = connector.getResourceAdapter().getInboundResourceAdapter().getMessageAdapter().getMessageListener();
                for (MessageListener messageListener : messageListeners) {
                    ActivationSpec activationSpec = messageListener.getActivationSpec();
                    this.process(connectorModule.getClassLoader(), activationSpec.getActivationSpecClass(), activationSpec);
                }
            }
            return connectorModule;
        }

        void process(ClassLoader cl, String cls, Object object) {
            List configProperties = null;
            try {
                configProperties = (List)object.getClass().getDeclaredMethod("getConfigProperty", new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configProperties == null) {
                return;
            }
            ClassLoader classLoader = cl;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            List<String> allowedTypes = Arrays.asList(Boolean.class.getName(), String.class.getName(), Integer.class.getName(), Double.class.getName(), Byte.class.getName(), Short.class.getName(), Long.class.getName(), Float.class.getName(), Character.class.getName());
            try {
                Field[] declaredFields;
                Object value;
                PropertyDescriptor[] propertyDescriptors;
                Class<?> clazz = classLoader.loadClass(AnnotationDeployer.realClassName(cls));
                Object o = clazz.newInstance();
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                    String name = propertyDescriptor.getName();
                    Class<?> type = propertyDescriptor.getPropertyType();
                    if (type == null) continue;
                    if (type.isPrimitive()) {
                        type = this.getWrapper(type.getName());
                    }
                    if (!allowedTypes.contains(type.getName()) || this.containsConfigProperty(configProperties, name)) continue;
                    ConfigProperty configProperty = new ConfigProperty();
                    configProperties.add(configProperty);
                    value = null;
                    if (propertyDescriptor.getReadMethod() != null) {
                        try {
                            value = propertyDescriptor.getReadMethod().invoke(o, new Object[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    java.lang.reflect.Method write = propertyDescriptor.getWriteMethod();
                    jakarta.resource.spi.ConfigProperty annotation = null;
                    if (write != null && (annotation = write.getAnnotation(jakarta.resource.spi.ConfigProperty.class)) == null) {
                        try {
                            annotation = clazz.getDeclaredField(name).getAnnotation(jakarta.resource.spi.ConfigProperty.class);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    configProperty.setConfigPropertyName(name);
                    configProperty.setConfigPropertyType(this.getConfigPropertyType(annotation, type));
                    if (value != null) {
                        configProperty.setConfigPropertyValue(value.toString());
                    }
                    if (annotation == null) continue;
                    if (annotation.defaultValue() != null && annotation.defaultValue().length() > 0) {
                        configProperty.setConfigPropertyValue(annotation.defaultValue());
                    }
                    configProperty.setConfigPropertyConfidential(Boolean.valueOf(annotation.confidential()));
                    configProperty.setConfigPropertyIgnore(Boolean.valueOf(annotation.ignore()));
                    configProperty.setConfigPropertySupportsDynamicUpdates(Boolean.valueOf(annotation.supportsDynamicUpdates()));
                    configProperty.setDescriptions(this.stringsToTexts(annotation.description()));
                }
                for (Field field : declaredFields = clazz.getDeclaredFields()) {
                    String type;
                    jakarta.resource.spi.ConfigProperty annotation = field.getAnnotation(jakarta.resource.spi.ConfigProperty.class);
                    String name = field.getName();
                    value = null;
                    try {
                        value = field.get(o);
                    }
                    catch (Exception write) {
                        // empty catch block
                    }
                    if (this.containsConfigProperty(configProperties, name) || (type = this.getConfigPropertyType(annotation, field.getType())) == null) continue;
                    ConfigProperty configProperty = new ConfigProperty();
                    configProperties.add(configProperty);
                    configProperty.setConfigPropertyName(name);
                    configProperty.setConfigPropertyType(type);
                    if (value != null) {
                        configProperty.setConfigPropertyValue(value.toString());
                    }
                    if (annotation == null) continue;
                    if (annotation.defaultValue() != null) {
                        configProperty.setConfigPropertyValue(annotation.defaultValue());
                    }
                    configProperty.setConfigPropertyConfidential(Boolean.valueOf(annotation.confidential()));
                    configProperty.setConfigPropertyIgnore(Boolean.valueOf(annotation.ignore()));
                    configProperty.setConfigPropertySupportsDynamicUpdates(Boolean.valueOf(annotation.supportsDynamicUpdates()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private String getConfigPropertyType(jakarta.resource.spi.ConfigProperty annotation, Class<?> type) {
            Class<?> t;
            Class<?> clazz = t = annotation == null ? null : annotation.type();
            if (t == null && type != null) {
                return type.getName();
            }
            if (t == null) {
                return null;
            }
            if (t.equals(Object.class)) {
                t = type;
            }
            if (t == null) {
                return null;
            }
            if (t.isPrimitive()) {
                t = this.getWrapper(t.getName());
            }
            return t.getName();
        }

        private boolean containsConfigProperty(List<ConfigProperty> configProperties, String name) {
            for (ConfigProperty configProperty : configProperties) {
                if (!configProperty.getConfigPropertyName().equals(name)) continue;
                return true;
            }
            return false;
        }

        private Class<?> getWrapper(String primitiveType) {
            HashMap<String, Class<Short>> builtInMap = new HashMap<String, Class<Short>>();
            builtInMap.put("int", Integer.class);
            builtInMap.put("long", Long.class);
            builtInMap.put("double", Double.class);
            builtInMap.put("float", Float.class);
            builtInMap.put("boolean", Boolean.class);
            builtInMap.put("char", Character.class);
            builtInMap.put("byte", Byte.class);
            builtInMap.put("void", Void.class);
            builtInMap.put("short", Short.class);
            return (Class)builtInMap.get(primitiveType);
        }

        private void processConnectionDescription(ResourceAdapter resourceAdapter, jakarta.resource.spi.ConnectionDefinition connectionDefinitionAnnotation, Class<?> cls) {
            OutboundResourceAdapter outboundResourceAdapter = resourceAdapter.getOutboundResourceAdapter();
            if (outboundResourceAdapter == null) {
                outboundResourceAdapter = new OutboundResourceAdapter();
                resourceAdapter.setOutboundResourceAdapter(outboundResourceAdapter);
            }
            List connectionDefinition = outboundResourceAdapter.getConnectionDefinition();
            ConnectionDefinition definition = null;
            for (ConnectionDefinition cd : connectionDefinition) {
                if (!cd.getManagedConnectionFactoryClass().equals(cls.getName())) continue;
                definition = cd;
                break;
            }
            if (definition == null) {
                definition = new ConnectionDefinition();
                outboundResourceAdapter.getConnectionDefinition().add(definition);
            }
            if (definition.getManagedConnectionFactoryClass() == null) {
                definition.setManagedConnectionFactoryClass(cls.getName());
            }
            if (definition.getConnectionInterface() == null) {
                definition.setConnectionInterface(connectionDefinitionAnnotation.connection().getName());
            }
            if (definition.getConnectionImplClass() == null) {
                definition.setConnectionImplClass(connectionDefinitionAnnotation.connectionImpl().getName());
            }
            if (definition.getConnectionFactoryInterface() == null) {
                definition.setConnectionFactoryInterface(connectionDefinitionAnnotation.connectionFactory().getName());
            }
            if (definition.getConnectionFactoryImplClass() == null) {
                definition.setConnectionFactoryImplClass(connectionDefinitionAnnotation.connectionFactoryImpl().getName());
            }
        }

        private Text[] stringsToTexts(String[] strings) {
            if (strings == null) {
                return null;
            }
            Text[] result = new Text[strings.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new Text();
                result[i].setValue(strings[i]);
            }
            return result;
        }

        private String getString(String descriptorString, String annotationString) {
            if (descriptorString != null && descriptorString.length() > 0) {
                return descriptorString;
            }
            if (annotationString != null && annotationString.length() > 0) {
                return annotationString;
            }
            return null;
        }

        private Text[] getTexts(Text[] originalTexts, String[] newStrings) {
            if (newStrings != null && newStrings.length > 0 && (originalTexts == null || originalTexts.length == 0)) {
                Text[] texts = new Text[newStrings.length];
                for (int i = 0; i < newStrings.length; ++i) {
                    texts[i] = new Text(null, newStrings[i]);
                }
                return texts;
            }
            return originalTexts;
        }

        public WebModule deploy(WebModule webModule) throws OpenEJBException {
            List found;
            boolean restHandledByTheWebApp;
            WebApp webApp = webModule.getWebApp();
            if (webApp != null && webApp.isMetadataComplete().booleanValue()) {
                return webModule;
            }
            try {
                if (webModule.getFinder() == null) {
                    webModule.setFinder(FinderFactory.createFinder(webModule));
                }
            }
            catch (Exception e) {
                startupLogger.warning("Unable to scrape for @WebService or @WebServiceProvider annotations. AnnotationFinder failed.", e);
                return webModule;
            }
            if (webApp == null) {
                webApp = new WebApp();
                webModule.setWebApp(webApp);
            }
            ArrayList<String> existingServlets = new ArrayList<String>();
            for (Servlet servlet : webApp.getServlet()) {
                if (servlet.getServletClass() == null) continue;
                existingServlets.add(servlet.getServletClass());
            }
            IAnnotationFinder finder = webModule.getFinder();
            ArrayList classes = new ArrayList();
            classes.addAll(finder.findAnnotatedClasses(WebService.class));
            classes.addAll(finder.findAnnotatedClasses(WebServiceProvider.class));
            for (Class webServiceClass : classes) {
                if (webServiceClass.isAnnotationPresent(Singleton.class) || webServiceClass.isAnnotationPresent(Stateless.class)) {
                    webModule.getEjbWebServices().add(webServiceClass.getName());
                    continue;
                }
                int modifiers = webServiceClass.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isAbstract(modifiers) || existingServlets.contains(webServiceClass.getName())) continue;
                Servlet servlet = new Servlet();
                servlet.setServletName(webServiceClass.getName());
                servlet.setServletClass(webServiceClass.getName());
                ParamValue param = new ParamValue();
                param.setParamName("openejb-internal");
                param.setParamValue("true");
                servlet.getInitParam().add(param);
                webApp.getServlet().add(servlet);
            }
            try {
                restHandledByTheWebApp = webModule.getClassLoader().loadClass(Application.class.getName()) != Application.class;
            }
            catch (Throwable e) {
                restHandledByTheWebApp = false;
            }
            if (!restHandledByTheWebApp) {
                webModule.getRestClasses().addAll(AnnotationDeployer.findRestClasses(webModule, finder));
                this.addJaxRsProviders(finder, webModule.getJaxrsProviders(), Provider.class);
                List applications = finder.findSubclasses(Application.class);
                for (Object app : applications) {
                    DiscoverAnnotatedBeans.addRestApplicationIfPossible(webModule, (Class<? extends Application>)app);
                }
                List applicationsByAnnotation = finder.findMetaAnnotatedClasses(ApplicationPath.class);
                for (Annotated annotatedApp : applicationsByAnnotation) {
                    Class app = (Class)annotatedApp.get();
                    if (!Application.class.isAssignableFrom(app)) {
                        logger.error("class '" + app.getName() + "' is annotated with @ApplicationPath but doesn't implement " + Application.class.getName());
                        continue;
                    }
                    DiscoverAnnotatedBeans.addRestApplicationIfPossible(webModule, app);
                }
            }
            IAnnotationFinder parentFinder = null;
            AppModule appModule = webModule.getAppModule();
            if (appModule != null) {
                parentFinder = appModule.getEarLibFinder();
            }
            ClassLoader classLoader = webModule.getClassLoader();
            for (String jsfClass : JSF_CLASSES) {
                Class<?> clazz;
                try {
                    clazz = classLoader.loadClass(jsfClass);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                HashSet<String> convertedClasses = new HashSet<String>();
                if (parentFinder != null) {
                    List foundParent = parentFinder.findMetaAnnotatedClasses(clazz);
                    for (Annotated annotated : foundParent) {
                        convertedClasses.add(((Class)annotated.get()).getName());
                    }
                    for (EjbModule module : appModule.getEjbModules()) {
                        if (appModule.isWebapp() || module.isWebapp() && !module.getModuleId().equals(webModule.getModuleId())) continue;
                        List ejbFound = module.getFinder().findMetaAnnotatedClasses(clazz);
                        for (Annotated annotated : ejbFound) {
                            convertedClasses.add(((Class)annotated.get()).getName());
                        }
                    }
                }
                found = finder.findMetaAnnotatedClasses(clazz);
                for (Annotated annotated : found) {
                    convertedClasses.add(((Class)annotated.get()).getName());
                }
                webModule.getJsfAnnotatedClasses().put(jsfClass, convertedClasses);
            }
            Map<String, String> urlByClasses = null;
            for (String apiClassName : WEB_CLASSES) {
                Class<?> clazz;
                try {
                    clazz = classLoader.loadClass(apiClassName);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                if (urlByClasses == null) {
                    urlByClasses = FinderFactory.urlByClass(finder);
                }
                found = finder.findMetaAnnotatedClasses(clazz);
                AnnotationDeployer.addWebAnnotatedClassInfo(urlByClasses, webModule.getWebAnnotatedClasses(), found);
            }
            if (urlByClasses != null) {
                urlByClasses.clear();
            }
            return webModule;
        }

        private void addJaxRsProviders(IAnnotationFinder finder, Collection<String> set, Class<? extends Annotation> annotation) {
            for (Annotated provider : finder.findMetaAnnotatedClasses(annotation)) {
                set.add(((Class)provider.get()).getName());
            }
        }

        private static void addRestApplicationIfPossible(WebModule webModule, Class<? extends Application> app) {
            if (!AnnotationDeployer.isInstantiable(app)) {
                return;
            }
            if (app.getConstructors().length == 0) {
                webModule.getRestApplications().add(app.getName());
            } else {
                for (Constructor<?> ctr : app.getConstructors()) {
                    if (ctr.getParameterTypes().length != 0) continue;
                    webModule.getRestApplications().add(app.getName());
                    break;
                }
            }
        }

        public EjbModule deploy(EjbModule ejbModule) throws OpenEJBException {
            boolean deployComp;
            SessionBean sessionBean;
            EnterpriseBean enterpriseBean;
            String ejbName;
            if (ejbModule.getEjbJar() != null && ejbModule.getEjbJar().isMetadataComplete().booleanValue()) {
                return ejbModule;
            }
            try {
                if (ejbModule.getFinder() == null) {
                    ejbModule.setFinder(FinderFactory.createFinder(ejbModule));
                }
            }
            catch (MalformedURLException e) {
                startupLogger.warning("startup.scrapeFailedForModule", ejbModule.getJarLocation());
                return ejbModule;
            }
            catch (Exception e) {
                startupLogger.warning("Unable to scrape for @Stateful, @Stateless, @Singleton or @MessageDriven annotations. AnnotationFinder failed.", e);
                return ejbModule;
            }
            IAnnotationFinder finder = ejbModule.getFinder();
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                SessionBean sessionBean2;
                if (!(bean instanceof SessionBean) || (sessionBean2 = (SessionBean)bean).getSessionType() != null) continue;
                try {
                    Class<?> clazz = ejbModule.getClassLoader().loadClass(bean.getEjbClass());
                    sessionBean2.setSessionType(this.getSessionType(clazz));
                }
                catch (Throwable clazz) {
                    // empty catch block
                }
            }
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                if (bean.getEjbClass() == null || bean.getEjbName() != null && !bean.getEjbName().startsWith("@NULL@")) continue;
                ejbModule.getEjbJar().removeEnterpriseBean(bean.getEjbName());
                try {
                    Class<?> clazz = ejbModule.getClassLoader().loadClass(bean.getEjbClass());
                    String ejbName2 = this.getEjbName(bean, clazz);
                    bean.setEjbName(ejbName2);
                }
                catch (Throwable clazz) {
                    // empty catch block
                }
                ejbModule.getEjbJar().addEnterpriseBean(bean);
            }
            EjbJar ejbJar = ejbModule.getEjbJar();
            for (Annotated beanClass : finder.findMetaAnnotatedClasses(Singleton.class)) {
                Singleton singleton;
                if (!this.isValidEjbAnnotationUsage(Singleton.class, beanClass, ejbName = this.getEjbName(singleton = (Singleton)beanClass.getAnnotation(Singleton.class), (Class)beanClass.get()), ejbModule)) continue;
                enterpriseBean = ejbJar.getEnterpriseBean(ejbName);
                if (enterpriseBean == null) {
                    enterpriseBean = new SingletonBean(ejbName, (Class)beanClass.get());
                    ejbJar.addEnterpriseBean(enterpriseBean);
                }
                if (enterpriseBean.getEjbClass() == null) {
                    enterpriseBean.setEjbClass((Class)beanClass.get());
                }
                if (enterpriseBean instanceof SessionBean) {
                    sessionBean = (SessionBean)enterpriseBean;
                    sessionBean.setSessionType(SessionType.SINGLETON);
                    if (singleton.mappedName() != null) {
                        sessionBean.setMappedName(singleton.mappedName());
                    }
                }
                LegacyProcessor.process((Class)beanClass.get(), enterpriseBean);
            }
            for (Annotated beanClass : finder.findMetaAnnotatedClasses(Stateless.class)) {
                Stateless stateless;
                if (!this.isValidEjbAnnotationUsage(Stateless.class, beanClass, ejbName = this.getEjbName(stateless = (Stateless)beanClass.getAnnotation(Stateless.class), (Class)beanClass.get()), ejbModule)) continue;
                enterpriseBean = ejbJar.getEnterpriseBean(ejbName);
                if (enterpriseBean == null) {
                    enterpriseBean = new StatelessBean(ejbName, (Class)beanClass.get());
                    ejbJar.addEnterpriseBean(enterpriseBean);
                }
                if (enterpriseBean.getEjbClass() == null) {
                    enterpriseBean.setEjbClass((Class)beanClass.get());
                }
                if (enterpriseBean instanceof SessionBean) {
                    sessionBean = (SessionBean)enterpriseBean;
                    sessionBean.setSessionType(SessionType.STATELESS);
                    if (stateless.mappedName() != null) {
                        sessionBean.setMappedName(stateless.mappedName());
                    }
                }
                LegacyProcessor.process((Class)beanClass.get(), enterpriseBean);
            }
            for (Annotated beanClass : finder.findMetaAnnotatedClasses(Stateful.class)) {
                Stateful stateful;
                if (!this.isValidEjbAnnotationUsage(Stateful.class, beanClass, ejbName = this.getEjbName(stateful = (Stateful)beanClass.getAnnotation(Stateful.class), (Class)beanClass.get()), ejbModule)) continue;
                enterpriseBean = ejbJar.getEnterpriseBean(ejbName);
                if (enterpriseBean == null) {
                    enterpriseBean = new StatefulBean(ejbName, (Class)beanClass.get());
                    ejbJar.addEnterpriseBean(enterpriseBean);
                }
                if (enterpriseBean.getEjbClass() == null) {
                    enterpriseBean.setEjbClass((Class)beanClass.get());
                }
                if (enterpriseBean instanceof SessionBean) {
                    sessionBean = (SessionBean)enterpriseBean;
                    sessionBean.setSessionType(SessionType.STATEFUL);
                    if (stateful.mappedName() != null) {
                        sessionBean.setMappedName(stateful.mappedName());
                    }
                    if (sessionBean.getPassivationCapable() == null) {
                        sessionBean.setPassivationCapable(Boolean.valueOf(stateful.passivationCapable()));
                    }
                }
                LegacyProcessor.process((Class)beanClass.get(), enterpriseBean);
            }
            for (Annotated beanClass : finder.findMetaAnnotatedClasses(ManagedBean.class)) {
                ManagedBean managed;
                if (!this.isValidEjbAnnotationUsage(ManagedBean.class, beanClass, ejbName = this.getEjbName(managed = (ManagedBean)beanClass.getAnnotation(ManagedBean.class), (Class)beanClass.get()), ejbModule)) continue;
                enterpriseBean = ejbJar.getEnterpriseBean(ejbName);
                if (enterpriseBean == null) {
                    enterpriseBean = new org.apache.openejb.jee.ManagedBean(ejbName, (Class)beanClass.get());
                    ejbJar.addEnterpriseBean(enterpriseBean);
                }
                if (enterpriseBean.getEjbClass() == null) {
                    enterpriseBean.setEjbClass((Class)beanClass.get());
                }
                if (!(enterpriseBean instanceof SessionBean)) continue;
                sessionBean = (SessionBean)enterpriseBean;
                sessionBean.setSessionType(SessionType.MANAGED);
                org.apache.openejb.jee.TransactionType transactionType = sessionBean.getTransactionType();
                if (transactionType != null) continue;
                sessionBean.setTransactionType(org.apache.openejb.jee.TransactionType.BEAN);
            }
            for (Annotated beanClass : finder.findMetaAnnotatedClasses(MessageDriven.class)) {
                Object mdb;
                if (!this.isValidEjbAnnotationUsage(MessageDriven.class, beanClass, ejbName = this.getEjbName((MessageDriven)(mdb = (MessageDriven)beanClass.getAnnotation(MessageDriven.class)), (Class)beanClass.get()), ejbModule)) continue;
                MessageDrivenBean messageBean = (MessageDrivenBean)ejbJar.getEnterpriseBean(ejbName);
                if (messageBean == null) {
                    messageBean = new MessageDrivenBean(ejbName);
                    ejbJar.addEnterpriseBean((EnterpriseBean)messageBean);
                }
                if (messageBean.getEjbClass() == null) {
                    messageBean.setEjbClass((Class)beanClass.get());
                }
                LegacyProcessor.process((Class)beanClass.get(), (EnterpriseBean)messageBean);
            }
            AssemblyDescriptor assemblyDescriptor = ejbModule.getEjbJar().getAssemblyDescriptor();
            if (assemblyDescriptor == null) {
                assemblyDescriptor = new AssemblyDescriptor();
                ejbModule.getEjbJar().setAssemblyDescriptor(assemblyDescriptor);
            }
            startupLogger.debug("Searching for annotated application exceptions (see OPENEJB-980)");
            List appExceptions = finder.findAnnotatedClasses(ApplicationException.class);
            for (Class exceptionClass : appExceptions) {
                startupLogger.debug("...handling " + String.valueOf(exceptionClass));
                ApplicationException annotation = exceptionClass.getAnnotation(ApplicationException.class);
                if (assemblyDescriptor.getApplicationException(exceptionClass) == null) {
                    startupLogger.debug("...adding " + String.valueOf(exceptionClass) + " with rollback=" + annotation.rollback());
                    assemblyDescriptor.addApplicationException(exceptionClass, annotation.rollback(), annotation.inherited());
                    continue;
                }
                AnnotationDeployer.mergeApplicationExceptionAnnotation(assemblyDescriptor, exceptionClass, annotation);
            }
            Beans beans = ejbModule.getBeans();
            if (beans == null && !ejbJar.getEnterpriseBeansByEjbName().isEmpty() && this.isActivateCdiForEjbOnlyModules(ejbModule)) {
                logger.info("Activating CDI in ACTIVATED mode in module '" + String.valueOf(ejbModule.getModuleUri()) + "' cause EJB were found\n  add openejb.cdi.activated=false in application.properties to switch it off or\n  openejb.cdi.activated-on-ejb=false in conf/system.properties  to switch it off");
                beans = new Beans();
                beans.setBeanDiscoveryMode("ANNOTATED");
                beans.setVersion("1.1");
                try {
                    ejbModule.getModuleUri().toURL();
                    beans.setUri(ejbModule.getModuleUri().toASCIIString());
                }
                catch (IllegalArgumentException | MalformedURLException iae) {
                    beans.setUri(URI.create("jar:file://!/" + ejbModule.getModuleUri().toASCIIString() + "/META-INF/beans.xml").toASCIIString());
                }
                ejbModule.setBeans(beans);
                deployComp = false;
            } else {
                deployComp = true;
            }
            if (beans != null) {
                Map managedClasses = beans.getManagedClasses();
                this.getBeanClasses(beans.getUri(), finder, managedClasses, beans.getNotManagedClasses(), ejbModule.getAltDDs());
                if (deployComp) {
                    Object id = ejbModule.getModuleId();
                    if (ejbModule.getJarLocation() != null && (ejbModule.getJarLocation().contains(ejbModule.getModuleId() + "/target/test-classes".replace("/", File.separator)) || ejbModule.getJarLocation().contains(ejbModule.getModuleId() + "/build/classes/test".replace("/", File.separator)))) {
                        id = (String)id + "_test";
                    }
                    String name = BeanContext.Comp.openejbCompName((String)id);
                    CompManagedBean managedBean = new CompManagedBean(name, BeanContext.Comp.class);
                    managedBean.setTransactionType(org.apache.openejb.jee.TransactionType.BEAN);
                    ejbModule.getEjbJar().addEnterpriseBean((EnterpriseBean)managedBean);
                    if ("true".equals(SystemInstance.get().getProperty("openejb.cdi.support.@Startup", "true"))) {
                        List forceStart = finder.findMetaAnnotatedClasses(Startup.class);
                        List startupBeans = beans.getStartupBeans();
                        for (Annotated clazz : forceStart) {
                            startupBeans.add(((Class)clazz.get()).getName());
                        }
                    }
                }
            }
            if (ejbModule.getAppModule() != null) {
                this.addJaxRsProviders(finder, ejbModule.getAppModule().getJaxRsProviders(), Provider.class);
            }
            AnnotationDeployer.autoJpa(ejbModule);
            return ejbModule;
        }

        private boolean isActivateCdiForEjbOnlyModules(EjbModule ejbModule) {
            String activated = ejbModule.getProperties().getProperty("openejb.cdi.activated");
            String globalConfig = SystemInstance.get().getProperty("openejb.cdi.activated-on-ejb");
            return (globalConfig == null || Boolean.parseBoolean(globalConfig)) && (activated == null && this.hasAtInject(ejbModule) || activated != null && Boolean.parseBoolean(activated));
        }

        private boolean hasAtInject(EjbModule ejbModule) {
            IAnnotationFinder finder = ejbModule.getFinder();
            return finder != null && (!finder.findAnnotatedFields(Inject.class).isEmpty() || !finder.findAnnotatedConstructors(Inject.class).isEmpty() || !finder.findAnnotatedMethods(Inject.class).isEmpty());
        }

        private SessionType getSessionType(Class<?> clazz) {
            if (clazz.isAnnotationPresent(Stateful.class)) {
                return SessionType.STATEFUL;
            }
            if (clazz.isAnnotationPresent(Stateless.class)) {
                return SessionType.STATELESS;
            }
            if (clazz.isAnnotationPresent(Singleton.class)) {
                return SessionType.SINGLETON;
            }
            if (clazz.isAnnotationPresent(ManagedBean.class)) {
                return SessionType.MANAGED;
            }
            return null;
        }

        private String getEjbName(EnterpriseBean bean, Class<?> clazz) {
            MessageDriven annotation;
            if (bean instanceof SessionBean) {
                SessionBean sessionBean = (SessionBean)bean;
                switch (sessionBean.getSessionType()) {
                    case STATEFUL: {
                        Stateful annotation2 = clazz.getAnnotation(Stateful.class);
                        if (annotation2 != null && DiscoverAnnotatedBeans.specified(annotation2.name())) {
                            return annotation2.name();
                        }
                    }
                    case STATELESS: {
                        Stateful annotation2 = clazz.getAnnotation(Stateless.class);
                        if (annotation2 != null && DiscoverAnnotatedBeans.specified(annotation2.name())) {
                            return annotation2.name();
                        }
                    }
                    case SINGLETON: {
                        Stateful annotation2 = clazz.getAnnotation(Singleton.class);
                        if (annotation2 == null || !DiscoverAnnotatedBeans.specified(annotation2.name())) break;
                        return annotation2.name();
                    }
                }
            }
            if (bean instanceof MessageDrivenBean && (annotation = clazz.getAnnotation(MessageDriven.class)) != null && DiscoverAnnotatedBeans.specified(annotation.name())) {
                return annotation.name();
            }
            return clazz.getSimpleName();
        }

        private static boolean specified(String name) {
            return name != null && name.length() != 0;
        }

        private void getBeanClasses(String uri, IAnnotationFinder finder, Map<URL, List<String>> classes, Map<URL, List<String>> notManaged, Map<String, Object> altDD) {
            IAnnotationFinder delegate;
            IAnnotationFinder iAnnotationFinder = delegate = FinderFactory.ModuleLimitedFinder.class.isInstance(finder) ? ((FinderFactory.ModuleLimitedFinder)FinderFactory.ModuleLimitedFinder.class.cast(finder)).getDelegate() : finder;
            if (!AnnotationFinder.class.isInstance(delegate)) {
                return;
            }
            AnnotationFinder annotationFinder = (AnnotationFinder)AnnotationFinder.class.cast(delegate);
            Archive archive = annotationFinder.getArchive();
            if (!WebappAggregatedArchive.class.isInstance(archive)) {
                try {
                    List annotatedClassNames = annotationFinder.getAnnotatedClassNames();
                    if (!annotatedClassNames.isEmpty()) {
                        classes.put(uri == null ? null : new URL(uri), annotatedClassNames);
                    }
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
                return;
            }
            WebappAggregatedArchive aggregatedArchive = (WebappAggregatedArchive)archive;
            Map<URL, List<String>> map = aggregatedArchive.getClassesMap();
            HashSet discoveredBeans = null;
            List extensions = null;
            FolderDDMapper ddMapper = SystemInstance.get().getComponent(FolderDDMapper.class);
            for (Map.Entry<URL, List<String>> entry : map.entrySet()) {
                URL key = entry.getKey();
                URL beansXml = this.hasBeansXml(key, ddMapper);
                List<String> value = entry.getValue();
                if (beansXml != null) {
                    classes.put(beansXml, value);
                    continue;
                }
                if (value.isEmpty()) continue;
                HashSet<String> fastValue = new HashSet<String>(value);
                if (discoveredBeans == null) {
                    discoveredBeans = new HashSet();
                    HashSet containerAnnot = new HashSet();
                    containerAnnot.add(Stereotype.class);
                    containerAnnot.add(NormalScope.class);
                    containerAnnot.add(Dependent.class);
                    containerAnnot.add(ApplicationScoped.class);
                    containerAnnot.add(ConversationScoped.class);
                    containerAnnot.add(RequestScoped.class);
                    containerAnnot.add(SessionScoped.class);
                    containerAnnot.add(Model.class);
                    containerAnnot.add(Singleton.class);
                    containerAnnot.add(Stateless.class);
                    containerAnnot.add(Stateful.class);
                    containerAnnot.add(MessageDriven.class);
                    containerAnnot.add(Interceptor.class);
                    containerAnnot.add(Decorator.class);
                    ClassLoader classLoader = ParentClassLoaderFinder.Helper.get();
                    try {
                        for (String string : Arrays.asList("jakarta.faces.flow.FlowScoped", "jakarta.faces.view.ViewScoped")) {
                            containerAnnot.add(classLoader.loadClass(string));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    HashSet<Class> newMarkers = new HashSet<Class>();
                    for (Object a : containerAnnot) {
                        newMarkers.addAll(finder.findAnnotatedClasses((Class)a));
                    }
                    do {
                        Object a;
                        HashSet hashSet = new HashSet(newMarkers);
                        newMarkers.clear();
                        a = hashSet.iterator();
                        while (a.hasNext()) {
                            Class marker = (Class)a.next();
                            discoveredBeans.add(marker);
                            List found = finder.findAnnotatedClasses((Class)Class.class.cast(marker));
                            for (Class c : found) {
                                if (c.isAnnotation()) {
                                    newMarkers.add(c);
                                }
                                discoveredBeans.add(c);
                            }
                        }
                    } while (!newMarkers.isEmpty());
                    for (Field field : finder.findAnnotatedFields(Delegate.class)) {
                        discoveredBeans.add(field.getDeclaringClass());
                    }
                    extensions = finder.findImplementations(Extension.class);
                }
                boolean skip = false;
                for (Class c : extensions) {
                    if (!fastValue.contains(c.getName())) continue;
                    skip = true;
                }
                if (skip) continue;
                HashSet<String> beans = new HashSet<String>();
                for (Class clazz : discoveredBeans) {
                    String name = clazz.getName();
                    if (!fastValue.contains(name)) continue;
                    beans.add(name);
                }
                if (beans.isEmpty()) continue;
                notManaged.put(entry.getKey(), new ArrayList(beans));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public URL hasBeansXml(URL url, FolderDDMapper ddMapper) {
            String urlPath = url.getPath();
            if (urlPath.endsWith("/WEB-INF/beans.xml")) {
                return url;
            }
            if (urlPath.endsWith("WEB-INF/classes/") || urlPath.endsWith("WEB-INF/classes")) {
                File toFile = URLs.toFile(url);
                File file = new File(toFile.getParent(), "beans.xml");
                if (file.exists()) {
                    try {
                        return file.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        return url;
                    }
                }
                file = new File(toFile, "META-INF/beans.xml");
                if (!file.exists()) return null;
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    return url;
                }
            }
            if (url.getPath().endsWith("!/META-INF/beans.xml")) {
                return url;
            }
            try (URLClassLoader loader2 = new URLClassLoader(new URL[]{url}, (ClassLoader)new EmptyResourcesClassLoader());){
                String[] paths;
                for (String path : paths = new String[]{"META-INF/beans.xml", "WEB-INF/beans.xml", "/WEB-INF/beans.xml", "/META-INF/beans.xml"}) {
                    URL resource = loader2.findResource(path);
                    if (resource == null) continue;
                    URL uRL = resource;
                    return uRL;
                }
            }
            catch (Exception loader2) {
                // empty catch block
            }
            if (ddMapper == null) return null;
            File asFile = URLs.toFile(url);
            if (!asFile.isDirectory()) return null;
            File ddFolder = ddMapper.getDDFolder(asFile);
            File file = new File(ddFolder, "beans.xml");
            if (!file.isFile()) return null;
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return null;
        }

        private String getEjbName(MessageDriven mdb, Class<?> beanClass) {
            return mdb.name().isEmpty() ? beanClass.getSimpleName() : mdb.name();
        }

        private String getEjbName(Stateful stateful, Class<?> beanClass) {
            return stateful.name().isEmpty() ? beanClass.getSimpleName() : stateful.name();
        }

        private String getEjbName(Stateless stateless, Class<?> beanClass) {
            return stateless.name().isEmpty() ? beanClass.getSimpleName() : stateless.name();
        }

        private String getEjbName(Singleton singleton, Class<?> beanClass) {
            return singleton.name().isEmpty() ? beanClass.getSimpleName() : singleton.name();
        }

        private String getEjbName(ManagedBean managed, Class<?> beanClass) {
            return managed.value().isEmpty() ? beanClass.getSimpleName() : managed.value();
        }

        private boolean isValidEjbAnnotationUsage(Class annotationClass, Annotated<Class<?>> beanClass, String ejbName, EjbModule ejbModule) {
            ArrayList<Class> annotations = new ArrayList<Class>(Arrays.asList(Singleton.class, Stateless.class, Stateful.class, MessageDriven.class));
            annotations.remove(annotationClass);
            boolean b = true;
            for (Class secondAnnotation : annotations) {
                Annotation annotation = beanClass.getAnnotation(secondAnnotation);
                if (annotation == null) continue;
                String secondEjbName = null;
                if (annotation instanceof Stateful) {
                    secondEjbName = this.getEjbName((Stateful)annotation, (Class)beanClass.get());
                } else if (annotation instanceof Stateless) {
                    secondEjbName = this.getEjbName((Stateless)annotation, (Class)beanClass.get());
                } else if (annotation instanceof Singleton) {
                    secondEjbName = this.getEjbName((Singleton)annotation, (Class)beanClass.get());
                } else if (annotation instanceof MessageDriven) {
                    secondEjbName = this.getEjbName((MessageDriven)annotation, (Class)beanClass.get());
                }
                if (!ejbName.equals(secondEjbName)) continue;
                ejbModule.getValidation().fail(ejbName, "multiplyAnnotatedAsBean", annotationClass.getSimpleName(), secondAnnotation.getSimpleName(), ejbName, ((Class)beanClass.get()).getName());
            }
            if (((Class)beanClass.get()).isInterface()) {
                if (!CheckClasses.isAbstractAllowed((Class)beanClass.get())) {
                    ejbModule.getValidation().fail(ejbName, "interfaceAnnotatedAsBean", annotationClass.getSimpleName(), ((Class)beanClass.get()).getName());
                    return false;
                }
            } else if (Modifier.isAbstract(((Class)beanClass.get()).getModifiers()) && !CheckClasses.isAbstractAllowed((Class)beanClass.get())) {
                ejbModule.getValidation().fail(ejbName, "abstractAnnotatedAsBean", annotationClass.getSimpleName(), ((Class)beanClass.get()).getName());
                return false;
            }
            return true;
        }
    }

    public static class ProcessAnnotatedBeans
    implements DynamicDeployer {
        public static final String STRICT_INTERFACE_DECLARATION = "openejb.strict.interface.declaration";
        private final boolean webserviceAsRemote;

        public ProcessAnnotatedBeans(boolean wsAsRemote) {
            this.webserviceAsRemote = wsAsRemote;
        }

        public void deploy(CdiBeanInfo beanInfo) throws OpenEJBException {
            AnnotationFinder annotationFinder = this.createFinder(beanInfo.getBeanClass());
            this.buildAnnotatedRefs(beanInfo, (IAnnotationFinder)annotationFinder, beanInfo.getClassLoader());
            this.processWebServiceClientHandlers(beanInfo, annotationFinder, beanInfo.getClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppModule deploy(AppModule appModule) throws OpenEJBException {
            for (EjbModule ejbModule : appModule.getEjbModules()) {
                AnnotationDeployer.setModule(ejbModule);
                try {
                    this.deploy(ejbModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (ClientModule clientModule : appModule.getClientModules()) {
                AnnotationDeployer.setModule(clientModule);
                try {
                    this.deploy(clientModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (ConnectorModule connectorModule : appModule.getConnectorModules()) {
                AnnotationDeployer.setModule(connectorModule);
                try {
                    this.deploy(connectorModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            for (WebModule webModule : appModule.getWebModules()) {
                AnnotationDeployer.setModule(webModule);
                try {
                    this.deploy(webModule);
                }
                finally {
                    AnnotationDeployer.removeModule();
                }
            }
            return appModule;
        }

        public ClientModule deploy(ClientModule clientModule) throws OpenEJBException {
            AnnotationFinder annotationFinder;
            Class<?> clazz;
            String className;
            if (clientModule.getApplicationClient() != null && clientModule.getApplicationClient().isMetadataComplete().booleanValue()) {
                return clientModule;
            }
            ClassLoader classLoader = clientModule.getClassLoader();
            ApplicationClient client = clientModule.getApplicationClient();
            if (client == null) {
                client = new ApplicationClient();
            }
            HashSet<Class> remoteClients = new HashSet<Class>();
            if (clientModule.getMainClass() != null) {
                Iterator<String> className2 = AnnotationDeployer.realClassName(clientModule.getMainClass());
                if (clientModule.getMainClass().contains("/")) {
                    clientModule.setMainClass((String)((Object)className2));
                }
                try {
                    Class<?> clazz2 = classLoader.loadClass((String)((Object)className2));
                    remoteClients.add(clazz2);
                    AnnotationFinder annotationFinder2 = this.createFinder(clazz2);
                    this.buildAnnotatedRefs((JndiConsumer)client, (IAnnotationFinder)annotationFinder2, classLoader);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    logger.debug("Could not load main class {1} for client module {2} / {3}", className2, clientModule.getJarLocation(), clientModule.getFile().getName());
                    if (clientModule.getAltDDs().containsKey("application-client.xml")) {
                        AnnotationDeployer.getValidationContext().fail("client", "client.missingMainClass", className2);
                    }
                    AnnotationDeployer.getValidationContext().warn("client", "client.missingMainClass", className2);
                }
            }
            for (String rawClassName : clientModule.getRemoteClients()) {
                className = AnnotationDeployer.realClassName(rawClassName);
                try {
                    clazz = classLoader.loadClass(className);
                    remoteClients.add(clazz);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    logger.debug("Could not load RemoteClient class {1} for client module {2} / {3}", className, clientModule.getJarLocation(), clientModule.getFile().getName());
                    throw new OpenEJBException("Unable to load RemoteClient class: " + className, e);
                }
                annotationFinder = this.createFinder(clazz);
                this.buildAnnotatedRefs((JndiConsumer)client, (IAnnotationFinder)annotationFinder, classLoader);
            }
            for (String rawClassName : clientModule.getLocalClients()) {
                className = AnnotationDeployer.realClassName(rawClassName);
                try {
                    clazz = classLoader.loadClass(className);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    logger.debug("Could not load LocalClient class {1} for client module {2} / {3}", className, clientModule.getJarLocation(), clientModule.getFile().getName());
                    throw new OpenEJBException("Unable to load LocalClient class: " + className, e);
                }
                annotationFinder = this.createFinder(clazz);
                this.buildAnnotatedRefs((JndiConsumer)client, (IAnnotationFinder)annotationFinder, classLoader);
            }
            this.validateRemoteClientRefs(classLoader, client, remoteClients);
            IAnnotationFinder finder = clientModule.getFinder();
            if (!AnnotationFinder.class.isInstance(finder) && finder != null) {
                Class[] loadedClasses = new Class[finder.getAnnotatedClassNames().size()];
                int i = 0;
                for (String s : finder.getAnnotatedClassNames()) {
                    try {
                        loadedClasses[i++] = classLoader.loadClass(s);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                clientModule.getFinderReference().set((IAnnotationFinder)new FinderFactory.OpenEJBAnnotationFinder((Archive)new ClassesArchive(loadedClasses)));
            }
            this.processWebServiceClientHandlers((JndiConsumer)client, (AnnotationFinder)AnnotationFinder.class.cast(clientModule.getFinder()), classLoader);
            return clientModule;
        }

        private void validateRemoteClientRefs(ClassLoader classLoader, ApplicationClient client, Set<Class> remoteClients) {
            Class<?> targetClass2;
            for (EjbLocalRef ref : client.getEjbLocalRef()) {
                for (InjectionTarget target : ref.getInjectionTarget()) {
                    try {
                        targetClass2 = classLoader.loadClass(AnnotationDeployer.realClassName(target.getInjectionTargetClass()));
                        for (Class remoteClient : remoteClients) {
                            if (!targetClass2.isAssignableFrom(remoteClient)) continue;
                            this.fail(remoteClient.getName(), "remoteClient.ejbLocalRef", target.getInjectionTargetClass(), target.getInjectionTargetName());
                        }
                    }
                    catch (ClassNotFoundException targetClass2) {
                    }
                }
            }
            for (EjbLocalRef ref : client.getPersistenceContextRef()) {
                for (InjectionTarget target : ref.getInjectionTarget()) {
                    try {
                        targetClass2 = classLoader.loadClass(AnnotationDeployer.realClassName(target.getInjectionTargetClass()));
                        for (Class remoteClient : remoteClients) {
                            if (!targetClass2.isAssignableFrom(remoteClient)) continue;
                            this.fail(remoteClient.getName(), "remoteClient.persistenceContextRef", target.getInjectionTargetClass(), target.getInjectionTargetName());
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
        }

        public ConnectorModule deploy(ConnectorModule connectorModule) throws OpenEJBException {
            return connectorModule;
        }

        public WebModule deploy(WebModule webModule) throws OpenEJBException {
            IAnnotationFinder finder;
            Set<String> restApp;
            WebApp webApp = webModule.getWebApp();
            if (webApp != null && webApp.isMetadataComplete().booleanValue()) {
                return webModule;
            }
            HashSet<Class> classes = new HashSet<Class>();
            ClassLoader classLoader = webModule.getClassLoader();
            String webXmlApplication = (String)webApp.contextParamsAsMap().get("jakarta.ws.rs.Application");
            if (webXmlApplication != null) {
                webModule.getRestApplications().clear();
                webModule.getRestApplications().add(webXmlApplication);
            }
            if ((restApp = webModule.getRestApplications()).isEmpty()) {
                AnnotationDeployer.addRestClassesToScannedClasses(webModule, classes, classLoader);
            } else {
                for (String rawClassName : restApp) {
                    Class<?> clazz;
                    String application = AnnotationDeployer.realClassName(rawClassName);
                    if (application == null) continue;
                    try {
                        clazz = classLoader.loadClass(application);
                        classes.add(clazz);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        logger.debug("Could not load rest Application class {1} for module {2} / {3}", application, webModule.getJarLocation(), webModule.getFile().getName());
                        throw new OpenEJBException("Unable to load Application class: " + application, e);
                    }
                    if (Modifier.isAbstract(clazz.getModifiers())) continue;
                    try {
                        Application app = (Application)Application.class.cast(clazz.newInstance());
                        try {
                            Set appClasses = app.getClasses();
                            if (!appClasses.isEmpty()) {
                                classes.addAll(appClasses);
                                continue;
                            }
                            AnnotationDeployer.addRestClassesToScannedClasses(webModule, classes, classLoader);
                        }
                        catch (RuntimeException npe) {
                            if (app != null) continue;
                            throw npe;
                        }
                    }
                    catch (InstantiationException e) {
                        throw new OpenEJBException("Unable to instantiate Application class: " + application, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new OpenEJBException("Unable to access Application class: " + application, e);
                    }
                }
            }
            block22: for (Servlet servlet : webApp.getServlet()) {
                String servletName = servlet.getServletName();
                if ("jakarta.ws.rs.core.Application".equals(servletName) || "jakarta.ws.rs.Application".equals(servletName)) {
                    boolean done = false;
                    for (ParamValue pv : servlet.getInitParam()) {
                        if (!"jakarta.ws.rs.core.Application".equals(pv.getParamName()) && !"jakarta.ws.rs.Application".equals(pv.getParamName())) continue;
                        webModule.getRestApplications().add(pv.getParamValue());
                        done = true;
                        break;
                    }
                    if (done) continue;
                    servlet.setServletName(ProvidedJAXRSApplication.class.getName());
                    webModule.getRestApplications().add(ProvidedJAXRSApplication.class.getName());
                    for (ServletMapping mapping : webApp.getServletMapping()) {
                        if (!servletName.equals(mapping.getServletName())) continue;
                        mapping.setServletName(ProvidedJAXRSApplication.class.getName());
                    }
                    continue;
                }
                String servletClass = AnnotationDeployer.realClassName(servlet.getServletClass());
                if (servletClass == null) {
                    servletClass = AnnotationDeployer.realClassName(servletName);
                }
                if (servletClass == null || servlet.getJspFile() != null) continue;
                if (!"org.apache.openejb.server.rest.OpenEJBRestServlet".equals(servletClass)) {
                    try {
                        Class<?> clazz = classLoader.loadClass(servletClass);
                        classes.add(clazz);
                        if (servlet.getServletClass() == null) {
                            servlet.setServletClass(servletClass);
                        }
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        logger.debug("Could not load Servlet class {1} for web module {2} / {3}", servletClass, webModule.getJarLocation(), webModule.getFile().getName());
                        if (servlet.getServletClass() != null) {
                            throw new OpenEJBException("Unable to load servlet class: " + servletClass, e);
                        }
                        logger.error("servlet " + servletName + " has no servlet-class defined and is not a subclass of Application");
                    }
                }
                for (ParamValue param : servlet.getInitParam()) {
                    if (!param.getParamName().equals(Application.class.getName()) && !param.getParamName().equals("jakarta.ws.rs.Application")) continue;
                    webModule.getRestApplications().clear();
                    webModule.getRestApplications().add(param.getParamValue());
                    continue block22;
                }
            }
            for (Filter filter : webApp.getFilter()) {
                String filterClass = AnnotationDeployer.realClassName(filter.getFilterClass());
                if (filterClass == null) continue;
                try {
                    Class<?> clazz = classLoader.loadClass(filterClass);
                    classes.add(clazz);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    logger.debug("Could not load Servlet Filter class {1} for web module {2} / {3}", filterClass, webModule.getJarLocation(), webModule.getFile().getName());
                    throw new OpenEJBException("Unable to load servlet filter class: " + filterClass, e);
                }
            }
            for (Listener listener : webApp.getListener()) {
                String listenerClass = AnnotationDeployer.realClassName(listener.getListenerClass());
                if (listenerClass == null) continue;
                try {
                    Class<?> clazz = classLoader.loadClass(listenerClass);
                    classes.add(clazz);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    logger.debug("Could not load Servlet listener class {1} for web module {2} / {3}", listenerClass, webModule.getJarLocation(), webModule.getFile().getName());
                    throw new OpenEJBException("Unable to load servlet listener class: " + listenerClass, e);
                }
            }
            for (TldTaglib taglib : webModule.getTaglibs()) {
                Class<?> clazz;
                for (Listener listener : taglib.getListener()) {
                    String listenerClass = AnnotationDeployer.realClassName(listener.getListenerClass());
                    if (listenerClass == null) continue;
                    try {
                        clazz = classLoader.loadClass(listenerClass);
                        classes.add(clazz);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        logger.debug("Could not load TagLib listener class {1} for web module {2} / {3}", listenerClass, webModule.getJarLocation(), webModule.getFile().getName());
                        logger.error("Unable to load tag library servlet listener class: " + listenerClass);
                    }
                }
                for (Tag tag : taglib.getTag()) {
                    String tagClass = AnnotationDeployer.realClassName(tag.getTagClass());
                    if (tagClass == null) continue;
                    try {
                        clazz = classLoader.loadClass(tagClass);
                        classes.add(clazz);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        logger.debug("Could not load tag class {1} for web module {2} / {3}", tagClass, webModule.getJarLocation(), webModule.getFile().getName());
                        logger.error("Unable to load tag library tag class: " + (String)tagClass);
                    }
                }
            }
            if (webModule.getWebservices() != null) {
                for (WebserviceDescription webservice : webModule.getWebservices().getWebserviceDescription()) {
                    for (PortComponent port : webservice.getPortComponent()) {
                        if (port.getServiceImplBean().getEjbLink() != null || port.getHandlerChains() == null) continue;
                        for (org.apache.openejb.jee.HandlerChain handlerChain : port.getHandlerChains().getHandlerChain()) {
                            for (Handler handler : handlerChain.getHandler()) {
                                String handlerClass = AnnotationDeployer.realClassName(handler.getHandlerClass());
                                if (handlerClass == null) continue;
                                try {
                                    Class<?> clazz = classLoader.loadClass(handlerClass);
                                    classes.add(clazz);
                                }
                                catch (ClassNotFoundException | NoClassDefFoundError e) {
                                    logger.debug("Could not load web service handler class {1} for web module {2} / {3}", handlerClass, webModule.getJarLocation(), webModule.getFile().getName());
                                    throw new OpenEJBException("Unable to load webservice handler class: " + handlerClass, e);
                                }
                            }
                        }
                    }
                }
            }
            if ((finder = webModule.getFinder()) != null) {
                for (String apiClassName : API_CLASSES) {
                    Class<?> clazz;
                    try {
                        clazz = classLoader.loadClass(apiClassName);
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                    if (clazz.isAnnotation()) {
                        classes.addAll(AnnotationDeployer.metaToClass(finder.findMetaAnnotatedClasses(clazz)));
                        continue;
                    }
                    if (Modifier.isAbstract(clazz.getModifiers())) {
                        classes.addAll(finder.findSubclasses(clazz));
                        continue;
                    }
                    classes.addAll(finder.findImplementations(clazz));
                }
            }
            AnnotationFinder annotationFinder = this.createFinder(classes.toArray(new Class[classes.size()]));
            this.buildAnnotatedRefs((JndiConsumer)webApp, (IAnnotationFinder)annotationFinder, classLoader);
            this.processWebServiceClientHandlers((JndiConsumer)webApp, annotationFinder, classLoader);
            return webModule;
        }

        /*
         * WARNING - void declaration
         */
        public EjbModule deploy(EjbModule ejbModule) throws OpenEJBException {
            EnterpriseBean[] enterpriseBeans;
            if (ejbModule.getEjbJar() != null && ejbModule.getEjbJar().isMetadataComplete().booleanValue()) {
                return ejbModule;
            }
            ClassLoader classLoader = ejbModule.getClassLoader();
            for (EnterpriseBean enterpriseBean : enterpriseBeans = ejbModule.getEjbJar().getEnterpriseBeans()) {
                InterceptorBinding binding;
                Object binding222;
                AnnotationFinder annotationFinder;
                Class<?> clazz;
                String ejbName = enterpriseBean.getEjbName();
                String ejbClassName = AnnotationDeployer.realClassName(enterpriseBean.getEjbClass());
                if (ejbClassName == null) {
                    ArrayList<String> others = new ArrayList<String>();
                    for (EnterpriseBean otherBean : enterpriseBeans) {
                        others.add(otherBean.getEjbName());
                    }
                    this.fail(ejbName, "xml.noEjbClass", ejbName, Join.join(", ", others));
                }
                try {
                    clazz = classLoader.loadClass(ejbClassName);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                MetaAnnotatedClass metaClass = new MetaAnnotatedClass(clazz);
                int n = DynamicProxyImplFactory.isKnownDynamicallyImplemented(metaClass, clazz) ? 1 : 0;
                AnnotationFinder finder = null;
                if (ejbModule.getFinder() instanceof AnnotationFinder) {
                    Proxy p;
                    AnnotationFinder af = (AnnotationFinder)ejbModule.getFinder();
                    List<Class<?>> ancestors = Classes.ancestors(clazz);
                    ancestors.addAll(Arrays.asList(clazz.getInterfaces()));
                    if (n != 0 && (p = (Proxy)metaClass.getAnnotation(Proxy.class)) != null) {
                        ancestors.add(p.value());
                    }
                    String[] names = new String[ancestors.size()];
                    int i = 0;
                    for (Class<?> clazz2 : ancestors) {
                        names[i++] = clazz2.getName();
                    }
                    annotationFinder = af.select(names);
                } else if (n == 0) {
                    annotationFinder = this.createFinder(clazz);
                } else {
                    Proxy proxy = (Proxy)metaClass.getAnnotation(Proxy.class);
                    Class[] classes = proxy == null ? new Class[]{clazz} : new Class[]{clazz, proxy.value()};
                    annotationFinder = this.createFinder(classes);
                }
                this.processCallbacks((Lifecycle)enterpriseBean, annotationFinder);
                if (enterpriseBean.getTransactionType() == null) {
                    TransactionManagement tx = this.getInheritableAnnotation(clazz, TransactionManagement.class);
                    Object transactionType = TransactionManagementType.CONTAINER;
                    if (tx != null) {
                        transactionType = tx.value();
                    }
                    switch (4.$SwitchMap$jakarta$ejb$TransactionManagementType[transactionType.ordinal()]) {
                        case 1: {
                            enterpriseBean.setTransactionType(org.apache.openejb.jee.TransactionType.BEAN);
                            break;
                        }
                        case 2: {
                            enterpriseBean.setTransactionType(org.apache.openejb.jee.TransactionType.CONTAINER);
                        }
                    }
                }
                AssemblyDescriptor assemblyDescriptor = ejbModule.getEjbJar().getAssemblyDescriptor();
                this.processApplicationExceptions(clazz, assemblyDescriptor);
                if (enterpriseBean.getTransactionType() == org.apache.openejb.jee.TransactionType.CONTAINER) {
                    this.processAttributes(new TransactionAttributeHandler(assemblyDescriptor, ejbName), clazz, annotationFinder);
                } else {
                    if (finder == null) {
                        finder = annotationFinder.select(new String[]{clazz.getName()});
                    }
                    this.checkAttributes(new TransactionAttributeHandler(assemblyDescriptor, ejbName), ejbName, ejbModule, finder, "invalidTransactionAttribute");
                }
                this.processSecurityAnnotations(clazz, ejbName, ejbModule, annotationFinder, enterpriseBean);
                this.processSchedules(enterpriseBean, annotationFinder);
                for (Object binding222 : assemblyDescriptor.getInterceptorBinding()) {
                    EjbJar ejbJar = ejbModule.getEjbJar();
                    ArrayList list = new ArrayList(binding222.getInterceptorClass());
                    if (binding222.getInterceptorOrder() != null) {
                        list.clear();
                        list.addAll(binding222.getInterceptorOrder().getInterceptorClass());
                    }
                    for (Class[] interceptor : list) {
                        if (ejbJar.getInterceptor((String)interceptor) != null) continue;
                        logger.debug("Adding '<ejb-jar><interceptors><interceptor>' entry for undeclared interceptor " + (String)interceptor);
                        ejbJar.addInterceptor(new org.apache.openejb.jee.Interceptor((String)interceptor));
                    }
                }
                List<Annotated<Class<?>>> annotatedClasses = AnnotationDeployer.sortClasses(annotationFinder.findMetaAnnotatedClasses(Interceptors.class));
                binding222 = annotatedClasses.iterator();
                while (binding222.hasNext()) {
                    void var24_63;
                    Annotated interceptorsAnnotatedClass = (Annotated)binding222.next();
                    Interceptors interceptors = (Interceptors)interceptorsAnnotatedClass.getAnnotation(Interceptors.class);
                    EjbJar ejbJar = ejbModule.getEjbJar();
                    for (Class clazz3 : interceptors.value()) {
                        if (ejbJar.getInterceptor(clazz3.getName()) != null) continue;
                        ejbJar.addInterceptor(new org.apache.openejb.jee.Interceptor(clazz3.getName()));
                    }
                    binding = new InterceptorBinding(enterpriseBean, new org.apache.openejb.jee.Interceptor[0]);
                    assemblyDescriptor.getInterceptorBinding().add(0, binding);
                    Class[] classArray = interceptors.value();
                    int n2 = classArray.length;
                    boolean bl = false;
                    while (var24_63 < n2) {
                        Class interceptor = classArray[var24_63];
                        binding.getInterceptorClass().add(interceptor.getName());
                        ++var24_63;
                    }
                }
                List<Annotated<java.lang.reflect.Method>> annotatedMethods = AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(Interceptors.class));
                for (Annotated<java.lang.reflect.Method> method : annotatedMethods) {
                    Interceptors interceptors = (Interceptors)method.getAnnotation(Interceptors.class);
                    if (interceptors == null) continue;
                    EjbJar ejbJar = ejbModule.getEjbJar();
                    for (Class interceptor : interceptors.value()) {
                        if (ejbJar.getInterceptor(interceptor.getName()) != null) continue;
                        ejbJar.addInterceptor(new org.apache.openejb.jee.Interceptor(interceptor.getName()));
                    }
                    InterceptorBinding binding3 = new InterceptorBinding(enterpriseBean, new org.apache.openejb.jee.Interceptor[0]);
                    assemblyDescriptor.getInterceptorBinding().add(0, binding3);
                    for (Class interceptor : interceptors.value()) {
                        binding3.getInterceptorClass().add(interceptor.getName());
                    }
                    binding3.setMethod(new NamedMethod((java.lang.reflect.Method)method.get()));
                }
                ExcludeDefaultInterceptors excludeDefaultInterceptors = clazz.getAnnotation(ExcludeDefaultInterceptors.class);
                if (excludeDefaultInterceptors != null) {
                    InterceptorBinding binding4 = assemblyDescriptor.addInterceptorBinding(new InterceptorBinding(enterpriseBean, new org.apache.openejb.jee.Interceptor[0]));
                    binding4.setExcludeDefaultInterceptors(true);
                }
                for (Annotated annotated : annotationFinder.findMetaAnnotatedMethods(ExcludeDefaultInterceptors.class)) {
                    binding = assemblyDescriptor.addInterceptorBinding(new InterceptorBinding(enterpriseBean, new org.apache.openejb.jee.Interceptor[0]));
                    binding.setExcludeDefaultInterceptors(true);
                    binding.setMethod(new NamedMethod((java.lang.reflect.Method)annotated.get()));
                }
                for (Annotated annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(ExcludeClassInterceptors.class))) {
                    binding = assemblyDescriptor.addInterceptorBinding(new InterceptorBinding(enterpriseBean, new org.apache.openejb.jee.Interceptor[0]));
                    binding.setExcludeClassInterceptors(true);
                    binding.setMethod(new NamedMethod((java.lang.reflect.Method)annotated.get()));
                }
                if (enterpriseBean instanceof RemoteBean) {
                    LocalHome localHome;
                    java.lang.reflect.Method create;
                    Class homeClass;
                    RemoteHome remoteHome;
                    RemoteBean remoteBean = (RemoteBean)enterpriseBean;
                    if (remoteBean.getHome() == null && (remoteHome = this.getInheritableAnnotation(clazz, RemoteHome.class)) != null) {
                        homeClass = remoteHome.value();
                        try {
                            create = null;
                            for (java.lang.reflect.Method method : homeClass.getMethods()) {
                                if (!method.getName().startsWith("create")) continue;
                                create = method;
                                break;
                            }
                            if (create == null) {
                                throw new NoSuchMethodException("create");
                            }
                            Class<?> remoteClass = create.getReturnType();
                            remoteBean.setHome(homeClass.getName());
                            remoteBean.setRemote(remoteClass.getName());
                        }
                        catch (NoSuchMethodException e) {
                            logger.error("Class annotated as a RemoteHome has no 'create()' method.  Unable to determine remote interface type.  Bean class: " + clazz.getName() + ",  Home class: " + homeClass.getName());
                        }
                    }
                    if (remoteBean.getLocalHome() == null && (localHome = this.getInheritableAnnotation(clazz, LocalHome.class)) != null) {
                        homeClass = localHome.value();
                        try {
                            create = null;
                            for (java.lang.reflect.Method method : homeClass.getMethods()) {
                                if (!method.getName().startsWith("create")) continue;
                                create = method;
                                break;
                            }
                            if (create == null) {
                                throw new NoSuchMethodException("create");
                            }
                            Class<?> remoteClass = create.getReturnType();
                            remoteBean.setLocalHome(homeClass.getName());
                            remoteBean.setLocal(remoteClass.getName());
                        }
                        catch (NoSuchMethodException e) {
                            logger.error("Class annotated as a LocalHome has no 'create()' method.  Unable to determine remote interface type.  Bean class: " + clazz.getName() + ",  Home class: " + homeClass.getName());
                        }
                    }
                    if (remoteBean instanceof SessionBean) {
                        SessionBean sessionBean = (SessionBean)remoteBean;
                        sessionBean.getParents().add(clazz.getName());
                        if (!clazz.isInterface()) {
                            Class<?> current = clazz.getSuperclass();
                            while (!current.equals(Object.class)) {
                                sessionBean.getParents().add(current.getName());
                                current = current.getSuperclass();
                            }
                        }
                        this.processSessionInterfaces(sessionBean, clazz, ejbModule);
                        this.processAsynchronous(enterpriseBean, annotationFinder);
                        if (sessionBean.getDependsOn() == null) {
                            DependsOn dependsOn = this.getInheritableAnnotation(clazz, DependsOn.class);
                            if (dependsOn != null) {
                                sessionBean.setDependsOn(dependsOn.value());
                            } else {
                                sessionBean.setDependsOn(Collections.EMPTY_LIST);
                            }
                        }
                        if (sessionBean.getSessionType() != SessionType.STATEFUL && annotationFinder.isAnnotationPresent(Path.class)) {
                            sessionBean.setRestService(true);
                        }
                        if (sessionBean.getSessionType() == SessionType.SINGLETON) {
                            if (sessionBean.getConcurrencyManagementType() == null) {
                                ConcurrencyManagement tx = this.getInheritableAnnotation(clazz, ConcurrencyManagement.class);
                                jakarta.ejb.ConcurrencyManagementType concurrencyType = jakarta.ejb.ConcurrencyManagementType.CONTAINER;
                                if (tx != null) {
                                    concurrencyType = tx.value();
                                }
                                switch (concurrencyType) {
                                    case BEAN: {
                                        sessionBean.setConcurrencyManagementType(ConcurrencyManagementType.BEAN);
                                        break;
                                    }
                                    case CONTAINER: {
                                        sessionBean.setConcurrencyManagementType(ConcurrencyManagementType.CONTAINER);
                                    }
                                }
                            }
                            LockHandler lockHandler = new LockHandler(assemblyDescriptor, sessionBean);
                            if (sessionBean.getConcurrencyManagementType() == ConcurrencyManagementType.CONTAINER) {
                                this.processAttributes(lockHandler, clazz, annotationFinder);
                            } else {
                                this.checkAttributes(lockHandler, ejbName, ejbModule, annotationFinder, "invalidConcurrencyAttribute");
                            }
                            AccessTimeoutHandler accessTimeoutHandler = new AccessTimeoutHandler(assemblyDescriptor, sessionBean, lockHandler.getContainerConcurrency());
                            this.processAttributes(accessTimeoutHandler, clazz, annotationFinder);
                            if (!sessionBean.hasInitOnStartup()) {
                                Startup startup = this.getInheritableAnnotation(clazz, Startup.class);
                                sessionBean.setInitOnStartup(startup != null);
                            }
                        } else if (sessionBean.getSessionType() == SessionType.STATEFUL) {
                            StatefulTimeout annotation;
                            if (sessionBean.getStatefulTimeout() == null && (annotation = this.getInheritableAnnotation(clazz, StatefulTimeout.class)) != null) {
                                Timeout timeout = new Timeout();
                                timeout.setTimeout(annotation.value());
                                timeout.setUnit(annotation.unit());
                                sessionBean.setStatefulTimeout(timeout);
                            }
                            AccessTimeoutHandler accessTimeoutHandler = new AccessTimeoutHandler(assemblyDescriptor, sessionBean);
                            this.processAttributes(accessTimeoutHandler, clazz, annotationFinder);
                        }
                    }
                }
                if (enterpriseBean instanceof MessageDrivenBean) {
                    Class<?>[] configProperties;
                    MessageDrivenBean mdb = (MessageDrivenBean)enterpriseBean;
                    MessageDriven messageDriven = clazz.getAnnotation(MessageDriven.class);
                    if (messageDriven != null) {
                        Class interfce;
                        ActivationConfig activationConfig = mdb.getActivationConfig();
                        if (activationConfig == null) {
                            activationConfig = new ActivationConfig();
                        }
                        if (!messageDriven.mappedName().isEmpty()) {
                            if (mdb.getActivationConfig() == null) {
                                mdb.setActivationConfig(activationConfig);
                            }
                            if (!activationConfig.toProperties().containsKey("destinationType")) {
                                activationConfig.addProperty("destinationType", Queue.class.getName());
                            }
                            activationConfig.addProperty("destination", messageDriven.mappedName());
                        }
                        if ((configProperties = messageDriven.activationConfig()) != null) {
                            if (mdb.getActivationConfig() == null) {
                                mdb.setActivationConfig(activationConfig);
                            }
                            Properties properties = activationConfig.toProperties();
                            for (Class<?> property : configProperties) {
                                if (properties.containsKey(property.propertyName())) continue;
                                activationConfig.addProperty(property.propertyName(), property.propertyValue());
                            }
                        }
                        if (mdb.getMessagingType() == null && (interfce = messageDriven.messageListenerInterface()) != null && !interfce.equals(Object.class)) {
                            if (!interfce.isInterface()) {
                                throw new OpenEJBException("MessageListenerInterface property of @MessageDriven is not an interface");
                            }
                            mdb.setMessagingType(interfce.getName());
                        }
                    }
                    if (mdb.getMessagingType() == null) {
                        void var24_69;
                        ArrayList interfaces = new ArrayList();
                        configProperties = clazz.getInterfaces();
                        int n3 = configProperties.length;
                        boolean bl = false;
                        while (var24_69 < n3) {
                            Class<?> intf = configProperties[var24_69];
                            String name = intf.getName();
                            if (!(name.equals("java.io.Serializable") || name.equals("java.io.Externalizable") || name.startsWith("jakarta.ejb.") || intf.isSynthetic())) {
                                interfaces.add(intf);
                            }
                            ++var24_69;
                        }
                        if (interfaces.size() != 1) {
                            StringBuilder msg = new StringBuilder("When annotating a bean class as @MessageDriven without declaring messageListenerInterface, the bean must implement exactly one interface, no more and no less. beanClass=" + clazz.getName() + " interfaces=");
                            for (Class clazz4 : interfaces) {
                                msg.append(clazz4.getName()).append(", ");
                            }
                            throw new IllegalStateException(msg.toString());
                        }
                        mdb.setMessagingType(((Class)interfaces.get(0)).getName());
                    }
                }
                this.buildAnnotatedRefs((JndiConsumer)enterpriseBean, (IAnnotationFinder)annotationFinder, classLoader);
                this.processWebServiceHandlers(ejbModule, enterpriseBean, annotationFinder);
                this.processWebServiceClientHandlers((JndiConsumer)enterpriseBean, annotationFinder, classLoader);
                try {
                    if (!BeanContext.Comp.class.getName().equals(enterpriseBean.getEjbClass())) continue;
                    this.buildAnnotatedRefs((JndiConsumer)enterpriseBean, ejbModule.getFinder(), classLoader);
                }
                catch (OpenEJBException e) {
                    logger.error("Processing of @Resource, @EJB, and other references failed for CDI managed beans", e);
                }
            }
            for (EnterpriseBean enterpriseBean : ejbModule.getEjbJar().getInterceptors()) {
                Class<?> clazz;
                try {
                    clazz = classLoader.loadClass(AnnotationDeployer.realClassName(enterpriseBean.getInterceptorClass()));
                }
                catch (ClassNotFoundException e) {
                    logger.debug("Could not load interceptor class {1} for enterprise beans module {2} / {3}", enterpriseBean.getInterceptorClass(), ejbModule.getJarLocation(), ejbModule.getFile().getName());
                    throw new OpenEJBException("Unable to load interceptor class: " + enterpriseBean.getInterceptorClass(), e);
                }
                AnnotationFinder annotationFinder = this.createFinder(clazz);
                this.processCallbacks((Lifecycle)enterpriseBean, annotationFinder);
                boolean override = "true".equalsIgnoreCase(this.getProperty("openejb.callbacks.override", "false"));
                if (this.apply(override, enterpriseBean.getAroundConstruct())) {
                    for (Annotated annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(AroundConstruct.class))) {
                        enterpriseBean.getAroundConstruct().add(new LifecycleCallback((java.lang.reflect.Method)annotated.get()));
                    }
                }
                this.processApplicationExceptions(clazz, ejbModule.getEjbJar().getAssemblyDescriptor());
                this.buildAnnotatedRefs((JndiConsumer)enterpriseBean, (IAnnotationFinder)annotationFinder, classLoader);
                this.processWebServiceClientHandlers((JndiConsumer)enterpriseBean, annotationFinder, classLoader);
                for (EnterpriseBean bean : enterpriseBeans) {
                    this.mergeJndiReferences(enterpriseBean.getEnvEntryMap(), bean.getEnvEntryMap());
                    this.mergeJndiReferences(enterpriseBean.getEjbRefMap(), bean.getEjbRefMap());
                    this.mergeJndiReferences(enterpriseBean.getEjbLocalRefMap(), bean.getEjbLocalRefMap());
                    this.mergeJndiReferences(enterpriseBean.getResourceRefMap(), bean.getResourceRefMap());
                    this.mergeJndiReferences(enterpriseBean.getResourceEnvRefMap(), bean.getResourceEnvRefMap());
                    this.mergeJndiReferences(enterpriseBean.getPersistenceContextRefMap(), bean.getPersistenceContextRefMap());
                    this.mergeJndiReferences(enterpriseBean.getPersistenceUnitRefMap(), bean.getPersistenceUnitRefMap());
                    this.mergeJndiReferences(enterpriseBean.getMessageDestinationRefMap(), bean.getMessageDestinationRefMap());
                    this.mergeJndiReferences(enterpriseBean.getServiceRefMap(), bean.getServiceRefMap());
                }
            }
            return ejbModule;
        }

        private void processAsynchronous(EnterpriseBean bean, AnnotationFinder annotationFinder) {
            if (!(bean instanceof SessionBean)) {
                return;
            }
            SessionBean sessionBean = (SessionBean)bean;
            for (Annotated method : annotationFinder.findMetaAnnotatedMethods(Asynchronous.class)) {
                sessionBean.getAsyncMethod().add(new AsyncMethod((java.lang.reflect.Method)method.get()));
            }
            for (Annotated clazz : annotationFinder.findMetaAnnotatedClasses(Asynchronous.class)) {
                if (((Class)clazz.get()).isInterface()) continue;
                sessionBean.getAsynchronousClasses().add(((Class)clazz.get()).getName());
            }
        }

        private <T extends Injectable> void mergeJndiReferences(Map<String, T> from, Map<String, T> to) {
            for (Map.Entry<String, T> entry : from.entrySet()) {
                Injectable injectable = (Injectable)to.get(entry.getKey());
                if (injectable == null) {
                    to.put(entry.getKey(), (Injectable)entry.getValue());
                    continue;
                }
                injectable.getInjectionTarget().addAll(((Injectable)entry.getValue()).getInjectionTarget());
            }
        }

        private void processApplicationExceptions(Class<?> clazz, AssemblyDescriptor assemblyDescriptor) {
            for (java.lang.reflect.Method method : clazz.getMethods()) {
                for (Class<?> exception : method.getExceptionTypes()) {
                    ApplicationException annotation = exception.getAnnotation(ApplicationException.class);
                    if (annotation == null) continue;
                    if (assemblyDescriptor.getApplicationException(exception) != null) {
                        AnnotationDeployer.mergeApplicationExceptionAnnotation(assemblyDescriptor, exception, annotation);
                        continue;
                    }
                    logger.debug("Found previously undetected application exception {0} listed on a method {1} with annotation {2}", method, exception, annotation);
                    assemblyDescriptor.addApplicationException(exception, annotation.rollback(), annotation.inherited());
                }
            }
        }

        private void processSessionInterfaces(SessionBean sessionBean, Class<?> beanClass, EjbModule ejbModule) {
            ValidationContext validation = ejbModule.getValidation();
            String ejbName = sessionBean.getEjbName();
            boolean strict = this.getProperty(STRICT_INTERFACE_DECLARATION, "false").equalsIgnoreCase("true");
            ArrayList<String> descriptor = new ArrayList<String>();
            descriptor.add(sessionBean.getHome());
            descriptor.add(sessionBean.getRemote());
            descriptor.add(sessionBean.getLocalHome());
            descriptor.add(sessionBean.getLocal());
            descriptor.addAll(sessionBean.getBusinessLocal());
            descriptor.addAll(sessionBean.getBusinessRemote());
            descriptor.add(sessionBean.getServiceEndpoint());
            BusinessInterfaces xml = new BusinessInterfaces();
            xml.addLocals(sessionBean.getBusinessLocal(), ejbModule.getClassLoader());
            xml.addRemotes(sessionBean.getBusinessRemote(), ejbModule.getClassLoader());
            if (beanClass.getAnnotation(LocalBean.class) != null) {
                sessionBean.setLocalBean(new Empty());
            }
            if (strict) {
                for (Class interfce : xml.local) {
                    if (!xml.remote.contains(interfce)) continue;
                    validation.fail(ejbName, "xml.localRemote.conflict", interfce.getName());
                }
            }
            BusinessInterfaces all = new BusinessInterfaces();
            all.local.addAll(xml.local);
            all.remote.addAll(xml.remote);
            List<Class<?>> classes = strict ? new ArrayList(Collections.singletonList(beanClass)) : Classes.ancestors(beanClass);
            for (Class<?> clazz : classes) {
                WebService webService;
                int n;
                Class<?> webServiceItf = null;
                if (sessionBean.getServiceEndpoint() == null) {
                    Class defaultEndpoint = BeanContext.ServiceEndpoint.class;
                    Class<?>[] classArray = clazz.getInterfaces();
                    int n2 = classArray.length;
                    for (n = 0; n < n2; ++n) {
                        Class<?> interfce = classArray[n];
                        if (!interfce.isAnnotationPresent(WebService.class)) continue;
                        defaultEndpoint = interfce;
                        webServiceItf = interfce;
                    }
                    webService = clazz.getAnnotation(WebService.class);
                    if (webService != null) {
                        String className = webService.endpointInterface();
                        if (!className.isEmpty()) {
                            sessionBean.setServiceEndpoint(className);
                        } else {
                            sessionBean.setServiceEndpoint(defaultEndpoint.getName());
                        }
                    } else if (clazz.isAnnotationPresent(WebServiceProvider.class)) {
                        sessionBean.setServiceEndpoint(defaultEndpoint.getName());
                    } else if (!defaultEndpoint.equals(BeanContext.ServiceEndpoint.class)) {
                        sessionBean.setServiceEndpoint(defaultEndpoint.getName());
                    }
                }
                ArrayList<WebService> interfaces = new ArrayList<WebService>();
                if (!clazz.isInterface()) {
                    webService = clazz.getInterfaces();
                    int className = ((Class<?>[])webService).length;
                    for (n = 0; n < className; ++n) {
                        WebService interfce = webService[n];
                        String name = interfce.getName();
                        if (name.equals("scala.ScalaObject") || name.equals("groovy.lang.GroovyObject") || name.equals("java.io.Serializable") || name.equals("java.io.Externalizable") || name.equals(InvocationHandler.class.getName()) && DynamicSubclass.isDynamic(beanClass) || name.startsWith("jakarta.ejb.") || descriptor.contains(interfce.getName()) || interfce.isSynthetic() || "net.sourceforge.cobertura.coveragedata.HasBeenInstrumented".equals(name) || name.startsWith("org.scalatest.")) continue;
                        interfaces.add(interfce);
                    }
                }
                interfaces.removeAll(all.local);
                interfaces.removeAll(all.remote);
                Local local = clazz.getAnnotation(Local.class);
                Remote remote = clazz.getAnnotation(Remote.class);
                boolean impliedLocal = local != null && local.value().length == 0;
                boolean impliedRemote = remote != null && remote.value().length == 0;
                BusinessInterfaces bean = new BusinessInterfaces();
                if (local != null) {
                    bean.local.addAll(Arrays.asList(local.value()));
                }
                if (remote != null) {
                    bean.remote.addAll(Arrays.asList(remote.value()));
                }
                if (strict) {
                    for (Class interfce : bean.local) {
                        if (!bean.remote.contains(interfce)) continue;
                        validation.fail(ejbName, "ann.localRemote.conflict", interfce.getName());
                    }
                }
                interfaces.removeAll(bean.local);
                interfaces.removeAll(bean.remote);
                if (impliedLocal || impliedRemote) {
                    if (interfaces.size() != 1) {
                        ArrayList<CallSite> interfaceNames = new ArrayList<CallSite>();
                        for (Class clazz2 : interfaces) {
                            interfaceNames.add((CallSite)((Object)(clazz2.getName() + ".class")));
                        }
                        if (impliedLocal && local.value().length == 0 && interfaces.size() == 0 && !strict) {
                            validation.warn(ejbName, "ann.local.forLocalBean", Join.join(", ", interfaceNames));
                        } else if (impliedLocal) {
                            validation.fail(ejbName, "ann.local.noAttributes", Join.join(", ", interfaceNames));
                            return;
                        }
                        if (impliedRemote) {
                            validation.fail(ejbName, "ann.remote.noAttributes", Join.join(", ", interfaceNames));
                            return;
                        }
                    } else if (strict && impliedLocal && impliedRemote) {
                        Class interfce = (Class)interfaces.remove(0);
                        validation.fail(ejbName, "ann.localRemote.ambiguous", interfce.getName());
                    } else {
                        if (impliedLocal) {
                            bean.local.addAll(interfaces);
                        }
                        if (impliedRemote) {
                            bean.remote.addAll(interfaces);
                        }
                        interfaces.clear();
                    }
                }
                BusinessInterfaces implemented = new BusinessInterfaces();
                for (Class clazz3 : interfaces) {
                    boolean present;
                    boolean isLocal = clazz3.isAnnotationPresent(Local.class);
                    boolean isRemote = clazz3.isAnnotationPresent(Remote.class);
                    if (strict && isLocal && isRemote) {
                        validation.fail(ejbName, "ann.localRemote.conflict", clazz3.getName());
                        continue;
                    }
                    Class<?>[] superInterface = clazz3.getInterfaces();
                    if (isLocal) {
                        if (strict) {
                            for (Class<?> si : superInterface) {
                                present = si.isAnnotationPresent(Remote.class);
                                if (!present) continue;
                                validation.fail(ejbName, "ann.remoteOrLocal.converse.parent", clazz3.getName(), "Local", si.getName(), "Remote");
                            }
                        }
                        implemented.local.add(clazz3);
                    }
                    if (!isRemote) continue;
                    if (strict) {
                        for (Class<?> si : superInterface) {
                            present = si.isAnnotationPresent(Local.class);
                            if (!present) continue;
                            validation.fail(ejbName, "ann.remoteOrLocal.converse.parent", clazz3.getName(), "Remote", si.getName(), "Local");
                        }
                    }
                    implemented.remote.add(clazz3);
                }
                interfaces.removeAll(implemented.local);
                interfaces.removeAll(implemented.remote);
                bean.local.removeAll(all.local);
                bean.local.removeAll(all.remote);
                bean.remote.removeAll(all.remote);
                bean.remote.removeAll(all.local);
                for (Class clazz4 : bean.local) {
                    this.validateLocalInterface(clazz4, validation, ejbName);
                }
                for (Class clazz5 : bean.remote) {
                    this.validateRemoteInterface(clazz5, validation, ejbName);
                }
                all.local.addAll(bean.local);
                all.remote.addAll(bean.remote);
                implemented.local.removeAll(all.local);
                implemented.local.removeAll(all.remote);
                implemented.remote.removeAll(all.remote);
                implemented.remote.removeAll(all.local);
                for (Class clazz6 : implemented.local) {
                    this.validateLocalInterface(clazz6, validation, ejbName);
                }
                for (Class clazz7 : implemented.remote) {
                    this.validateRemoteInterface(clazz7, validation, ejbName);
                }
                all.local.addAll(implemented.local);
                all.remote.addAll(implemented.remote);
                if (clazz == beanClass && sessionBean.getLocalBean() == null && sessionBean.getBusinessLocal().isEmpty() && sessionBean.getBusinessRemote().isEmpty() && sessionBean.getHome() == null && sessionBean.getRemote() == null && sessionBean.getLocalHome() == null && sessionBean.getLocal() == null && all.local.isEmpty() && all.remote.isEmpty()) {
                    if (interfaces.size() == 0 || DynamicProxyImplFactory.isKnownDynamicallyImplemented(clazz)) {
                        sessionBean.setLocalBean(new Empty());
                    } else if (interfaces.size() == 1) {
                        all.local.add((Class)interfaces.remove(0));
                    } else {
                        validation.fail(ejbName, "too.many.interfaces", ejbName, ((Object)interfaces).toString().replace("interface ", ""));
                        return;
                    }
                }
                if (this.webserviceAsRemote && webServiceItf != null && all.remote.isEmpty()) {
                    all.remote.add(webServiceItf);
                }
                if (!beanClass.isAnnotationPresent(ManagedBean.class)) continue;
                sessionBean.setLocalBean(new Empty());
            }
            for (Class<?> clazz : all.local) {
                sessionBean.addBusinessLocal(clazz);
            }
            for (Class<?> clazz : all.remote) {
                sessionBean.addBusinessRemote(clazz);
            }
        }

        private String getProperty(String key, String defaultValue) {
            EjbModule ejbModule;
            OpenejbJar openejbJar;
            String value = SystemInstance.get().getOptions().get(key, defaultValue);
            DeploymentModule module = AnnotationDeployer.getModule();
            if (module instanceof EjbModule && (openejbJar = (ejbModule = (EjbModule)module).getOpenejbJar()) != null && openejbJar.getProperties() != null) {
                value = openejbJar.getProperties().getProperty(key, value);
            }
            return value;
        }

        private void processSecurityAnnotations(Class<?> beanClass, String ejbName, EjbModule ejbModule, AnnotationFinder annotationFinder, EnterpriseBean bean) {
            List securityRoleRefs;
            RemoteBean remoteBean;
            RolesAllowed rolesAllowed;
            AssemblyDescriptor assemblyDescriptor = ejbModule.getEjbJar().getAssemblyDescriptor();
            List<String> classPermissions = this.getDeclaredClassPermissions(assemblyDescriptor, ejbName);
            for (Class<?> clazzz : Classes.ancestors(beanClass)) {
                DeclareRoles declareRoles;
                RunAs runAs;
                MetaAnnotatedClass clazz = new MetaAnnotatedClass(clazzz);
                if (!classPermissions.contains("*") || !classPermissions.contains(clazz.getName())) {
                    MethodPermission methodPermission;
                    rolesAllowed = (RolesAllowed)clazz.getAnnotation(RolesAllowed.class);
                    PermitAll permitAll = (PermitAll)clazz.getAnnotation(PermitAll.class);
                    DenyAll denyAll = (DenyAll)clazz.getAnnotation(DenyAll.class);
                    if (rolesAllowed != null && permitAll != null || rolesAllowed != null && denyAll != null || permitAll != null && denyAll != null) {
                        ejbModule.getValidation().fail(ejbName, "permitAllAndRolesAllowedOnClass", clazz.getName());
                    }
                    if (rolesAllowed != null) {
                        methodPermission = new MethodPermission();
                        methodPermission.getRoleName().addAll(Arrays.asList(rolesAllowed.value()));
                        methodPermission.getMethod().add(new Method(ejbName, clazz.getName(), "*"));
                        assemblyDescriptor.getMethodPermission().add(methodPermission);
                        RemoteBean remoteBean2 = (RemoteBean)bean;
                        List securityRoleRefs2 = remoteBean2.getSecurityRoleRef();
                        for (String role : rolesAllowed.value()) {
                            securityRoleRefs2.add(new SecurityRoleRef(role));
                        }
                    }
                    if (permitAll != null) {
                        methodPermission = new MethodPermission();
                        methodPermission.setUnchecked(true);
                        methodPermission.getMethod().add(new Method(ejbName, clazz.getName(), "*"));
                        assemblyDescriptor.getMethodPermission().add(methodPermission);
                    }
                    if (denyAll != null) {
                        assemblyDescriptor.getExcludeList().addMethod(new Method(ejbName, clazz.getName(), "*"));
                    }
                }
                if ((runAs = (RunAs)clazz.getAnnotation(RunAs.class)) != null && bean.getSecurityIdentity() == null) {
                    SecurityIdentity securityIdentity = new SecurityIdentity();
                    securityIdentity.setRunAs(runAs.value());
                    bean.setSecurityIdentity(securityIdentity);
                }
                if ((declareRoles = (DeclareRoles)clazz.getAnnotation(DeclareRoles.class)) == null || !(bean instanceof RemoteBean)) continue;
                remoteBean = (RemoteBean)bean;
                securityRoleRefs = remoteBean.getSecurityRoleRef();
                for (String role : declareRoles.value()) {
                    securityRoleRefs.add(new SecurityRoleRef(role));
                }
            }
            ArrayList<java.lang.reflect.Method> seen = new ArrayList<java.lang.reflect.Method>();
            for (Annotated method : annotationFinder.findMetaAnnotatedMethods(RolesAllowed.class)) {
                this.checkConflictingSecurityAnnotations((Annotated<java.lang.reflect.Method>)method, ejbName, ejbModule, seen);
                rolesAllowed = (RolesAllowed)method.getAnnotation(RolesAllowed.class);
                MethodPermission methodPermission = new MethodPermission();
                methodPermission.getRoleName().addAll(Arrays.asList(rolesAllowed.value()));
                methodPermission.getMethod().add(new Method(ejbName, (java.lang.reflect.Method)method.get()));
                assemblyDescriptor.getMethodPermission().add(methodPermission);
                remoteBean = (RemoteBean)bean;
                securityRoleRefs = remoteBean.getSecurityRoleRef();
                for (String role : rolesAllowed.value()) {
                    securityRoleRefs.add(new SecurityRoleRef(role));
                }
            }
            for (Annotated method : annotationFinder.findMetaAnnotatedMethods(PermitAll.class)) {
                this.checkConflictingSecurityAnnotations((Annotated<java.lang.reflect.Method>)method, ejbName, ejbModule, seen);
                MethodPermission methodPermission = new MethodPermission();
                methodPermission.setUnchecked(true);
                methodPermission.getMethod().add(new Method(ejbName, (java.lang.reflect.Method)method.get()));
                assemblyDescriptor.getMethodPermission().add(methodPermission);
            }
            for (Annotated method : annotationFinder.findMetaAnnotatedMethods(DenyAll.class)) {
                this.checkConflictingSecurityAnnotations((Annotated<java.lang.reflect.Method>)method, ejbName, ejbModule, seen);
                ExcludeList excludeList = assemblyDescriptor.getExcludeList();
                excludeList.addMethod(new Method(ejbName, (java.lang.reflect.Method)method.get()));
            }
        }

        private void checkConflictingSecurityAnnotations(Annotated<java.lang.reflect.Method> method, String ejbName, EjbModule ejbModule, List<java.lang.reflect.Method> seen) {
            if (seen.contains(method.get())) {
                return;
            }
            seen.add((java.lang.reflect.Method)method.get());
            ArrayList<CallSite> annotations = new ArrayList<CallSite>();
            for (Class annotation : Arrays.asList(RolesAllowed.class, PermitAll.class, DenyAll.class)) {
                if (method.getAnnotation(annotation) == null) continue;
                annotations.add((CallSite)((Object)("@" + annotation.getSimpleName())));
            }
            if (annotations.size() > 1) {
                ejbModule.getValidation().fail(ejbName, "conflictingSecurityAnnotations", ((java.lang.reflect.Method)method.get()).getName(), Join.join(" and ", annotations), ((java.lang.reflect.Method)method.get()).getDeclaringClass());
            }
        }

        private void processSchedules(EnterpriseBean bean, AnnotationFinder annotationFinder) {
            if (!(bean instanceof TimerConsumer)) {
                return;
            }
            TimerConsumer timerConsumer = (TimerConsumer)bean;
            HashSet scheduleMethods = new HashSet();
            scheduleMethods.addAll(annotationFinder.findMetaAnnotatedMethods(Schedules.class));
            scheduleMethods.addAll(annotationFinder.findMetaAnnotatedMethods(Schedule.class));
            List timers = timerConsumer.getTimer();
            HashSet<CallSite> methodsConfiguredInDeploymentXml = new HashSet<CallSite>();
            for (Timer timer : timers) {
                NamedMethod namedMethod = timer.getTimeoutMethod();
                methodsConfiguredInDeploymentXml.add((CallSite)((Object)(namedMethod.getMethodName() + (namedMethod.getMethodParams() == null ? "" : Join.join("", namedMethod.getMethodParams().getMethodParam())))));
            }
            for (Annotated method : scheduleMethods) {
                Schedule scheduleAnnotation;
                if (methodsConfiguredInDeploymentXml.contains(((java.lang.reflect.Method)method.get()).getName() + Join.join("", this.asStrings(((java.lang.reflect.Method)method.get()).getParameterTypes())))) continue;
                ArrayList<Schedule> scheduleAnnotationList = new ArrayList<Schedule>();
                Schedules schedulesAnnotation = (Schedules)method.getAnnotation(Schedules.class);
                if (schedulesAnnotation != null) {
                    scheduleAnnotationList.addAll(Arrays.asList(schedulesAnnotation.value()));
                }
                if ((scheduleAnnotation = (Schedule)method.getAnnotation(Schedule.class)) != null) {
                    scheduleAnnotationList.add(scheduleAnnotation);
                }
                for (Schedule schedule : scheduleAnnotationList) {
                    Timer timer = new Timer();
                    timer.setPersistent(Boolean.valueOf(schedule.persistent()));
                    timer.setInfo(schedule.info() == null || schedule.info().isEmpty() ? null : schedule.info());
                    timer.setTimezone(schedule.timezone() == null || schedule.timezone().isEmpty() ? null : schedule.timezone());
                    TimerSchedule timerSchedule = new TimerSchedule();
                    timerSchedule.setSecond(schedule.second());
                    timerSchedule.setMinute(schedule.minute());
                    timerSchedule.setHour(schedule.hour());
                    timerSchedule.setDayOfWeek(schedule.dayOfWeek());
                    timerSchedule.setDayOfMonth(schedule.dayOfMonth());
                    timerSchedule.setMonth(schedule.month());
                    timerSchedule.setYear(schedule.year());
                    timer.setSchedule(timerSchedule);
                    timer.setTimeoutMethod(new NamedMethod((java.lang.reflect.Method)method.get()));
                    timers.add(timer);
                }
            }
        }

        private void processCallbacks(Lifecycle bean, AnnotationFinder annotationFinder) {
            List<Annotated<java.lang.reflect.Method>> list;
            TimerConsumer timerConsumer;
            boolean override = "true".equalsIgnoreCase(this.getProperty("openejb.callbacks.override", "false"));
            if (this.apply(override, bean.getPostConstruct())) {
                for (Annotated<java.lang.reflect.Method> annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(PostConstruct.class))) {
                    bean.getPostConstruct().add(new LifecycleCallback((java.lang.reflect.Method)annotated.get()));
                }
            }
            if (this.apply(override, bean.getPreDestroy())) {
                for (Annotated<java.lang.reflect.Method> annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(PreDestroy.class))) {
                    bean.getPreDestroy().add(new LifecycleCallback((java.lang.reflect.Method)annotated.get()));
                }
            }
            if (bean instanceof Invokable) {
                Invokable invokable = (Invokable)bean;
                if (this.apply(override, invokable.getAroundInvoke())) {
                    for (Annotated<java.lang.reflect.Method> annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(jakarta.interceptor.AroundInvoke.class))) {
                        invokable.getAroundInvoke().add(new AroundInvoke((java.lang.reflect.Method)annotated.get()));
                    }
                }
                if (this.apply(override, invokable.getAroundTimeout())) {
                    for (Annotated<java.lang.reflect.Method> annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(jakarta.interceptor.AroundTimeout.class))) {
                        invokable.getAroundTimeout().add(new AroundTimeout((java.lang.reflect.Method)annotated.get()));
                    }
                }
            }
            if (bean instanceof TimerConsumer && (timerConsumer = (TimerConsumer)bean).getTimeoutMethod() == null && (list = AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(jakarta.ejb.Timeout.class))).size() >= 1) {
                timerConsumer.setTimeoutMethod(new NamedMethod((java.lang.reflect.Method)list.get(list.size() - 1).get()));
            }
            if (bean instanceof Session) {
                LifecycleCallback lifecycleCallback;
                LifecycleCallback lifecycleCallback2;
                Session session = (Session)bean;
                LifecycleCallback lifecycleCallback3 = (LifecycleCallback)this.getFirst(session.getAfterBegin());
                if (lifecycleCallback3 == null) {
                    for (Annotated<java.lang.reflect.Method> annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(AfterBegin.class))) {
                        session.getAfterBegin().add(new LifecycleCallback((java.lang.reflect.Method)annotated.get()));
                    }
                }
                if ((lifecycleCallback2 = (LifecycleCallback)this.getFirst(session.getBeforeCompletion())) == null) {
                    for (Annotated<java.lang.reflect.Method> annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(BeforeCompletion.class))) {
                        session.getBeforeCompletion().add(new LifecycleCallback((java.lang.reflect.Method)annotated.get()));
                    }
                }
                if ((lifecycleCallback = (LifecycleCallback)this.getFirst(session.getAfterCompletion())) == null) {
                    for (Annotated<java.lang.reflect.Method> annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(AfterCompletion.class))) {
                        session.getAfterCompletion().add(new LifecycleCallback((java.lang.reflect.Method)annotated.get()));
                    }
                }
                if (this.apply(override, session.getPostActivate())) {
                    for (Annotated<java.lang.reflect.Method> annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(PostActivate.class))) {
                        session.getPostActivate().add(new LifecycleCallback((java.lang.reflect.Method)annotated.get()));
                    }
                }
                if (this.apply(override, session.getPrePassivate())) {
                    for (Annotated<java.lang.reflect.Method> annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(PrePassivate.class))) {
                        session.getPrePassivate().add(new LifecycleCallback((java.lang.reflect.Method)annotated.get()));
                    }
                }
                for (Annotated<java.lang.reflect.Method> annotated : AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(Init.class))) {
                    InitMethod initMethod = new InitMethod((java.lang.reflect.Method)annotated.get());
                    Init init = (Init)annotated.getAnnotation(Init.class);
                    if (init.value() != null && !init.value().isEmpty()) {
                        initMethod.setCreateMethod(init.value());
                    }
                    session.getInitMethod().add(initMethod);
                }
                List<Annotated<java.lang.reflect.Method>> list2 = AnnotationDeployer.sortMethods(annotationFinder.findMetaAnnotatedMethods(Remove.class));
                HashMap<NamedMethod, RemoveMethod> hashMap = new HashMap<NamedMethod, RemoveMethod>();
                for (RemoveMethod removeMethod : session.getRemoveMethod()) {
                    hashMap.put(removeMethod.getBeanMethod(), removeMethod);
                }
                for (Annotated annotated : list2) {
                    Remove remove = (Remove)annotated.getAnnotation(Remove.class);
                    RemoveMethod removeMethod = new RemoveMethod((java.lang.reflect.Method)annotated.get(), remove.retainIfException());
                    RemoveMethod declaredRemoveMethod = (RemoveMethod)hashMap.get(removeMethod.getBeanMethod());
                    if (declaredRemoveMethod == null) {
                        session.getRemoveMethod().add(removeMethod);
                        continue;
                    }
                    if (declaredRemoveMethod.isExplicitlySet()) continue;
                    declaredRemoveMethod.setRetainIfException(remove.retainIfException());
                }
            }
        }

        private boolean apply(boolean override, List<?> list) {
            if (!override) {
                return true;
            }
            return list.size() == 0;
        }

        public void buildAnnotatedRefs(JndiConsumer consumer, IAnnotationFinder annotationFinder, ClassLoader classLoader) throws OpenEJBException {
            DataSourceDefinition definition;
            DataSourceDefinitions defs;
            PersistenceContext pCtx;
            Member member;
            jakarta.persistence.PersistenceUnit pUnit;
            Member member2;
            HandlerChain handlerChain;
            WebServiceRef webserviceref;
            Resource resource;
            Member member3;
            EJB ejb;
            ArrayList<EJB> ejbList = new ArrayList<EJB>();
            for (Annotated clazz : annotationFinder.findMetaAnnotatedClasses(EJBs.class)) {
                EJBs ejbs = (EJBs)clazz.getAnnotation(EJBs.class);
                ejbList.addAll(Arrays.asList(ejbs.value()));
            }
            for (Annotated clazz : annotationFinder.findMetaAnnotatedClasses(EJB.class)) {
                EJB e = (EJB)clazz.getAnnotation(EJB.class);
                ejbList.add(e);
            }
            for (EJB ejb2 : ejbList) {
                this.buildEjbRef(consumer, ejb2, null);
            }
            for (Annotated field : annotationFinder.findMetaAnnotatedFields(EJB.class)) {
                ejb = (EJB)field.getAnnotation(EJB.class);
                FieldMember member4 = new FieldMember((Field)field.get());
                this.buildEjbRef(consumer, ejb, member4);
            }
            for (Object method : annotationFinder.findMetaAnnotatedMethods(EJB.class)) {
                ejb = (EJB)method.getAnnotation(EJB.class);
                member3 = new MethodMember((java.lang.reflect.Method)method.get());
                this.buildEjbRef(consumer, ejb, member3);
            }
            ArrayList<Resource> resourceList = new ArrayList<Resource>();
            for (Annotated clazz : annotationFinder.findMetaAnnotatedClasses(Resources.class)) {
                Resources resources = (Resources)clazz.getAnnotation(Resources.class);
                resourceList.addAll(Arrays.asList(resources.value()));
            }
            for (Annotated clazz : annotationFinder.findMetaAnnotatedClasses(Resource.class)) {
                resource = (Resource)clazz.getAnnotation(Resource.class);
                resourceList.add(resource);
            }
            for (Resource resource2 : resourceList) {
                this.buildResource(consumer, resource2, null);
            }
            for (Object field : annotationFinder.findMetaAnnotatedFields(Resource.class)) {
                resource = (Resource)field.getAnnotation(Resource.class);
                FieldMember member32 = new FieldMember((Field)field.get());
                this.buildResource(consumer, resource, member32);
            }
            for (Annotated method : annotationFinder.findMetaAnnotatedMethods(Resource.class)) {
                resource = (Resource)method.getAnnotation(Resource.class);
                MethodMember member4 = new MethodMember((java.lang.reflect.Method)method.get());
                this.buildResource(consumer, resource, member4);
            }
            for (Object field : annotationFinder.findMetaAnnotatedFields(Context.class)) {
                member3 = new FieldMember((Field)field.get());
                this.buildContext(consumer, member3);
            }
            ArrayList<WebServiceRef> webservicerefList = new ArrayList<WebServiceRef>();
            for (Annotated clazz : annotationFinder.findMetaAnnotatedClasses(WebServiceRefs.class)) {
                WebServiceRefs webServiceRefs = (WebServiceRefs)clazz.getAnnotation(WebServiceRefs.class);
                webservicerefList.addAll(Arrays.asList(webServiceRefs.value()));
            }
            for (Annotated clazz : annotationFinder.findMetaAnnotatedClasses(WebServiceRef.class)) {
                WebServiceRef webServiceRef = (WebServiceRef)clazz.getAnnotation(WebServiceRef.class);
                webservicerefList.add(webServiceRef);
            }
            for (WebServiceRef webserviceref2 : webservicerefList) {
                this.buildWebServiceRef(consumer, webserviceref2, null, null, classLoader);
            }
            for (Annotated field : annotationFinder.findMetaAnnotatedFields(WebServiceRef.class)) {
                webserviceref = (WebServiceRef)field.getAnnotation(WebServiceRef.class);
                handlerChain = (HandlerChain)field.getAnnotation(HandlerChain.class);
                FieldMember member22 = new FieldMember((Field)field.get());
                this.buildWebServiceRef(consumer, webserviceref, handlerChain, member22, classLoader);
            }
            for (Object method : annotationFinder.findMetaAnnotatedMethods(WebServiceRef.class)) {
                webserviceref = (WebServiceRef)method.getAnnotation(WebServiceRef.class);
                handlerChain = (HandlerChain)method.getAnnotation(HandlerChain.class);
                member2 = new MethodMember((java.lang.reflect.Method)method.get());
                this.buildWebServiceRef(consumer, webserviceref, handlerChain, member2, classLoader);
            }
            ArrayList<jakarta.persistence.PersistenceUnit> persistenceUnitList = new ArrayList<jakarta.persistence.PersistenceUnit>();
            for (Annotated clazz : annotationFinder.findMetaAnnotatedClasses(PersistenceUnits.class)) {
                PersistenceUnits persistenceUnits = (PersistenceUnits)clazz.getAnnotation(PersistenceUnits.class);
                persistenceUnitList.addAll(Arrays.asList(persistenceUnits.value()));
            }
            for (Annotated clazz : annotationFinder.findMetaAnnotatedClasses(jakarta.persistence.PersistenceUnit.class)) {
                jakarta.persistence.PersistenceUnit persistenceUnit = (jakarta.persistence.PersistenceUnit)clazz.getAnnotation(jakarta.persistence.PersistenceUnit.class);
                persistenceUnitList.add(persistenceUnit);
            }
            for (jakarta.persistence.PersistenceUnit pUnit2 : persistenceUnitList) {
                this.buildPersistenceUnit(consumer, pUnit2, null);
            }
            for (Annotated field : annotationFinder.findMetaAnnotatedFields(jakarta.persistence.PersistenceUnit.class)) {
                pUnit = (jakarta.persistence.PersistenceUnit)field.getAnnotation(jakarta.persistence.PersistenceUnit.class);
                member2 = new FieldMember((Field)field.get());
                this.buildPersistenceUnit(consumer, pUnit, member2);
            }
            for (Annotated method : annotationFinder.findMetaAnnotatedMethods(jakarta.persistence.PersistenceUnit.class)) {
                pUnit = (jakarta.persistence.PersistenceUnit)method.getAnnotation(jakarta.persistence.PersistenceUnit.class);
                member2 = new MethodMember((java.lang.reflect.Method)method.get());
                this.buildPersistenceUnit(consumer, pUnit, member2);
            }
            PersistenceContextAnnFactory pcFactory = new PersistenceContextAnnFactory();
            ArrayList<PersistenceContext> persistenceContextList = new ArrayList<PersistenceContext>();
            for (Annotated clazz : annotationFinder.findMetaAnnotatedClasses(PersistenceContexts.class)) {
                PersistenceContexts persistenceContexts = (PersistenceContexts)clazz.getAnnotation(PersistenceContexts.class);
                persistenceContextList.addAll(Arrays.asList(persistenceContexts.value()));
                pcFactory.addAnnotations((Class)clazz.get());
            }
            for (Annotated clazz : annotationFinder.findMetaAnnotatedClasses(PersistenceContext.class)) {
                PersistenceContext persistenceContext = (PersistenceContext)clazz.getAnnotation(PersistenceContext.class);
                persistenceContextList.add(persistenceContext);
                pcFactory.addAnnotations((Class)clazz.get());
                if (!((Class)clazz.get()).isInterface()) continue;
                member = new FilledMember("em", EntityManager.class, (Class)clazz.get());
                this.buildPersistenceContext(consumer, pcFactory.create(persistenceContext, member), member);
            }
            for (PersistenceContext pCtx2 : persistenceContextList) {
                this.buildPersistenceContext(consumer, pcFactory.create(pCtx2, null), null);
            }
            for (Annotated field : annotationFinder.findMetaAnnotatedFields(PersistenceContext.class)) {
                pCtx = (PersistenceContext)field.getAnnotation(PersistenceContext.class);
                member = new FieldMember((Field)field.get());
                this.buildPersistenceContext(consumer, pcFactory.create(pCtx, member), member);
            }
            for (Annotated method : annotationFinder.findMetaAnnotatedMethods(PersistenceContext.class)) {
                pCtx = (PersistenceContext)method.getAnnotation(PersistenceContext.class);
                member = new MethodMember((java.lang.reflect.Method)method.get());
                this.buildPersistenceContext(consumer, pcFactory.create(pCtx, member), member);
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(DataSourceDefinitions.class)) {
                defs = (DataSourceDefinitions)annotated.getAnnotation(DataSourceDefinitions.class);
                for (DataSourceDefinition dataSourceDefinition : defs.value()) {
                    this.buildDataSourceDefinition(consumer, dataSourceDefinition);
                }
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(DataSourceDefinition.class)) {
                definition = (DataSourceDefinition)annotated.getAnnotation(DataSourceDefinition.class);
                this.buildDataSourceDefinition(consumer, definition);
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(ContextServiceDefinition.List.class)) {
                defs = (ContextServiceDefinition.List)annotated.getAnnotation(ContextServiceDefinition.List.class);
                for (DataSourceDefinition dataSourceDefinition : defs.value()) {
                    this.buildContextServiceDefinition(consumer, (ContextServiceDefinition)dataSourceDefinition);
                }
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(ContextServiceDefinition.class)) {
                definition = (ContextServiceDefinition)annotated.getAnnotation(ContextServiceDefinition.class);
                this.buildContextServiceDefinition(consumer, (ContextServiceDefinition)definition);
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(ManagedExecutorDefinition.List.class)) {
                defs = (ManagedExecutorDefinition.List)annotated.getAnnotation(ManagedExecutorDefinition.List.class);
                for (DataSourceDefinition dataSourceDefinition : defs.value()) {
                    this.buildManagedExecutorDefinition(consumer, (ManagedExecutorDefinition)dataSourceDefinition);
                }
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(ManagedExecutorDefinition.class)) {
                definition = (ManagedExecutorDefinition)annotated.getAnnotation(ManagedExecutorDefinition.class);
                this.buildManagedExecutorDefinition(consumer, (ManagedExecutorDefinition)definition);
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(ManagedScheduledExecutorDefinition.List.class)) {
                defs = (ManagedScheduledExecutorDefinition.List)annotated.getAnnotation(ManagedScheduledExecutorDefinition.List.class);
                for (DataSourceDefinition dataSourceDefinition : defs.value()) {
                    this.buildManagedScheduledExecutorDefinition(consumer, (ManagedScheduledExecutorDefinition)dataSourceDefinition);
                }
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(ManagedScheduledExecutorDefinition.class)) {
                definition = (ManagedScheduledExecutorDefinition)annotated.getAnnotation(ManagedScheduledExecutorDefinition.class);
                this.buildManagedScheduledExecutorDefinition(consumer, (ManagedScheduledExecutorDefinition)definition);
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(ManagedThreadFactoryDefinition.List.class)) {
                defs = (ManagedThreadFactoryDefinition.List)annotated.getAnnotation(ManagedThreadFactoryDefinition.List.class);
                for (DataSourceDefinition dataSourceDefinition : defs.value()) {
                    this.buildManagedThreadFactoryDefinition(consumer, (ManagedThreadFactoryDefinition)dataSourceDefinition);
                }
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(ManagedThreadFactoryDefinition.class)) {
                definition = (ManagedThreadFactoryDefinition)annotated.getAnnotation(ManagedThreadFactoryDefinition.class);
                this.buildManagedThreadFactoryDefinition(consumer, (ManagedThreadFactoryDefinition)definition);
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(JMSConnectionFactoryDefinitions.class)) {
                defs = (JMSConnectionFactoryDefinitions)annotated.getAnnotation(JMSConnectionFactoryDefinitions.class);
                for (DataSourceDefinition dataSourceDefinition : defs.value()) {
                    this.buildConnectionFactoryDefinition(consumer, (JMSConnectionFactoryDefinition)dataSourceDefinition);
                }
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(JMSConnectionFactoryDefinition.class)) {
                definition = (JMSConnectionFactoryDefinition)annotated.getAnnotation(JMSConnectionFactoryDefinition.class);
                this.buildConnectionFactoryDefinition(consumer, (JMSConnectionFactoryDefinition)definition);
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(JMSDestinationDefinitions.class)) {
                defs = (JMSDestinationDefinitions)annotated.getAnnotation(JMSDestinationDefinitions.class);
                for (DataSourceDefinition dataSourceDefinition : defs.value()) {
                    this.buildDestinationDefinition(consumer, (JMSDestinationDefinition)dataSourceDefinition);
                }
            }
            for (Annotated annotated : annotationFinder.findMetaAnnotatedClasses(JMSDestinationDefinition.class)) {
                this.buildDestinationDefinition(consumer, (JMSDestinationDefinition)annotated.getAnnotation(JMSDestinationDefinition.class));
            }
        }

        private void buildContextServiceDefinition(JndiConsumer consumer, ContextServiceDefinition definition) {
            ContextService contextService;
            ContextService existing = (ContextService)consumer.getContextServiceMap().get(definition.name());
            ContextService contextService2 = contextService = existing != null ? existing : new ContextService();
            if (contextService.getName() == null) {
                JndiName jndiName = new JndiName();
                jndiName.setvalue(definition.name());
                contextService.setName(jndiName);
            }
            if (contextService.getCleared().isEmpty()) {
                contextService.getCleared().addAll(Arrays.asList(definition.cleared()));
            }
            if (contextService.getPropagated().isEmpty()) {
                contextService.getPropagated().addAll(Arrays.asList(definition.propagated()));
            }
            if (contextService.getUnchanged().isEmpty()) {
                contextService.getUnchanged().addAll(Arrays.asList(definition.unchanged()));
            }
            consumer.getContextServiceMap().put(definition.name(), contextService);
        }

        private void buildManagedExecutorDefinition(JndiConsumer consumer, ManagedExecutorDefinition definition) {
            ManagedExecutor existing = (ManagedExecutor)consumer.getManagedExecutorMap().get(definition.name());
            ManagedExecutor managedExecutor = existing != null ? existing : new ManagedExecutor();
            managedExecutor.setName(new JndiName());
            managedExecutor.getName().setvalue(definition.name());
            managedExecutor.setContextService(new JndiName());
            managedExecutor.getContextService().setvalue(definition.context());
            managedExecutor.setHungTaskThreshold(Long.valueOf(definition.hungTaskThreshold()));
            managedExecutor.setMaxAsync(definition.maxAsync() == -1 ? null : Integer.valueOf(definition.maxAsync()));
            consumer.getManagedExecutorMap().put(definition.name(), managedExecutor);
        }

        private void buildManagedScheduledExecutorDefinition(JndiConsumer consumer, ManagedScheduledExecutorDefinition definition) {
            ManagedScheduledExecutor existing = (ManagedScheduledExecutor)consumer.getManagedScheduledExecutorMap().get(definition.name());
            ManagedScheduledExecutor managedScheduledExecutor = existing != null ? existing : new ManagedScheduledExecutor();
            managedScheduledExecutor.setName(new JndiName());
            managedScheduledExecutor.getName().setvalue(definition.name());
            managedScheduledExecutor.setContextService(new JndiName());
            managedScheduledExecutor.getContextService().setvalue(definition.context());
            managedScheduledExecutor.setHungTaskThreshold(Long.valueOf(definition.hungTaskThreshold()));
            managedScheduledExecutor.setMaxAsync(definition.maxAsync() == -1 ? null : Integer.valueOf(definition.maxAsync()));
            consumer.getManagedScheduledExecutorMap().put(definition.name(), managedScheduledExecutor);
        }

        private void buildManagedThreadFactoryDefinition(JndiConsumer consumer, ManagedThreadFactoryDefinition definition) {
            ManagedThreadFactory existing = (ManagedThreadFactory)consumer.getManagedThreadFactoryMap().get(definition.name());
            ManagedThreadFactory managedThreadFactory = existing != null ? existing : new ManagedThreadFactory();
            managedThreadFactory.setName(new JndiName());
            managedThreadFactory.getName().setvalue(definition.name());
            managedThreadFactory.setContextService(new JndiName());
            managedThreadFactory.getContextService().setvalue(definition.context());
            managedThreadFactory.setPriority(Integer.valueOf(definition.priority()));
            consumer.getManagedThreadFactoryMap().put(definition.name(), managedThreadFactory);
        }

        private void buildContext(JndiConsumer consumer, Member member) {
            ContextRef ref = new ContextRef();
            ref.setName(member.getDeclaringClass().getName() + "/" + member.getName());
            ref.setResType(member.getType().getName());
            InjectionTarget target = new InjectionTarget();
            target.setInjectionTargetClass(member.getDeclaringClass().getName());
            target.setInjectionTargetName(member.getName());
            ref.getInjectionTarget().add(target);
            consumer.getResourceRef().add(ref);
        }

        private void buildEjbRef(JndiConsumer consumer, EJB ejb, Member member) {
            String ejbName;
            Class<?> interfce;
            String name = consumer.getJndiConsumerName();
            if (member == null) {
                boolean shouldReturn = false;
                if (ejb.name().isEmpty()) {
                    this.fail(name, "ejbAnnotation.onClassWithNoName", new Object[0]);
                    shouldReturn = true;
                }
                if (ejb.beanInterface().equals(Object.class)) {
                    this.fail(name, "ejbAnnotation.onClassWithNoBeanInterface", new Object[0]);
                    shouldReturn = true;
                }
                if (shouldReturn) {
                    return;
                }
            }
            EjbRef ejbRef = new EjbRef();
            ejbRef.setRefType(EjbReference.Type.UNKNOWN);
            Object refName = ejb.name();
            if (((String)refName).length() == 0) {
                refName = member.getDeclaringClass().getName() + "/" + member.getName();
            }
            ejbRef.setEjbRefName(this.normalize((String)refName));
            if (member != null) {
                InjectionTarget target = new InjectionTarget();
                target.setInjectionTargetClass(member.getDeclaringClass().getName());
                target.setInjectionTargetName(member.getName());
                ejbRef.getInjectionTarget().add(target);
            }
            if ((interfce = ejb.beanInterface()).equals(Object.class)) {
                interfce = member == null ? null : member.getType();
            }
            boolean localbean = this.isKnownLocalBean(interfce);
            boolean dynamicallyImplemented = DynamicProxyImplFactory.isKnownDynamicallyImplemented(interfce);
            if (!localbean && interfce != null && !this.isValidEjbInterface(name, interfce, ejbRef.getName())) {
                return;
            }
            if (interfce != null && !interfce.equals(Object.class)) {
                if (EJBHome.class.isAssignableFrom(interfce)) {
                    ejbRef.setHome(interfce.getName());
                    for (java.lang.reflect.Method method : methods = interfce.getMethods()) {
                        if (!method.getName().startsWith("create")) continue;
                        ejbRef.setRemote(method.getReturnType().getName());
                        break;
                    }
                    ejbRef.setRefType(EjbReference.Type.REMOTE);
                } else if (EJBLocalHome.class.isAssignableFrom(interfce)) {
                    ejbRef.setHome(interfce.getName());
                    for (java.lang.reflect.Method method : methods = interfce.getMethods()) {
                        if (!method.getName().startsWith("create")) continue;
                        ejbRef.setRemote(method.getReturnType().getName());
                        break;
                    }
                    ejbRef.setRefType(EjbReference.Type.LOCAL);
                } else if (localbean) {
                    ejbRef.setRefType(EjbReference.Type.LOCAL);
                    ejbRef.setRemote(interfce.getName());
                } else if (dynamicallyImplemented) {
                    ejbRef.setRefType(EjbReference.Type.LOCAL);
                    ejbRef.setRemote(interfce.getName());
                } else {
                    ejbRef.setRemote(interfce.getName());
                    if (interfce.getAnnotation(Local.class) != null) {
                        ejbRef.setRefType(EjbReference.Type.LOCAL);
                    } else if (interfce.getAnnotation(Remote.class) != null) {
                        ejbRef.setRefType(EjbReference.Type.REMOTE);
                    }
                }
            }
            if ((ejbName = ejb.beanName()).isEmpty()) {
                ejbName = null;
            }
            ejbRef.setEjbLink(ejbName);
            String mappedName = ejb.mappedName();
            if (mappedName.isEmpty()) {
                mappedName = null;
            }
            ejbRef.setMappedName(mappedName);
            String lookupName = ProcessAnnotatedBeans.getLookupName(ejb);
            if (lookupName.isEmpty()) {
                lookupName = null;
            }
            ejbRef.setLookupName(lookupName);
            Map remoteRefs = consumer.getEjbRefMap();
            if (remoteRefs.containsKey(ejbRef.getName())) {
                EjbRef ref = (EjbRef)remoteRefs.get(ejbRef.getName());
                if (ref.getRemote() == null) {
                    ref.setRemote(ejbRef.getRemote());
                }
                if (ref.getHome() == null) {
                    ref.setHome(ejbRef.getHome());
                }
                if (ref.getMappedName() == null) {
                    ref.setMappedName(ejbRef.getMappedName());
                }
                ref.getInjectionTarget().addAll(ejbRef.getInjectionTarget());
                return;
            }
            Map localRefs = consumer.getEjbLocalRefMap();
            if (localRefs.containsKey(ejbRef.getName())) {
                EjbLocalRef ejbLocalRef = new EjbLocalRef((EjbReference)ejbRef);
                EjbLocalRef ref = (EjbLocalRef)localRefs.get(ejbLocalRef.getName());
                if (ref.getLocal() == null) {
                    ref.setLocal(ejbLocalRef.getLocal());
                }
                if (ref.getLocalHome() == null) {
                    ref.setLocalHome(ejbLocalRef.getLocalHome());
                }
                if (ref.getMappedName() == null) {
                    ref.setMappedName(ejbLocalRef.getMappedName());
                }
                if (ref.getEjbLink() == null) {
                    ref.setEjbLink(ejbLocalRef.getEjbLink());
                }
                ref.getInjectionTarget().addAll(ejbLocalRef.getInjectionTarget());
                return;
            }
            switch (ejbRef.getRefType()) {
                case UNKNOWN: 
                case REMOTE: {
                    consumer.getEjbRef().add(ejbRef);
                    break;
                }
                case LOCAL: {
                    consumer.getEjbLocalRef().add(new EjbLocalRef((EjbReference)ejbRef));
                }
            }
        }

        private String normalize(String refName) {
            if (refName.startsWith("java:")) {
                return refName.startsWith("/") ? refName.substring(1) : refName;
            }
            return "java:comp/env/" + refName;
        }

        private boolean isKnownLocalBean(Class clazz) {
            if (clazz.isAnnotation()) {
                return false;
            }
            if (clazz.isArray()) {
                return false;
            }
            if (clazz.isEnum()) {
                return false;
            }
            if (clazz.isInterface()) {
                return false;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            if (Modifier.isAbstract(clazz.getModifiers())) {
                return false;
            }
            return !Modifier.isFinal(clazz.getModifiers());
        }

        private boolean isValidEjbInterface(String b, Class clazz, String refName) {
            if (clazz.isInterface()) {
                if (EJBObject.class.isAssignableFrom(clazz)) {
                    this.fail(b, "ann.ejb.ejbObject", clazz.getName(), refName);
                    return false;
                }
                if (EJBLocalObject.class.isAssignableFrom(clazz)) {
                    this.fail(b, "ann.ejb.ejbLocalObject", clazz.getName(), refName);
                    return false;
                }
            }
            return true;
        }

        private void fail(String component, String key, Object ... details) {
            AnnotationDeployer.getValidationContext().fail(component, key, details);
        }

        private void buildResource(JndiConsumer consumer, Resource resource, Member member) {
            String lookupName;
            if (member == null && resource.name().length() == 0) {
                this.fail(consumer.getJndiConsumerName(), "resourceAnnotation.onClassWithNoName", new Object[0]);
                return;
            }
            Object refName = resource.name();
            if (((String)refName).isEmpty()) {
                refName = member.getDeclaringClass().getName() + "/" + member.getName();
            }
            refName = this.normalize((String)refName);
            JndiReference reference = (JndiReference)consumer.getEnvEntryMap().get(refName);
            if (reference == null) {
                Class<?> type;
                if (member != null) {
                    type = member.getType();
                    if (EntityManager.class.isAssignableFrom(type)) {
                        this.fail(consumer.getJndiConsumerName(), "resourceRef.onEntityManager", refName);
                        return;
                    }
                    if (EntityManagerFactory.class.isAssignableFrom(type)) {
                        this.fail(consumer.getJndiConsumerName(), "resourceRef.onEntityManagerFactory", refName);
                        return;
                    }
                }
                if (knownResourceEnvTypes.contains((type = member == null ? resource.type() : member.getType()).getName())) {
                    ResourceEnvRef resourceEnvRef = (ResourceEnvRef)consumer.getResourceEnvRefMap().get(refName);
                    if (resourceEnvRef == null) {
                        resourceEnvRef = new ResourceEnvRef();
                        resourceEnvRef.setName((String)refName);
                        consumer.getResourceEnvRef().add(resourceEnvRef);
                    }
                    if (resourceEnvRef.getResourceEnvRefType() == null || "".equals(resourceEnvRef.getResourceEnvRefType())) {
                        resourceEnvRef.setResourceEnvRefType(type.getName());
                    }
                    reference = resourceEnvRef;
                } else if (AnnotationDeployer.isKnownEnvironmentEntryType(type)) {
                    String lookupName2 = ProcessAnnotatedBeans.getLookupName(resource);
                    if (!lookupName2.isEmpty()) {
                        EnvEntry envEntry = new EnvEntry();
                        envEntry.setName((String)refName);
                        consumer.getEnvEntry().add(envEntry);
                        envEntry.setLookupName(lookupName2);
                        reference = envEntry;
                    } else if (AnnotationDeployer.isShareableJNDINamespace((String)refName)) {
                        EnvEntry envEntry = new EnvEntry();
                        envEntry.setName((String)refName);
                        consumer.getEnvEntry().add(envEntry);
                        reference = envEntry;
                    } else {
                        String shortName = this.normalize(member.getName());
                        reference = (JndiReference)consumer.getEnvEntryMap().get(shortName);
                        if (reference == null) {
                            EnvEntry envEntry = new EnvEntry();
                            envEntry.setName((String)refName);
                            consumer.getEnvEntry().add(envEntry);
                            reference = envEntry;
                        }
                    }
                } else {
                    ResourceRef resourceRef = (ResourceRef)consumer.getResourceRefMap().get(refName);
                    if (resourceRef == null) {
                        resourceRef = new ResourceRef();
                        resourceRef.setName((String)refName);
                        consumer.getResourceRef().add(resourceRef);
                    }
                    if (member != null) {
                        resourceRef.setOrigin(String.valueOf(member.getDeclaringClass()) + "#" + member.getName());
                    }
                    if (resourceRef.getResAuth() == null) {
                        if (resource.authenticationType() == Resource.AuthenticationType.APPLICATION) {
                            resourceRef.setResAuth(ResAuth.APPLICATION);
                        } else {
                            resourceRef.setResAuth(ResAuth.CONTAINER);
                        }
                    }
                    if (resourceRef.getResType() == null || "".equals(resourceRef.getResType())) {
                        resourceRef.setResType(type.getName());
                    }
                    if (resourceRef.getResSharingScope() == null) {
                        if (resource.shareable()) {
                            resourceRef.setResSharingScope(ResSharingScope.SHAREABLE);
                        } else {
                            resourceRef.setResSharingScope(ResSharingScope.UNSHAREABLE);
                        }
                    }
                    reference = resourceRef;
                }
            }
            if (member != null) {
                InjectionTarget target = new InjectionTarget();
                target.setInjectionTargetClass(member.getDeclaringClass().getName());
                target.setInjectionTargetName(member.getName());
                reference.getInjectionTarget().add(target);
            }
            if (reference.getMappedName() == null && !resource.mappedName().isEmpty()) {
                reference.setMappedName(resource.mappedName());
            }
            if (reference.getLookupName() == null && !(lookupName = ProcessAnnotatedBeans.getLookupName(resource)).isEmpty()) {
                reference.setLookupName(lookupName);
            }
        }

        private static java.lang.reflect.Method getLookupMethod(Class cls) {
            String name = cls.getName();
            if (!lookupMissing.contains(name)) {
                try {
                    return cls.getMethod("lookup", null);
                }
                catch (NoSuchMethodException e) {
                    lookupMissing.add(name);
                    String exists = ProcessAnnotatedBeans.getSourceIfExists(cls);
                    logger.warning("Method 'lookup' is not available for '" + name + "'" + (String)(null != exists ? ". The old API '" + exists + "' was found on the classpath." : ". Probably using an older Runtime."));
                }
            }
            return null;
        }

        private static String getSourceIfExists(Class<?> cls) {
            if (cls.getProtectionDomain() != null && cls.getProtectionDomain().getCodeSource() != null && cls.getProtectionDomain().getCodeSource().getLocation() != null) {
                return cls.getProtectionDomain().getCodeSource().getLocation().toString();
            }
            return null;
        }

        private static String getLookupName(Resource resource) {
            String value = "";
            java.lang.reflect.Method lookupMethod = ProcessAnnotatedBeans.getLookupMethod(Resource.class);
            if (lookupMethod != null) {
                try {
                    value = (String)lookupMethod.invoke((Object)resource, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return value;
        }

        private static String getLookupName(EJB ejb) {
            String value = "";
            java.lang.reflect.Method lookupMethod = ProcessAnnotatedBeans.getLookupMethod(EJB.class);
            if (lookupMethod != null) {
                try {
                    value = (String)lookupMethod.invoke((Object)ejb, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return value;
        }

        private void buildPersistenceUnit(JndiConsumer consumer, jakarta.persistence.PersistenceUnit persistenceUnit, Member member) throws OpenEJBException {
            Object refName = persistenceUnit.name();
            if (((String)refName).length() == 0) {
                if (member == null) {
                    this.fail(consumer.getJndiConsumerName(), "persistenceUnitAnnotation.onClassWithNoName", persistenceUnit.unitName());
                    return;
                }
                refName = member.getDeclaringClass().getName() + "/" + member.getName();
            }
            refName = this.normalize((String)refName);
            PersistenceUnitRef persistenceUnitRef = (PersistenceUnitRef)consumer.getPersistenceUnitRefMap().get(refName);
            if (persistenceUnitRef == null) {
                persistenceUnitRef = new PersistenceUnitRef();
                persistenceUnitRef.setPersistenceUnitName(persistenceUnit.unitName());
                persistenceUnitRef.setPersistenceUnitRefName((String)refName);
                consumer.getPersistenceUnitRef().add(persistenceUnitRef);
            }
            if (member != null) {
                Class<?> type = member.getType();
                if (EntityManager.class.isAssignableFrom(type)) {
                    AnnotationDeployer.failIfCdiProducer(member, "EntityManagerFactory");
                    ValidationContext validationContext = AnnotationDeployer.getValidationContext();
                    String jndiConsumerName = consumer.getJndiConsumerName();
                    String name = persistenceUnitRef.getName();
                    validationContext.fail(jndiConsumerName, "persistenceUnitAnnotation.onEntityManager", name);
                } else if (!EntityManagerFactory.class.isAssignableFrom(type)) {
                    AnnotationDeployer.failIfCdiProducer(member, "EntityManagerFactory");
                    this.fail(consumer.getJndiConsumerName(), "persistenceUnitAnnotation.onNonEntityManagerFactory", persistenceUnitRef.getName());
                } else {
                    InjectionTarget target = new InjectionTarget();
                    target.setInjectionTargetClass(member.getDeclaringClass().getName());
                    target.setInjectionTargetName(member.getName());
                    persistenceUnitRef.getInjectionTarget().add(target);
                }
            }
            if (persistenceUnitRef.getPersistenceUnitName() == null && !persistenceUnit.unitName().isEmpty()) {
                persistenceUnitRef.setPersistenceUnitName(persistenceUnit.unitName());
            }
        }

        private void buildPersistenceContext(JndiConsumer consumer, PersistenceContextAnn persistenceContext, Member member) throws OpenEJBException {
            AppModule module = null;
            if (currentModule.get() instanceof AppModule) {
                module = (AppModule)currentModule.get();
            } else if (currentModule.get() instanceof Module) {
                module = ((Module)((Object)currentModule.get())).getAppModule();
            }
            if (module != null && TransactionType.RESOURCE_LOCAL.equals((Object)module.getTransactionType(persistenceContext.unitName()))) {
                String name = persistenceContext.unitName();
                if (name == null || name.isEmpty()) {
                    try {
                        name = ((PersistenceUnit)module.getPersistenceModules().iterator().next().getPersistence().getPersistenceUnit().iterator().next()).getName();
                    }
                    catch (Exception e) {
                        name = "?";
                    }
                }
                logger.info("PersistenceUnit '" + name + "' is a RESOURCE_LOCAL one, you'll have to manage @PersistenceContext yourself.");
                return;
            }
            Object refName = persistenceContext.name();
            if (((String)refName).length() == 0) {
                if (member == null) {
                    this.fail(consumer.getJndiConsumerName(), "persistenceContextAnnotation.onClassWithNoName", persistenceContext.unitName());
                    return;
                }
                refName = member.getDeclaringClass().getName() + "/" + member.getName();
            }
            refName = this.normalize((String)refName);
            PersistenceContextRef persistenceContextRef = (PersistenceContextRef)consumer.getPersistenceContextRefMap().get(refName);
            if (persistenceContextRef == null) {
                persistenceContextRef = new PersistenceContextRef();
                if (persistenceContext.synchronization() != null) {
                    persistenceContextRef.setPersistenceContextSynchronization(PersistenceContextSynchronization.valueOf((String)persistenceContext.synchronization().toUpperCase(Locale.ENGLISH)));
                }
                persistenceContextRef.setPersistenceUnitName(persistenceContext.unitName());
                persistenceContextRef.setPersistenceContextRefName((String)refName);
                if ("EXTENDED".equalsIgnoreCase(persistenceContext.type())) {
                    persistenceContextRef.setPersistenceContextType(PersistenceContextType.EXTENDED);
                } else {
                    persistenceContextRef.setPersistenceContextType(PersistenceContextType.TRANSACTION);
                }
                consumer.getPersistenceContextRef().add(persistenceContextRef);
            } else {
                if (persistenceContextRef.getPersistenceUnitName() == null || "".equals(persistenceContextRef.getPersistenceUnitName())) {
                    persistenceContextRef.setPersistenceUnitName(persistenceContext.unitName());
                }
                if (persistenceContextRef.getPersistenceContextType() == null) {
                    if ("EXTENDED".equalsIgnoreCase(persistenceContext.type())) {
                        persistenceContextRef.setPersistenceContextType(PersistenceContextType.EXTENDED);
                    } else {
                        persistenceContextRef.setPersistenceContextType(PersistenceContextType.TRANSACTION);
                    }
                }
                if (persistenceContextRef.getPersistenceContextSynchronization() == null && persistenceContext.synchronization() != null) {
                    persistenceContextRef.setPersistenceContextSynchronization(PersistenceContextSynchronization.valueOf((String)persistenceContext.synchronization().toUpperCase(Locale.ENGLISH)));
                }
            }
            ArrayList<Property> persistenceProperties = persistenceContextRef.getPersistenceProperty();
            if (persistenceProperties == null) {
                persistenceProperties = new ArrayList<Property>();
                persistenceContextRef.setPersistenceProperty(persistenceProperties);
            }
            for (Map.Entry<String, String> persistenceProperty : persistenceContext.properties().entrySet()) {
                boolean flag = true;
                for (Property prpty : persistenceProperties) {
                    if (!prpty.getName().equals(persistenceProperty.getKey())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                Property property = new Property();
                property.setName(persistenceProperty.getKey());
                property.setValue(persistenceProperty.getValue());
                persistenceProperties.add(property);
            }
            if (member != null) {
                Class<?> type = member.getType();
                if (EntityManagerFactory.class.isAssignableFrom(type)) {
                    AnnotationDeployer.failIfCdiProducer(member, "EntityManager");
                    this.fail(consumer.getJndiConsumerName(), "persistenceContextAnnotation.onEntityManagerFactory", persistenceContextRef.getName());
                } else if (!EntityManager.class.isAssignableFrom(type)) {
                    AnnotationDeployer.failIfCdiProducer(member, "EntityManager");
                    this.fail(consumer.getJndiConsumerName(), "persistenceContextAnnotation.onNonEntityManager", persistenceContextRef.getName());
                } else {
                    InjectionTarget target = new InjectionTarget();
                    target.setInjectionTargetClass(member.getDeclaringClass().getName());
                    target.setInjectionTargetName(member.getName());
                    persistenceContextRef.getInjectionTarget().add(target);
                }
            }
        }

        private void buildDestinationDefinition(JndiConsumer consumer, JMSDestinationDefinition definition) {
            JMSDestination destination = new JMSDestination();
            destination.setName(definition.name());
            destination.setClassName(definition.className());
            destination.setInterfaceName(definition.interfaceName());
            destination.setResourceAdapter(definition.resourceAdapter());
            destination.setDestinationName(definition.destinationName());
            for (String s : definition.properties()) {
                int equal = s.indexOf(61);
                if (equal < s.length() - 1) {
                    SuperProperties props = new SuperProperties();
                    try {
                        props.load(new ByteArrayInputStream(s.getBytes()));
                        for (String key : props.stringPropertyNames()) {
                            if (key.isEmpty()) continue;
                            destination.property(key, props.getProperty(key));
                        }
                        continue;
                    }
                    catch (IOException e) {
                        String key;
                        key = s.substring(0, equal).trim();
                        String value = s.substring(equal + 1).trim();
                        destination.property(key, value);
                        continue;
                    }
                }
                destination.property(s.trim(), "");
            }
            consumer.getJMSDestination().add(destination);
        }

        private void buildConnectionFactoryDefinition(JndiConsumer consumer, JMSConnectionFactoryDefinition definition) {
            JMSConnectionFactory connectionFactory = new JMSConnectionFactory();
            connectionFactory.setName(definition.name());
            connectionFactory.setMinPoolSize(Integer.valueOf(definition.minPoolSize()));
            connectionFactory.setMaxPoolSize(Integer.valueOf(definition.maxPoolSize()));
            connectionFactory.setClassName(definition.className());
            connectionFactory.setInterfaceName(definition.interfaceName());
            connectionFactory.setClientId(definition.clientId());
            connectionFactory.setUser(definition.user());
            connectionFactory.setPassword(definition.password());
            connectionFactory.setResourceAdapter(definition.resourceAdapter());
            connectionFactory.setTransactional(definition.transactional());
            for (String s : definition.properties()) {
                int equal = s.indexOf(61);
                if (equal < s.length() - 1) {
                    SuperProperties props = new SuperProperties();
                    try {
                        props.load(new ByteArrayInputStream(s.getBytes()));
                        for (String key : props.stringPropertyNames()) {
                            if (key.isEmpty()) continue;
                            connectionFactory.property(key, props.getProperty(key));
                        }
                        continue;
                    }
                    catch (IOException e) {
                        String key;
                        key = s.substring(0, equal).trim();
                        String value = s.substring(equal + 1).trim();
                        connectionFactory.property(key, value);
                        continue;
                    }
                }
                connectionFactory.property(s.trim(), "");
            }
            consumer.getJMSConnectionFactories().add(connectionFactory);
        }

        private void buildDataSourceDefinition(JndiConsumer consumer, DataSourceDefinition d) {
            DataSource dataSource = new DataSource();
            dataSource.setName(d.name());
            dataSource.setClassName(d.className());
            dataSource.setTransactional(Boolean.valueOf(d.transactional()));
            DataSource existing = (DataSource)consumer.getDataSourceMap().get(dataSource.getKey());
            if (existing != null) {
                return;
            }
            if (!d.databaseName().isEmpty()) {
                dataSource.setDatabaseName(d.databaseName());
            }
            if (d.initialPoolSize() != -1) {
                dataSource.setInitialPoolSize(Integer.valueOf(d.initialPoolSize()));
            }
            if (d.isolationLevel() != -1) {
                dataSource.setIsolationLevel(IsolationLevel.fromFlag((int)d.isolationLevel()));
            }
            if (d.loginTimeout() != 0) {
                dataSource.setLoginTimeout(Integer.valueOf(d.loginTimeout()));
            }
            if (d.maxIdleTime() != -1) {
                dataSource.setMaxIdleTime(Integer.valueOf(d.maxIdleTime()));
            }
            if (d.maxPoolSize() != -1) {
                dataSource.setMaxPoolSize(Integer.valueOf(d.maxPoolSize()));
            }
            if (d.maxStatements() != -1) {
                dataSource.setMaxStatements(Integer.valueOf(d.maxStatements()));
            }
            if (d.minPoolSize() != -1) {
                dataSource.setMinPoolSize(Integer.valueOf(d.minPoolSize()));
            }
            if (!d.password().isEmpty()) {
                dataSource.setPassword(d.password());
            }
            if (d.portNumber() != -1) {
                dataSource.setPortNumber(Integer.valueOf(d.portNumber()));
            }
            if (!"localhost".equals(d.serverName())) {
                dataSource.setServerName(d.serverName());
            }
            if (!d.url().isEmpty()) {
                dataSource.setUrl(d.url());
            }
            if (!d.user().isEmpty()) {
                dataSource.setUser(d.user());
            }
            for (String s : d.properties()) {
                int equal = s.indexOf(61);
                if (equal < s.length() - 1) {
                    SuperProperties props = new SuperProperties();
                    try {
                        props.load(new ByteArrayInputStream(s.getBytes()));
                        for (String key : props.stringPropertyNames()) {
                            if (key.isEmpty()) continue;
                            dataSource.property(key, props.getProperty(key));
                        }
                        continue;
                    }
                    catch (IOException e) {
                        String key;
                        key = s.substring(0, equal).trim();
                        String value = s.substring(equal + 1).trim();
                        dataSource.property(key, value);
                        continue;
                    }
                }
                dataSource.property(s.trim(), "");
            }
            consumer.getDataSource().add(dataSource);
            SystemInstance.get().fireEvent(new DataSourceDefinitionUrlBuild(dataSource));
        }

        private void buildWebServiceRef(JndiConsumer consumer, WebServiceRef webService, HandlerChain handlerChain, Member member, ClassLoader classLoader) throws OpenEJBException {
            String wsdlLocation;
            Object refName = webService.name();
            if (((String)refName).isEmpty()) {
                if (member == null) {
                    return;
                }
                refName = member.getDeclaringClass().getName() + "/" + member.getName();
            }
            refName = this.normalize((String)refName);
            ServiceRef serviceRef = (ServiceRef)consumer.getServiceRefMap().get(refName);
            if (serviceRef == null) {
                serviceRef = new ServiceRef();
                serviceRef.setServiceRefName((String)refName);
                consumer.getServiceRef().add(serviceRef);
            }
            if (member != null) {
                InjectionTarget target = new InjectionTarget();
                target.setInjectionTargetClass(member.getDeclaringClass().getName());
                target.setInjectionTargetName(member.getName());
                serviceRef.getInjectionTarget().add(target);
            }
            Class<?> serviceInterface = null;
            if (serviceRef.getServiceInterface() == null && (serviceInterface = webService.type()).equals(Object.class) && (Service.class.equals((Object)(serviceInterface = webService.value())) || Object.class.equals((Object)serviceInterface)) && member != null) {
                serviceInterface = member.getType();
            }
            if (serviceInterface == null || !Service.class.isAssignableFrom(serviceInterface)) {
                serviceInterface = Service.class;
            }
            serviceRef.setServiceInterface(serviceInterface.getName());
            if (serviceRef.getServiceRefType() == null || "".equals(serviceRef.getServiceRefType())) {
                if (webService.type() != Object.class) {
                    serviceRef.setServiceRefType(webService.type().getName());
                } else {
                    serviceRef.setServiceRefType(member.getType().getName());
                }
            }
            Class<?> refType = null;
            try {
                refType = classLoader.loadClass(AnnotationDeployer.realClassName(serviceRef.getType()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (serviceRef.getMappedName() == null) {
                String mappedName = webService.mappedName();
                if (mappedName.isEmpty()) {
                    mappedName = null;
                }
                serviceRef.setMappedName(mappedName);
            }
            if (serviceRef.getWsdlFile() == null && !(wsdlLocation = webService.wsdlLocation()).isEmpty()) {
                serviceRef.setWsdlFile(wsdlLocation);
            }
            if (SystemInstance.get().hasProperty("openejb.geronimo")) {
                return;
            }
            if (serviceRef.getWsdlFile() == null && refType != null) {
                serviceRef.setWsdlFile(JaxWsUtils.getServiceWsdlLocation(refType, classLoader));
            }
            if (serviceRef.getWsdlFile() == null) {
                serviceRef.setWsdlFile(JaxWsUtils.getServiceWsdlLocation(serviceInterface, classLoader));
            }
            if (serviceRef.getServiceQname() == null && refType != null) {
                try {
                    serviceRef.setServiceQname(JaxWsUtils.getServiceQName(refType));
                }
                catch (IllegalArgumentException iae) {
                    if (FieldMember.class.isInstance(member) && ((FieldMember)FieldMember.class.cast((Object)member)).field.getAnnotation(Produces.class) != null) {
                        throw new DefinitionException(String.valueOf(((FieldMember)FieldMember.class.cast((Object)member)).field) + " is not a webservice client");
                    }
                    throw iae;
                }
            }
            if (serviceRef.getServiceQname() == null) {
                serviceRef.setServiceQname(JaxWsUtils.getServiceQName(serviceInterface));
            }
            if (serviceRef.getHandlerChains() == null && handlerChain != null) {
                try {
                    URL handlerFileURL = member.getDeclaringClass().getResource(handlerChain.file());
                    HandlerChains handlerChains = ReadDescriptors.readHandlerChains(handlerFileURL);
                    serviceRef.setHandlerChains(handlerChains);
                }
                catch (Throwable e) {
                    throw new OpenEJBException("Unable to load handler chain file: " + handlerChain.file(), e);
                }
            }
        }

        private void processWebServiceHandlers(EjbModule ejbModule, EnterpriseBean bean, AnnotationFinder finder) throws OpenEJBException {
            HashSet<String> classes = new HashSet<String>();
            if (ejbModule.getWebservices() != null) {
                for (WebserviceDescription webservice : ejbModule.getWebservices().getWebserviceDescription()) {
                    for (PortComponent port : webservice.getPortComponent()) {
                        if (!bean.getEjbName().equals(port.getServiceImplBean().getEjbLink()) || port.getHandlerChains() == null) continue;
                        for (org.apache.openejb.jee.HandlerChain handlerChain : port.getHandlerChains().getHandlerChain()) {
                            for (Handler handler : handlerChain.getHandler()) {
                                String handlerClass = AnnotationDeployer.realClassName(handler.getHandlerClass());
                                if (handlerClass == null) continue;
                                classes.add(handlerClass);
                            }
                        }
                    }
                }
            }
            AnnotationFinder handlersFinder = finder.select(classes);
            this.buildAnnotatedRefs((JndiConsumer)bean, (IAnnotationFinder)handlersFinder, ejbModule.getClassLoader());
        }

        private void processWebServiceClientHandlers(JndiConsumer consumer, AnnotationFinder finder, ClassLoader classLoader) throws OpenEJBException {
            if (SystemInstance.get().hasProperty("openejb.geronimo")) {
                return;
            }
            HashSet<String> processedClasses = new HashSet<String>();
            HashSet<String> handlerClasses = new HashSet<String>();
            do {
                handlerClasses.clear();
                for (ServiceRef serviceRef : consumer.getServiceRef()) {
                    HandlerChains chains = serviceRef.getAllHandlers();
                    if (chains == null) continue;
                    for (org.apache.openejb.jee.HandlerChain handlerChain : chains.getHandlerChain()) {
                        for (Handler handler : handlerChain.getHandler()) {
                            if (handler.getHandlerClass() == null) continue;
                            handlerClasses.add(AnnotationDeployer.realClassName(handler.getHandlerClass()));
                        }
                    }
                }
                handlerClasses.removeAll(processedClasses);
                if (handlerClasses.isEmpty()) continue;
                FinderFactory.OpenEJBAnnotationFinder handlerAnnotationFinder = finder != null ? finder.select(handlerClasses) : new FinderFactory.OpenEJBAnnotationFinder((Archive)new FinderFactory.DoLoadClassesArchive(classLoader, handlerClasses));
                this.buildAnnotatedRefs(consumer, (IAnnotationFinder)handlerAnnotationFinder, classLoader);
                processedClasses.addAll(handlerClasses);
            } while (!handlerClasses.isEmpty());
        }

        private List<String> getDeclaredClassPermissions(AssemblyDescriptor assemblyDescriptor, String ejbName) {
            List permissions = assemblyDescriptor.getMethodPermission();
            ArrayList<String> classPermissions = new ArrayList<String>();
            for (MethodPermission permission : permissions) {
                for (Method method : permission.getMethod()) {
                    if (!method.getEjbName().equals(ejbName) || !"*".equals(method.getMethodName())) continue;
                    String className = method.getClassName();
                    if (className == null) {
                        className = "*";
                    }
                    classPermissions.add(className);
                }
            }
            return classPermissions;
        }

        private <A extends Annotation> void checkAttributes(AnnotationHandler<A> handler, String ejbName, EjbModule ejbModule, AnnotationFinder annotationFinder, String messageKey) {
            Map<String, List<MethodAttribute>> existingDeclarations = handler.getExistingDeclarations();
            int xml = 0;
            for (List<MethodAttribute> methodAttributes : existingDeclarations.values()) {
                xml += methodAttributes.size();
            }
            if (xml > 0) {
                ejbModule.getValidation().warn(ejbName, "xml." + messageKey, xml);
            }
            int ann = annotationFinder.findAnnotatedClasses(handler.getAnnotationClass()).size();
            if ((ann += annotationFinder.findAnnotatedMethods(handler.getAnnotationClass()).size()) > 0) {
                ejbModule.getValidation().warn(ejbName, "ann." + messageKey, ann);
            }
        }

        private <A extends Annotation> void processAttributes(AnnotationHandler<A> handler, Class<?> clazz, AnnotationFinder annotationFinder) {
            Map<String, List<MethodAttribute>> existingDeclarations = handler.getExistingDeclarations();
            Class<A> annotationClass = handler.getAnnotationClass();
            List<Annotated<Class<?>>> types = AnnotationDeployer.sortClasses(annotationFinder.findMetaAnnotatedClasses(annotationClass));
            if (!this.hasMethodAttribute("*", null, existingDeclarations)) {
                for (Annotated<Class<?>> type : types) {
                    Annotation attribute;
                    if (!((Class)type.get()).isAssignableFrom(clazz) || this.hasMethodAttribute("*", (Class)type.get(), existingDeclarations) || (attribute = type.getAnnotation(annotationClass)) == null) continue;
                    handler.addClassLevelDeclaration(attribute, (Class)type.get());
                }
            }
            List methods = annotationFinder.findMetaAnnotatedMethods(annotationClass);
            for (Annotated method : methods) {
                Annotation attribute = method.getAnnotation(annotationClass);
                if (!existingDeclarations.containsKey(((java.lang.reflect.Method)method.get()).getName())) {
                    handler.addMethodLevelDeclaration(attribute, (java.lang.reflect.Method)method.get());
                    continue;
                }
                List<MethodAttribute> list = existingDeclarations.get(((java.lang.reflect.Method)method.get()).getName());
                block2: for (MethodAttribute mtx : list) {
                    MethodParams methodParams = mtx.getMethodParams();
                    if (methodParams == null) {
                        handler.addMethodLevelDeclaration(attribute, (java.lang.reflect.Method)method.get());
                        continue;
                    }
                    List params1 = methodParams.getMethodParam();
                    String[] params2 = this.asStrings(((java.lang.reflect.Method)method.get()).getParameterTypes());
                    if (params1.size() != params2.length) {
                        handler.addMethodLevelDeclaration(attribute, (java.lang.reflect.Method)method.get());
                        continue;
                    }
                    for (int i = 0; i < params1.size(); ++i) {
                        String b;
                        String a = (String)params1.get(i);
                        if (a.equals(b = params2[i])) continue;
                        handler.addMethodLevelDeclaration(attribute, (java.lang.reflect.Method)method.get());
                        continue block2;
                    }
                }
            }
        }

        private boolean hasMethodAttribute(String methodName, Class clazz, Map<String, List<MethodAttribute>> map) {
            return this.getMethodAttribute(methodName, clazz, map) != null;
        }

        private MethodAttribute getMethodAttribute(String methodName, Class clazz, Map<String, List<MethodAttribute>> map) {
            List<MethodAttribute> methodAttributes = map.get(methodName);
            if (methodAttributes == null) {
                return null;
            }
            Iterator<MethodAttribute> iterator = methodAttributes.iterator();
            while (iterator.hasNext()) {
                MethodAttribute methodAttribute;
                String className = clazz != null ? clazz.getName() : "null";
                if (!className.equals((methodAttribute = iterator.next()).getClassName())) continue;
                return methodAttribute;
            }
            return null;
        }

        private <A extends Annotation> A getInheritableAnnotation(Class clazz, Class<A> annotationClass) {
            if (clazz == null || clazz.equals(Object.class)) {
                return null;
            }
            MetaAnnotatedClass meta = new MetaAnnotatedClass(clazz);
            Annotation annotation = meta.getAnnotation(annotationClass);
            if (annotation != null) {
                return (A)annotation;
            }
            return this.getInheritableAnnotation(clazz.getSuperclass(), annotationClass);
        }

        private AnnotationFinder createFinder(Class<?> ... classes) {
            HashSet parents = new HashSet();
            for (Class<?> clazz : classes) {
                parents.addAll(Classes.ancestors(clazz));
            }
            return new AnnotationFinder((Archive)new ClassesArchive(parents)).enableMetaAnnotations();
        }

        private String[] asStrings(Class[] types) {
            ArrayList<String> names = new ArrayList<String>();
            for (Class clazz : types) {
                names.add(clazz.getName());
            }
            return names.toArray(new String[names.size()]);
        }

        private <T> T getFirst(List<T> list) {
            if (list.size() > 0) {
                return list.get(0);
            }
            return null;
        }

        private boolean validateRemoteInterface(Class interfce, ValidationContext validation, String ejbName) {
            return this.isValidInterface(interfce, validation, ejbName, "Remote");
        }

        private boolean validateLocalInterface(Class interfce, ValidationContext validation, String ejbName) {
            return this.isValidInterface(interfce, validation, ejbName, "Local");
        }

        private boolean isValidInterface(Class interfce, ValidationContext validation, String ejbName, String annotationName) {
            if (!interfce.isInterface()) {
                validation.fail(ejbName, "ann.notAnInterface", annotationName, interfce.getName());
                return false;
            }
            if (EJBHome.class.isAssignableFrom(interfce)) {
                validation.fail(ejbName, "ann.remoteOrLocal.ejbHome", annotationName, interfce.getName());
                return false;
            }
            if (EJBObject.class.isAssignableFrom(interfce)) {
                validation.fail(ejbName, "ann.remoteOrLocal.ejbObject", annotationName, interfce.getName());
                return false;
            }
            if (EJBLocalHome.class.isAssignableFrom(interfce)) {
                validation.fail(ejbName, "ann.remoteOrLocal.ejbLocalHome", annotationName, interfce.getName());
                return false;
            }
            if (EJBLocalObject.class.isAssignableFrom(interfce)) {
                validation.fail(ejbName, "ann.remoteOrLocal.ejbLocalObject", annotationName, interfce.getName());
                return false;
            }
            return true;
        }

        public static class TransactionAttributeHandler
        implements AnnotationHandler<TransactionAttribute> {
            private final AssemblyDescriptor assemblyDescriptor;
            private final String ejbName;

            public TransactionAttributeHandler(AssemblyDescriptor assemblyDescriptor, String ejbName) {
                this.assemblyDescriptor = assemblyDescriptor;
                this.ejbName = ejbName;
            }

            @Override
            public Map<String, List<MethodAttribute>> getExistingDeclarations() {
                return this.assemblyDescriptor.getMethodTransactionMap(this.ejbName);
            }

            @Override
            public void addClassLevelDeclaration(TransactionAttribute attribute, Class type) {
                ContainerTransaction ctx = new ContainerTransaction(this.cast(attribute.value()), type.getName(), this.ejbName, "*");
                this.assemblyDescriptor.getContainerTransaction().add(ctx);
            }

            @Override
            public void addMethodLevelDeclaration(TransactionAttribute attribute, java.lang.reflect.Method method) {
                ContainerTransaction ctx = new ContainerTransaction(this.cast(attribute.value()), this.ejbName, method);
                this.assemblyDescriptor.getContainerTransaction().add(ctx);
            }

            @Override
            public Class<TransactionAttribute> getAnnotationClass() {
                return TransactionAttribute.class;
            }

            private TransAttribute cast(TransactionAttributeType transactionAttributeType) {
                return TransAttribute.valueOf((String)transactionAttributeType.toString());
            }
        }

        public static interface AnnotationHandler<A extends Annotation> {
            public Class<A> getAnnotationClass();

            public Map<String, List<MethodAttribute>> getExistingDeclarations();

            public void addClassLevelDeclaration(A var1, Class var2);

            public void addMethodLevelDeclaration(A var1, java.lang.reflect.Method var2);
        }

        public static class LockHandler
        extends ConcurrentMethodHandler
        implements AnnotationHandler<Lock> {
            public LockHandler(AssemblyDescriptor assemblyDescriptor, SessionBean bean) {
                this(assemblyDescriptor, bean, new HashMap<Object, ContainerConcurrency>());
            }

            public LockHandler(AssemblyDescriptor assemblyDescriptor, SessionBean bean, Map<Object, ContainerConcurrency> methods) {
                super(assemblyDescriptor, bean, methods);
            }

            @Override
            public void addClassLevelDeclaration(Lock attribute, Class type) {
                ContainerConcurrency concurrency = this.getContainerConcurrency(type);
                concurrency.setLock(this.toLock(attribute));
            }

            @Override
            public void addMethodLevelDeclaration(Lock attribute, java.lang.reflect.Method method) {
                ContainerConcurrency concurrency = this.getContainerConcurrency(method);
                concurrency.setLock(this.toLock(attribute));
            }

            private ConcurrentLockType toLock(Lock annotation) {
                if (LockType.READ.equals((Object)annotation.value())) {
                    return ConcurrentLockType.READ;
                }
                if (LockType.WRITE.equals((Object)annotation.value())) {
                    return ConcurrentLockType.WRITE;
                }
                throw new IllegalArgumentException("Unknown lock annotation: " + String.valueOf(annotation.value()));
            }

            @Override
            public Class<Lock> getAnnotationClass() {
                return Lock.class;
            }
        }

        public static class AccessTimeoutHandler
        extends ConcurrentMethodHandler
        implements AnnotationHandler<AccessTimeout> {
            public AccessTimeoutHandler(AssemblyDescriptor assemblyDescriptor, SessionBean bean) {
                this(assemblyDescriptor, bean, new HashMap<Object, ContainerConcurrency>());
            }

            public AccessTimeoutHandler(AssemblyDescriptor assemblyDescriptor, SessionBean bean, Map<Object, ContainerConcurrency> methods) {
                super(assemblyDescriptor, bean, methods);
            }

            @Override
            public void addClassLevelDeclaration(AccessTimeout attribute, Class type) {
                ContainerConcurrency concurrency = this.getContainerConcurrency(type);
                concurrency.setAccessTimeout(this.toTimeout(attribute));
            }

            @Override
            public void addMethodLevelDeclaration(AccessTimeout attribute, java.lang.reflect.Method method) {
                ContainerConcurrency concurrency = this.getContainerConcurrency(method);
                concurrency.setAccessTimeout(this.toTimeout(attribute));
            }

            private Timeout toTimeout(AccessTimeout annotation) {
                Timeout timeout = new Timeout();
                timeout.setTimeout(annotation.value());
                timeout.setUnit(annotation.unit());
                return timeout;
            }

            @Override
            public Class<AccessTimeout> getAnnotationClass() {
                return AccessTimeout.class;
            }
        }

        private static class BusinessInterfaces {
            private final Set<Class> local = new LinkedHashSet<Class>();
            private final Set<Class> remote = new LinkedHashSet<Class>();

            private BusinessInterfaces() {
            }

            public void addLocals(Collection<String> names, ClassLoader loader) {
                this.add(loader, names, this.local);
            }

            public void addRemotes(Collection<String> names, ClassLoader loader) {
                this.add(loader, names, this.remote);
            }

            private void add(ClassLoader loader, Collection<String> names, Set<Class> classes) {
                for (String className : names) {
                    try {
                        classes.add(loader.loadClass(AnnotationDeployer.realClassName(className)));
                    }
                    catch (Throwable throwable) {}
                }
            }
        }

        private static class ConcurrentMethodHandler {
            protected final AssemblyDescriptor assemblyDescriptor;
            protected final SessionBean bean;
            protected final Map<Object, ContainerConcurrency> methods;

            public ConcurrentMethodHandler(AssemblyDescriptor assemblyDescriptor, SessionBean bean, Map<Object, ContainerConcurrency> methods) {
                this.assemblyDescriptor = assemblyDescriptor;
                this.bean = bean;
                this.methods = methods;
            }

            public Map<String, List<MethodAttribute>> getExistingDeclarations() {
                HashMap<String, List<MethodAttribute>> declarations = new HashMap<String, List<MethodAttribute>>();
                List methods = this.bean.getConcurrentMethod();
                for (ConcurrentMethod method : methods) {
                    List list = declarations.computeIfAbsent(method.getMethod().getMethodName(), k -> new ArrayList());
                    list.add(new MethodAttribute(null, this.bean.getEjbName(), method.getMethod()));
                }
                return declarations;
            }

            public ContainerConcurrency getContainerConcurrency(java.lang.reflect.Method method) {
                ContainerConcurrency concurrency = this.methods.get(method);
                if (concurrency == null) {
                    concurrency = new ContainerConcurrency(null, this.bean.getEjbName(), method);
                    this.methods.put(method, concurrency);
                    this.assemblyDescriptor.getContainerConcurrency().add(concurrency);
                }
                return concurrency;
            }

            public ContainerConcurrency getContainerConcurrency(Class clazz) {
                ContainerConcurrency concurrency = this.methods.get(clazz);
                if (concurrency == null) {
                    concurrency = new ContainerConcurrency(null, clazz.getName(), this.bean.getEjbName(), "*");
                    this.methods.put(clazz, concurrency);
                    this.assemblyDescriptor.getContainerConcurrency().add(concurrency);
                }
                return concurrency;
            }

            protected Map<Object, ContainerConcurrency> getContainerConcurrency() {
                return this.methods;
            }
        }
    }

    public static class FieldMember
    implements Member {
        private final Field field;

        public FieldMember(Field field) {
            this.field = field;
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        public String toString() {
            return this.field.toString();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.field.getDeclaringClass();
        }

        @Override
        public String getName() {
            return this.field.getName();
        }
    }

    public static interface FolderDDMapper {
        public File getDDFolder(File var1);
    }

    public static class ProvidedJAXRSApplication
    extends Application {
    }

    public static class MethodMember
    implements Member {
        private final java.lang.reflect.Method setter;

        public MethodMember(java.lang.reflect.Method method) {
            this.setter = method;
        }

        @Override
        public Class<?> getType() {
            return this.setter.getParameterTypes()[0];
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.setter.getDeclaringClass();
        }

        @Override
        public String getName() {
            StringBuilder name = new StringBuilder(this.setter.getName());
            name.delete(0, 3);
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            return name.toString();
        }

        public String toString() {
            return this.setter.toString();
        }
    }

    public static class FilledMember
    implements Member {
        private final String name;
        private final Class<?> type;
        private final Class<?> declaringClass;

        public FilledMember(String name, Class<?> type, Class<?> declaringClass) {
            this.name = name;
            this.type = type;
            this.declaringClass = declaringClass;
        }

        public Class getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Class getType() {
            return this.type;
        }

        public String toString() {
            return "FilledMember{name='" + this.name + "', type=" + this.type.getName() + ", declaringClass=" + this.declaringClass.getName() + "}";
        }
    }

    public static interface Member {
        public Class<?> getDeclaringClass();

        public String getName();

        public Class<?> getType();
    }
}

