/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.security.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.ChannelBindingsContext;
import org.opensaml.saml.ext.saml2cb.ChannelBindings;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.slf4j.Logger;

public class ExtractChannelBindingsExtensionsHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractChannelBindingsExtensionsHandler.class);

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext) || messageContext.getMessage() == null) {
            return false;
        }
        if (!SAMLBindingSupport.isMessageSigned((MessageContext)messageContext)) {
            this.log.debug("Message was not signed, cannot extract ChannelBindings from it");
            return false;
        }
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        List bindings;
        Extensions extensions = null;
        Object object = messageContext.getMessage();
        if (object instanceof RequestAbstractType) {
            RequestAbstractType req = (RequestAbstractType)object;
            extensions = req.getExtensions();
        } else {
            object = messageContext.getMessage();
            if (object instanceof StatusResponseType) {
                StatusResponseType resp = (StatusResponseType)object;
                extensions = resp.getExtensions();
            } else {
                this.log.debug("{} Message was not of a supported type", (Object)this.getLogPrefix());
                return;
            }
        }
        List list = bindings = extensions != null ? extensions.getUnknownXMLObjects(ChannelBindings.DEFAULT_ELEMENT_NAME) : CollectionSupport.emptyList();
        if (bindings.isEmpty()) {
            this.log.debug("{} Message did not contain any ChannelBindings extensions", (Object)this.getLogPrefix());
            return;
        }
        Collection channelBindings = ((ChannelBindingsContext)messageContext.ensureSubcontext(ChannelBindingsContext.class)).getChannelBindings();
        for (XMLObject cb : bindings) {
            if (!(cb instanceof ChannelBindings)) continue;
            ChannelBindings downcast = (ChannelBindings)cb;
            channelBindings.add(downcast);
        }
        this.log.debug("{} {} ChannelBindings extension(s) found", (Object)this.getLogPrefix(), (Object)channelBindings.size());
    }
}

