/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.criterion;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.xmlsec.SignatureValidationConfiguration;

public class SignatureValidationConfigurationCriterion
implements Criterion {
    @Nonnull
    private List<SignatureValidationConfiguration> configs;

    public SignatureValidationConfigurationCriterion(@Nonnull @NotEmpty List<SignatureValidationConfiguration> configurations) {
        this.configs = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(configurations, (String)"List of configurations cannot be null")));
        Constraint.isNotEmpty(this.configs, (String)"At least one configuration is required");
    }

    public SignatureValidationConfigurationCriterion(SignatureValidationConfiguration ... configurations) {
        this.configs = CollectionSupport.listOf((Object[])((SignatureValidationConfiguration[])Constraint.isNotNull((Object)configurations, (String)"List of configurations cannot be null")));
        Constraint.isNotEmpty(this.configs, (String)"At least one configuration is required");
    }

    @Nonnull
    @NotEmpty
    @NotLive
    @Unmodifiable
    public List<SignatureValidationConfiguration> getConfigurations() {
        return this.configs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SignatureValidationConfigurationCriterion [configs=");
        builder.append(this.configs);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.configs.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SignatureValidationConfigurationCriterion) {
            SignatureValidationConfigurationCriterion other = (SignatureValidationConfigurationCriterion)obj;
            return this.configs.equals(other.getConfigurations());
        }
        return false;
    }
}

