/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.circuit.breaker;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerLogger;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;

public class CompletionStageCircuitBreaker<V>
extends CircuitBreaker<CompletionStage<V>> {
    public CompletionStageCircuitBreaker(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, ExceptionDecision exceptionDecision, long delayInMillis, int requestVolumeThreshold, double failureRatio, int successThreshold, Stopwatch stopwatch, Timer timer) {
        super(delegate, description, exceptionDecision, delayInMillis, requestVolumeThreshold, failureRatio, successThreshold, stopwatch, timer);
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) throws Exception {
        CircuitBreakerLogger.LOG.trace("CompletionStageCircuitBreaker started");
        try {
            CompletionStage<V> completionStage = this.doApply(ctx);
            return completionStage;
        }
        finally {
            CircuitBreakerLogger.LOG.trace("CompletionStageCircuitBreaker finished");
        }
    }

    private CompletionStage<V> doApply(InvocationContext<CompletionStage<V>> ctx) throws Exception {
        CircuitBreaker.State currentState = (CircuitBreaker.State)this.state.get();
        switch (currentState.id) {
            case 0: {
                return this.inClosed(ctx, currentState);
            }
            case 1: {
                return this.inOpen(ctx, currentState);
            }
            case 2: {
                return this.inHalfOpen(ctx, currentState);
            }
        }
        throw new AssertionError((Object)("Invalid circuit breaker state: " + currentState.id));
    }

    private CompletionStage<V> inClosed(InvocationContext<CompletionStage<V>> ctx, CircuitBreaker.State state) {
        try {
            CircuitBreakerLogger.LOG.trace("Circuit breaker closed, invocation allowed");
            CompletableFuture result = new CompletableFuture();
            this.delegate.apply(ctx).whenComplete((value, error) -> {
                if (error != null) {
                    this.inClosedHandleResult(this.isConsideredSuccess((Throwable)error), ctx, state);
                    result.completeExceptionally((Throwable)error);
                } else {
                    this.inClosedHandleResult(true, ctx, state);
                    result.complete(value);
                }
            });
            return result;
        }
        catch (Throwable e) {
            this.inClosedHandleResult(this.isConsideredSuccess(e), ctx, state);
            return CompletableFuture.failedFuture(e);
        }
    }

    private CompletionStage<V> inOpen(InvocationContext<CompletionStage<V>> ctx, CircuitBreaker.State state) throws Exception {
        if (state.runningStopwatch.elapsedTimeInMillis() < this.delayInMillis) {
            CircuitBreakerLogger.LOG.debugOrTrace(this.description + " invocation prevented by circuit breaker", "Circuit breaker open, invocation prevented");
            ctx.fireEvent(CircuitBreakerEvents.Finished.PREVENTED);
            return CompletableFuture.failedFuture((Throwable)new CircuitBreakerOpenException(this.description + " circuit breaker is open"));
        }
        CircuitBreakerLogger.LOG.trace("Delay elapsed synchronously, circuit breaker moving to half-open");
        this.toHalfOpen(ctx, state);
        return this.doApply(ctx);
    }

    private CompletionStage<V> inHalfOpen(InvocationContext<CompletionStage<V>> ctx, CircuitBreaker.State state) {
        if (state.probeAttempts.incrementAndGet() > this.successThreshold) {
            CircuitBreakerLogger.LOG.debugOrTrace(this.description + " invocation prevented by circuit breaker", "Circuit breaker half-open, invocation prevented");
            ctx.fireEvent(CircuitBreakerEvents.Finished.PREVENTED);
            return CompletableFuture.failedFuture((Throwable)new CircuitBreakerOpenException(this.description + " circuit breaker is half-open"));
        }
        try {
            CircuitBreakerLogger.LOG.trace("Circuit breaker half-open, probe invocation allowed");
            CompletableFuture result = new CompletableFuture();
            this.delegate.apply(ctx).whenComplete((value, error) -> {
                if (error != null) {
                    this.inHalfOpenHandleResult(this.isConsideredSuccess((Throwable)error), ctx, state);
                    result.completeExceptionally((Throwable)error);
                } else {
                    this.inHalfOpenHandleResult(true, ctx, state);
                    result.complete(value);
                }
            });
            return result;
        }
        catch (Throwable e) {
            this.inHalfOpenHandleResult(this.isConsideredSuccess(e), ctx, state);
            return CompletableFuture.failedFuture(e);
        }
    }
}

