/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class FilteredInputStream
extends FilterInputStream {
    private boolean done = false;

    public FilteredInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        int count = 0;
        if (this.done) {
            return -1;
        }
        int max = off + len;
        for (int i = off; i < max; ++i) {
            int read = this.read();
            if (read == -1) {
                this.done = true;
                return count == 0 ? -1 : count;
            }
            bytes[i] = (byte)read;
            ++count;
        }
        return count;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

