/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.invocation;

import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public class AsyncSupportRegistry {
    private static final List<AsyncSupport<?, ?>> registry;

    private static ServiceLoader<AsyncSupport> load() {
        return ServiceLoader.load(AsyncSupport.class, AsyncSupport.class.getClassLoader());
    }

    public static boolean isKnown(Class<?>[] parameterTypes, Class<?> returnType) {
        for (AsyncSupport<?, ?> asyncSupport : registry) {
            if (!asyncSupport.applies(parameterTypes, returnType)) continue;
            return true;
        }
        return false;
    }

    public static <V, AT> AsyncSupport<V, AT> get(Class<?>[] parameterTypes, Class<?> returnType) {
        for (AsyncSupport<?, ?> asyncSupport : registry) {
            if (!asyncSupport.applies(parameterTypes, returnType)) continue;
            return asyncSupport;
        }
        return null;
    }

    public static Collection<AsyncSupport<?, ?>> allKnown() {
        return registry;
    }

    static {
        ArrayList<AsyncSupport> list = new ArrayList<AsyncSupport>();
        ServiceLoader<AsyncSupport> instances = System.getSecurityManager() != null ? AccessController.doPrivileged(AsyncSupportRegistry::load) : AsyncSupportRegistry.load();
        for (AsyncSupport instance : instances) {
            list.add(instance);
        }
        registry = Collections.unmodifiableList(list);
    }
}

