# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/executePipeline.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def executePipeline(pipeline: Frame,
                    Xtrain: Matrix,
                    Ytrain: Matrix,
                    Xtest: Matrix,
                    Ytest: Matrix,
                    metaList: List,
                    hyperParameters: Matrix,
                    flagsCount: int,
                    verbose: bool,
                    **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     This function execute pipeline.
    
    
    
    :param logical: ---
    :param pipeline: ---
    :param X: ---
    :param Y: ---
    :param Xtest: ---
    :param Ytest: ---
    :param metaList: ---
    :param hyperParameters: ---
    :param hpForPruning: ---
    :param changesByOp: ---
    :param flagsCount: ---
    :param test: ---
    :param verbose: ---
    :return: ---
    :return: ---
    :return: ---
    :return: ---
    :return: ---
    :return: ---
    :return: ---
    """

    params_dict = {'pipeline': pipeline, 'Xtrain': Xtrain, 'Ytrain': Ytrain, 'Xtest': Xtest, 'Ytest': Ytest, 'metaList': metaList, 'hyperParameters': hyperParameters, 'flagsCount': flagsCount, 'verbose': verbose}
    params_dict.update(kwargs)
    
    vX_0 = Matrix(pipeline.sds_context, '')
    vX_1 = Matrix(pipeline.sds_context, '')
    vX_2 = Matrix(pipeline.sds_context, '')
    vX_3 = Matrix(pipeline.sds_context, '')
    vX_4 = Scalar(pipeline.sds_context, '')
    vX_5 = Matrix(pipeline.sds_context, '')
    vX_6 = Matrix(pipeline.sds_context, '')
    vX_7 = Scalar(pipeline.sds_context, '')
    vX_8 = List(pipeline.sds_context, '')
    output_nodes = [vX_0, vX_1, vX_2, vX_3, vX_4, vX_5, vX_6, vX_7, vX_8, ]

    op = MultiReturn(pipeline.sds_context, 'executePipeline', output_nodes, named_input_nodes=params_dict)

    vX_0._unnamed_input_nodes = [op]
    vX_1._unnamed_input_nodes = [op]
    vX_2._unnamed_input_nodes = [op]
    vX_3._unnamed_input_nodes = [op]
    vX_4._unnamed_input_nodes = [op]
    vX_5._unnamed_input_nodes = [op]
    vX_6._unnamed_input_nodes = [op]
    vX_7._unnamed_input_nodes = [op]
    vX_8._unnamed_input_nodes = [op]

    return op
