/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops.compile.linearization;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.Lop;

public interface ILinearize {
    public static final Log LOG = LogFactory.getLog((String)ILinearize.class.getName());

    public static List<Lop> linearize(List<Lop> v) {
        try {
            DMLConfig dmlConfig = ConfigurationManager.getDMLConfig();
            DagLinearization linearization = DagLinearization.valueOf(dmlConfig.getTextValue("sysds.compile.linearization").toUpperCase());
            switch (linearization) {
                case MIN_INTERMEDIATE: {
                    return ILinearize.doMinIntermediateSort(v);
                }
                case BREADTH_FIRST: {
                    return ILinearize.doBreadthFirstSort(v);
                }
            }
            return ILinearize.depthFirst(v);
        }
        catch (Exception e) {
            LOG.warn((Object)"Invalid or failed DAG_LINEARIZATION, fallback to DEPTH_FIRST ordering");
            return ILinearize.depthFirst(v);
        }
    }

    private static List<Lop> depthFirst(List<Lop> v) {
        List<Lop> nodes = Stream.concat(v.stream().filter(l -> !l.getOutputs().isEmpty()).sorted(Comparator.comparing(l -> l.getID())), v.stream().filter(l -> l.getOutputs().isEmpty())).collect(Collectors.toList());
        return nodes;
    }

    private static List<Lop> doBreadthFirstSort(List<Lop> v) {
        List<Lop> nodes = v.stream().sorted(Comparator.comparing(Lop::getLevel)).collect(Collectors.toList());
        return nodes;
    }

    private static List<Lop> doMinIntermediateSort(List<Lop> v) {
        ArrayList<Lop> nodes = new ArrayList<Lop>(v.size());
        List<Lop> lowestLevel = v.stream().filter(l -> l.getOutputs().isEmpty()).collect(Collectors.toList());
        LinkedList<Lop> remaining = new LinkedList<Lop>(v);
        ILinearize.sortRecursive(nodes, lowestLevel, remaining);
        while (!remaining.isEmpty()) {
            int maxLevel = remaining.stream().mapToInt(Lop::getLevel).max().orElse(-1);
            List<Lop> lowestNodes = remaining.stream().filter(l -> l.getLevel() == maxLevel).collect(Collectors.toList());
            ILinearize.sortRecursive(nodes, lowestNodes, remaining);
        }
        Collections.reverse(nodes);
        return nodes;
    }

    private static void sortRecursive(List<Lop> result, List<Lop> input, List<Lop> remaining) {
        List memEst = input.stream().distinct().map(l -> new AbstractMap.SimpleEntry<Lop, Long>((Lop)l, l.getOutputs().isEmpty() ? 0L : OptimizerUtils.estimateSizeExactSparsity(l.getOutputParameters().getNumRows(), l.getOutputParameters().getNumCols(), l.getOutputParameters().getNnz()))).sorted(Comparator.comparing(e -> (Long)e.getValue())).collect(Collectors.toList());
        Collections.reverse(memEst);
        for (Map.Entry e2 : memEst) {
            if (result.contains(e2.getKey()) || !result.containsAll(((Lop)e2.getKey()).getOutputs()) && remaining.stream().anyMatch(l -> ((Lop)e2.getKey()).getOutputs().contains(l))) continue;
            result.add((Lop)e2.getKey());
            remaining.remove(e2.getKey());
            ILinearize.sortRecursive(result, ((Lop)e2.getKey()).getInputs(), remaining);
        }
    }

    public static enum DagLinearization {
        DEPTH_FIRST,
        BREADTH_FIRST,
        MIN_INTERMEDIATE;

    }
}

