/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class UnaryMatrixSPInstruction
extends UnarySPInstruction {
    protected UnaryMatrixSPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        super(SPInstruction.SPType.Unary, op, in, out, opcode, instr);
    }

    public static UnarySPInstruction parseInstruction(String str) {
        CPOperand in = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String opcode = UnaryMatrixSPInstruction.parseUnaryInstruction(str, in, out);
        return new UnaryMatrixSPInstruction(InstructionUtils.parseUnaryOperator(opcode), in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        UnaryOperator uop = (UnaryOperator)this._optr;
        JavaPairRDD out = in.mapValues((Function)new RDDMatrixBuiltinUnaryOp(uop));
        this.updateUnaryOutputDataCharacteristics(sec);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
    }

    private static class RDDMatrixBuiltinUnaryOp
    implements Function<MatrixBlock, MatrixBlock> {
        private static final long serialVersionUID = -3128192099832877491L;
        private UnaryOperator _op = null;

        public RDDMatrixBuiltinUnaryOp(UnaryOperator u_op) {
            this._op = u_op;
        }

        public MatrixBlock call(MatrixBlock arg0) throws Exception {
            return arg0.unaryOperations(this._op, new MatrixBlock());
        }
    }
}

