/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.CompressionStatistics;
import org.apache.sysds.runtime.compress.SingletonLookupHashMap;
import org.apache.sysds.runtime.compress.workload.WTreeRoot;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class CompressionCPInstruction
extends ComputationCPInstruction {
    private static final Log LOG = LogFactory.getLog((String)CompressionCPInstruction.class.getName());
    private final int _singletonLookupID;

    private CompressionCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr, int singletonLookupID) {
        super(CPInstruction.CPType.Compression, op, in, null, null, out, opcode, istr);
        this._singletonLookupID = singletonLookupID;
    }

    public static CompressionCPInstruction parseInstruction(String str) {
        InstructionUtils.checkNumFields(str, 2, 3);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        if (parts.length == 4) {
            int treeNodeID = Integer.parseInt(parts[3]);
            return new CompressionCPInstruction(null, in1, out, opcode, str, treeNodeID);
        }
        return new CompressionCPInstruction(null, in1, out, opcode, str, 0);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock in = ec.getMatrixInput(this.input1.getName());
        SingletonLookupHashMap m = SingletonLookupHashMap.getMap();
        WTreeRoot root = this._singletonLookupID != 0 ? (WTreeRoot)m.get(this._singletonLookupID) : null;
        m.removeKey(this._singletonLookupID);
        int k = OptimizerUtils.getConstrainedNumThreads(-1);
        Pair<MatrixBlock, CompressionStatistics> compResult = CompressedMatrixBlockFactory.compress(in, k, root);
        if (LOG.isTraceEnabled()) {
            LOG.trace(compResult.getRight());
        }
        MatrixBlock out = (MatrixBlock)compResult.getLeft();
        ec.releaseMatrixInput(this.input1.getName());
        ec.setMatrixOutput(this.output.getName(), out);
    }
}

