/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.functionobjects;

import org.apache.sysds.runtime.functionobjects.TernaryValueFunction;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;

public class MinusMultiply
extends TernaryValueFunction
implements TernaryValueFunction.ValueFunctionWithConstant {
    private static final long serialVersionUID = 2801982061205871665L;
    private static MinusMultiply singleObj = null;
    private final double _cnt;

    private MinusMultiply() {
        this._cnt = 1.0;
    }

    private MinusMultiply(double cnt) {
        this._cnt = cnt;
    }

    public double getConstant() {
        return this._cnt;
    }

    public static MinusMultiply getFnObject() {
        if (singleObj == null) {
            singleObj = new MinusMultiply();
        }
        return singleObj;
    }

    @Override
    public double execute(double in1, double in2, double in3) {
        return in1 - in2 * in3;
    }

    @Override
    public BinaryOperator setOp2Constant(double cnt) {
        return new BinaryOperator(new MinusMultiply(cnt));
    }

    @Override
    public double execute(double in1, double in2) {
        return in1 - this._cnt * in2;
    }
}

