/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.FunctionDictionary;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.DMLScriptException;
import org.apache.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;

public class Program {
    public static final String KEY_DELIM = "::";
    private DMLProgram _prog;
    private ArrayList<ProgramBlock> _programBlocks;
    private HashMap<String, FunctionDictionary<FunctionProgramBlock>> _namespaces = new HashMap();

    public Program() {
        this._namespaces.put(".defaultNS", new FunctionDictionary());
        this._programBlocks = new ArrayList();
    }

    public Program(DMLProgram prog) {
        this();
        this.setDMLProg(prog);
    }

    public void setDMLProg(DMLProgram prog) {
        this._prog = prog;
    }

    public DMLProgram getDMLProg() {
        return this._prog;
    }

    public synchronized void addFunctionProgramBlock(String fkey, FunctionProgramBlock fpb, boolean opt) {
        String[] parts = DMLProgram.splitFunctionKey(fkey);
        this.addFunctionProgramBlock(parts[0], parts[1], fpb, opt);
    }

    public synchronized void addFunctionProgramBlock(String namespace, String fname, FunctionProgramBlock fpb) {
        this.addFunctionProgramBlock(namespace, fname, fpb, true);
    }

    public synchronized void addFunctionProgramBlock(String namespace, String fname, FunctionProgramBlock fpb, boolean opt) {
        if (fpb == null) {
            throw new DMLRuntimeException("Invalid null function program block.");
        }
        FunctionDictionary<FunctionProgramBlock> dict = this._namespaces.get(namespace = Program.getSafeNamespace(namespace));
        if (dict == null) {
            dict = new FunctionDictionary();
            this._namespaces.put(namespace, dict);
        }
        dict.addFunction(fname, fpb, opt);
    }

    public synchronized void removeFunctionProgramBlock(String namespace, String fname) {
        namespace = Program.getSafeNamespace(namespace);
        FunctionDictionary<FunctionProgramBlock> dict = null;
        if (this._namespaces.containsKey(namespace) && (dict = this._namespaces.get(namespace)).containsFunction(fname)) {
            dict.removeFunction(fname);
        }
    }

    public HashMap<String, FunctionProgramBlock> getFunctionProgramBlocks() {
        return this.getFunctionProgramBlocks(true);
    }

    public synchronized HashMap<String, FunctionProgramBlock> getFunctionProgramBlocks(boolean opt) {
        HashMap<String, FunctionProgramBlock> retVal = new HashMap<String, FunctionProgramBlock>();
        for (Map.Entry<String, FunctionDictionary<FunctionProgramBlock>> namespace : this._namespaces.entrySet()) {
            if (namespace.getValue().getFunctions(opt) == null) continue;
            for (Map.Entry<String, FunctionProgramBlock> e2 : namespace.getValue().getFunctions(opt).entrySet()) {
                String fKey = DMLProgram.constructFunctionKey(namespace.getKey(), e2.getKey());
                retVal.put(fKey, e2.getValue());
            }
        }
        return retVal;
    }

    public synchronized boolean containsFunctionProgramBlock(String namespace, String fname) {
        return this._namespaces.containsKey(namespace = Program.getSafeNamespace(namespace)) && this._namespaces.get(namespace).containsFunction(fname);
    }

    public synchronized boolean containsFunctionProgramBlock(String fkey, boolean opt) {
        String[] parts = DMLProgram.splitFunctionKey(fkey);
        return this.containsFunctionProgramBlock(parts[0], parts[1], opt);
    }

    public synchronized boolean containsFunctionProgramBlock(String namespace, String fname, boolean opt) {
        return this._namespaces.containsKey(namespace = Program.getSafeNamespace(namespace)) && this._namespaces.get(namespace).containsFunction(fname, opt);
    }

    public synchronized FunctionProgramBlock getFunctionProgramBlock(String namespace, String fname) {
        return this.getFunctionProgramBlock(namespace, fname, true);
    }

    public synchronized FunctionProgramBlock getFunctionProgramBlock(String fkey, boolean opt) {
        String[] parts = DMLProgram.splitFunctionKey(fkey);
        return this.getFunctionProgramBlock(parts[0], parts[1], opt);
    }

    public synchronized FunctionProgramBlock getFunctionProgramBlock(String namespace, String fname, boolean opt) {
        FunctionDictionary<FunctionProgramBlock> dict = this._namespaces.get(namespace = Program.getSafeNamespace(namespace));
        if (dict == null) {
            throw new DMLRuntimeException("namespace " + namespace + " is undefined.");
        }
        FunctionProgramBlock retVal = dict.getFunction(fname, opt);
        if (retVal == null) {
            throw new DMLRuntimeException("function " + fname + " (" + opt + ") is undefined in namespace " + namespace);
        }
        return retVal;
    }

    public void addProgramBlock(ProgramBlock pb) {
        this._programBlocks.add(pb);
    }

    public ArrayList<ProgramBlock> getProgramBlocks() {
        return this._programBlocks;
    }

    public void execute(ExecutionContext ec) {
        try {
            for (int i = 0; i < this._programBlocks.size(); ++i) {
                this._programBlocks.get(i).execute(ec);
            }
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    public Program clone(boolean deep) {
        if (deep) {
            throw new NotImplementedException();
        }
        Program ret = new Program(this._prog);
        ret._programBlocks.addAll(this._programBlocks);
        for (Map.Entry<String, FunctionDictionary<FunctionProgramBlock>> e1 : this._namespaces.entrySet()) {
            for (Map.Entry<String, FunctionProgramBlock> e2 : e1.getValue().getFunctions().entrySet()) {
                ret.addFunctionProgramBlock(e1.getKey(), e2.getKey(), e2.getValue());
            }
        }
        return ret;
    }

    public Object clone() {
        return this.clone(true);
    }

    private static String getSafeNamespace(String namespace) {
        return namespace == null ? ".defaultNS" : namespace;
    }
}

