/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Divide;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.utils.MemoryEstimates;

public class QDictionary
extends ADictionary {
    private static final long serialVersionUID = 2100501253343438897L;
    protected double _scale;
    protected byte[] _values;

    protected QDictionary(byte[] values, double scale) {
        this._values = values;
        this._scale = scale;
    }

    @Override
    public double[] getValues() {
        if (this._values == null) {
            return new double[0];
        }
        double[] res = new double[this._values.length];
        for (int i = 0; i < this._values.length; ++i) {
            res[i] = this.getValue(i);
        }
        return res;
    }

    @Override
    public double getValue(int i) {
        return i >= this.size() ? 0.0 : (double)this._values[i] * this._scale;
    }

    public byte getValueByte(int i) {
        return this._values[i];
    }

    public byte[] getValuesByte() {
        return this._values;
    }

    public double getScale() {
        return this._scale;
    }

    @Override
    public long getInMemorySize() {
        return QDictionary.getInMemorySize(this.size());
    }

    public static long getInMemorySize(int valuesCount) {
        return 16L + MemoryEstimates.byteArrayCost(valuesCount) + 8L;
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        int len = this.size();
        double ret = init;
        for (int i = 0; i < len; ++i) {
            ret = fn.execute(ret, this.getValue(i));
        }
        return ret;
    }

    @Override
    public double[] aggregateTuples(Builtin fn, int nCol) {
        if (nCol == 1) {
            return this.getValues();
        }
        int nRows = this._values.length / nCol;
        double[] res = new double[nRows];
        for (int i = 0; i < nRows; ++i) {
            int off = i * nCol;
            res[i] = this._values[off];
            for (int j = off + 1; j < off + nCol; ++j) {
                res[i] = fn.execute(res[i], (double)this._values[j] * this._scale);
            }
        }
        return res;
    }

    @Override
    public QDictionary apply(ScalarOperator op) {
        if (this._values == null) {
            return this;
        }
        if (op.fn instanceof Multiply || op.fn instanceof Divide) {
            this._scale = op.executeScalar(this._scale);
            return this;
        }
        if (op.fn instanceof Plus) {
            double max = Math.max(Math.abs(op.executeScalar(-127.0 * this._scale)), Math.abs(op.executeScalar(127.0 * this._scale)));
            double oldScale = this._scale;
            this._scale = max / 127.0;
            for (int i = 0; i < this._values.length; ++i) {
                this._values[i] = (byte)Math.round(op.executeScalar((double)this._values[i] * oldScale) / this._scale);
            }
        } else {
            int i;
            double[] temp = new double[this._values.length];
            double max = Math.abs(op.executeScalar(this.getValue(0)));
            for (i = 0; i < this._values.length; ++i) {
                temp[i] = op.executeScalar(this.getValue(i));
                double absTemp = Math.abs(temp[i]);
                if (!(absTemp > max)) continue;
                max = absTemp;
            }
            this._scale = max / 127.0;
            for (i = 0; i < this._values.length; ++i) {
                this._values[i] = (byte)Math.round(temp[i] / this._scale);
            }
        }
        return this;
    }

    @Override
    public QDictionary applyScalarOp(ScalarOperator op, double newVal, int numCols) {
        double[] temp = this.getValues();
        double max = Math.abs(newVal);
        for (int i = 0; i < this.size(); ++i) {
            temp[i] = op.executeScalar(temp[i]);
            double absTemp = Math.abs(temp[i]);
            if (!(absTemp > max)) continue;
            max = absTemp;
        }
        double scale = max / 127.0;
        byte[] res = new byte[this.size() + numCols];
        for (int i = 0; i < this.size(); ++i) {
            res[i] = (byte)Math.round(temp[i] / scale);
        }
        Arrays.fill(res, this.size(), this.size() + numCols, (byte)Math.round(newVal / scale));
        return new QDictionary(res, scale);
    }

    @Override
    public QDictionary applyBinaryRowOpRight(BinaryOperator op, double[] v, boolean sparseSafe, int[] colIndexes) {
        double absTemp;
        int i;
        ValueFunction fn = op.fn;
        if (this._values == null) {
            if (sparseSafe) {
                return new QDictionary(null, 1.0);
            }
            this._values = new byte[0];
        }
        double[] temp = sparseSafe ? new double[this._values.length] : new double[this._values.length + colIndexes.length];
        double max = Math.abs(fn.execute(0.0, v[0]));
        int colL = colIndexes.length;
        for (i = 0; i < this.size(); ++i) {
            temp[i] = fn.execute((double)this._values[i] * this._scale, v[colIndexes[i % colL]]);
            absTemp = Math.abs(temp[i]);
            if (!(absTemp > max)) continue;
            max = absTemp;
        }
        if (!sparseSafe) {
            while (i < this.size() + colL) {
                temp[i] = fn.execute(0.0, v[colIndexes[i % colL]]);
                absTemp = Math.abs(temp[i]);
                if (absTemp > max) {
                    max = absTemp;
                }
                ++i;
            }
        }
        double scale = max / 127.0;
        byte[] res = sparseSafe ? this._values : new byte[this.size() + colIndexes.length];
        for (i = 0; i < temp.length; ++i) {
            res[i] = (byte)Math.round(temp[i] / scale);
        }
        return new QDictionary(res, scale);
    }

    @Override
    public QDictionary applyBinaryRowOpLeft(BinaryOperator op, double[] v, boolean sparseSafe, int[] colIndexes) {
        throw new NotImplementedException("Not Implemented yet");
    }

    private int size() {
        return this._values.length;
    }

    @Override
    public QDictionary clone() {
        return new QDictionary((byte[])this._values.clone(), this._scale);
    }

    @Override
    public QDictionary cloneAndExtend(int len) {
        byte[] ret = Arrays.copyOf(this._values, this._values.length + len);
        return new QDictionary(ret, this._scale);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.INT8_DICT.ordinal());
        out.writeDouble(this._scale);
        out.writeInt(this._values.length);
        for (int i = 0; i < this._values.length; ++i) {
            out.writeByte(this._values[i]);
        }
    }

    public static QDictionary read(DataInput in) throws IOException {
        double scale = in.readDouble();
        int numVals = in.readInt();
        byte[] values = new byte[numVals];
        for (int i = 0; i < numVals; ++i) {
            values[i] = in.readByte();
        }
        return new QDictionary(values, scale);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 13 + this.size();
    }

    @Override
    public int getNumberOfValues(int nCol) {
        return this._values == null ? 0 : this._values.length / nCol;
    }

    @Override
    public double[] sumAllRowsToDouble(boolean square, int nrColumns) {
        if (nrColumns == 1 && !square) {
            return this.getValues();
        }
        int numVals = this.getNumberOfValues(nrColumns);
        double[] ret = new double[numVals];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRow(k, square, nrColumns);
        }
        return ret;
    }

    @Override
    public double sumRow(int k, boolean square, int nrColumns) {
        if (this._values == null) {
            return 0.0;
        }
        int valOff = k * nrColumns;
        if (!square) {
            int res = 0;
            for (int i = 0; i < nrColumns; ++i) {
                res += this._values[valOff + i];
            }
            return (double)res * this._scale;
        }
        double res = 0.0;
        for (int i = 0; i < nrColumns; ++i) {
            res += (double)(this._values[valOff + i] * this._values[valOff + i]) * this._scale * this._scale;
        }
        return res;
    }

    @Override
    public double[] colSum(int[] counts, int nCol) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public void colSum(double[] c, int[] counts, int[] colIndexes, boolean square) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public double sum(int[] counts, int ncol) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public double sumsq(int[] counts, int ncol) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public void addMaxAndMin(double[] ret, int[] colIndexes) {
        int i;
        byte[] mins = new byte[colIndexes.length];
        byte[] maxs = new byte[colIndexes.length];
        for (i = 0; i < colIndexes.length; ++i) {
            mins[i] = this._values[i];
            maxs[i] = this._values[i];
        }
        for (i = colIndexes.length; i < this._values.length; ++i) {
            int idx = i % colIndexes.length;
            mins[idx] = (byte)Math.min(this._values[i], mins[idx]);
            maxs[idx] = (byte)Math.max(this._values[i], maxs[idx]);
        }
        for (i = 0; i < colIndexes.length; ++i) {
            int idy;
            int n = idy = colIndexes[i] * 2;
            ret[n] = ret[n] + (double)mins[i] * this._scale;
            int n2 = idy + 1;
            ret[n2] = ret[n2] + (double)maxs[i] * this._scale;
        }
    }

    @Override
    public String getString(int colIndexes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this._values[i]);
            sb.append(i % colIndexes == colIndexes - 1 ? "\n" : " ");
        }
        return sb.toString();
    }

    public Dictionary makeDoubleDictionary() {
        double[] doubleValues = this.getValues();
        return new Dictionary(doubleValues);
    }

    @Override
    public ADictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        int numberTuples = this.getNumberOfValues(previousNumberOfColumns);
        int tupleLengthAfter = idxEnd - idxStart;
        byte[] newDictValues = new byte[tupleLengthAfter * numberTuples];
        int orgOffset = idxStart;
        int targetOffset = 0;
        for (int v = 0; v < numberTuples; ++v) {
            int c = 0;
            while (c < tupleLengthAfter) {
                newDictValues[targetOffset] = this._values[orgOffset];
                ++c;
                ++orgOffset;
                ++targetOffset;
            }
            orgOffset += previousNumberOfColumns - idxEnd + idxStart;
        }
        return new QDictionary(newDictValues, this._scale);
    }

    @Override
    public ADictionary reExpandColumns(int max) {
        byte[] newDictValues = new byte[this._values.length * max];
        int i = 0;
        int offset = 0;
        while (i < this._values.length) {
            int val = this._values[i] - 1;
            newDictValues[offset + val] = 1;
            ++i;
            offset += max;
        }
        return new QDictionary(newDictValues, 1.0);
    }

    @Override
    public boolean containsValue(double pattern) {
        if (Double.isNaN(pattern) || Double.isInfinite(pattern)) {
            return false;
        }
        throw new NotImplementedException("Not contains value on Q Dictionary");
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        long nnz = 0L;
        int nRow = this._values.length / nCol;
        for (int i = 0; i < nRow; ++i) {
            int off;
            long rowCount = 0L;
            for (int j = off = i * nCol; j < off + nCol; ++j) {
                if (this._values[j] == 0) continue;
                ++rowCount;
            }
            nnz += rowCount * (long)counts[i];
        }
        return nnz;
    }

    @Override
    public void addToEntry(Dictionary d, int fr, int to, int nCol) {
        throw new NotImplementedException("Not implemented yet");
    }

    @Override
    public boolean isLossy() {
        return false;
    }

    @Override
    public double[] getTuple(int index, int nCol) {
        return null;
    }

    @Override
    public ADictionary subtractTuple(double[] tuple) {
        throw new NotImplementedException();
    }

    @Override
    public MatrixBlockDictionary getAsMatrixBlockDictionary(int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, int[] colIndexes) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary scaleTuples(int[] scaling, int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary preaggValuesFromDense(int numVals, int[] colIndexes, int[] aggregateColumns, double[] b, int cut) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary replace(double pattern, double replace, int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary replaceZeroAndExtend(double replace, int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public double product(int[] counts, int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public void colProduct(double[] res, int[] counts, int[] colIndexes) {
        throw new NotImplementedException();
    }
}

