/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionSparse
extends ReaderColumnSelection {
    private SparseBlock a;

    protected ReaderColumnSelectionSparse(MatrixBlock data, int[] colIndexes, int rl, int ru) {
        super(colIndexes, rl, Math.min(ru, data.getNumRows()));
        this.a = data.getSparseBlock();
    }

    @Override
    protected DblArray getNextRow() {
        if (this._rl == this._ru - 1) {
            return null;
        }
        ++this._rl;
        boolean zeroResult = true;
        if (!this.a.isEmpty(this._rl)) {
            int j;
            int apos = this.a.pos(this._rl);
            int alen = this.a.size(this._rl) + apos;
            int[] aix = this.a.indexes(this._rl);
            double[] avals = this.a.values(this._rl);
            int skip = 0;
            for (j = apos; j < alen && aix[j] < this._colIndexes[0]; ++j) {
            }
            while (skip < this._colIndexes.length && j < alen) {
                if (this._colIndexes[skip] == aix[j]) {
                    this.reusableArr[skip] = avals[j];
                    zeroResult = false;
                    ++skip;
                    ++j;
                    continue;
                }
                if (this._colIndexes[skip] > aix[j]) {
                    ++j;
                    continue;
                }
                this.reusableArr[skip++] = 0.0;
            }
            if (!zeroResult) {
                while (skip < this._colIndexes.length) {
                    this.reusableArr[skip++] = 0.0;
                }
            }
        }
        return zeroResult ? emptyReturn : this.reusableReturn;
    }
}

