/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.insertionsort;

import org.apache.sysds.runtime.compress.colgroup.insertionsort.AInsertionSorter;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public class MergeSort
extends AInsertionSorter {
    private int currentFill = 0;

    public MergeSort(int endLength, int numRows, IntArrayList[] offsets, int negativeIndex) {
        super(endLength, numRows, offsets, negativeIndex);
        if (this._negativeIndex == -1) {
            this.insert();
        } else {
            this.insertWithNegative();
        }
    }

    private void insert() {
        for (int i = 0; i < this._offsets.length; ++i) {
            this.insert(this._offsets[i], i);
        }
    }

    private void insertWithNegative() {
        for (int i = 0; i < this._offsets.length; ++i) {
            if (i < this._negativeIndex) {
                this.insert(this._offsets[i], i);
                continue;
            }
            if (i <= this._negativeIndex) continue;
            this.insert(this._offsets[i], i - 1);
        }
        this.negativeInsert(this._offsets[this._negativeIndex]);
    }

    protected void insert(IntArrayList array, int label) {
        if (this.currentFill == 0) {
            this.currentFill = array.size();
            for (int i = 0; i < this.currentFill; ++i) {
                this.set(i, array.get(i), label);
            }
        } else {
            this.merge(array, label);
        }
    }

    private void merge(IntArrayList a, int label) {
        int pA = a.size();
        int pP = this.currentFill;
        this.currentFill = pA + pP;
        int pN = this.currentFill - 1;
        --pA;
        --pP;
        while (pP >= 0 && pA >= 0) {
            int vP = this._indexes[pP];
            int vA = a.get(pA);
            if (vP > vA) {
                this.set(pN--, vP, this._labels.getIndex(pP--));
                continue;
            }
            this.set(pN--, vA, label);
            --pA;
        }
        while (pA >= 0) {
            this.set(pN--, a.get(pA--), label);
        }
    }

    protected void negativeInsert(IntArrayList a) {
        int vP;
        int label = this._numLabels - 1;
        int pA = a.size() - 1;
        int pP = this.currentFill - 1;
        int pN = this._indexes.length - 1;
        int vA = a.get(pA);
        int vM = this._numRows - 1;
        while (pP >= 0 && pA >= 0 && pN >= 0) {
            vP = this._indexes[pP];
            vA = a.get(pA);
            if (vP == vM) {
                this.set(pN--, vM, this._labels.getIndex(pP--));
            } else if (vA == vM) {
                --pA;
            } else {
                this.set(pN--, vM, label);
            }
            --vM;
        }
        if (pA < 0) {
            while (pP >= 0 && pN >= 0) {
                vP = this._indexes[pP];
                if (vP == vM) {
                    this.set(pN--, vM, this._labels.getIndex(pP--));
                } else {
                    this.set(pN--, vM, label);
                }
                --vM;
            }
        } else {
            while (pN >= 0 && pA >= 0) {
                vA = a.get(pA);
                if (vA < vM) {
                    this.set(pN--, vM, label);
                } else {
                    --pA;
                }
                --vM;
            }
        }
        while (pN >= 0 && vM >= 0) {
            this.set(pN--, vM--, label);
        }
    }
}

