/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.bitmap.BitmapEncoder;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.AInsertionSorter;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.InsertionSorterFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToInt;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DCounts;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayCountHashMap;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public final class ColGroupFactory {
    private static final Log LOG = LogFactory.getLog((String)ColGroupFactory.class.getName());

    public static List<AColGroup> compressColGroups(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings compSettings, int k) {
        for (CompressedSizeInfoColGroup g : csi.getInfo()) {
            g.clearMap();
        }
        if (compSettings.transposed && in.getNumColumns() == 1 || !compSettings.transposed && in.getNumRows() == 1) {
            throw new DMLCompressionException("Error input for compression only have 1 row");
        }
        if (k <= 1) {
            return ColGroupFactory.compressColGroupsSingleThreaded(in, csi, compSettings);
        }
        return ColGroupFactory.compressColGroupsParallel(in, csi, compSettings, k);
    }

    public static AColGroup genColGroupConst(int numCols, double value) {
        if (numCols <= 0) {
            throw new DMLCompressionException("Invalid construction of constant column group with cols: " + numCols);
        }
        int[] colIndices = ColGroupFactory.genColsIndices(numCols);
        if (value == 0.0) {
            return new ColGroupEmpty(colIndices);
        }
        return ColGroupFactory.getColGroupConst(colIndices, value);
    }

    public static AColGroup genColGroupConst(int numCols, double[] values) {
        if (numCols <= 0) {
            throw new DMLCompressionException("Invalid construction of constant column group with cols: " + numCols);
        }
        int[] colIndices = ColGroupFactory.genColsIndices(numCols);
        return ColGroupFactory.getColGroupConst(colIndices, values);
    }

    public static AColGroup getColGroupConst(int[] cols, double value) {
        int numCols = cols.length;
        double[] values = new double[numCols];
        for (int i = 0; i < numCols; ++i) {
            values[i] = value;
        }
        return ColGroupFactory.getColGroupConst(cols, values);
    }

    public static AColGroup getColGroupConst(int[] cols, double[] values) {
        Dictionary dict = new Dictionary(values);
        return new ColGroupConst(cols, dict);
    }

    public static AColGroup getColGroupConst(int numCols, ADictionary dict) {
        int[] colIndices = ColGroupFactory.genColsIndices(numCols);
        return new ColGroupConst(colIndices, dict);
    }

    private static List<AColGroup> compressColGroupsSingleThreaded(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings compSettings) {
        ArrayList<AColGroup> ret = new ArrayList<AColGroup>(csi.getNumberColGroups());
        List<CompressedSizeInfoColGroup> groups = csi.getInfo();
        Tmp tmpMap = new Tmp();
        for (CompressedSizeInfoColGroup g : groups) {
            ret.addAll(ColGroupFactory.compressColGroup(in, compSettings, tmpMap, g, 1));
        }
        return ret;
    }

    private static List<AColGroup> compressColGroupsParallel(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings compSettings, int k) {
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<CompressTask> tasks = new ArrayList<CompressTask>();
            List<List<CompressedSizeInfoColGroup>> threadGroups = ColGroupFactory.makeGroups(csi.getInfo(), k);
            for (List<CompressedSizeInfoColGroup> tg : threadGroups) {
                if (tg.isEmpty()) continue;
                tasks.add(new CompressTask(in, tg, compSettings, Math.max(1, k / 2)));
            }
            ArrayList<AColGroup> ret = new ArrayList<AColGroup>(csi.getNumberColGroups());
            for (Future t : pool.invokeAll(tasks)) {
                ret.addAll((Collection)t.get());
            }
            pool.shutdown();
            return ret;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DMLRuntimeException("Failed compression ", e);
        }
    }

    private static List<List<CompressedSizeInfoColGroup>> makeGroups(List<CompressedSizeInfoColGroup> groups, int k) {
        int i;
        Collections.sort(groups, Comparator.comparing(g -> -g.getNumVals()));
        ArrayList<List<CompressedSizeInfoColGroup>> ret = new ArrayList<List<CompressedSizeInfoColGroup>>();
        for (i = 0; i < k; ++i) {
            ret.add(new ArrayList());
        }
        for (i = 0; i < groups.size(); ++i) {
            ((List)ret.get(i % k)).add(groups.get(i));
        }
        return ret;
    }

    private static Collection<AColGroup> compressColGroup(MatrixBlock in, CompressionSettings compSettings, Tmp tmpMap, CompressedSizeInfoColGroup cg, int k) {
        int inCols;
        int n = inCols = compSettings.transposed ? in.getNumRows() : in.getNumColumns();
        if (LOG.isDebugEnabled() && inCols < 1000) {
            Timing time = new Timing(true);
            time.start();
            Collection<AColGroup> ret = ColGroupFactory.compressColGroupExecute(in, compSettings, tmpMap, cg, k);
            LOG.debug((Object)((Object)((Object)cg.getBestCompressionType()) + "\ttime [ms]: " + time.stop() + "\tnrColumns: " + cg.getColumns().length));
            return ret;
        }
        return ColGroupFactory.compressColGroupExecute(in, compSettings, tmpMap, cg, k);
    }

    private static Collection<AColGroup> compressColGroupExecute(MatrixBlock in, CompressionSettings compSettings, Tmp tmpMap, CompressedSizeInfoColGroup cg, int k) {
        int[] colIndexes = cg.getColumns();
        if (in.isEmpty()) {
            return Collections.singletonList(new ColGroupEmpty(colIndexes));
        }
        if (in.isInSparseFormat() && compSettings.transposed) {
            SparseBlock sb = in.getSparseBlock();
            for (int col : colIndexes) {
                if (!sb.isEmpty(col)) continue;
                return ColGroupFactory.compressColGroupAndExtractEmptyColumns(in, compSettings, tmpMap, cg, k);
            }
            return Collections.singletonList(ColGroupFactory.compressColGroupForced(in, compSettings, tmpMap, cg, k));
        }
        return Collections.singletonList(ColGroupFactory.compressColGroupForced(in, compSettings, tmpMap, cg, k));
    }

    private static Collection<AColGroup> compressColGroupAndExtractEmptyColumns(MatrixBlock in, CompressionSettings compSettings, Tmp tmpMap, CompressedSizeInfoColGroup cg, int k) {
        int[] colIndexes;
        IntArrayList e = new IntArrayList();
        IntArrayList v = new IntArrayList();
        SparseBlock sb = in.getSparseBlock();
        for (int col : colIndexes = cg.getColumns()) {
            if (sb.isEmpty(col)) {
                e.appendValue(col);
                continue;
            }
            v.appendValue(col);
        }
        ColGroupEmpty empty = new ColGroupEmpty(e.extractValues(true));
        if (v.size() > 0) {
            AColGroup colGroup = ColGroupFactory.compressColGroupForced(in, compSettings, tmpMap, cg, v.extractValues(true), k);
            return Arrays.asList(empty, colGroup);
        }
        return Collections.singletonList(empty);
    }

    private static AColGroup compressColGroupForced(MatrixBlock in, CompressionSettings compSettings, Tmp tmpMap, CompressedSizeInfoColGroup cg, int k) {
        int[] colIndexes = cg.getColumns();
        return ColGroupFactory.compressColGroupForced(in, compSettings, tmpMap, cg, colIndexes, k);
    }

    private static AColGroup compressColGroupForced(MatrixBlock in, CompressionSettings cs, Tmp tmp, CompressedSizeInfoColGroup cg, int[] colIndexes, int k) {
        int nrUniqueEstimate = cg.getNumVals();
        AColGroup.CompressionType estimatedBestCompressionType = cg.getBestCompressionType();
        if (estimatedBestCompressionType == AColGroup.CompressionType.UNCOMPRESSED) {
            return new ColGroupUncompressed(colIndexes, in, cs.transposed);
        }
        if (estimatedBestCompressionType == AColGroup.CompressionType.SDC && colIndexes.length == 1 && in.isInSparseFormat() && cs.transposed) {
            return ColGroupFactory.compressSDCZero(in.getSparseBlock(), colIndexes, in.getNumColumns(), tmp.getDblCountMap(nrUniqueEstimate));
        }
        if (colIndexes.length > 1 && estimatedBestCompressionType == AColGroup.CompressionType.DDC) {
            return ColGroupFactory.directCompressDDC(colIndexes, in, cs, cg, k);
        }
        int numRows = cs.transposed ? in.getNumColumns() : in.getNumRows();
        ABitmap ubm = BitmapEncoder.extractBitmap(colIndexes, in, cs.transposed, nrUniqueEstimate);
        return ColGroupFactory.compress(colIndexes, numRows, ubm, estimatedBestCompressionType, cs, in, cg.getTupleSparsity());
    }

    public static AColGroup compress(int[] colIndexes, int rlen, ABitmap ubm, AColGroup.CompressionType compType, CompressionSettings cs, MatrixBlock rawMatrixBlock, double tupleSparsity) {
        try {
            if (ubm == null) {
                return new ColGroupEmpty(colIndexes);
            }
            IntArrayList[] of = ubm.getOffsetList();
            if (of.length == 1 && of[0].size() == rlen) {
                return new ColGroupConst(colIndexes, DictionaryFactory.create(ubm));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("compressing to: " + (Object)((Object)compType)));
            }
            if (cs.sortValuesByLength) {
                ubm.sortValuesByFrequency();
            }
            switch (compType) {
                case DDC: {
                    return ColGroupFactory.compressDDC(colIndexes, rlen, ubm, cs, tupleSparsity);
                }
                case RLE: {
                    return ColGroupFactory.compressRLE(colIndexes, rlen, ubm, cs, tupleSparsity);
                }
                case OLE: {
                    return ColGroupFactory.compressOLE(colIndexes, rlen, ubm, cs, tupleSparsity);
                }
                case SDC: {
                    return ColGroupFactory.compressSDC(colIndexes, rlen, ubm, cs, tupleSparsity);
                }
                case UNCOMPRESSED: {
                    return new ColGroupUncompressed(colIndexes, rawMatrixBlock, cs.transposed);
                }
                case CONST: 
                case EMPTY: {
                    throw new DMLCompressionException("Should never use these column groups since the code defaults to these if applicable");
                }
            }
            throw new DMLCompressionException("Not implemented ColGroup Type compressed in factory.");
        }
        catch (Exception e) {
            throw new DMLCompressionException("Error in construction of colGroup type: " + (Object)((Object)compType), e);
        }
    }

    private static ColGroupDDC directCompressDDC(int[] colIndexes, MatrixBlock raw, CompressionSettings cs, CompressedSizeInfoColGroup cg, int k) {
        int rlen = cs.transposed ? raw.getNumColumns() : raw.getNumRows();
        int nVal = Math.max(cg.getNumVals(), 257);
        return ColGroupFactory.directCompressDDC(colIndexes, raw, cs, cg, MapToFactory.create(rlen, nVal), rlen, k);
    }

    private static ColGroupDDC directCompressDDC(int[] colIndexes, MatrixBlock raw, CompressionSettings cs, CompressedSizeInfoColGroup cg, AMapToData data, int rlen, int k) {
        int fill = data instanceof MapToInt ? Integer.MAX_VALUE : 65535;
        data.fill(fill);
        DblArrayCountHashMap map = new DblArrayCountHashMap(cg.getNumVals());
        if (rlen < 10000 || k == 1) {
            ColGroupFactory.readToMapDDC(colIndexes, raw, map, cs, data, 0, rlen);
        } else {
            ColGroupFactory.parallelReadToMapDDC(colIndexes, raw, map, cs, data, rlen, k);
        }
        boolean extra = false;
        for (int i = 0; i < rlen; ++i) {
            if (data.getIndex(i) != fill) continue;
            extra = true;
            break;
        }
        ADictionary dict = DictionaryFactory.create(map, colIndexes.length, extra);
        if (extra) {
            data.replace(fill, map.size());
        }
        AMapToData resData = MapToFactory.resize(data, map.size() + (extra ? 1 : 0));
        ColGroupDDC res = new ColGroupDDC(colIndexes, rlen, dict, resData, null);
        return res;
    }

    private static void readToMapDDC(int[] colIndexes, MatrixBlock raw, DblArrayCountHashMap map, CompressionSettings cs, AMapToData data, int rl, int ru) {
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(raw, colIndexes, cs.transposed, rl, ru);
        DblArray cellVals = null;
        while ((cellVals = reader.nextRow()) != null) {
            int id = map.increment(cellVals);
            int row = reader.getCurrentRowIndex();
            data.set(row, id);
        }
    }

    private static void parallelReadToMapDDC(int[] colIndexes, MatrixBlock raw, DblArrayCountHashMap map, CompressionSettings cs, AMapToData data, int rlen, int k) {
        try {
            int blk = Math.max(rlen / colIndexes.length / k, 128000 / colIndexes.length);
            ExecutorService pool = CommonThreadPool.get(Math.min(Math.max(rlen / blk, 1), k));
            ArrayList<readToMapDDCTask> tasks = new ArrayList<readToMapDDCTask>();
            for (int i = 0; i < rlen; i += blk) {
                int end = Math.min(rlen, i + blk);
                tasks.add(new readToMapDDCTask(colIndexes, raw, map, cs, data, i, end));
            }
            for (Future t : pool.invokeAll(tasks)) {
                t.get();
            }
            pool.shutdown();
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Failed to parallelize DDC compression");
        }
    }

    private static AColGroup compressSDC(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        int numZeros = (int)((long)rlen - ubm.getNumOffsets());
        int largestOffset = 0;
        int largestIndex = 0;
        if (!cs.sortValuesByLength) {
            int index = 0;
            for (IntArrayList a : ubm.getOffsetList()) {
                if (a.size() > largestOffset) {
                    largestOffset = a.size();
                    largestIndex = index;
                }
                ++index;
            }
        }
        ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
        if (numZeros >= largestOffset && ubm.getOffsetList().length == 1) {
            AOffset off = OffsetFactory.create(ubm.getOffsetList()[0].extractValues(true));
            return new ColGroupSDCSingleZeros(colIndexes, rlen, dict, off);
        }
        if (ubm.getOffsetList().length == 1) {
            dict = DictionaryFactory.moveFrequentToLastDictionaryEntry(dict, ubm, rlen, largestIndex);
            return ColGroupFactory.setupSingleValueSDCColGroup(colIndexes, rlen, ubm, dict);
        }
        if (numZeros >= largestOffset) {
            return ColGroupFactory.setupMultiValueZeroColGroup(colIndexes, rlen, ubm, dict);
        }
        dict = DictionaryFactory.moveFrequentToLastDictionaryEntry(dict, ubm, rlen, largestIndex);
        return ColGroupFactory.setupMultiValueColGroup(colIndexes, numZeros, rlen, ubm, largestIndex, dict);
    }

    private static AColGroup setupMultiValueZeroColGroup(int[] colIndexes, int rlen, ABitmap ubm, ADictionary dict) {
        try {
            IntArrayList[] offsets = ubm.getOffsetList();
            AInsertionSorter s = InsertionSorterFactory.create(rlen, offsets);
            AOffset indexes = OffsetFactory.create(s.getIndexes());
            AMapToData data = s.getData();
            int[] counts = new int[offsets.length + 1];
            int sum = 0;
            for (int i = 0; i < offsets.length; ++i) {
                counts[i] = offsets[i].size();
                sum += counts[i];
            }
            counts[offsets.length] = rlen - sum;
            ColGroupSDCZeros ret = new ColGroupSDCZeros(colIndexes, rlen, dict, indexes, data, counts);
            return ret;
        }
        catch (Exception e) {
            throw new DMLCompressionException("Failed to construct SDC Zero Group with columns :" + Arrays.toString(colIndexes), e);
        }
    }

    private static AColGroup setupMultiValueColGroup(int[] colIndexes, int numZeros, int rlen, ABitmap ubm, int largestIndex, ADictionary dict) {
        try {
            IntArrayList[] offsets = ubm.getOffsetList();
            AInsertionSorter s = InsertionSorterFactory.create(rlen, offsets, largestIndex);
            AOffset indexes = OffsetFactory.create(s.getIndexes());
            AMapToData _data = s.getData();
            ColGroupSDC ret = new ColGroupSDC(colIndexes, rlen, dict, indexes, _data);
            return ret;
        }
        catch (Exception e) {
            throw new DMLCompressionException("Failed to construct SDC Group with columns :\n" + Arrays.toString(colIndexes), e);
        }
    }

    private static AColGroup setupSingleValueSDCColGroup(int[] colIndexes, int rlen, ABitmap ubm, ADictionary dict) {
        IntArrayList inv = ubm.getOffsetsList(0);
        int[] indexes = new int[rlen - inv.size()];
        int p = 0;
        int v = 0;
        for (int i = 0; i < inv.size(); ++i) {
            int j = inv.get(i);
            while (v < j) {
                indexes[p++] = v++;
            }
            if (v != j) continue;
            ++v;
        }
        while (v < rlen) {
            indexes[p++] = v++;
        }
        AOffset off = OffsetFactory.create(indexes);
        return new ColGroupSDCSingle(colIndexes, rlen, dict, off);
    }

    private static AColGroup compressDDC(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        boolean zeros = ubm.getNumOffsets() < (long)rlen;
        ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity, zeros);
        AMapToData data = MapToFactory.create(rlen, zeros, ubm.getOffsetList());
        return new ColGroupDDC(colIndexes, rlen, dict, data, null);
    }

    private static AColGroup compressOLE(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
        ColGroupOLE ole = new ColGroupOLE(rlen);
        int numVals = ubm.getNumValues();
        char[][] lbitmaps = new char[numVals][];
        int totalLen = 0;
        for (int i = 0; i < numVals; ++i) {
            lbitmaps[i] = ColGroupOLE.genOffsetBitmap(ubm.getOffsetsList(i).extractValues(), ubm.getNumOffsets(i));
            totalLen += lbitmaps[i].length;
        }
        ole.createCompressedBitmaps(numVals, totalLen, lbitmaps);
        ole._dict = dict;
        ole._zeros = ubm.getNumOffsets() < (long)rlen;
        ole._colIndexes = colIndexes;
        return ole;
    }

    private static AColGroup compressRLE(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
        ColGroupRLE rle = new ColGroupRLE(rlen);
        int numVals = ubm.getNumValues();
        char[][] lbitmaps = new char[numVals][];
        int totalLen = 0;
        for (int k = 0; k < numVals; ++k) {
            lbitmaps[k] = ColGroupRLE.genRLEBitmap(ubm.getOffsetsList(k).extractValues(), ubm.getNumOffsets(k));
            totalLen += lbitmaps[k].length;
        }
        rle.createCompressedBitmaps(numVals, totalLen, lbitmaps);
        rle._dict = dict;
        rle._zeros = ubm.getNumOffsets() < (long)rlen;
        rle._colIndexes = colIndexes;
        return rle;
    }

    private static int[] genColsIndices(int numCols) {
        int[] colIndices = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            colIndices[i] = i;
        }
        return colIndices;
    }

    private static AColGroup compressSDCZero(SparseBlock sb, int[] cols, int rlen, DoubleCountHashMap map) {
        int sbRow = cols[0];
        int apos = sb.pos(sbRow);
        int alen = sb.size(sbRow) + apos;
        AOffset offsets = OffsetFactory.create(sb.indexes(sbRow), apos, alen);
        double[] vals = sb.values(sbRow);
        for (int j = apos; j < alen; ++j) {
            map.increment(vals[j]);
        }
        ArrayList<DCounts> entries = map.extractValues();
        Collections.sort(entries, Comparator.comparing(x -> -x.count));
        int[] counts = new int[entries.size() + 1];
        int sum = 0;
        double[] dict = new double[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            DCounts x2 = (DCounts)entries.get(i);
            counts[i] = x2.count;
            sum += x2.count;
            dict[i] = x2.key;
            x2.count = i++;
        }
        counts[entries.size()] = rlen - sum;
        AMapToData mapToData = MapToFactory.create(alen - apos, entries.size());
        for (int j = apos; j < alen; ++j) {
            mapToData.set(j - apos, map.get(vals[j]));
        }
        return new ColGroupSDCZeros(cols, rlen, new Dictionary(dict), offsets, mapToData, counts);
    }

    private static class Tmp {
        private DoubleCountHashMap dblCountMap = null;

        protected Tmp() {
        }

        protected DoubleCountHashMap getDblCountMap(int size) {
            if (this.dblCountMap != null) {
                this.dblCountMap.reset(size);
            } else {
                this.dblCountMap = new DoubleCountHashMap(size);
            }
            return this.dblCountMap;
        }
    }

    private static class readToMapDDCTask
    implements Callable<Object> {
        private final int[] _colIndexes;
        private final MatrixBlock _raw;
        private final DblArrayCountHashMap _map;
        private final CompressionSettings _cs;
        private final AMapToData _data;
        private final int _rl;
        private final int _ru;

        protected readToMapDDCTask(int[] colIndexes, MatrixBlock raw, DblArrayCountHashMap map, CompressionSettings cs, AMapToData data, int rl, int ru) {
            this._colIndexes = colIndexes;
            this._raw = raw;
            this._map = map;
            this._cs = cs;
            this._data = data;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Collection<AColGroup> call() {
            ColGroupFactory.readToMapDDC(this._colIndexes, this._raw, this._map, this._cs, this._data, this._rl, this._ru);
            return null;
        }
    }

    private static class CompressTask
    implements Callable<Collection<AColGroup>> {
        private final MatrixBlock _in;
        private final List<CompressedSizeInfoColGroup> _groups;
        private final CompressionSettings _compSettings;
        private final int _k;

        protected CompressTask(MatrixBlock in, List<CompressedSizeInfoColGroup> groups, CompressionSettings compSettings, int k) {
            this._in = in;
            this._groups = groups;
            this._compSettings = compSettings;
            this._k = k;
        }

        @Override
        public Collection<AColGroup> call() {
            ArrayList<AColGroup> res = new ArrayList<AColGroup>();
            Tmp tmpMap = new Tmp();
            for (CompressedSizeInfoColGroup g : this._groups) {
                res.addAll(ColGroupFactory.compressColGroup(this._in, this._compSettings, tmpMap, g, this._k));
            }
            return res;
        }
    }
}

