/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.Identifier;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.MultiAssignmentStatement;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.VariableSet;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public abstract class Expression
implements ParseInfo {
    private static final Log LOG = LogFactory.getLog((String)Expression.class.getName());
    private static final IDSequence _tempId = new IDSequence();
    protected Identifier[] _outputs = null;
    private String _filename;
    private int _beginLine;
    private int _beginColumn;
    private int _endLine;
    private int _endColumn;
    private String _text;
    private ArrayList<String> _parseExceptionList = new ArrayList();

    public abstract Expression rewriteExpression(String var1);

    public void setOutput(Identifier output) {
        if (this._outputs == null) {
            this._outputs = new Identifier[1];
        }
        this._outputs[0] = output;
    }

    public Identifier getOutput() {
        if (this._outputs != null && this._outputs.length > 0) {
            return this._outputs[0];
        }
        return null;
    }

    public Identifier[] getOutputs() {
        return this._outputs;
    }

    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> currConstVars, boolean conditional) {
        this.raiseValidateError("Should never be invoked in Baseclass 'Expression'", false);
    }

    public void validateExpression(MultiAssignmentStatement mas, HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> currConstVars, boolean conditional) {
        this.raiseValidateError("Should never be invoked in Baseclass 'Expression'", false);
    }

    public static BinaryOp getBinaryOp(String val) {
        if (val.equalsIgnoreCase("+")) {
            return BinaryOp.PLUS;
        }
        if (val.equalsIgnoreCase("-")) {
            return BinaryOp.MINUS;
        }
        if (val.equalsIgnoreCase("*")) {
            return BinaryOp.MULT;
        }
        if (val.equalsIgnoreCase("/")) {
            return BinaryOp.DIV;
        }
        if (val.equalsIgnoreCase("%%")) {
            return BinaryOp.MODULUS;
        }
        if (val.equalsIgnoreCase("%/%")) {
            return BinaryOp.INTDIV;
        }
        if (val.equalsIgnoreCase("^")) {
            return BinaryOp.POW;
        }
        if (val.equalsIgnoreCase("%*%")) {
            return BinaryOp.MATMULT;
        }
        return BinaryOp.INVALID;
    }

    public static RelationalOp getRelationalOp(String val) {
        if (val == null) {
            return null;
        }
        if (val.equalsIgnoreCase("<")) {
            return RelationalOp.LESS;
        }
        if (val.equalsIgnoreCase("<=")) {
            return RelationalOp.LESSEQUAL;
        }
        if (val.equalsIgnoreCase(">")) {
            return RelationalOp.GREATER;
        }
        if (val.equalsIgnoreCase(">=")) {
            return RelationalOp.GREATEREQUAL;
        }
        if (val.equalsIgnoreCase("==")) {
            return RelationalOp.EQUAL;
        }
        if (val.equalsIgnoreCase("!=")) {
            return RelationalOp.NOTEQUAL;
        }
        return RelationalOp.INVALID;
    }

    public static BooleanOp getBooleanOp(String val) {
        if (val.equalsIgnoreCase("&&")) {
            return BooleanOp.CONDITIONALAND;
        }
        if (val.equalsIgnoreCase("&")) {
            return BooleanOp.LOGICALAND;
        }
        if (val.equalsIgnoreCase("||")) {
            return BooleanOp.CONDITIONALOR;
        }
        if (val.equalsIgnoreCase("|")) {
            return BooleanOp.LOGICALOR;
        }
        if (val.equalsIgnoreCase("!")) {
            return BooleanOp.NOT;
        }
        return BooleanOp.INVALID;
    }

    public static Types.FileFormat convertFormatType(String format) {
        if (format == null) {
            return Types.FileFormat.defaultFormat();
        }
        return Types.FileFormat.safeValueOf(format);
    }

    public static String getTempName() {
        return "parsertemp" + _tempId.getNextID();
    }

    public abstract VariableSet variablesRead();

    public abstract VariableSet variablesUpdated();

    public static Types.DataType computeDataType(Expression expression1, Expression expression2, boolean cast) {
        return Expression.computeDataType(expression1.getOutput(), expression2.getOutput(), cast);
    }

    public static Types.DataType computeDataType(Identifier identifier1, Identifier identifier2, boolean cast) {
        Types.DataType d2;
        Types.DataType d1 = identifier1.getDataType();
        if (d1 == (d2 = identifier2.getDataType())) {
            return d1;
        }
        if (cast) {
            if (d1 == Types.DataType.MATRIX && d2 == Types.DataType.SCALAR) {
                return Types.DataType.MATRIX;
            }
            if (d1 == Types.DataType.SCALAR && d2 == Types.DataType.MATRIX) {
                return Types.DataType.MATRIX;
            }
        }
        identifier1.raiseValidateError("Invalid Datatypes for operation " + (Object)((Object)d1) + " " + (Object)((Object)d2), false, "Invalid Parameters");
        return null;
    }

    public static Types.ValueType computeValueType(Expression expression1, Expression expression2, boolean cast) {
        return Expression.computeValueType(expression1.getOutput(), expression2.getOutput(), cast);
    }

    public static Types.ValueType computeValueType(Identifier identifier1, Identifier identifier2, boolean cast) {
        return Expression.computeValueType(identifier1, identifier1.getValueType(), identifier2.getValueType(), cast);
    }

    public static Types.ValueType computeValueType(Expression expr1, Types.ValueType v1, Types.ValueType v2, boolean cast) {
        if (v1 == v2) {
            return v1;
        }
        if (v1 == Types.ValueType.UNKNOWN && v2 != Types.ValueType.UNKNOWN) {
            return v2;
        }
        if (v1 != Types.ValueType.UNKNOWN && v2 == Types.ValueType.UNKNOWN) {
            return v1;
        }
        if (cast) {
            if (v1 == Types.ValueType.FP64 && v2 == Types.ValueType.INT64) {
                return Types.ValueType.FP64;
            }
            if (v2 == Types.ValueType.FP64 && v1 == Types.ValueType.INT64) {
                return Types.ValueType.FP64;
            }
            if (v1 == Types.ValueType.STRING || v2 == Types.ValueType.STRING) {
                return Types.ValueType.STRING;
            }
        }
        expr1.raiseValidateError("Invalid Valuetypes for operation " + (Object)((Object)v1) + " " + (Object)((Object)v2), false, "Invalid Parameters");
        return null;
    }

    public boolean equals(Object that) {
        if (that == null || !(that instanceof Expression)) {
            return false;
        }
        Expression thatExpr = (Expression)that;
        String thisStr = this.toString();
        String thatStr = thatExpr.toString();
        return thisStr.equalsIgnoreCase(thatStr);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void raiseValidateError(String message) {
        this.raiseValidateError(message, false, null);
    }

    public void raiseValidateError(String message, boolean conditional) {
        this.raiseValidateError(message, conditional, null);
    }

    public void raiseValidateError(String msg, boolean conditional, String errorCode) {
        if (!conditional) {
            String fullMsg = this.printErrorLocation() + msg;
            if (errorCode != null) {
                throw new LanguageException(fullMsg, errorCode);
            }
            throw new LanguageException(fullMsg);
        }
        String fullMsg = this.printWarningLocation() + msg;
        LOG.warn((Object)fullMsg);
    }

    public static MatrixCharacteristics getBinaryMatrixCharacteristics(Expression expression1, Expression expression2) {
        Identifier idleft = expression1.getOutput();
        Identifier idright = expression2.getOutput();
        if (idleft.getDataType() == Types.DataType.SCALAR && idright.getDataType() == Types.DataType.SCALAR) {
            return new MatrixCharacteristics(0L, 0L, 0, 0L);
        }
        if (idleft.getDataType() == Types.DataType.SCALAR && idright.getDataType() == Types.DataType.MATRIX) {
            return new MatrixCharacteristics(idright.getDim1(), idright.getDim2(), idright.getBlocksize());
        }
        if (idleft.getDataType() == Types.DataType.MATRIX && idright.getDataType() == Types.DataType.SCALAR) {
            return new MatrixCharacteristics(idleft.getDim1(), idleft.getDim2(), idleft.getBlocksize());
        }
        if (idleft.getDataType() == Types.DataType.MATRIX && idright.getDataType() == Types.DataType.MATRIX) {
            MatrixCharacteristics mc = new MatrixCharacteristics(idleft.getDim1(), idleft.getDim2(), idleft.getBlocksize());
            if (mc.getRows() < 0L && idright.getDim1() > 1L) {
                mc.setRows(idright.getDim1());
            }
            if (mc.getCols() < 0L && idright.getDim2() > 1L) {
                mc.setCols(idright.getDim2());
            }
            return mc;
        }
        return new MatrixCharacteristics(-1L, -1L, -1, -1L);
    }

    @Override
    public void setFilename(String passed) {
        this._filename = passed;
    }

    @Override
    public void setBeginLine(int passed) {
        this._beginLine = passed;
    }

    @Override
    public void setBeginColumn(int passed) {
        this._beginColumn = passed;
    }

    @Override
    public void setEndLine(int passed) {
        this._endLine = passed;
    }

    @Override
    public void setEndColumn(int passed) {
        this._endColumn = passed;
    }

    @Override
    public void setText(String text) {
        this._text = text;
    }

    public void setParseExceptionList(ArrayList<String> passed) {
        this._parseExceptionList = passed;
    }

    public void setParseInfo(ParseInfo parseInfo) {
        this._beginLine = parseInfo.getBeginLine();
        this._beginColumn = parseInfo.getBeginColumn();
        this._endLine = parseInfo.getEndLine();
        this._endColumn = parseInfo.getEndColumn();
        this._text = parseInfo.getText();
        this._filename = parseInfo.getFilename();
    }

    public void setCtxValues(ParserRuleContext ctx) {
        this.setBeginLine(ctx.start.getLine());
        this.setBeginColumn(ctx.start.getCharPositionInLine());
        this.setEndLine(ctx.stop.getLine());
        this.setEndColumn(ctx.stop.getCharPositionInLine());
        if (ctx.start != null && ctx.stop != null && ctx.start.getStartIndex() != -1 && ctx.stop.getStopIndex() != -1 && ctx.start.getStartIndex() <= ctx.stop.getStopIndex() && ctx.start.getInputStream() != null) {
            String text = ctx.start.getInputStream().getText(Interval.of(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            if (text != null) {
                text = text.trim();
            }
            this.setText(text);
        } else {
            String text = ctx.getText();
            if (text != null) {
                text = text.trim();
            }
            this.setText(text);
        }
    }

    public void setCtxValuesAndFilename(ParserRuleContext ctx, String filename) {
        this.setCtxValues(ctx);
        this.setFilename(filename);
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    @Override
    public int getBeginLine() {
        return this._beginLine;
    }

    @Override
    public int getBeginColumn() {
        return this._beginColumn;
    }

    @Override
    public int getEndLine() {
        return this._endLine;
    }

    @Override
    public int getEndColumn() {
        return this._endColumn;
    }

    @Override
    public String getText() {
        return this._text;
    }

    public ArrayList<String> getParseExceptionList() {
        return this._parseExceptionList;
    }

    public String printErrorLocation() {
        String file = this._filename;
        file = file == null ? "" : file + " ";
        if (this.getText() != null) {
            return "ERROR: " + file + "[line " + this._beginLine + ":" + this._beginColumn + "] -> " + this.getText() + " -- ";
        }
        return "ERROR: " + file + "[line " + this._beginLine + ":" + this._beginColumn + "] -- ";
    }

    public String printWarningLocation() {
        String file = this._filename;
        file = file == null ? "" : file + " ";
        if (this.getText() != null) {
            return "WARNING: " + file + "[line " + this._beginLine + ":" + this._beginColumn + "] -> " + this.getText() + " -- ";
        }
        return "WARNING: " + file + "[line " + this._beginLine + ":" + this._beginColumn + "] -- ";
    }

    public String printInfoLocation() {
        return "INFO: " + this._filename + " -- line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    public static enum FunctCallOp {
        INTERNAL,
        EXTERNAL;

    }

    public static enum DataOp {
        READ,
        WRITE,
        RAND,
        MATRIX,
        FRAME,
        TENSOR,
        SQL,
        FEDERATED;

    }

    public static enum BooleanOp {
        CONDITIONALAND,
        CONDITIONALOR,
        LOGICALAND,
        LOGICALOR,
        NOT,
        INVALID;

    }

    public static enum RelationalOp {
        LESSEQUAL,
        LESS,
        GREATEREQUAL,
        GREATER,
        EQUAL,
        NOTEQUAL,
        INVALID;

    }

    public static enum BinaryOp {
        PLUS,
        MINUS,
        MULT,
        DIV,
        MODULUS,
        INTDIV,
        MATMULT,
        POW,
        INVALID;

    }
}

