/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.api;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apereo.cas.configuration.loader.CasConfigurationPropertiesLoader;
import org.apereo.cas.configuration.support.RelaxedPropertyNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;

@FunctionalInterface
public interface CasConfigurationPropertiesSourceLocator {
    public static final String BOOTSTRAP_PROPERTY_LOCATOR_BEAN_NAME = "casCoreBootstrapPropertySourceLocator";
    public static final Logger LOGGER = LoggerFactory.getLogger(CasConfigurationPropertiesSourceLocator.class);
    public static final String PROPERTY_CAS_STANDALONE_CONFIGURATION_FILE = "cas.standalone.configuration-file";
    public static final String PROPERTY_CAS_STANDALONE_CONFIGURATION_DIRECTORY = "cas.standalone.configuration-directory";
    public static final List<File> DEFAULT_CAS_CONFIG_DIRECTORIES = List.of(new File("/etc/cas/config"), new File("/opt/cas/config"), new File("/var/cas/config"));
    public static final String PROFILE_STANDALONE = "standalone";
    public static final String PROFILE_NATIVE = "native";
    public static final String PROFILE_EMBEDDED = "embedded";
    public static final String PROFILE_NONE = "none";

    public Optional<PropertySource<?>> locate(Environment var1, ResourceLoader var2);

    public static File getStandaloneProfileConfigurationDirectory(Environment environment) {
        if (environment.getActiveProfiles().length > 0 && Arrays.stream(environment.getActiveProfiles()).allMatch(profile -> profile.equalsIgnoreCase(PROFILE_NONE))) {
            LOGGER.info("Standalone configuration directory processing is skipped for profile [{}]", (Object)PROFILE_NONE);
            return null;
        }
        LinkedHashSet<String> values = new LinkedHashSet<String>(RelaxedPropertyNames.forCamelCase((String)PROPERTY_CAS_STANDALONE_CONFIGURATION_DIRECTORY).getValues());
        values.add(PROPERTY_CAS_STANDALONE_CONFIGURATION_DIRECTORY);
        File file = values.stream().map(key -> (File)environment.getProperty(key, File.class)).filter(Objects::nonNull).findFirst().orElse(null);
        if (file != null && file.exists()) {
            LOGGER.trace("Received standalone configuration directory [{}]", (Object)file);
            return file;
        }
        return DEFAULT_CAS_CONFIG_DIRECTORIES.stream().filter(File::exists).findFirst().orElse(null);
    }

    public static File getStandaloneProfileConfigurationFile(Environment environment) {
        LinkedHashSet<String> values = new LinkedHashSet<String>(RelaxedPropertyNames.forCamelCase((String)PROPERTY_CAS_STANDALONE_CONFIGURATION_FILE).getValues());
        values.add(PROPERTY_CAS_STANDALONE_CONFIGURATION_FILE);
        return values.stream().map(key -> (File)environment.getProperty(key, File.class)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static String getApplicationName(Environment environment) {
        return environment.getProperty("spring.application.name", "cas");
    }

    public static String getConfigurationName(Environment environment) {
        return environment.getProperty("spring.config.name", "cas");
    }

    public static List<CasConfigurationPropertiesLoader> getConfigurationPropertiesLoaders() {
        return ServiceLoader.load(CasConfigurationPropertiesLoader.class).stream().map(ServiceLoader.Provider::get).filter(Objects::nonNull).sorted((Comparator<CasConfigurationPropertiesLoader>)AnnotationAwareOrderComparator.INSTANCE).collect(Collectors.toList());
    }
}

