/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.InboundPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;
import org.apache.syncope.core.persistence.jpa.dao.repo.ExternalResourceRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class ExternalResourceRepoExtImpl
implements ExternalResourceRepoExt {
    protected final TaskDAO taskDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final RealmDAO realmDAO;
    protected final EntityManager entityManager;

    public ExternalResourceRepoExtImpl(TaskDAO taskDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, RealmDAO realmDAO, EntityManager entityManager) {
        this.taskDAO = taskDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.realmDAO = realmDAO;
        this.entityManager = entityManager;
    }

    @Override
    public ExternalResource authFind(String key) {
        ExternalResource resource = (ExternalResource)this.entityManager.find(JPAExternalResource.class, (Object)key);
        if (resource == null) {
            return null;
        }
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("RESOURCE_READ");
        if (authRealms == null || authRealms.isEmpty() || authRealms.stream().noneMatch(realm -> resource.getConnector() != null && resource.getConnector().getAdminRealm().getFullPath().startsWith((String)realm))) {
            throw new DelegatedAdministrationException(resource.getConnector().getAdminRealm().getFullPath(), ExternalResource.class.getSimpleName(), resource.getKey());
        }
        return resource;
    }

    @Override
    public List<ExternalResource> findByPolicy(Policy policy) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPAExternalResource.class.getSimpleName()).append(" e WHERE e.");
        if (AccountPolicy.class.isAssignableFrom(policy.getClass())) {
            queryString.append("accountPolicy");
        } else if (PasswordPolicy.class.isAssignableFrom(policy.getClass())) {
            queryString.append("passwordPolicy");
        } else if (PropagationPolicy.class.isAssignableFrom(policy.getClass())) {
            queryString.append("propagationPolicy");
        } else if (InboundPolicy.class.isAssignableFrom(policy.getClass())) {
            queryString.append("inboundPolicy");
        } else if (PushPolicy.class.isAssignableFrom(policy.getClass())) {
            queryString.append("pushPolicy");
        }
        TypedQuery query = this.entityManager.createQuery(queryString.append("=:policy").toString(), ExternalResource.class);
        query.setParameter("policy", (Object)policy);
        return query.getResultList();
    }

    @Override
    @Transactional(readOnly=true)
    public List<? extends ExternalResource> findAll() {
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("RESOURCE_LIST");
        if (CollectionUtils.isEmpty((Collection)authRealms)) {
            return List.of();
        }
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM  " + JPAExternalResource.class.getSimpleName() + " e", ExternalResource.class);
        return query.getResultList().stream().filter(resource -> authRealms.stream().anyMatch(realm -> resource.getConnector() != null && resource.getConnector().getAdminRealm().getFullPath().startsWith((String)realm))).toList();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public ExternalResource save(ExternalResource resource) {
        ((JPAExternalResource)resource).list2json();
        return (ExternalResource)this.entityManager.merge((Object)resource);
    }

    @Override
    public void deleteMapping(String schemaKey) {
        this.findAll().forEach(resource -> {
            MutableObject removed = new MutableObject((Object)false);
            resource.getProvisions().forEach(arg_0 -> ExternalResourceRepoExtImpl.lambda$deleteMapping$4((Mutable)removed, schemaKey, arg_0));
            if (((Boolean)removed.get()).booleanValue()) {
                this.entityManager.merge(resource);
            }
        });
    }

    @Override
    public void deleteById(String key) {
        ExternalResource resource = (ExternalResource)this.entityManager.find(JPAExternalResource.class, (Object)key);
        if (resource == null) {
            return;
        }
        this.taskDAO.deleteAll(resource, TaskType.PROPAGATION);
        this.taskDAO.deleteAll(resource, TaskType.LIVE_SYNC);
        this.taskDAO.deleteAll(resource, TaskType.PULL);
        this.taskDAO.deleteAll(resource, TaskType.PUSH);
        this.realmDAO.findByResources(resource).forEach(realm -> realm.getResources().remove(resource));
        this.anyObjectDAO.findByResourcesContaining(resource).forEach(anyObject -> anyObject.getResources().remove(resource));
        this.userDAO.findLinkedAccountsByResource(resource).forEach(account -> {
            account.getOwner().getLinkedAccounts().remove(account);
            account.setOwner(null);
        });
        this.userDAO.findByResourcesContaining(resource).forEach(user -> user.getResources().remove(resource));
        this.groupDAO.findByResourcesContaining(resource).forEach(group -> group.getResources().remove(resource));
        if (resource.getConnector() != null && resource.getConnector().getResources() != null && !resource.getConnector().getResources().isEmpty()) {
            resource.getConnector().getResources().remove(resource);
        }
        resource.setConnector(null);
        this.entityManager.remove((Object)resource);
    }

    private static /* synthetic */ void lambda$deleteMapping$4(Mutable removed, String schemaKey, Provision provision) {
        removed.setValue((Object)((Boolean)removed.get() != false || provision.getMapping() != null && provision.getMapping().getItems().removeIf(item -> schemaKey.equals(item.getIntAttrName())) ? 1 : 0));
    }
}

