/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.core.persistence.api.dao.MalformedPathException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.entity.JPARealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class JPARealmSearchDAO
implements RealmSearchDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(RealmSearchDAO.class);
    protected final EntityManager entityManager;

    protected static int setParameter(List<Object> parameters, Object parameter) {
        parameters.add(parameter);
        return parameters.size();
    }

    protected static StringBuilder buildDescendantsQuery(Set<String> bases, String keyword, List<Object> parameters) {
        String basesClause = bases.stream().map(base -> "e.fullPath=?" + JPARealmSearchDAO.setParameter(parameters, base) + " OR e.fullPath LIKE ?" + JPARealmSearchDAO.setParameter(parameters, "/".equals(base) ? "/%" : base + "/%")).collect(Collectors.joining(" OR "));
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPARealm.class.getSimpleName()).append(" e ").append("WHERE (").append(basesClause).append(')');
        if (keyword != null) {
            queryString.append(" AND LOWER(e.name) LIKE ?").append(JPARealmSearchDAO.setParameter(parameters, "%" + keyword.replaceAll("_", "\\\\_").toLowerCase() + "%"));
        }
        return queryString;
    }

    public JPARealmSearchDAO(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Transactional(readOnly=true)
    public Optional<Realm> findByFullPath(String fullPath) {
        if (StringUtils.isBlank((CharSequence)fullPath) || !"/".equals(fullPath) && !RealmDAO.PATH_PATTERN.matcher(fullPath).matches()) {
            throw new MalformedPathException(fullPath);
        }
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e.fullPath=:fullPath", Realm.class);
        query.setParameter("fullPath", (Object)fullPath);
        Realm result = null;
        try {
            result = (Realm)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("Realm with fullPath {} not found", (Object)fullPath, (Object)e);
        }
        return Optional.ofNullable(result);
    }

    public List<Realm> findByName(String name) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e.name=:name", Realm.class);
        query.setParameter("name", (Object)name);
        return query.getResultList();
    }

    public List<Realm> findChildren(Realm realm) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e.parent=:realm", Realm.class);
        query.setParameter("realm", (Object)realm);
        return query.getResultList();
    }

    public long countDescendants(String base, String keyword) {
        return this.countDescendants(Set.of(base), keyword);
    }

    public long countDescendants(Set<String> bases, String keyword) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder queryString = JPARealmSearchDAO.buildDescendantsQuery(bases, keyword, parameters);
        Query query = this.entityManager.createQuery(Strings.CS.replaceOnce(queryString.toString(), "SELECT e ", "SELECT COUNT(e) "));
        for (int i = 1; i <= parameters.size(); ++i) {
            query.setParameter(i, parameters.get(i - 1));
        }
        return ((Number)query.getSingleResult()).longValue();
    }

    public List<Realm> findDescendants(String base, String keyword, Pageable pageable) {
        return this.findDescendants(Set.of(base), keyword, pageable);
    }

    public List<Realm> findDescendants(Set<String> bases, String keyword, Pageable pageable) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder queryString = JPARealmSearchDAO.buildDescendantsQuery(bases, keyword, parameters);
        TypedQuery query = this.entityManager.createQuery(queryString.append(" ORDER BY e.fullPath").toString(), Realm.class);
        for (int i = 1; i <= parameters.size(); ++i) {
            query.setParameter(i, parameters.get(i - 1));
        }
        if (pageable.isPaged()) {
            query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
            query.setMaxResults(pageable.getPageSize());
        }
        return query.getResultList();
    }

    public List<String> findDescendants(String base, String prefix) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder queryString = JPARealmSearchDAO.buildDescendantsQuery(Set.of(base), null, parameters);
        TypedQuery query = this.entityManager.createQuery(queryString.append(" AND (e.fullPath=?").append(JPARealmSearchDAO.setParameter(parameters, prefix)).append(" OR e.fullPath LIKE ?").append(JPARealmSearchDAO.setParameter(parameters, "/".equals(prefix) ? "/%" : prefix + "/%")).append(')').append(" ORDER BY e.fullPath").toString(), Realm.class);
        for (int i = 1; i <= parameters.size(); ++i) {
            query.setParameter(i, parameters.get(i - 1));
        }
        return query.getResultList().stream().map(Entity::getKey).toList();
    }
}

