/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.configuration;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apereo.cas.client.configuration.BaseConfigurationStrategy;
import org.apereo.cas.client.configuration.ConfigurationKey;
import org.apereo.cas.client.util.CommonUtils;

public class JndiConfigurationStrategyImpl
extends BaseConfigurationStrategy {
    private static final String ENVIRONMENT_PREFIX = "java:comp/env/cas/";
    private final String environmentPrefix;
    private InitialContext context;
    private String simpleFilterName;

    public JndiConfigurationStrategyImpl() {
        this(ENVIRONMENT_PREFIX);
    }

    public JndiConfigurationStrategyImpl(String environmentPrefix) {
        this.environmentPrefix = environmentPrefix;
    }

    @Override
    public final void init(FilterConfig filterConfig, Class<? extends Filter> clazz) {
        this.simpleFilterName = clazz.getSimpleName();
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            this.logger.error("Unable to create InitialContext. No properties can be loaded via JNDI.", (Throwable)e);
        }
    }

    @Override
    protected final String get(ConfigurationKey configurationKey) {
        if (this.context == null) {
            return null;
        }
        String propertyName = configurationKey.getName();
        String filterValue = JndiConfigurationStrategyImpl.loadFromContext(this.context, this.environmentPrefix + this.simpleFilterName + "/" + propertyName);
        if (CommonUtils.isNotBlank(filterValue)) {
            this.logger.info("Property [{}] loaded from JNDI Filter Specific Property with value [{}]", (Object)propertyName, (Object)filterValue);
            return filterValue;
        }
        String rootValue = JndiConfigurationStrategyImpl.loadFromContext(this.context, this.environmentPrefix + propertyName);
        if (CommonUtils.isNotBlank(rootValue)) {
            this.logger.info("Property [{}] loaded from JNDI with value [{}]", (Object)propertyName, (Object)rootValue);
            return rootValue;
        }
        return null;
    }

    private static String loadFromContext(InitialContext context, String path) {
        try {
            return (String)context.lookup(path);
        }
        catch (NamingException e) {
            return null;
        }
    }
}

