/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkThread;
import org.apache.kafka.clients.consumer.internals.Deserializers;
import org.apache.kafka.clients.consumer.internals.Fetch;
import org.apache.kafka.clients.consumer.internals.FetchBuffer;
import org.apache.kafka.clients.consumer.internals.FetchCollector;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.FetchMetricsRegistry;
import org.apache.kafka.clients.consumer.internals.FetchRequestManager;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetFetcher;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.DelayedReceive;
import org.apache.kafka.test.MockSelector;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchRequestManagerTest {
    private static final double EPSILON = 1.0E-4;
    private final String topicName = "test";
    private final String groupId = "test-group";
    private final Uuid topicId = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = new HashMap<String, Uuid>(){
        {
            this.put("test", FetchRequestManagerTest.this.topicId);
        }
    };
    private final Map<Uuid, String> topicNames = Collections.singletonMap(this.topicId, "test");
    private final String metricGroup = "consumertest-group-fetch-manager-metrics";
    private final TopicPartition tp0 = new TopicPartition("test", 0);
    private final TopicPartition tp1 = new TopicPartition("test", 1);
    private final TopicPartition tp2 = new TopicPartition("test", 2);
    private final TopicPartition tp3 = new TopicPartition("test", 3);
    private final TopicIdPartition tidp0 = new TopicIdPartition(this.topicId, this.tp0);
    private final TopicIdPartition tidp1 = new TopicIdPartition(this.topicId, this.tp1);
    private final TopicIdPartition tidp2 = new TopicIdPartition(this.topicId, this.tp2);
    private final TopicIdPartition tidp3 = new TopicIdPartition(this.topicId, this.tp3);
    private final int validLeaderEpoch = 0;
    private final MetadataResponse initialUpdateResponse = RequestTestUtils.metadataUpdateWithIds(1, Collections.singletonMap("test", 4), this.topicIds);
    private final int minBytes = 1;
    private final int maxBytes = Integer.MAX_VALUE;
    private final int maxWaitMs = 0;
    private final int fetchSize = 1000;
    private final long retryBackoffMs = 100L;
    private final long requestTimeoutMs = 30000L;
    private final ApiVersions apiVersions = new ApiVersions();
    private MockTime time = new MockTime(1L);
    private SubscriptionState subscriptions;
    private ConsumerMetadata metadata;
    private FetchMetricsRegistry metricsRegistry;
    private FetchMetricsManager metricsManager;
    private MockClient client;
    private Metrics metrics;
    private TestableFetchRequestManager<?, ?> fetcher;
    private TestableNetworkClientDelegate networkClientDelegate;
    private OffsetFetcher offsetFetcher;
    private MemoryRecords records;
    private MemoryRecords nextRecords;
    private MemoryRecords emptyRecords;
    private MemoryRecords partialRecords;

    @BeforeEach
    public void setup() {
        this.records = this.buildRecords(1L, 3, 1L);
        this.nextRecords = this.buildRecords(4L, 2, 4L);
        this.emptyRecords = this.buildRecords(0L, 0, 0L);
        this.partialRecords = this.buildRecords(4L, 1, 0L);
        this.partialRecords.buffer().putInt(8, 10000);
    }

    private void assignFromUser(Set<TopicPartition> partitions) {
        this.subscriptions.assignFromUser(partitions);
        this.client.updateMetadata(this.initialUpdateResponse);
        this.metadata.updateWithCurrentRequestVersion(RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), Collections.singletonMap("test", 4), tp -> 0, this.topicIds), false, 0L);
    }

    private void assignFromUser(TopicPartition partition) {
        this.subscriptions.assignFromUser(Collections.singleton(partition));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(1, Collections.singletonMap(partition.topic(), 1), Collections.emptyMap()));
        this.metadata.update(9, RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), Collections.singletonMap(partition.topic(), 1), tp -> 0, this.topicIds), false, 0L);
    }

    @AfterEach
    public void teardown() throws Exception {
        if (this.metrics != null) {
            this.metrics.close();
        }
        if (this.fetcher != null) {
            this.fetcher.close();
        }
    }

    private int sendFetches() {
        this.offsetFetcher.validatePositionsOnMetadataChange();
        return ((TestableFetchRequestManager)this.fetcher).sendFetches();
    }

    @Test
    public void testFetchNormal() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp0));
        List records = partitionRecords.get(this.tp0);
        Assertions.assertEquals((int)3, (int)records.size());
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        long offset = 1L;
        for (ConsumerRecord record : records) {
            Assertions.assertEquals((long)offset, (long)record.offset());
            ++offset;
        }
    }

    @Test
    public void testInflightFetchOnPendingPartitions() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.subscriptions.markPendingRevocation(Collections.singleton(this.tp0));
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertNull(this.fetchRecords().get(this.tp0));
    }

    @Test
    public void testInflightFetchResultNotProcessedForPartitionsAwaitingCallbackCompletion() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.subscriptions.markPendingOnAssignedCallback(Collections.singleton(this.tp0), true);
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertNull(this.fetchRecords().get(this.tp0));
    }

    @Test
    public void testFetchResultNotProcessedForPartitionsAwaitingCallbackCompletion() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        this.assertNonEmptyFetch();
        this.subscriptions.markPendingOnAssignedCallback(Collections.singleton(this.tp0), true);
        Assertions.assertEquals((int)0, (int)this.sendFetches());
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.subscriptions.enablePartitionsAwaitingCallback(Collections.singleton(this.tp0));
        this.assertNonEmptyFetch();
    }

    private void assertNonEmptyFetch() {
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
    }

    @Test
    public void testCloseShouldBeIdempotent() {
        this.buildFetcher();
        this.fetcher.close();
        this.fetcher.close();
        this.fetcher.close();
        ((TestableFetchRequestManager)((Object)Mockito.verify(this.fetcher, (VerificationMode)Mockito.times((int)1)))).closeInternal((Timer)ArgumentMatchers.any(Timer.class));
    }

    @Test
    public void testFetcherCloseClosesFetchSessionsInBroker() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        FetchResponse fetchResponse = this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0);
        this.client.prepareResponse((AbstractResponse)fetchResponse);
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Assertions.assertEquals((int)0, (int)this.networkClientDelegate.pendingRequestCount());
        ArgumentCaptor argument = ArgumentCaptor.forClass(NetworkClientDelegate.UnsentRequest.class);
        Timer timer = this.time.timer(Duration.ofSeconds(10L));
        ConsumerNetworkThread.runAtClose(Collections.singletonList(Optional.of(this.fetcher)), (NetworkClientDelegate)this.networkClientDelegate);
        this.networkClientDelegate.poll(this.time.timer(1L));
        ((TestableNetworkClientDelegate)((Object)Mockito.verify((Object)((Object)this.networkClientDelegate), (VerificationMode)Mockito.times((int)2)))).doSend((NetworkClientDelegate.UnsentRequest)argument.capture(), (Long)ArgumentMatchers.any(Long.class));
        NetworkClientDelegate.UnsentRequest lastUnsentRequest = (NetworkClientDelegate.UnsentRequest)argument.getValue();
        FetchRequest.Builder builder = (FetchRequest.Builder)lastUnsentRequest.requestBuilder();
        Assertions.assertEquals((int)fetchResponse.sessionId(), (int)builder.metadata().sessionId());
        Assertions.assertEquals((int)-1, (int)builder.metadata().epoch());
        Assertions.assertTrue((boolean)builder.fetchData().isEmpty());
    }

    @Test
    public void testFetchingPendingPartitions() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        this.subscriptions.markPendingRevocation(Collections.singleton(this.tp0));
        Assertions.assertEquals((int)0, (int)this.sendFetches());
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
    }

    @Test
    public void testFetchWithNoTopicId() {
        this.buildFetcher();
        TopicIdPartition noId = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("noId", 0));
        this.assignFromUser(noId.topicPartition());
        this.subscriptions.seek(noId.topicPartition(), 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse(this.fetchRequestMatcher((short)12, noId, 0L, Optional.of(0)), (AbstractResponse)this.fullFetchResponse(noId, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)partitionRecords.containsKey(noId.topicPartition()));
        List records = partitionRecords.get(noId.topicPartition());
        Assertions.assertEquals((int)3, (int)records.size());
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)noId.topicPartition()).offset);
        long offset = 1L;
        for (ConsumerRecord record : records) {
            Assertions.assertEquals((long)offset, (long)record.offset());
            ++offset;
        }
    }

    @Test
    public void testFetchWithTopicId() {
        this.buildFetcher();
        TopicIdPartition tp = new TopicIdPartition(this.topicId, new TopicPartition("test", 0));
        this.assignFromUser(Collections.singleton(tp.topicPartition()));
        this.subscriptions.seek(tp.topicPartition(), 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse(this.fetchRequestMatcher(ApiKeys.FETCH.latestVersion(), tp, 0L, Optional.of(0)), (AbstractResponse)this.fullFetchResponse(tp, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)partitionRecords.containsKey(tp.topicPartition()));
        List records = partitionRecords.get(tp.topicPartition());
        Assertions.assertEquals((int)3, (int)records.size());
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)tp.topicPartition()).offset);
        long offset = 1L;
        for (ConsumerRecord record : records) {
            Assertions.assertEquals((long)offset, (long)record.offset());
            ++offset;
        }
    }

    @Test
    public void testFetchForgetTopicIdWhenUnassigned() {
        this.buildFetcher();
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        this.subscriptions.assignFromUser(Collections.singleton(foo.topicPartition()));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(1, Collections.singleton(foo), tp -> 0));
        this.subscriptions.seek(foo.topicPartition(), 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse(this.fetchRequestMatcher(ApiKeys.FETCH.latestVersion(), Collections.singletonMap(foo, new FetchRequest.PartitionData(foo.topicId(), 0L, -1L, 1000, Optional.of(0))), Collections.emptyList()), (AbstractResponse)this.fullFetchResponse(1, foo, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        this.subscriptions.assignFromUser(Collections.singleton(bar.topicPartition()));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(1, Collections.singleton(bar), tp -> 0));
        this.subscriptions.seek(bar.topicPartition(), 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse(this.fetchRequestMatcher(ApiKeys.FETCH.latestVersion(), Collections.singletonMap(bar, new FetchRequest.PartitionData(bar.topicId(), 0L, -1L, 1000, Optional.of(0))), Collections.singletonList(foo)), (AbstractResponse)this.fullFetchResponse(1, bar, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
    }

    @Test
    public void testFetchForgetTopicIdWhenReplaced() {
        this.buildFetcher();
        TopicIdPartition fooWithOldTopicId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition fooWithNewTopicId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        this.subscriptions.assignFromUser(Collections.singleton(fooWithOldTopicId.topicPartition()));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(1, Collections.singleton(fooWithOldTopicId), tp -> 0));
        this.subscriptions.seek(fooWithOldTopicId.topicPartition(), 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse(this.fetchRequestMatcher(ApiKeys.FETCH.latestVersion(), Collections.singletonMap(fooWithOldTopicId, new FetchRequest.PartitionData(fooWithOldTopicId.topicId(), 0L, -1L, 1000, Optional.of(0))), Collections.emptyList()), (AbstractResponse)this.fullFetchResponse(1, fooWithOldTopicId, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        this.subscriptions.assignFromUser(Collections.singleton(fooWithNewTopicId.topicPartition()));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(1, Collections.singleton(fooWithNewTopicId), tp -> 0));
        this.subscriptions.seek(fooWithNewTopicId.topicPartition(), 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse(this.fetchRequestMatcher(ApiKeys.FETCH.latestVersion(), Collections.singletonMap(fooWithNewTopicId, new FetchRequest.PartitionData(fooWithNewTopicId.topicId(), 0L, -1L, 1000, Optional.of(0))), Collections.singletonList(fooWithOldTopicId)), (AbstractResponse)this.fullFetchResponse(1, fooWithNewTopicId, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
    }

    @Test
    public void testFetchTopicIdUpgradeDowngrade() {
        this.buildFetcher();
        TopicIdPartition fooWithoutId = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 0));
        this.subscriptions.assignFromUser(Collections.singleton(fooWithoutId.topicPartition()));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(1, Collections.singleton(fooWithoutId), tp -> 0));
        this.subscriptions.seek(fooWithoutId.topicPartition(), 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse(this.fetchRequestMatcher((short)12, Collections.singletonMap(fooWithoutId, new FetchRequest.PartitionData(fooWithoutId.topicId(), 0L, -1L, 1000, Optional.of(0))), Collections.emptyList()), (AbstractResponse)this.fullFetchResponse(1, fooWithoutId, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        TopicIdPartition fooWithId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        this.subscriptions.assignFromUser(Collections.singleton(fooWithId.topicPartition()));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(1, Collections.singleton(fooWithId), tp -> 0));
        this.subscriptions.seek(fooWithId.topicPartition(), 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse(this.fetchRequestMatcher(ApiKeys.FETCH.latestVersion(), Collections.singletonMap(fooWithId, new FetchRequest.PartitionData(fooWithId.topicId(), 0L, -1L, 1000, Optional.of(0))), Collections.emptyList()), (AbstractResponse)this.fullFetchResponse(1, fooWithId, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        this.subscriptions.assignFromUser(Collections.singleton(fooWithoutId.topicPartition()));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(1, Collections.singleton(fooWithoutId), tp -> 0));
        this.subscriptions.seek(fooWithoutId.topicPartition(), 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse(this.fetchRequestMatcher((short)12, Collections.singletonMap(fooWithoutId, new FetchRequest.PartitionData(fooWithoutId.topicId(), 0L, -1L, 1000, Optional.of(0))), Collections.emptyList()), (AbstractResponse)this.fullFetchResponse(1, fooWithoutId, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
    }

    private MockClient.RequestMatcher fetchRequestMatcher(short expectedVersion, TopicIdPartition tp, long expectedFetchOffset, Optional<Integer> expectedCurrentLeaderEpoch) {
        return this.fetchRequestMatcher(expectedVersion, Collections.singletonMap(tp, new FetchRequest.PartitionData(tp.topicId(), expectedFetchOffset, -1L, 1000, expectedCurrentLeaderEpoch)), Collections.emptyList());
    }

    private MockClient.RequestMatcher fetchRequestMatcher(short expectedVersion, Map<TopicIdPartition, FetchRequest.PartitionData> fetch, List<TopicIdPartition> forgotten) {
        return body -> {
            if (body instanceof FetchRequest) {
                FetchRequest fetchRequest = (FetchRequest)body;
                Assertions.assertEquals((short)expectedVersion, (short)fetchRequest.version());
                Assertions.assertEquals((Object)fetch, (Object)fetchRequest.fetchData(this.topicNames(new ArrayList<TopicIdPartition>(fetch.keySet()))));
                Assertions.assertEquals((Object)forgotten, (Object)fetchRequest.forgottenTopics(this.topicNames(forgotten)));
                return true;
            }
            Assertions.fail((String)"Should have seen FetchRequest");
            return false;
        };
    }

    private Map<Uuid, String> topicNames(List<TopicIdPartition> partitions) {
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        partitions.forEach(partition -> topicNames.putIfAbsent(partition.topicId(), partition.topic()));
        return topicNames;
    }

    @Test
    public void testMissingLeaderEpochInRecords() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)0, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)System.currentTimeMillis(), (int)-1);
        builder.append(0L, "key".getBytes(), "1".getBytes());
        builder.append(0L, "key".getBytes(), "2".getBytes());
        MemoryRecords records = builder.build();
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp0));
        Assertions.assertEquals((int)2, (int)partitionRecords.get(this.tp0).size());
        for (ConsumerRecord record : partitionRecords.get(this.tp0)) {
            Assertions.assertEquals(Optional.empty(), (Object)record.leaderEpoch());
        }
    }

    @Test
    public void testLeaderEpochInConsumerRecord() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        int partitionLeaderEpoch = 1;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)System.currentTimeMillis(), (int)partitionLeaderEpoch);
        builder.append(0L, "key".getBytes(), Integer.toString(partitionLeaderEpoch).getBytes());
        builder.append(0L, "key".getBytes(), Integer.toString(partitionLeaderEpoch).getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)2L, (long)System.currentTimeMillis(), (int)(partitionLeaderEpoch += 7));
        builder.append(0L, "key".getBytes(), Integer.toString(partitionLeaderEpoch).getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)3L, (long)System.currentTimeMillis(), (int)(partitionLeaderEpoch += 5));
        builder.append(0L, "key".getBytes(), Integer.toString(partitionLeaderEpoch).getBytes());
        builder.append(0L, "key".getBytes(), Integer.toString(partitionLeaderEpoch).getBytes());
        builder.append(0L, "key".getBytes(), Integer.toString(partitionLeaderEpoch).getBytes());
        builder.close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp0));
        Assertions.assertEquals((int)6, (int)partitionRecords.get(this.tp0).size());
        for (ConsumerRecord record : partitionRecords.get(this.tp0)) {
            int expectedLeaderEpoch = Integer.parseInt(Utils.utf8((byte[])((byte[])record.value())));
            Assertions.assertEquals(Optional.of(expectedLeaderEpoch), (Object)record.leaderEpoch());
        }
    }

    @Test
    public void testClearBufferedDataForTopicPartitions() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        HashSet<TopicPartition> newAssignedTopicPartitions = new HashSet<TopicPartition>();
        newAssignedTopicPartitions.add(this.tp1);
        ((TestableFetchRequestManager)this.fetcher).clearBufferedDataForUnassignedPartitions(newAssignedTopicPartitions);
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
    }

    @Test
    public void testFetchSkipsBlackedOutNodes() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Node node = (Node)this.initialUpdateResponse.brokers().iterator().next();
        this.client.backoff(node, 500L);
        Assertions.assertEquals((int)0, (int)this.sendFetches());
        this.time.sleep(500L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
    }

    @Test
    public void testFetcherIgnoresControlRecords() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        long producerId = 1L;
        short producerEpoch = 0;
        int baseSequence = 0;
        int partitionLeaderEpoch = 0;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.idempotentBuilder((ByteBuffer)buffer, (Compression)Compression.NONE, (long)0L, (long)producerId, (short)producerEpoch, (int)baseSequence);
        builder.append(0L, "key".getBytes(), null);
        builder.close();
        MemoryRecords.writeEndTransactionalMarker((ByteBuffer)buffer, (long)1L, (long)this.time.milliseconds(), (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 0));
        buffer.flip();
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, MemoryRecords.readableRecords((ByteBuffer)buffer), Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp0));
        List records = partitionRecords.get(this.tp0);
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((long)2L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        ConsumerRecord record = records.get(0);
        Assertions.assertArrayEquals((byte[])"key".getBytes(), (byte[])((byte[])record.key()));
    }

    @Test
    public void testFetchError() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NOT_LEADER_OR_FOLLOWER, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertFalse((boolean)partitionRecords.containsKey(this.tp0));
    }

    private MockClient.RequestMatcher matchesOffset(TopicIdPartition tp, long offset) {
        return body -> {
            FetchRequest fetch = (FetchRequest)body;
            Map fetchData = fetch.fetchData(this.topicNames);
            return fetchData.containsKey(tp) && ((FetchRequest.PartitionData)fetchData.get((Object)tp)).fetchOffset == offset;
        };
    }

    @Test
    public void testFetchedRecordsRaisesOnSerializationErrors() {
        ByteArrayDeserializer deserializer = new ByteArrayDeserializer(){
            int i = 0;

            public byte[] deserialize(String topic, byte[] data) {
                if (this.i++ % 2 == 1) {
                    Assertions.assertEquals((Object)"value-1", (Object)new String(data, StandardCharsets.UTF_8));
                    throw new SerializationException();
                }
                return data;
            }
        };
        this.buildFetcher((Deserializer<?>)deserializer, (Deserializer<?>)deserializer);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 1L);
        this.client.prepareResponse(this.matchesOffset(this.tidp0, 1L), (AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.networkClientDelegate.poll(this.time.timer(0L));
        for (int i = 0; i < 2; ++i) {
            Assertions.assertThrows(SerializationException.class, this::collectFetch);
            Assertions.assertEquals((long)1L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        }
    }

    @Test
    public void testParseCorruptedRecord() throws Exception {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufferOutputStream(buffer));
        byte magic = 1;
        byte[] key = "foo".getBytes();
        byte[] value = "baz".getBytes();
        long offset = 0L;
        long timestamp = 500L;
        int size = LegacyRecord.recordSize((byte)magic, (int)key.length, (int)value.length);
        byte attributes = LegacyRecord.computeAttributes((byte)magic, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME);
        long crc = LegacyRecord.computeChecksum((byte)magic, (byte)attributes, (long)timestamp, (byte[])key, (byte[])value);
        out.writeLong(offset);
        out.writeInt(size);
        LegacyRecord.write((DataOutputStream)out, (byte)magic, (long)crc, (byte)LegacyRecord.computeAttributes((byte)magic, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME), (long)timestamp, (byte[])key, (byte[])value);
        out.writeLong(offset + 1L);
        out.writeInt(size);
        LegacyRecord.write((DataOutputStream)out, (byte)magic, (long)(crc + 1L), (byte)LegacyRecord.computeAttributes((byte)magic, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME), (long)timestamp, (byte[])key, (byte[])value);
        out.writeLong(offset + 2L);
        out.writeInt(size);
        LegacyRecord.write((DataOutputStream)out, (byte)magic, (long)crc, (byte)LegacyRecord.computeAttributes((byte)magic, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME), (long)timestamp, (byte[])key, (byte[])value);
        out.writeLong(offset + 3L);
        out.writeInt(1);
        out.writeLong(offset + 4L);
        out.writeInt(size);
        LegacyRecord.write((DataOutputStream)out, (byte)magic, (long)crc, (byte)LegacyRecord.computeAttributes((byte)magic, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME), (long)timestamp, (byte[])key, (byte[])value);
        buffer.flip();
        this.subscriptions.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.empty(), this.metadata.currentLeader(this.tp0)));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, MemoryRecords.readableRecords((ByteBuffer)buffer), Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertEquals((int)1, (int)this.fetchRecords().get(this.tp0).size());
        Assertions.assertEquals((long)1L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        this.ensureBlockOnRecord(1L);
        this.seekAndConsumeRecord(buffer, 2L);
        this.ensureBlockOnRecord(3L);
        try {
            this.seekAndConsumeRecord(buffer, 4L);
            Assertions.fail((String)"Should have thrown exception when fail to retrieve a record from iterator.");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
        this.ensureBlockOnRecord(4L);
    }

    private void ensureBlockOnRecord(long blockedOffset) {
        for (int i = 0; i < 2; ++i) {
            Assertions.assertThrows(KafkaException.class, this::fetchRecords);
            Assertions.assertEquals((long)blockedOffset, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        }
    }

    private void seekAndConsumeRecord(ByteBuffer responseBuffer, long toOffset) {
        this.subscriptions.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(toOffset, Optional.empty(), this.metadata.currentLeader(this.tp0)));
        this.collectFetch();
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, MemoryRecords.readableRecords((ByteBuffer)responseBuffer), Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Map recordsByPartition = this.fetchRecords();
        List records = recordsByPartition.get(this.tp0);
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((long)toOffset, (long)records.get(0).offset());
        Assertions.assertEquals((long)(toOffset + 1L), (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
    }

    @Test
    public void testInvalidDefaultRecordBatch() {
        this.buildFetcher();
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        ByteBufferOutputStream out = new ByteBufferOutputStream(buffer);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(out, 2, (Compression)Compression.NONE, TimestampType.CREATE_TIME, 0L, 10L, 0L, 0, 0, false, false, 0, 1024);
        builder.append(10L, "key".getBytes(), "value".getBytes());
        builder.close();
        buffer.flip();
        buffer.position(17);
        buffer.put("beef".getBytes());
        buffer.position(0);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, MemoryRecords.readableRecords((ByteBuffer)buffer), Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        for (int i = 0; i < 2; ++i) {
            Assertions.assertThrows(KafkaException.class, this::collectFetch);
            Assertions.assertEquals((long)0L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        }
    }

    @Test
    public void testParseInvalidRecordBatch() {
        this.buildFetcher();
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        ByteBuffer buffer = records.buffer();
        buffer.putInt(32, buffer.get(32) ^ 0x5332717);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, MemoryRecords.readableRecords((ByteBuffer)buffer), Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertThrows(KafkaException.class, this::collectFetch);
        Assertions.assertEquals((long)0L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
    }

    @Test
    public void testHeaders() {
        this.buildFetcher();
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(0L, "key".getBytes(), "value-1".getBytes());
        Header[] headersArray = new Header[]{new RecordHeader("headerKey", "headerValue".getBytes(StandardCharsets.UTF_8))};
        builder.append(0L, "key".getBytes(), "value-2".getBytes(), headersArray);
        Header[] headersArray2 = new Header[]{new RecordHeader("headerKey", "headerValue".getBytes(StandardCharsets.UTF_8)), new RecordHeader("headerKey", "headerValue2".getBytes(StandardCharsets.UTF_8))};
        builder.append(0L, "key".getBytes(), "value-3".getBytes(), headersArray2);
        MemoryRecords memoryRecords = builder.build();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 1L);
        this.client.prepareResponse(this.matchesOffset(this.tidp0, 1L), (AbstractResponse)this.fullFetchResponse(this.tidp0, memoryRecords, Errors.NONE, 100L, 0));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.networkClientDelegate.poll(this.time.timer(0L));
        Map recordsByPartition = this.fetchRecords();
        List records = recordsByPartition.get(this.tp0);
        Assertions.assertEquals((int)3, (int)records.size());
        Iterator recordIterator = records.iterator();
        ConsumerRecord record = recordIterator.next();
        Assertions.assertNull((Object)record.headers().lastHeader("headerKey"));
        record = recordIterator.next();
        Assertions.assertEquals((Object)"headerValue", (Object)new String(record.headers().lastHeader("headerKey").value(), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"headerKey", (Object)record.headers().lastHeader("headerKey").key());
        record = recordIterator.next();
        Assertions.assertEquals((Object)"headerValue2", (Object)new String(record.headers().lastHeader("headerKey").value(), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"headerKey", (Object)record.headers().lastHeader("headerKey").key());
    }

    @Test
    public void testFetchMaxPollRecords() {
        this.buildFetcher(2);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 1L);
        this.client.prepareResponse(this.matchesOffset(this.tidp0, 1L), (AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.client.prepareResponse(this.matchesOffset(this.tidp0, 4L), (AbstractResponse)this.fullFetchResponse(this.tidp0, this.nextRecords, Errors.NONE, 100L, 0));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.networkClientDelegate.poll(this.time.timer(0L));
        Map recordsByPartition = this.fetchRecords();
        List recordsToTest = recordsByPartition.get(this.tp0);
        Assertions.assertEquals((int)2, (int)recordsToTest.size());
        Assertions.assertEquals((long)3L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        Assertions.assertEquals((long)1L, (long)recordsToTest.get(0).offset());
        Assertions.assertEquals((long)2L, (long)recordsToTest.get(1).offset());
        Assertions.assertEquals((int)0, (int)this.sendFetches());
        this.networkClientDelegate.poll(this.time.timer(0L));
        recordsByPartition = this.fetchRecords();
        recordsToTest = recordsByPartition.get(this.tp0);
        Assertions.assertEquals((int)1, (int)recordsToTest.size());
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        Assertions.assertEquals((long)3L, (long)recordsToTest.get(0).offset());
        Assertions.assertTrue((this.sendFetches() > 0 ? 1 : 0) != 0);
        this.networkClientDelegate.poll(this.time.timer(0L));
        recordsByPartition = this.fetchRecords();
        recordsToTest = recordsByPartition.get(this.tp0);
        Assertions.assertEquals((int)2, (int)recordsToTest.size());
        Assertions.assertEquals((long)6L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        Assertions.assertEquals((long)4L, (long)recordsToTest.get(0).offset());
        Assertions.assertEquals((long)5L, (long)recordsToTest.get(1).offset());
    }

    @Test
    public void testFetchAfterPartitionWithFetchedRecordsIsUnassigned() {
        this.buildFetcher(2);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 1L);
        this.client.prepareResponse(this.matchesOffset(this.tidp0, 1L), (AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.networkClientDelegate.poll(this.time.timer(0L));
        Map recordsByPartition = this.fetchRecords();
        List recordsToTest = recordsByPartition.get(this.tp0);
        Assertions.assertEquals((int)2, (int)recordsToTest.size());
        Assertions.assertEquals((long)3L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        Assertions.assertEquals((long)1L, (long)recordsToTest.get(0).offset());
        Assertions.assertEquals((long)2L, (long)recordsToTest.get(1).offset());
        this.assignFromUser(Collections.singleton(this.tp1));
        this.client.prepareResponse(this.matchesOffset(this.tidp1, 4L), (AbstractResponse)this.fullFetchResponse(this.tidp1, this.nextRecords, Errors.NONE, 100L, 0));
        this.subscriptions.seek(this.tp1, 4L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.networkClientDelegate.poll(this.time.timer(0L));
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertNull(fetchedRecords.get(this.tp0));
        recordsToTest = fetchedRecords.get(this.tp1);
        Assertions.assertEquals((int)2, (int)recordsToTest.size());
        Assertions.assertEquals((long)6L, (long)this.subscriptions.position((TopicPartition)this.tp1).offset);
        Assertions.assertEquals((long)4L, (long)recordsToTest.get(0).offset());
        Assertions.assertEquals((long)5L, (long)recordsToTest.get(1).offset());
    }

    @Test
    public void testFetchNonContinuousRecords() {
        this.buildFetcher();
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(15L, 0L, "key".getBytes(), "value-1".getBytes());
        builder.appendWithOffset(20L, 0L, "key".getBytes(), "value-2".getBytes());
        builder.appendWithOffset(30L, 0L, "key".getBytes(), "value-3".getBytes());
        MemoryRecords records = builder.build();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Map recordsByPartition = this.fetchRecords();
        List consumerRecords = recordsByPartition.get(this.tp0);
        Assertions.assertEquals((int)3, (int)consumerRecords.size());
        Assertions.assertEquals((long)31L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        Assertions.assertEquals((long)15L, (long)consumerRecords.get(0).offset());
        Assertions.assertEquals((long)20L, (long)consumerRecords.get(1).offset());
        Assertions.assertEquals((long)30L, (long)consumerRecords.get(2).offset());
    }

    @Test
    public void testFetchRequestWhenRecordTooLarge() {
        try {
            this.buildFetcher();
            this.client.setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.FETCH.id, (short)2, (short)2));
            this.makeFetchRequestWithIncompleteRecord();
            Assertions.assertThrows(RecordTooLargeException.class, this::collectFetch);
            Assertions.assertEquals((long)0L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        }
        finally {
            this.client.setNodeApiVersions(NodeApiVersions.create());
        }
    }

    @Test
    public void testFetchRequestInternalError() {
        this.buildFetcher();
        this.makeFetchRequestWithIncompleteRecord();
        try {
            this.collectFetch();
            Assertions.fail((String)"collectFetch should have thrown a KafkaException");
        }
        catch (KafkaException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Failed to make progress reading messages"));
            Assertions.assertEquals((long)0L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        }
    }

    private void makeFetchRequestWithIncompleteRecord() {
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        MemoryRecords partialRecord = MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}));
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, partialRecord, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
    }

    @Test
    public void testUnauthorizedTopic() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.TOPIC_AUTHORIZATION_FAILED, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        try {
            this.collectFetch();
            Assertions.fail((String)"collectFetch should have thrown a TopicAuthorizationException");
        }
        catch (TopicAuthorizationException e) {
            Assertions.assertEquals(Collections.singleton("test"), (Object)e.unauthorizedTopics());
        }
    }

    @Test
    public void testFetchDuringEagerRebalance() {
        this.buildFetcher();
        this.subscriptions.subscribe(Collections.singleton("test"), Optional.empty());
        this.subscriptions.assignFromSubscribed(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(1, Collections.singletonMap("test", 4), tp -> 0, this.topicIds));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.subscriptions.assignFromSubscribed(Collections.emptyList());
        this.subscriptions.assignFromSubscribed(Collections.singleton(this.tp0));
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetchRecords().isEmpty());
    }

    @Test
    public void testFetchDuringCooperativeRebalance() {
        this.buildFetcher();
        this.subscriptions.subscribe(Collections.singleton("test"), Optional.empty());
        this.subscriptions.assignFromSubscribed(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(1, Collections.singletonMap("test", 4), tp -> 0, this.topicIds));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.subscriptions.assignFromSubscribed(Collections.singleton(this.tp0));
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertEquals((int)1, (int)fetchedRecords.size());
        Assertions.assertEquals((int)3, (int)fetchedRecords.get(this.tp0).size());
    }

    @Test
    public void testInFlightFetchOnPausedPartition() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.subscriptions.pause(this.tp0);
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertNull(this.fetchRecords().get(this.tp0));
    }

    @Test
    public void testFetchOnPausedPartition() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        this.subscriptions.pause(this.tp0);
        Assertions.assertFalse((this.sendFetches() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.client.requests().isEmpty());
    }

    @Test
    public void testFetchOnCompletedFetchesForPausedAndResumedPartitions() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.subscriptions.pause(this.tp0);
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.assertEmptyFetch("Should not return any records or advance position when partition is paused");
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches(), (String)"Should still contain completed fetches");
        Assertions.assertFalse((boolean)this.fetcher.hasAvailableFetches(), (String)"Should not have any available (non-paused) completed fetches");
        Assertions.assertEquals((int)0, (int)this.sendFetches());
        this.subscriptions.resume(this.tp0);
        Assertions.assertTrue((boolean)this.fetcher.hasAvailableFetches(), (String)"Should have available (non-paused) completed fetches");
        this.networkClientDelegate.poll(this.time.timer(0L));
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertEquals((int)1, (int)fetchedRecords.size(), (String)"Should return records when partition is resumed");
        Assertions.assertNotNull(fetchedRecords.get(this.tp0));
        Assertions.assertEquals((int)3, (int)fetchedRecords.get(this.tp0).size());
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.assertEmptyFetch("Should not return records or advance position after previously paused partitions are fetched");
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches(), (String)"Should no longer contain completed fetches");
    }

    @Test
    public void testFetchOnCompletedFetchesForSomePausedPartitions() {
        this.buildFetcher();
        this.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1}));
        this.subscriptions.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(1L, Optional.empty(), this.metadata.currentLeader(this.tp0)));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.subscriptions.seekUnvalidated(this.tp1, new SubscriptionState.FetchPosition(1L, Optional.empty(), this.metadata.currentLeader(this.tp1)));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp1, this.nextRecords, Errors.NONE, 100L, 0));
        this.subscriptions.pause(this.tp0);
        this.networkClientDelegate.poll(this.time.timer(0L));
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertEquals((int)1, (int)fetchedRecords.size(), (String)"Should return completed fetch for unpaused partitions");
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches(), (String)"Should still contain completed fetches");
        Assertions.assertNotNull(fetchedRecords.get(this.tp1));
        Assertions.assertNull(fetchedRecords.get(this.tp0));
        this.assertEmptyFetch("Should not return records or advance position for remaining paused partition");
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches(), (String)"Should still contain completed fetches");
    }

    @Test
    public void testFetchOnCompletedFetchesForAllPausedPartitions() {
        this.buildFetcher();
        this.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1}));
        this.subscriptions.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(1L, Optional.empty(), this.metadata.currentLeader(this.tp0)));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.subscriptions.seekUnvalidated(this.tp1, new SubscriptionState.FetchPosition(1L, Optional.empty(), this.metadata.currentLeader(this.tp1)));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp1, this.nextRecords, Errors.NONE, 100L, 0));
        this.subscriptions.pause(this.tp0);
        this.subscriptions.pause(this.tp1);
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.assertEmptyFetch("Should not return records or advance position for all paused partitions");
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches(), (String)"Should still contain completed fetches");
        Assertions.assertFalse((boolean)this.fetcher.hasAvailableFetches(), (String)"Should not have any available (non-paused) completed fetches");
    }

    @Test
    public void testPartialFetchWithPausedPartitions() {
        this.buildFetcher(2);
        this.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1}));
        this.subscriptions.seek(this.tp0, 1L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertEquals((int)2, (int)fetchedRecords.get(this.tp0).size(), (String)"Should return 2 records from fetch with 3 records");
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches(), (String)"Should have no completed fetches");
        this.subscriptions.pause(this.tp0);
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.assertEmptyFetch("Should not return records or advance position for paused partitions");
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches(), (String)"Should have 1 entry in completed fetches");
        Assertions.assertFalse((boolean)this.fetcher.hasAvailableFetches(), (String)"Should not have any available (non-paused) completed fetches");
        this.subscriptions.resume(this.tp0);
        this.networkClientDelegate.poll(this.time.timer(0L));
        fetchedRecords = this.fetchRecords();
        Assertions.assertEquals((int)1, (int)fetchedRecords.get(this.tp0).size(), (String)"Should return last remaining record");
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches(), (String)"Should have no completed fetches");
    }

    @Test
    public void testFetchDiscardedAfterPausedPartitionResumedAndSeekedToNewOffset() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.subscriptions.pause(this.tp0);
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.subscriptions.seek(this.tp0, 3L);
        this.subscriptions.resume(this.tp0);
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches(), (String)"Should have 1 entry in completed fetches");
        Fetch fetch = this.collectFetch();
        Assertions.assertEquals(Collections.emptyMap(), (Object)fetch.records(), (String)"Should not return any records because we seeked to a new offset");
        Assertions.assertFalse((boolean)fetch.positionAdvanced());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches(), (String)"Should have no completed fetches");
    }

    @Test
    public void testFetchSessionIdError() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fetchResponseWithTopLevelError(this.tidp0, Errors.FETCH_SESSION_TOPIC_ID_ERROR, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.assertEmptyFetch("Should not return records or advance position on fetch error");
        Assertions.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(this.time.milliseconds()));
    }

    @ParameterizedTest
    @MethodSource(value={"handleFetchResponseErrorSupplier"})
    public void testHandleFetchResponseError(Errors error, long highWatermark, boolean hasTopLevelError, boolean shouldRequestMetadataUpdate) {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        FetchResponse fetchResponse = hasTopLevelError ? this.fetchResponseWithTopLevelError(this.tidp0, error, 0) : this.fullFetchResponse(this.tidp0, this.records, error, highWatermark, 0);
        this.client.prepareResponse((AbstractResponse)fetchResponse);
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.assertEmptyFetch("Should not return records or advance position on fetch error");
        long timeToNextUpdate = this.metadata.timeToNextUpdate(this.time.milliseconds());
        if (shouldRequestMetadataUpdate) {
            Assertions.assertEquals((long)0L, (long)timeToNextUpdate, (String)"Should have requested metadata update");
        } else {
            Assertions.assertNotEquals((long)0L, (long)timeToNextUpdate, (String)"Should not have requested metadata update");
        }
    }

    private static Stream<Arguments> handleFetchResponseErrorSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{Errors.NOT_LEADER_OR_FOLLOWER, 100L, false, true}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_TOPIC_OR_PARTITION, 100L, false, true}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_TOPIC_ID, -1L, false, true}), Arguments.of((Object[])new Object[]{Errors.FETCH_SESSION_TOPIC_ID_ERROR, -1L, true, true}), Arguments.of((Object[])new Object[]{Errors.INCONSISTENT_TOPIC_ID, -1L, false, true}), Arguments.of((Object[])new Object[]{Errors.FENCED_LEADER_EPOCH, 100L, false, true}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_LEADER_EPOCH, 100L, false, false}));
    }

    @Test
    public void testEpochSetInFetchRequest() {
        this.buildFetcher();
        this.subscriptions.assignFromUser(Collections.singleton(this.tp0));
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), Collections.singletonMap("test", 4), tp -> 99, this.topicIds);
        this.client.updateMetadata(metadataResponse);
        this.subscriptions.seek(this.tp0, 10L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        MockClient.RequestMatcher matcher = body -> {
            if (body instanceof FetchRequest) {
                FetchRequest fetchRequest = (FetchRequest)body;
                fetchRequest.fetchData(this.topicNames).values().forEach(partitionData -> {
                    Assertions.assertTrue((boolean)partitionData.currentLeaderEpoch.isPresent(), (String)"Expected Fetcher to set leader epoch in request");
                    Assertions.assertEquals((long)99L, (long)((Integer)partitionData.currentLeaderEpoch.get()).longValue(), (String)"Expected leader epoch to match epoch from metadata update");
                });
                return true;
            }
            Assertions.fail((String)"Should have seen FetchRequest");
            return false;
        };
        this.client.prepareResponse(matcher, (AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.pollNoWakeup();
        Assertions.assertEquals((int)0, (int)this.networkClientDelegate.pendingRequestCount());
    }

    @Test
    public void testFetchOffsetOutOfRange() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.OFFSET_OUT_OF_RANGE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.assertEmptyFetch("Should not return records or advance position on fetch error");
        Assertions.assertTrue((boolean)this.subscriptions.isOffsetResetNeeded(this.tp0));
        Assertions.assertNull((Object)this.subscriptions.validPosition(this.tp0));
        Assertions.assertNull((Object)this.subscriptions.position(this.tp0));
    }

    @Test
    public void testStaleOutOfRangeError() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.OFFSET_OUT_OF_RANGE, 100L, 0));
        this.subscriptions.seek(this.tp0, 1L);
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.assertEmptyFetch("Should not return records or advance position on fetch error");
        Assertions.assertFalse((boolean)this.subscriptions.isOffsetResetNeeded(this.tp0));
        Assertions.assertEquals((long)1L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
    }

    @Test
    public void testFetchedRecordsAfterSeek() {
        this.buildFetcher(OffsetResetStrategy.NONE, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), 2, IsolationLevel.READ_UNCOMMITTED);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertTrue((this.sendFetches() > 0 ? 1 : 0) != 0);
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.OFFSET_OUT_OF_RANGE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertFalse((boolean)this.subscriptions.isOffsetResetNeeded(this.tp0));
        this.subscriptions.seek(this.tp0, 2L);
        this.assertEmptyFetch("Should not return records or advance position after seeking to end of topic partition");
    }

    @Test
    public void testFetchOffsetOutOfRangeException() {
        this.buildFetcher(OffsetResetStrategy.NONE, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), 2, IsolationLevel.READ_UNCOMMITTED);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        this.sendFetches();
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.OFFSET_OUT_OF_RANGE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertFalse((boolean)this.subscriptions.isOffsetResetNeeded(this.tp0));
        for (int i = 0; i < 2; ++i) {
            OffsetOutOfRangeException e = (OffsetOutOfRangeException)Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.collectFetch());
            Assertions.assertEquals(Collections.singleton(this.tp0), e.offsetOutOfRangePartitions().keySet());
            Assertions.assertEquals((long)0L, (long)((Long)e.offsetOutOfRangePartitions().get(this.tp0)));
        }
    }

    @Test
    public void testFetchPositionAfterException() {
        this.buildFetcher(OffsetResetStrategy.NONE, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_UNCOMMITTED);
        this.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1}));
        this.subscriptions.seek(this.tp0, 1L);
        this.subscriptions.seek(this.tp1, 1L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> partitions = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        partitions.put(this.tidp1, new FetchResponseData.PartitionData().setPartitionIndex(this.tp1.partition()).setHighWatermark(100L).setRecords((BaseRecords)this.records));
        partitions.put(this.tidp0, new FetchResponseData.PartitionData().setPartitionIndex(this.tp0.partition()).setErrorCode(Errors.OFFSET_OUT_OF_RANGE.code()).setHighWatermark(100L));
        this.client.prepareResponse((AbstractResponse)FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, new LinkedHashMap(partitions)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        ArrayList<ConsumerRecord<byte[], byte[]>> allFetchedRecords = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        this.fetchRecordsInto(allFetchedRecords);
        Assertions.assertEquals((long)1L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)this.tp1).offset);
        Assertions.assertEquals((int)3, (int)allFetchedRecords.size());
        OffsetOutOfRangeException e = (OffsetOutOfRangeException)Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.fetchRecordsInto(allFetchedRecords));
        Assertions.assertEquals(Collections.singleton(this.tp0), e.offsetOutOfRangePartitions().keySet());
        Assertions.assertEquals((long)1L, (long)((Long)e.offsetOutOfRangePartitions().get(this.tp0)));
        Assertions.assertEquals((long)1L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)this.tp1).offset);
        Assertions.assertEquals((int)3, (int)allFetchedRecords.size());
    }

    private void fetchRecordsInto(List<ConsumerRecord<byte[], byte[]>> allFetchedRecords) {
        Map fetchedRecords = this.fetchRecords();
        fetchedRecords.values().forEach(allFetchedRecords::addAll);
    }

    @Test
    public void testCompletedFetchRemoval() {
        this.buildFetcher(OffsetResetStrategy.NONE, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_UNCOMMITTED);
        this.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1, this.tp2, this.tp3}));
        this.subscriptions.seek(this.tp0, 1L);
        this.subscriptions.seek(this.tp1, 1L);
        this.subscriptions.seek(this.tp2, 1L);
        this.subscriptions.seek(this.tp3, 1L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> partitions = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        partitions.put(this.tidp1, new FetchResponseData.PartitionData().setPartitionIndex(this.tp1.partition()).setHighWatermark(100L).setRecords((BaseRecords)this.records));
        partitions.put(this.tidp0, new FetchResponseData.PartitionData().setPartitionIndex(this.tp0.partition()).setErrorCode(Errors.OFFSET_OUT_OF_RANGE.code()).setHighWatermark(100L));
        partitions.put(this.tidp2, new FetchResponseData.PartitionData().setPartitionIndex(this.tp2.partition()).setHighWatermark(100L).setLastStableOffset(4L).setLogStartOffset(0L).setRecords((BaseRecords)this.nextRecords));
        partitions.put(this.tidp3, new FetchResponseData.PartitionData().setPartitionIndex(this.tp3.partition()).setHighWatermark(100L).setLastStableOffset(4L).setLogStartOffset(0L).setRecords((BaseRecords)this.partialRecords));
        this.client.prepareResponse((AbstractResponse)FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, new LinkedHashMap(partitions)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        ArrayList<ConsumerRecord<byte[], byte[]>> fetchedRecords = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        this.fetchRecordsInto(fetchedRecords);
        Assertions.assertEquals((long)fetchedRecords.size(), (long)(this.subscriptions.position((TopicPartition)this.tp1).offset - 1L));
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)this.tp1).offset);
        Assertions.assertEquals((int)3, (int)fetchedRecords.size());
        ArrayList<OffsetOutOfRangeException> oorExceptions = new ArrayList<OffsetOutOfRangeException>();
        try {
            this.fetchRecordsInto(fetchedRecords);
        }
        catch (OffsetOutOfRangeException oor) {
            oorExceptions.add(oor);
        }
        Assertions.assertEquals((int)1, (int)oorExceptions.size());
        OffsetOutOfRangeException oor = (OffsetOutOfRangeException)((Object)oorExceptions.get(0));
        Assertions.assertTrue((boolean)oor.offsetOutOfRangePartitions().containsKey(this.tp0));
        Assertions.assertEquals((int)oor.offsetOutOfRangePartitions().size(), (int)1);
        this.fetchRecordsInto(fetchedRecords);
        Assertions.assertEquals((long)6L, (long)this.subscriptions.position((TopicPartition)this.tp2).offset);
        Assertions.assertEquals((int)5, (int)fetchedRecords.size());
        int numExceptionsExpected = 3;
        ArrayList<KafkaException> kafkaExceptions = new ArrayList<KafkaException>();
        for (int i = 1; i <= numExceptionsExpected; ++i) {
            try {
                this.fetchRecordsInto(fetchedRecords);
                continue;
            }
            catch (KafkaException e) {
                kafkaExceptions.add(e);
            }
        }
        Assertions.assertEquals((int)numExceptionsExpected, (int)kafkaExceptions.size());
    }

    @Test
    public void testSeekBeforeException() {
        this.buildFetcher(OffsetResetStrategy.NONE, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), 2, IsolationLevel.READ_UNCOMMITTED);
        this.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{this.tp0}));
        this.subscriptions.seek(this.tp0, 1L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        HashMap<TopicIdPartition, FetchResponseData.PartitionData> partitions = new HashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        partitions.put(this.tidp0, new FetchResponseData.PartitionData().setPartitionIndex(this.tp0.partition()).setHighWatermark(100L).setRecords((BaseRecords)this.records));
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertEquals((int)2, (int)this.fetchRecords().get(this.tp0).size());
        this.subscriptions.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1}));
        this.subscriptions.seekUnvalidated(this.tp1, new SubscriptionState.FetchPosition(1L, Optional.empty(), this.metadata.currentLeader(this.tp1)));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        partitions = new HashMap();
        partitions.put(this.tidp1, new FetchResponseData.PartitionData().setPartitionIndex(this.tp1.partition()).setErrorCode(Errors.OFFSET_OUT_OF_RANGE.code()).setHighWatermark(100L));
        this.client.prepareResponse((AbstractResponse)FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, new LinkedHashMap(partitions)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertEquals((int)1, (int)this.fetchRecords().get(this.tp0).size());
        this.subscriptions.seek(this.tp1, 10L);
        this.assertEmptyFetch("Should not return records or advance position after seeking to end of topic partitions");
    }

    @Test
    public void testFetchDisconnected() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0), true);
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.assertEmptyFetch("Should not return records or advance position on disconnect");
        Assertions.assertFalse((boolean)this.subscriptions.isOffsetResetNeeded(this.tp0));
        Assertions.assertTrue((boolean)this.subscriptions.isFetchable(this.tp0));
        Assertions.assertEquals((long)0L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
    }

    @Test
    public void testQuotaMetrics() {
        this.buildFetcher();
        MockSelector selector = new MockSelector(this.time);
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        NetworkClient client = new NetworkClient((Selectable)selector, (Metadata)this.metadata, "mock", Integer.MAX_VALUE, 1000L, 1000L, 65536, 65536, 1000, 10000L, 127000L, (Time)this.time, true, new ApiVersions(), this.metricsManager.throttleTimeSensor(), new LogContext(), MetadataRecoveryStrategy.NONE);
        ApiVersionsResponse apiVersionsResponse = TestUtils.defaultApiVersionsResponse(400, ApiMessageType.ListenerType.ZK_BROKER);
        ByteBuffer buffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)apiVersionsResponse, ApiKeys.API_VERSIONS.latestVersion(), 0);
        selector.delayedReceive(new DelayedReceive(node.idString(), new NetworkReceive(node.idString(), buffer)));
        while (!client.ready(node, this.time.milliseconds())) {
            client.poll(1L, this.time.milliseconds());
            this.time.sleep(client.throttleDelayMs(node, this.time.milliseconds()));
        }
        selector.clear();
        for (int i = 1; i <= 3; ++i) {
            int throttleTimeMs = 100 * i;
            FetchRequest.Builder builder = FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)100, (int)100, new LinkedHashMap());
            builder.rackId("");
            ClientRequest request = client.newClientRequest(node.idString(), (AbstractRequest.Builder)builder, this.time.milliseconds(), true);
            client.send(request, this.time.milliseconds());
            client.poll(1L, this.time.milliseconds());
            FetchResponse response = this.fullFetchResponse(this.tidp0, this.nextRecords, Errors.NONE, i, throttleTimeMs);
            buffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)response, ApiKeys.FETCH.latestVersion(), request.correlationId());
            selector.completeReceive(new NetworkReceive(node.idString(), buffer));
            client.poll(1L, this.time.milliseconds());
            this.time.sleep(client.throttleDelayMs(node, this.time.milliseconds()));
            selector.clear();
        }
        Map allMetrics = this.metrics.metrics();
        KafkaMetric avgMetric = (KafkaMetric)allMetrics.get(this.metrics.metricInstance(this.metricsRegistry.fetchThrottleTimeAvg, new String[0]));
        KafkaMetric maxMetric = (KafkaMetric)allMetrics.get(this.metrics.metricInstance(this.metricsRegistry.fetchThrottleTimeMax, new String[0]));
        Assertions.assertEquals((double)250.0, (double)((Double)avgMetric.metricValue()), (double)1.0E-4);
        Assertions.assertEquals((double)400.0, (double)((Double)maxMetric.metricValue()), (double)1.0E-4);
        client.close();
    }

    @Test
    public void testFetcherMetrics() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        MetricName maxLagMetric = this.metrics.metricInstance(this.metricsRegistry.recordsLagMax, new String[0]);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("topic", this.tp0.topic());
        tags.put("partition", String.valueOf(this.tp0.partition()));
        MetricName partitionLagMetric = this.metrics.metricName("records-lag", "consumertest-group-fetch-manager-metrics", tags);
        Map allMetrics = this.metrics.metrics();
        KafkaMetric recordsFetchLagMax = (KafkaMetric)allMetrics.get(maxLagMetric);
        Assertions.assertEquals((double)Double.NaN, (double)((Double)recordsFetchLagMax.metricValue()), (double)1.0E-4);
        this.fetchRecords(this.tidp0, MemoryRecords.EMPTY, Errors.NONE, 100L, 0);
        Assertions.assertEquals((double)100.0, (double)((Double)recordsFetchLagMax.metricValue()), (double)1.0E-4);
        KafkaMetric partitionLag = (KafkaMetric)allMetrics.get(partitionLagMetric);
        Assertions.assertEquals((double)100.0, (double)((Double)partitionLag.metricValue()), (double)1.0E-4);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        for (int v = 0; v < 3; ++v) {
            builder.appendWithOffset((long)v, -1L, "key".getBytes(), ("value-" + v).getBytes());
        }
        this.fetchRecords(this.tidp0, builder.build(), Errors.NONE, 200L, 0);
        Assertions.assertEquals((double)197.0, (double)((Double)recordsFetchLagMax.metricValue()), (double)1.0E-4);
        Assertions.assertEquals((double)197.0, (double)((Double)partitionLag.metricValue()), (double)1.0E-4);
        this.subscriptions.unsubscribe();
        this.sendFetches();
        Assertions.assertFalse((boolean)allMetrics.containsKey(partitionLagMetric));
    }

    @Test
    public void testFetcherLeadMetric() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        MetricName minLeadMetric = this.metrics.metricInstance(this.metricsRegistry.recordsLeadMin, new String[0]);
        HashMap<String, String> tags = new HashMap<String, String>(2);
        tags.put("topic", this.tp0.topic());
        tags.put("partition", String.valueOf(this.tp0.partition()));
        MetricName partitionLeadMetric = this.metrics.metricName("records-lead", "consumertest-group-fetch-manager-metrics", "", tags);
        Map allMetrics = this.metrics.metrics();
        KafkaMetric recordsFetchLeadMin = (KafkaMetric)allMetrics.get(minLeadMetric);
        Assertions.assertEquals((double)Double.NaN, (double)((Double)recordsFetchLeadMin.metricValue()), (double)1.0E-4);
        this.fetchRecords(this.tidp0, MemoryRecords.EMPTY, Errors.NONE, 100L, -1L, 0L, 0);
        Assertions.assertEquals((double)0.0, (double)((Double)recordsFetchLeadMin.metricValue()), (double)1.0E-4);
        KafkaMetric partitionLead = (KafkaMetric)allMetrics.get(partitionLeadMetric);
        Assertions.assertEquals((double)0.0, (double)((Double)partitionLead.metricValue()), (double)1.0E-4);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        for (int v = 0; v < 3; ++v) {
            builder.appendWithOffset((long)v, -1L, "key".getBytes(), ("value-" + v).getBytes());
        }
        this.fetchRecords(this.tidp0, builder.build(), Errors.NONE, 200L, -1L, 0L, 0);
        Assertions.assertEquals((double)0.0, (double)((Double)recordsFetchLeadMin.metricValue()), (double)1.0E-4);
        Assertions.assertEquals((double)3.0, (double)((Double)partitionLead.metricValue()), (double)1.0E-4);
        this.subscriptions.unsubscribe();
        this.sendFetches();
        Assertions.assertFalse((boolean)allMetrics.containsKey(partitionLeadMetric));
    }

    @Test
    public void testReadCommittedLagMetric() {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        MetricName maxLagMetric = this.metrics.metricInstance(this.metricsRegistry.recordsLagMax, new String[0]);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("topic", this.tp0.topic());
        tags.put("partition", String.valueOf(this.tp0.partition()));
        MetricName partitionLagMetric = this.metrics.metricName("records-lag", "consumertest-group-fetch-manager-metrics", tags);
        Map allMetrics = this.metrics.metrics();
        KafkaMetric recordsFetchLagMax = (KafkaMetric)allMetrics.get(maxLagMetric);
        Assertions.assertEquals((double)Double.NaN, (double)((Double)recordsFetchLagMax.metricValue()), (double)1.0E-4);
        this.fetchRecords(this.tidp0, MemoryRecords.EMPTY, Errors.NONE, 100L, 50L, 0);
        Assertions.assertEquals((double)50.0, (double)((Double)recordsFetchLagMax.metricValue()), (double)1.0E-4);
        KafkaMetric partitionLag = (KafkaMetric)allMetrics.get(partitionLagMetric);
        Assertions.assertEquals((double)50.0, (double)((Double)partitionLag.metricValue()), (double)1.0E-4);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        for (int v = 0; v < 3; ++v) {
            builder.appendWithOffset((long)v, -1L, "key".getBytes(), ("value-" + v).getBytes());
        }
        this.fetchRecords(this.tidp0, builder.build(), Errors.NONE, 200L, 150L, 0);
        Assertions.assertEquals((double)147.0, (double)((Double)recordsFetchLagMax.metricValue()), (double)1.0E-4);
        Assertions.assertEquals((double)147.0, (double)((Double)partitionLag.metricValue()), (double)1.0E-4);
        this.subscriptions.unsubscribe();
        this.sendFetches();
        Assertions.assertFalse((boolean)allMetrics.containsKey(partitionLagMetric));
    }

    @Test
    public void testFetchResponseMetrics() {
        this.buildFetcher();
        String topic1 = "foo";
        String topic2 = "bar";
        TopicPartition tp1 = new TopicPartition(topic1, 0);
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        this.subscriptions.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2}));
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put(topic1, 1);
        partitionCounts.put(topic2, 1);
        this.topicIds.put(topic1, Uuid.randomUuid());
        this.topicIds.put(topic2, Uuid.randomUuid());
        TopicIdPartition tidp1 = new TopicIdPartition(this.topicIds.get(topic1), tp1);
        TopicIdPartition tidp2 = new TopicIdPartition(this.topicIds.get(topic2), tp2);
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(1, partitionCounts, tp -> 0, this.topicIds));
        int expectedBytes = 0;
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> fetchPartitionData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        for (TopicIdPartition tp3 : Utils.mkSet((Object[])new TopicIdPartition[]{tidp1, tidp2})) {
            this.subscriptions.seek(tp3.topicPartition(), 0L);
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
            for (int v = 0; v < 3; ++v) {
                builder.appendWithOffset((long)v, -1L, "key".getBytes(), ("value-" + v).getBytes());
            }
            MemoryRecords records = builder.build();
            for (Record record : records.records()) {
                expectedBytes += record.sizeInBytes();
            }
            fetchPartitionData.put(tp3, new FetchResponseData.PartitionData().setPartitionIndex(tp3.topicPartition().partition()).setHighWatermark(15L).setLogStartOffset(0L).setRecords((BaseRecords)records));
        }
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, fetchPartitionData));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertEquals((int)3, (int)fetchedRecords.get(tp1).size());
        Assertions.assertEquals((int)3, (int)fetchedRecords.get(tp2).size());
        Map allMetrics = this.metrics.metrics();
        KafkaMetric fetchSizeAverage = (KafkaMetric)allMetrics.get(this.metrics.metricInstance(this.metricsRegistry.fetchSizeAvg, new String[0]));
        KafkaMetric recordsCountAverage = (KafkaMetric)allMetrics.get(this.metrics.metricInstance(this.metricsRegistry.recordsPerRequestAvg, new String[0]));
        Assertions.assertEquals((double)expectedBytes, (double)((Double)fetchSizeAverage.metricValue()), (double)1.0E-4);
        Assertions.assertEquals((double)6.0, (double)((Double)recordsCountAverage.metricValue()), (double)1.0E-4);
    }

    @Test
    public void testFetchResponseMetricsWithSkippedOffset() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 1L);
        Map allMetrics = this.metrics.metrics();
        KafkaMetric fetchSizeAverage = (KafkaMetric)allMetrics.get(this.metrics.metricInstance(this.metricsRegistry.fetchSizeAvg, new String[0]));
        KafkaMetric recordsCountAverage = (KafkaMetric)allMetrics.get(this.metrics.metricInstance(this.metricsRegistry.recordsPerRequestAvg, new String[0]));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        for (int v = 0; v < 3; ++v) {
            builder.appendWithOffset((long)v, -1L, "key".getBytes(), ("value-" + v).getBytes());
        }
        MemoryRecords records = builder.build();
        int expectedBytes = 0;
        for (Record record : records.records()) {
            if (record.offset() < 1L) continue;
            expectedBytes += record.sizeInBytes();
        }
        this.fetchRecords(this.tidp0, records, Errors.NONE, 100L, 0);
        Assertions.assertEquals((double)expectedBytes, (double)((Double)fetchSizeAverage.metricValue()), (double)1.0E-4);
        Assertions.assertEquals((double)2.0, (double)((Double)recordsCountAverage.metricValue()), (double)1.0E-4);
    }

    @Test
    public void testFetchResponseMetricsWithOnePartitionError() {
        this.buildFetcher();
        this.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1}));
        this.subscriptions.seek(this.tp0, 0L);
        this.subscriptions.seek(this.tp1, 0L);
        Map allMetrics = this.metrics.metrics();
        KafkaMetric fetchSizeAverage = (KafkaMetric)allMetrics.get(this.metrics.metricInstance(this.metricsRegistry.fetchSizeAvg, new String[0]));
        KafkaMetric recordsCountAverage = (KafkaMetric)allMetrics.get(this.metrics.metricInstance(this.metricsRegistry.recordsPerRequestAvg, new String[0]));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        for (int v = 0; v < 3; ++v) {
            builder.appendWithOffset((long)v, -1L, "key".getBytes(), ("value-" + v).getBytes());
        }
        MemoryRecords records = builder.build();
        HashMap<TopicIdPartition, FetchResponseData.PartitionData> partitions = new HashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        partitions.put(this.tidp0, new FetchResponseData.PartitionData().setPartitionIndex(this.tp0.partition()).setHighWatermark(100L).setLogStartOffset(0L).setRecords((BaseRecords)records));
        partitions.put(this.tidp1, new FetchResponseData.PartitionData().setPartitionIndex(this.tp1.partition()).setErrorCode(Errors.OFFSET_OUT_OF_RANGE.code()).setHighWatermark(100L).setLogStartOffset(0L));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, new LinkedHashMap(partitions)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.collectFetch();
        int expectedBytes = 0;
        for (Record record : records.records()) {
            expectedBytes += record.sizeInBytes();
        }
        Assertions.assertEquals((double)expectedBytes, (double)((Double)fetchSizeAverage.metricValue()), (double)1.0E-4);
        Assertions.assertEquals((double)3.0, (double)((Double)recordsCountAverage.metricValue()), (double)1.0E-4);
    }

    @Test
    public void testFetchResponseMetricsWithOnePartitionAtTheWrongOffset() {
        this.buildFetcher();
        this.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1}));
        this.subscriptions.seek(this.tp0, 0L);
        this.subscriptions.seek(this.tp1, 0L);
        Map allMetrics = this.metrics.metrics();
        KafkaMetric fetchSizeAverage = (KafkaMetric)allMetrics.get(this.metrics.metricInstance(this.metricsRegistry.fetchSizeAvg, new String[0]));
        KafkaMetric recordsCountAverage = (KafkaMetric)allMetrics.get(this.metrics.metricInstance(this.metricsRegistry.recordsPerRequestAvg, new String[0]));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.subscriptions.seek(this.tp1, 5L);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        for (int v = 0; v < 3; ++v) {
            builder.appendWithOffset((long)v, -1L, "key".getBytes(), ("value-" + v).getBytes());
        }
        MemoryRecords records = builder.build();
        HashMap<TopicIdPartition, FetchResponseData.PartitionData> partitions = new HashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        partitions.put(this.tidp0, new FetchResponseData.PartitionData().setPartitionIndex(this.tp0.partition()).setHighWatermark(100L).setLogStartOffset(0L).setRecords((BaseRecords)records));
        partitions.put(this.tidp1, new FetchResponseData.PartitionData().setPartitionIndex(this.tp1.partition()).setHighWatermark(100L).setLogStartOffset(0L).setRecords((BaseRecords)MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("val".getBytes())})));
        this.client.prepareResponse((AbstractResponse)FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, new LinkedHashMap(partitions)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.collectFetch();
        int expectedBytes = 0;
        for (Record record : records.records()) {
            expectedBytes += record.sizeInBytes();
        }
        Assertions.assertEquals((double)expectedBytes, (double)((Double)fetchSizeAverage.metricValue()), (double)1.0E-4);
        Assertions.assertEquals((double)3.0, (double)((Double)recordsCountAverage.metricValue()), (double)1.0E-4);
    }

    @Test
    public void testFetcherMetricsTemplates() {
        Map<String, String> clientTags = Collections.singletonMap("client-id", "clientA");
        this.buildFetcher(new MetricConfig().tags(clientTags), OffsetResetStrategy.EARLIEST, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_UNCOMMITTED);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp0));
        HashSet<MetricNameTemplate> allMetrics = new HashSet<MetricNameTemplate>();
        for (MetricName n : this.metrics.metrics().keySet()) {
            String name = n.name().replaceAll(this.tp0.toString(), "{topic}-{partition}");
            if (n.group().equals("kafka-metrics-count")) continue;
            allMetrics.add(new MetricNameTemplate(name, n.group(), "", n.tags().keySet()));
        }
        TestUtils.checkEquals(allMetrics, new HashSet(this.metricsRegistry.getAllTemplates()), "metrics", "templates");
    }

    private Map<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> fetchRecords(TopicIdPartition tp, MemoryRecords records, Errors error, long hw, int throttleTime) {
        return this.fetchRecords(tp, records, error, hw, -1L, throttleTime);
    }

    private Map<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> fetchRecords(TopicIdPartition tp, MemoryRecords records, Errors error, long hw, long lastStableOffset, int throttleTime) {
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(tp, records, error, hw, lastStableOffset, throttleTime));
        this.networkClientDelegate.poll(this.time.timer(0L));
        return this.fetchRecords();
    }

    private Map<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> fetchRecords(TopicIdPartition tp, MemoryRecords records, Errors error, long hw, long lastStableOffset, long logStartOffset, int throttleTime) {
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fetchResponse(tp, records, error, hw, lastStableOffset, logStartOffset, throttleTime));
        this.networkClientDelegate.poll(this.time.timer(0L));
        return this.fetchRecords();
    }

    @Test
    public void testSkippingAbortedTransactions() {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int currentOffset = 0;
        currentOffset += this.appendTransactionalRecords(buffer, 1L, (long)currentOffset, new SimpleRecord(this.time.milliseconds(), "key".getBytes(), "value".getBytes()), new SimpleRecord(this.time.milliseconds(), "key".getBytes(), "value".getBytes()));
        this.abortTransaction(buffer, 1L, currentOffset);
        buffer.flip();
        List<FetchResponseData.AbortedTransaction> abortedTransactions = Collections.singletonList(new FetchResponseData.AbortedTransaction().setProducerId(1L).setFirstOffset(0L));
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponseWithAbortedTransactions(records, abortedTransactions, Errors.NONE, 100L, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Fetch fetch = this.collectFetch();
        Assertions.assertEquals(Collections.emptyMap(), (Object)fetch.records());
        Assertions.assertTrue((boolean)fetch.positionAdvanced());
    }

    @Test
    public void testReturnCommittedTransactions() {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int currentOffset = 0;
        currentOffset += this.appendTransactionalRecords(buffer, 1L, (long)currentOffset, new SimpleRecord(this.time.milliseconds(), "key".getBytes(), "value".getBytes()), new SimpleRecord(this.time.milliseconds(), "key".getBytes(), "value".getBytes()));
        this.commitTransaction(buffer, 1L, currentOffset);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse(body -> {
            FetchRequest request = (FetchRequest)body;
            Assertions.assertEquals((Object)IsolationLevel.READ_COMMITTED, (Object)request.isolationLevel());
            return true;
        }, (AbstractResponse)this.fullFetchResponseWithAbortedTransactions(records, Collections.emptyList(), Errors.NONE, 100L, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)fetchedRecords.containsKey(this.tp0));
        Assertions.assertEquals((int)fetchedRecords.get(this.tp0).size(), (int)2);
    }

    @Test
    public void testReadCommittedWithCommittedAndAbortedTransactions() {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        ArrayList<FetchResponseData.AbortedTransaction> abortedTransactions = new ArrayList<FetchResponseData.AbortedTransaction>();
        long pid1 = 1L;
        long pid2 = 2L;
        this.appendTransactionalRecords(buffer, pid1, 0L, new SimpleRecord("commit1-1".getBytes(), "value".getBytes()), new SimpleRecord("commit1-2".getBytes(), "value".getBytes()));
        this.appendTransactionalRecords(buffer, pid2, 2L, new SimpleRecord("abort2-1".getBytes(), "value".getBytes()));
        this.commitTransaction(buffer, pid1, 3L);
        this.appendTransactionalRecords(buffer, pid2, 4L, new SimpleRecord("abort2-2".getBytes(), "value".getBytes()));
        this.abortTransaction(buffer, pid2, 5L);
        abortedTransactions.add(new FetchResponseData.AbortedTransaction().setProducerId(pid2).setFirstOffset(2L));
        this.appendTransactionalRecords(buffer, pid1, 6L, new SimpleRecord("abort1-1".getBytes(), "value".getBytes()));
        this.appendTransactionalRecords(buffer, pid2, 7L, new SimpleRecord("commit2-1".getBytes(), "value".getBytes()));
        this.appendTransactionalRecords(buffer, pid1, 8L, new SimpleRecord("abort1-2".getBytes(), "value".getBytes()));
        this.abortTransaction(buffer, pid1, 9L);
        abortedTransactions.add(new FetchResponseData.AbortedTransaction().setProducerId(1L).setFirstOffset(6L));
        this.commitTransaction(buffer, pid2, 10L);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponseWithAbortedTransactions(records, abortedTransactions, Errors.NONE, 100L, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)fetchedRecords.containsKey(this.tp0));
        List fetchedConsumerRecords = fetchedRecords.get(this.tp0);
        HashSet<String> fetchedKeys = new HashSet<String>();
        for (ConsumerRecord consumerRecord : fetchedConsumerRecords) {
            fetchedKeys.add(new String((byte[])consumerRecord.key(), StandardCharsets.UTF_8));
        }
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"commit1-1", "commit1-2", "commit2-1"}), fetchedKeys);
    }

    @Test
    public void testMultipleAbortMarkers() {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int currentOffset = 0;
        currentOffset += this.appendTransactionalRecords(buffer, 1L, (long)currentOffset, new SimpleRecord(this.time.milliseconds(), "abort1-1".getBytes(), "value".getBytes()), new SimpleRecord(this.time.milliseconds(), "abort1-2".getBytes(), "value".getBytes()));
        currentOffset += this.abortTransaction(buffer, 1L, currentOffset);
        currentOffset += this.abortTransaction(buffer, 1L, currentOffset);
        currentOffset += this.appendTransactionalRecords(buffer, 1L, (long)currentOffset, new SimpleRecord(this.time.milliseconds(), "commit1-1".getBytes(), "value".getBytes()), new SimpleRecord(this.time.milliseconds(), "commit1-2".getBytes(), "value".getBytes()));
        this.commitTransaction(buffer, 1L, currentOffset);
        buffer.flip();
        List<FetchResponseData.AbortedTransaction> abortedTransactions = Collections.singletonList(new FetchResponseData.AbortedTransaction().setProducerId(1L).setFirstOffset(0L));
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponseWithAbortedTransactions(records, abortedTransactions, Errors.NONE, 100L, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)fetchedRecords.containsKey(this.tp0));
        Assertions.assertEquals((int)fetchedRecords.get(this.tp0).size(), (int)2);
        List fetchedConsumerRecords = fetchedRecords.get(this.tp0);
        HashSet<String> expectedCommittedKeys = new HashSet<String>(Arrays.asList("commit1-1", "commit1-2"));
        HashSet<String> actuallyCommittedKeys = new HashSet<String>();
        for (ConsumerRecord consumerRecord : fetchedConsumerRecords) {
            actuallyCommittedKeys.add(new String((byte[])consumerRecord.key(), StandardCharsets.UTF_8));
        }
        Assertions.assertEquals(expectedCommittedKeys, actuallyCommittedKeys);
    }

    @Test
    public void testReadCommittedAbortMarkerWithNoData() {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        long producerId = 1L;
        this.abortTransaction(buffer, producerId, 5L);
        this.appendTransactionalRecords(buffer, producerId, 6L, new SimpleRecord("6".getBytes(), null), new SimpleRecord("7".getBytes(), null), new SimpleRecord("8".getBytes(), null));
        this.commitTransaction(buffer, producerId, 9L);
        buffer.flip();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        List<FetchResponseData.AbortedTransaction> abortedTransactions = Collections.singletonList(new FetchResponseData.AbortedTransaction().setProducerId(producerId).setFirstOffset(0L));
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponseWithAbortedTransactions(MemoryRecords.readableRecords((ByteBuffer)buffer), abortedTransactions, Errors.NONE, 100L, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map allFetchedRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)allFetchedRecords.containsKey(this.tp0));
        List fetchedRecords = allFetchedRecords.get(this.tp0);
        Assertions.assertEquals((int)3, (int)fetchedRecords.size());
        Assertions.assertEquals(Arrays.asList(6L, 7L, 8L), this.collectRecordOffsets(fetchedRecords));
    }

    @Test
    public void testUpdatePositionWithLastRecordMissingFromBatch() {
        this.buildFetcher();
        MemoryRecords records = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        MemoryRecords.FilterResult result = records.filterTo(this.tp0, new MemoryRecords.RecordFilter(0L, 0L){

            protected MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                return new MemoryRecords.RecordFilter.BatchRetentionResult(MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY, false);
            }

            protected boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                return record.key() != null;
            }
        }, ByteBuffer.allocate(1024), Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        result.outputBuffer().flip();
        MemoryRecords compactedRecords = MemoryRecords.readableRecords((ByteBuffer)result.outputBuffer());
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, compactedRecords, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map allFetchedRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)allFetchedRecords.containsKey(this.tp0));
        List fetchedRecords = allFetchedRecords.get(this.tp0);
        Assertions.assertEquals((int)3, (int)fetchedRecords.size());
        for (int i = 0; i < 3; ++i) {
            Assertions.assertEquals((Object)Integer.toString(i), (Object)new String((byte[])fetchedRecords.get(i).key()));
        }
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
    }

    @Test
    public void testUpdatePositionOnEmptyBatch() {
        this.buildFetcher();
        long producerId = 1L;
        short producerEpoch = 0;
        int sequence = 1;
        long baseOffset = 37L;
        long lastOffset = 54L;
        int partitionLeaderEpoch = 7;
        ByteBuffer buffer = ByteBuffer.allocate(61);
        DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)producerId, (short)producerEpoch, (int)sequence, (long)baseOffset, (long)lastOffset, (int)partitionLeaderEpoch, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)false, (boolean)false);
        buffer.flip();
        MemoryRecords recordsWithEmptyBatch = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, recordsWithEmptyBatch, Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Fetch fetch = this.collectFetch();
        Assertions.assertEquals(Collections.emptyMap(), (Object)fetch.records());
        Assertions.assertTrue((boolean)fetch.positionAdvanced());
        Assertions.assertEquals((long)(lastOffset + 1L), (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
    }

    @Test
    public void testReadCommittedWithCompactedTopic() {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        this.appendTransactionalRecords(buffer, pid3, 3L, new SimpleRecord("3".getBytes(), "value".getBytes()), new SimpleRecord("4".getBytes(), "value".getBytes()));
        this.appendTransactionalRecords(buffer, pid2, 15L, new SimpleRecord("15".getBytes(), "value".getBytes()), new SimpleRecord("16".getBytes(), "value".getBytes()), new SimpleRecord("17".getBytes(), "value".getBytes()));
        this.appendTransactionalRecords(buffer, pid1, 22L, new SimpleRecord("22".getBytes(), "value".getBytes()), new SimpleRecord("23".getBytes(), "value".getBytes()));
        this.abortTransaction(buffer, pid2, 28L);
        this.appendTransactionalRecords(buffer, pid3, 30L, new SimpleRecord("30".getBytes(), "value".getBytes()), new SimpleRecord("31".getBytes(), "value".getBytes()), new SimpleRecord("32".getBytes(), "value".getBytes()));
        this.commitTransaction(buffer, pid3, 35L);
        this.appendTransactionalRecords(buffer, pid1, 39L, new SimpleRecord("39".getBytes(), "value".getBytes()), new SimpleRecord("40".getBytes(), "value".getBytes()));
        buffer.flip();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        List<FetchResponseData.AbortedTransaction> abortedTransactions = Arrays.asList(new FetchResponseData.AbortedTransaction().setProducerId(pid2).setFirstOffset(6L), new FetchResponseData.AbortedTransaction().setProducerId(pid1).setFirstOffset(0L));
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponseWithAbortedTransactions(MemoryRecords.readableRecords((ByteBuffer)buffer), abortedTransactions, Errors.NONE, 100L, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map allFetchedRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)allFetchedRecords.containsKey(this.tp0));
        List fetchedRecords = allFetchedRecords.get(this.tp0);
        Assertions.assertEquals((int)5, (int)fetchedRecords.size());
        Assertions.assertEquals(Arrays.asList(3L, 4L, 30L, 31L, 32L), this.collectRecordOffsets(fetchedRecords));
    }

    @Test
    public void testReturnAbortedTransactionsInUncommittedMode() {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_UNCOMMITTED);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int currentOffset = 0;
        currentOffset += this.appendTransactionalRecords(buffer, 1L, (long)currentOffset, new SimpleRecord(this.time.milliseconds(), "key".getBytes(), "value".getBytes()), new SimpleRecord(this.time.milliseconds(), "key".getBytes(), "value".getBytes()));
        this.abortTransaction(buffer, 1L, currentOffset);
        buffer.flip();
        List<FetchResponseData.AbortedTransaction> abortedTransactions = Collections.singletonList(new FetchResponseData.AbortedTransaction().setProducerId(1L).setFirstOffset(0L));
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponseWithAbortedTransactions(records, abortedTransactions, Errors.NONE, 100L, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)fetchedRecords.containsKey(this.tp0));
    }

    @Test
    public void testConsumerPositionUpdatedWhenSkippingAbortedTransactions() {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        long currentOffset = 0L;
        currentOffset += (long)this.appendTransactionalRecords(buffer, 1L, currentOffset, new SimpleRecord(this.time.milliseconds(), "abort1-1".getBytes(), "value".getBytes()), new SimpleRecord(this.time.milliseconds(), "abort1-2".getBytes(), "value".getBytes()));
        currentOffset += (long)this.abortTransaction(buffer, 1L, currentOffset);
        buffer.flip();
        List<FetchResponseData.AbortedTransaction> abortedTransactions = Collections.singletonList(new FetchResponseData.AbortedTransaction().setProducerId(1L).setFirstOffset(0L));
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponseWithAbortedTransactions(records, abortedTransactions, Errors.NONE, 100L, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertFalse((boolean)fetchedRecords.containsKey(this.tp0));
        Assertions.assertEquals((long)currentOffset, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
    }

    @Test
    public void testConsumingViaIncrementalFetchRequests() {
        this.buildFetcher(2);
        this.assignFromUser(new HashSet<TopicPartition>(Arrays.asList(this.tp0, this.tp1)));
        this.subscriptions.seekValidated(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.empty(), this.metadata.currentLeader(this.tp0)));
        this.subscriptions.seekValidated(this.tp1, new SubscriptionState.FetchPosition(1L, Optional.empty(), this.metadata.currentLeader(this.tp1)));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> partitions1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        partitions1.put(this.tidp0, new FetchResponseData.PartitionData().setPartitionIndex(this.tp0.partition()).setHighWatermark(2L).setLastStableOffset(2L).setLogStartOffset(0L).setRecords((BaseRecords)this.records));
        partitions1.put(this.tidp1, new FetchResponseData.PartitionData().setPartitionIndex(this.tp1.partition()).setHighWatermark(100L).setLogStartOffset(0L).setRecords((BaseRecords)this.emptyRecords));
        FetchResponse resp1 = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, partitions1);
        this.client.prepareResponse((AbstractResponse)resp1);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertFalse((boolean)fetchedRecords.containsKey(this.tp1));
        List recordsToTest = fetchedRecords.get(this.tp0);
        Assertions.assertEquals((int)2, (int)recordsToTest.size());
        Assertions.assertEquals((long)3L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        Assertions.assertEquals((long)1L, (long)this.subscriptions.position((TopicPartition)this.tp1).offset);
        Assertions.assertEquals((long)1L, (long)recordsToTest.get(0).offset());
        Assertions.assertEquals((long)2L, (long)recordsToTest.get(1).offset());
        Assertions.assertEquals((int)0, (int)this.sendFetches());
        fetchedRecords = this.fetchRecords();
        Assertions.assertFalse((boolean)fetchedRecords.containsKey(this.tp1));
        recordsToTest = fetchedRecords.get(this.tp0);
        Assertions.assertEquals((int)1, (int)recordsToTest.size());
        Assertions.assertEquals((long)3L, (long)recordsToTest.get(0).offset());
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        LinkedHashMap partitions2 = new LinkedHashMap();
        FetchResponse resp2 = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, partitions2);
        this.client.prepareResponse((AbstractResponse)resp2);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.networkClientDelegate.poll(this.time.timer(0L));
        fetchedRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)fetchedRecords.isEmpty());
        Assertions.assertEquals((long)4L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        Assertions.assertEquals((long)1L, (long)this.subscriptions.position((TopicPartition)this.tp1).offset);
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> partitions3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        partitions3.put(this.tidp0, new FetchResponseData.PartitionData().setPartitionIndex(this.tp0.partition()).setHighWatermark(100L).setLastStableOffset(4L).setLogStartOffset(0L).setRecords((BaseRecords)this.nextRecords));
        FetchResponse resp3 = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, partitions3);
        this.client.prepareResponse((AbstractResponse)resp3);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.networkClientDelegate.poll(this.time.timer(0L));
        fetchedRecords = this.fetchRecords();
        Assertions.assertFalse((boolean)fetchedRecords.containsKey(this.tp1));
        recordsToTest = fetchedRecords.get(this.tp0);
        Assertions.assertEquals((int)2, (int)recordsToTest.size());
        Assertions.assertEquals((long)6L, (long)this.subscriptions.position((TopicPartition)this.tp0).offset);
        Assertions.assertEquals((long)1L, (long)this.subscriptions.position((TopicPartition)this.tp1).offset);
        Assertions.assertEquals((long)4L, (long)recordsToTest.get(0).offset());
        Assertions.assertEquals((long)5L, (long)recordsToTest.get(1).offset());
    }

    @Test
    public void testEmptyControlBatch() {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int currentOffset = 1;
        DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)1L, (short)0, (int)-1, (long)0L, (long)0L, (int)-1, (TimestampType)TimestampType.CREATE_TIME, (long)this.time.milliseconds(), (boolean)true, (boolean)true);
        currentOffset += this.appendTransactionalRecords(buffer, 1L, (long)currentOffset, new SimpleRecord(this.time.milliseconds(), "key".getBytes(), "value".getBytes()), new SimpleRecord(this.time.milliseconds(), "key".getBytes(), "value".getBytes()));
        this.commitTransaction(buffer, 1L, currentOffset);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse(body -> {
            FetchRequest request = (FetchRequest)body;
            Assertions.assertEquals((Object)IsolationLevel.READ_COMMITTED, (Object)request.isolationLevel());
            return true;
        }, (AbstractResponse)this.fullFetchResponseWithAbortedTransactions(records, Collections.emptyList(), Errors.NONE, 100L, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map fetchedRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)fetchedRecords.containsKey(this.tp0));
        Assertions.assertEquals((int)fetchedRecords.get(this.tp0).size(), (int)2);
    }

    private MemoryRecords buildRecords(long baseOffset, int count, long firstMessageId) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset);
        for (int i = 0; i < count; ++i) {
            builder.append(0L, "key".getBytes(), ("value-" + (firstMessageId + (long)i)).getBytes());
        }
        return builder.build();
    }

    private int appendTransactionalRecords(ByteBuffer buffer, long pid, long baseOffset, int baseSequence, SimpleRecord ... records) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)this.time.milliseconds(), (long)pid, (short)0, (int)baseSequence, (boolean)true, (int)-1);
        for (SimpleRecord record : records) {
            builder.append(record);
        }
        builder.build();
        return records.length;
    }

    private int appendTransactionalRecords(ByteBuffer buffer, long pid, long baseOffset, SimpleRecord ... records) {
        return this.appendTransactionalRecords(buffer, pid, baseOffset, (int)baseOffset, records);
    }

    private void commitTransaction(ByteBuffer buffer, long producerId, long baseOffset) {
        short producerEpoch = 0;
        int partitionLeaderEpoch = 0;
        MemoryRecords.writeEndTransactionalMarker((ByteBuffer)buffer, (long)baseOffset, (long)this.time.milliseconds(), (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 0));
    }

    private int abortTransaction(ByteBuffer buffer, long producerId, long baseOffset) {
        short producerEpoch = 0;
        int partitionLeaderEpoch = 0;
        MemoryRecords.writeEndTransactionalMarker((ByteBuffer)buffer, (long)baseOffset, (long)this.time.milliseconds(), (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 0));
        return 1;
    }

    @Test
    public void testSubscriptionPositionUpdatedWithEpoch() {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)2, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)-1L, (long)-1L, (short)-1, (int)-1, (boolean)false, (int)1);
        builder.appendWithOffset(0L, 0L, "key".getBytes(), "value-1".getBytes());
        builder.appendWithOffset(1L, 0L, "key".getBytes(), "value-2".getBytes());
        builder.appendWithOffset(2L, 0L, "key".getBytes(), "value-3".getBytes());
        MemoryRecords records = builder.build();
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put(this.tp0.topic(), 4);
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), partitionCounts, tp -> 1, this.topicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 0L);
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, records, Errors.NONE, 100L, 0));
        this.networkClientDelegate.pollNoWakeup();
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp0));
        Assertions.assertEquals((long)this.subscriptions.position((TopicPartition)this.tp0).offset, (long)3L);
        TestUtils.assertOptional(this.subscriptions.position((TopicPartition)this.tp0).offsetEpoch, value -> Assertions.assertEquals((int)value, (int)1));
    }

    @Test
    public void testPreferredReadReplica() {
        this.buildFetcher(new MetricConfig(), OffsetResetStrategy.EARLIEST, (Deserializer)new BytesDeserializer(), (Deserializer)new BytesDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED, Duration.ofMinutes(5L).toMillis());
        this.subscriptions.assignFromUser(Collections.singleton(this.tp0));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(2, Collections.singletonMap("test", 4), tp -> 0, this.topicIds, false));
        this.subscriptions.seek(this.tp0, 0L);
        Node selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)-1, (int)selected.id());
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, -1L, 0, Optional.of(1)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp0));
        selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)selected.id());
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, -1L, 0, Optional.of(2)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)-1, (int)selected.id());
    }

    @Test
    public void testFetchDisconnectedShouldClearPreferredReadReplica() {
        this.buildFetcher(new MetricConfig(), OffsetResetStrategy.EARLIEST, (Deserializer)new BytesDeserializer(), (Deserializer)new BytesDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED, Duration.ofMinutes(5L).toMillis());
        this.subscriptions.assignFromUser(Collections.singleton(this.tp0));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(2, Collections.singletonMap("test", 4), tp -> 0, this.topicIds, false));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, -1L, 0, Optional.of(1)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        Node selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)selected.id());
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0), true);
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)-1, (int)selected.id());
    }

    @Test
    public void testFetchDisconnectedShouldNotClearPreferredReadReplicaIfUnassigned() {
        this.buildFetcher(new MetricConfig(), OffsetResetStrategy.EARLIEST, (Deserializer)new BytesDeserializer(), (Deserializer)new BytesDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED, Duration.ofMinutes(5L).toMillis());
        this.subscriptions.assignFromUser(Collections.singleton(this.tp0));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(2, Collections.singletonMap("test", 4), tp -> 0, this.topicIds, false));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, -1L, 0, Optional.of(1)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        Node selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)selected.id());
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, 0), true);
        this.subscriptions.assignFromUser(Collections.emptySet());
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)-1, (int)selected.id());
    }

    @Test
    public void testFetchErrorShouldClearPreferredReadReplica() {
        this.buildFetcher(new MetricConfig(), OffsetResetStrategy.EARLIEST, (Deserializer)new BytesDeserializer(), (Deserializer)new BytesDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED, Duration.ofMinutes(5L).toMillis());
        this.subscriptions.assignFromUser(Collections.singleton(this.tp0));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(2, Collections.singletonMap("test", 4), tp -> 0, this.topicIds, false));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, -1L, 0, Optional.of(1)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        Node selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)selected.id());
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, MemoryRecords.EMPTY, Errors.NOT_LEADER_OR_FOLLOWER, -1L, -1L, 0, Optional.of(1)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)-1, (int)selected.id());
    }

    @Test
    public void testPreferredReadReplicaOffsetError() {
        this.buildFetcher(new MetricConfig(), OffsetResetStrategy.EARLIEST, (Deserializer)new BytesDeserializer(), (Deserializer)new BytesDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED, Duration.ofMinutes(5L).toMillis());
        this.subscriptions.assignFromUser(Collections.singleton(this.tp0));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(2, Collections.singletonMap("test", 4), tp -> 0, this.topicIds, false));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, -1L, 0, Optional.of(1)));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        Node selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)selected.id(), (int)1);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.OFFSET_OUT_OF_RANGE, 100L, -1L, 0, Optional.empty()));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        this.fetchRecords();
        selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)selected.id(), (int)-1);
    }

    @Test
    public void testFetchCompletedBeforeHandlerAdded() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        this.sendFetches();
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.buildRecords(1L, 1, 1L), Errors.NONE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        this.fetchRecords();
        Metadata.LeaderAndEpoch leaderAndEpoch = this.subscriptions.position((TopicPartition)this.tp0).currentLeader;
        Assertions.assertTrue((boolean)leaderAndEpoch.leader.isPresent());
        Node readReplica = this.fetcher.selectReadReplica(this.tp0, (Node)leaderAndEpoch.leader.get(), this.time.milliseconds());
        AtomicBoolean wokenUp = new AtomicBoolean(false);
        this.client.setWakeupHook(() -> {
            if (!wokenUp.getAndSet(true)) {
                this.networkClientDelegate.disconnectAsync(readReplica);
                this.networkClientDelegate.poll(this.time.timer(0L));
            }
        });
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        this.networkClientDelegate.disconnectAsync(readReplica);
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertEquals((int)1, (int)this.sendFetches());
    }

    @Test
    public void testCorruptMessageError() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.subscriptions.seek(this.tp0, 0L);
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponse((AbstractResponse)this.fullFetchResponse(this.tidp0, this.buildRecords(1L, 1, 1L), Errors.CORRUPT_MESSAGE, 100L, 0));
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Assertions.assertThrows(KafkaException.class, this::fetchRecords);
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"FENCED_LEADER_EPOCH", "NOT_LEADER_OR_FOLLOWER"})
    public void testWhenFetchResponseReturnsALeaderShipChangeErrorButNoNewLeaderInformation(Errors error) {
        this.buildFetcher(new MetricConfig(), OffsetResetStrategy.EARLIEST, (Deserializer)new BytesDeserializer(), (Deserializer)new BytesDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_UNCOMMITTED, Duration.ofMinutes(5L).toMillis());
        this.subscriptions.assignFromUser(new HashSet<TopicPartition>(Arrays.asList(this.tp0, this.tp1)));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(2, Collections.singletonMap("test", 4), tp -> 0, this.topicIds, false));
        Node tp0Leader = this.metadata.fetch().leaderFor(this.tp0);
        Node tp1Leader = this.metadata.fetch().leaderFor(this.tp1);
        Node nodeId0 = this.metadata.fetch().nodeById(0);
        Cluster startingClusterMetadata = this.metadata.fetch();
        this.subscriptions.seek(this.tp0, 0L);
        this.subscriptions.seek(this.tp1, 0L);
        Assertions.assertEquals((int)2, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponseFrom((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, -1L, 0, Optional.of(nodeId0.id())), tp0Leader);
        this.client.prepareResponseFrom((AbstractResponse)this.fullFetchResponse(this.tidp1, this.records, Errors.NONE, 100L, -1L, 0, Optional.of(nodeId0.id())), tp1Leader);
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp0));
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp1));
        Node selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)nodeId0.id(), (int)selected.id());
        selected = this.fetcher.selectReadReplica(this.tp1, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)nodeId0.id(), (int)selected.id());
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> partitions = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        partitions.put(this.tidp0, new FetchResponseData.PartitionData().setPartitionIndex(this.tidp0.topicPartition().partition()).setErrorCode(error.code()));
        partitions.put(this.tidp1, new FetchResponseData.PartitionData().setPartitionIndex(this.tidp1.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setHighWatermark(100L).setLastStableOffset(-1L).setLogStartOffset(0L).setRecords((BaseRecords)this.nextRecords));
        this.client.prepareResponseFrom((AbstractResponse)FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, partitions), nodeId0);
        this.networkClientDelegate.poll(this.time.timer(0L));
        partitionRecords = this.fetchRecords();
        Assertions.assertFalse((boolean)partitionRecords.containsKey(this.tp0));
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp1));
        Assertions.assertEquals((Object)startingClusterMetadata, (Object)this.metadata.fetch());
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        Assertions.assertEquals(Optional.empty(), (Object)this.subscriptions.preferredReadReplica(this.tp0, this.time.milliseconds()));
        Assertions.assertEquals(Optional.of(nodeId0.id()), (Object)this.subscriptions.preferredReadReplica(this.tp1, this.time.milliseconds()));
        Assertions.assertTrue((boolean)this.subscriptions.isFetchable(this.tp0));
        Metadata.LeaderAndEpoch currentLeader = this.subscriptions.position((TopicPartition)this.tp0).currentLeader;
        Assertions.assertEquals((int)tp0Leader.id(), (int)((Node)currentLeader.leader.get()).id());
        Assertions.assertEquals((int)0, (Integer)((Integer)currentLeader.epoch.get()));
        Assertions.assertTrue((boolean)this.subscriptions.isFetchable(this.tp1));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"FENCED_LEADER_EPOCH", "NOT_LEADER_OR_FOLLOWER"})
    public void testWhenFetchResponseReturnsALeaderShipChangeErrorAndNewLeaderInformation(Errors error) {
        this.buildFetcher(new MetricConfig(), OffsetResetStrategy.EARLIEST, (Deserializer)new BytesDeserializer(), (Deserializer)new BytesDeserializer(), Integer.MAX_VALUE, IsolationLevel.READ_UNCOMMITTED, Duration.ofMinutes(5L).toMillis());
        this.subscriptions.assignFromUser(new HashSet<TopicPartition>(Arrays.asList(this.tp0, this.tp1)));
        this.client.updateMetadata(RequestTestUtils.metadataUpdateWithIds(2, Collections.singletonMap("test", 4), tp -> 0, this.topicIds, false));
        Node tp0Leader = this.metadata.fetch().leaderFor(this.tp0);
        Node tp1Leader = this.metadata.fetch().leaderFor(this.tp1);
        Node nodeId0 = this.metadata.fetch().nodeById(0);
        Cluster startingClusterMetadata = this.metadata.fetch();
        this.subscriptions.seek(this.tp0, 0L);
        this.subscriptions.seek(this.tp1, 0L);
        Assertions.assertEquals((int)2, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        this.client.prepareResponseFrom((AbstractResponse)this.fullFetchResponse(this.tidp0, this.records, Errors.NONE, 100L, -1L, 0, Optional.of(nodeId0.id())), tp0Leader);
        this.client.prepareResponseFrom((AbstractResponse)this.fullFetchResponse(this.tidp1, this.records, Errors.NONE, 100L, -1L, 0, Optional.of(nodeId0.id())), tp1Leader);
        this.networkClientDelegate.poll(this.time.timer(0L));
        Assertions.assertTrue((boolean)this.fetcher.hasCompletedFetches());
        Map partitionRecords = this.fetchRecords();
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp0));
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp1));
        Node selected = this.fetcher.selectReadReplica(this.tp0, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)nodeId0.id(), (int)selected.id());
        selected = this.fetcher.selectReadReplica(this.tp1, Node.noNode(), this.time.milliseconds());
        Assertions.assertEquals((int)nodeId0.id(), (int)selected.id());
        Assertions.assertEquals((int)1, (int)this.sendFetches());
        Assertions.assertFalse((boolean)this.fetcher.hasCompletedFetches());
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> partitions = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        Node newNode = new Node(999, "newnode", 999, "newrack");
        FetchResponseData.PartitionData tp0Data = new FetchResponseData.PartitionData().setPartitionIndex(this.tidp0.topicPartition().partition()).setErrorCode(error.code());
        tp0Data.currentLeader().setLeaderId(newNode.id());
        int tp0NewLeaderEpoch = 100;
        tp0Data.currentLeader().setLeaderEpoch(tp0NewLeaderEpoch);
        partitions.put(this.tidp0, tp0Data);
        partitions.put(this.tidp1, new FetchResponseData.PartitionData().setPartitionIndex(this.tidp1.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setHighWatermark(100L).setLastStableOffset(-1L).setLogStartOffset(0L).setRecords((BaseRecords)this.nextRecords));
        this.client.prepareResponseFrom((AbstractResponse)FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, partitions, Collections.singletonList(newNode)), nodeId0);
        this.networkClientDelegate.poll(this.time.timer(0L));
        partitionRecords = this.fetchRecords();
        Assertions.assertFalse((boolean)partitionRecords.containsKey(this.tp0));
        Assertions.assertTrue((boolean)partitionRecords.containsKey(this.tp1));
        Assertions.assertNotEquals((Object)startingClusterMetadata, (Object)this.metadata.fetch());
        Assertions.assertEquals((Object)newNode, (Object)this.metadata.fetch().nodeById(999));
        Metadata.LeaderAndEpoch currentLeaderTp0 = this.metadata.currentLeader(this.tp0);
        Assertions.assertEquals(Optional.of(newNode), (Object)currentLeaderTp0.leader);
        Assertions.assertEquals(Optional.of(tp0NewLeaderEpoch), (Object)currentLeaderTp0.epoch);
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        Assertions.assertEquals(Optional.empty(), (Object)this.subscriptions.preferredReadReplica(this.tp0, this.time.milliseconds()));
        Assertions.assertEquals(Optional.of(nodeId0.id()), (Object)this.subscriptions.preferredReadReplica(this.tp1, this.time.milliseconds()));
        Assertions.assertTrue((boolean)this.subscriptions.isFetchable(this.tp0));
        Metadata.LeaderAndEpoch currentLeader = this.subscriptions.position((TopicPartition)this.tp0).currentLeader;
        Assertions.assertEquals((int)newNode.id(), (int)((Node)currentLeader.leader.get()).id());
        Assertions.assertEquals((int)tp0NewLeaderEpoch, (Integer)((Integer)currentLeader.epoch.get()));
        Assertions.assertTrue((boolean)this.subscriptions.isFetchable(this.tp1));
    }

    private OffsetsForLeaderEpochResponse prepareOffsetsForLeaderEpochResponse(TopicPartition topicPartition, Errors error, int leaderEpoch, long endOffset) {
        OffsetForLeaderEpochResponseData data = new OffsetForLeaderEpochResponseData();
        data.topics().add((ImplicitLinkedHashCollection.Element)new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(topicPartition.topic()).setPartitions(Collections.singletonList(new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicPartition.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset))));
        return new OffsetsForLeaderEpochResponse(data);
    }

    private FetchResponse fetchResponseWithTopLevelError(TopicIdPartition tp, Errors error, int throttleTime) {
        Map<TopicIdPartition, FetchResponseData.PartitionData> partitions = Collections.singletonMap(tp, new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(error.code()).setHighWatermark(-1L));
        return FetchResponse.of((Errors)error, (int)throttleTime, (int)0, new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>(partitions));
    }

    private FetchResponse fullFetchResponseWithAbortedTransactions(MemoryRecords records, List<FetchResponseData.AbortedTransaction> abortedTransactions, Errors error, long lastStableOffset, long hw, int throttleTime) {
        Map<TopicIdPartition, FetchResponseData.PartitionData> partitions = Collections.singletonMap(this.tidp0, new FetchResponseData.PartitionData().setPartitionIndex(this.tp0.partition()).setErrorCode(error.code()).setHighWatermark(hw).setLastStableOffset(lastStableOffset).setLogStartOffset(0L).setAbortedTransactions(abortedTransactions).setRecords((BaseRecords)records));
        return FetchResponse.of((Errors)Errors.NONE, (int)throttleTime, (int)0, new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>(partitions));
    }

    private FetchResponse fullFetchResponse(int sessionId, TopicIdPartition tp, MemoryRecords records, Errors error, long hw, int throttleTime) {
        return this.fullFetchResponse(sessionId, tp, records, error, hw, -1L, throttleTime);
    }

    private FetchResponse fullFetchResponse(TopicIdPartition tp, MemoryRecords records, Errors error, long hw, int throttleTime) {
        return this.fullFetchResponse(tp, records, error, hw, -1L, throttleTime);
    }

    private FetchResponse fullFetchResponse(TopicIdPartition tp, MemoryRecords records, Errors error, long hw, long lastStableOffset, int throttleTime) {
        return this.fullFetchResponse(0, tp, records, error, hw, lastStableOffset, throttleTime);
    }

    private FetchResponse fullFetchResponse(int sessionId, TopicIdPartition tp, MemoryRecords records, Errors error, long hw, long lastStableOffset, int throttleTime) {
        Map<TopicIdPartition, FetchResponseData.PartitionData> partitions = Collections.singletonMap(tp, new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(error.code()).setHighWatermark(hw).setLastStableOffset(lastStableOffset).setLogStartOffset(0L).setRecords((BaseRecords)records));
        return FetchResponse.of((Errors)Errors.NONE, (int)throttleTime, (int)sessionId, new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>(partitions));
    }

    private FetchResponse fullFetchResponse(TopicIdPartition tp, MemoryRecords records, Errors error, long hw, long lastStableOffset, int throttleTime, Optional<Integer> preferredReplicaId) {
        Map<TopicIdPartition, FetchResponseData.PartitionData> partitions = Collections.singletonMap(tp, new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(error.code()).setHighWatermark(hw).setLastStableOffset(lastStableOffset).setLogStartOffset(0L).setRecords((BaseRecords)records).setPreferredReadReplica(preferredReplicaId.orElse(-1).intValue()));
        return FetchResponse.of((Errors)Errors.NONE, (int)throttleTime, (int)0, new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>(partitions));
    }

    private FetchResponse fetchResponse(TopicIdPartition tp, MemoryRecords records, Errors error, long hw, long lastStableOffset, long logStartOffset, int throttleTime) {
        Map<TopicIdPartition, FetchResponseData.PartitionData> partitions = Collections.singletonMap(tp, new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(error.code()).setHighWatermark(hw).setLastStableOffset(lastStableOffset).setLogStartOffset(logStartOffset).setRecords((BaseRecords)records));
        return FetchResponse.of((Errors)Errors.NONE, (int)throttleTime, (int)0, new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>(partitions));
    }

    private void assertEmptyFetch(String reason) {
        Fetch fetch = this.collectFetch();
        Assertions.assertEquals(Collections.emptyMap(), (Object)fetch.records(), (String)reason);
        Assertions.assertFalse((boolean)fetch.positionAdvanced(), (String)reason);
        Assertions.assertTrue((boolean)fetch.isEmpty(), (String)reason);
    }

    private <K, V> Map<TopicPartition, List<ConsumerRecord<K, V>>> fetchRecords() {
        Fetch<K, V> fetch = this.collectFetch();
        return fetch.records();
    }

    private <K, V> Fetch<K, V> collectFetch() {
        return ((TestableFetchRequestManager)this.fetcher).collectFetch();
    }

    private void buildFetcher(int maxPollRecords) {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), maxPollRecords, IsolationLevel.READ_UNCOMMITTED);
    }

    private void buildFetcher() {
        this.buildFetcher(Integer.MAX_VALUE);
    }

    private void buildFetcher(Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer) {
        this.buildFetcher(OffsetResetStrategy.EARLIEST, keyDeserializer, valueDeserializer, Integer.MAX_VALUE, IsolationLevel.READ_UNCOMMITTED);
    }

    private <K, V> void buildFetcher(OffsetResetStrategy offsetResetStrategy, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, int maxPollRecords, IsolationLevel isolationLevel) {
        this.buildFetcher(new MetricConfig(), offsetResetStrategy, keyDeserializer, valueDeserializer, maxPollRecords, isolationLevel);
    }

    private <K, V> void buildFetcher(MetricConfig metricConfig, OffsetResetStrategy offsetResetStrategy, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, int maxPollRecords, IsolationLevel isolationLevel) {
        this.buildFetcher(metricConfig, offsetResetStrategy, keyDeserializer, valueDeserializer, maxPollRecords, isolationLevel, Long.MAX_VALUE);
    }

    private <K, V> void buildFetcher(MetricConfig metricConfig, OffsetResetStrategy offsetResetStrategy, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, int maxPollRecords, IsolationLevel isolationLevel, long metadataExpireMs) {
        LogContext logContext = new LogContext();
        SubscriptionState subscriptionState = new SubscriptionState(logContext, offsetResetStrategy);
        this.buildFetcher(metricConfig, keyDeserializer, valueDeserializer, maxPollRecords, isolationLevel, metadataExpireMs, subscriptionState, logContext);
    }

    private <K, V> void buildFetcher(MetricConfig metricConfig, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, int maxPollRecords, IsolationLevel isolationLevel, long metadataExpireMs, SubscriptionState subscriptionState, LogContext logContext) {
        this.buildDependencies(metricConfig, metadataExpireMs, subscriptionState, logContext);
        Deserializers deserializers = new Deserializers(keyDeserializer, valueDeserializer);
        FetchConfig fetchConfig = new FetchConfig(1, Integer.MAX_VALUE, 0, 1000, maxPollRecords, true, "", isolationLevel);
        FetchCollector fetchCollector = new FetchCollector(logContext, this.metadata, this.subscriptions, fetchConfig, deserializers, this.metricsManager, (Time)this.time);
        this.fetcher = (TestableFetchRequestManager)((Object)Mockito.spy(new TestableFetchRequestManager(logContext, this.time, this.metadata, subscriptionState, fetchConfig, new FetchBuffer(logContext), this.metricsManager, this.networkClientDelegate, fetchCollector, this.apiVersions)));
        ConsumerNetworkClient consumerNetworkClient = new ConsumerNetworkClient(logContext, (KafkaClient)this.client, (Metadata)this.metadata, (Time)this.time, 100L, 30000, Integer.MAX_VALUE);
        this.offsetFetcher = new OffsetFetcher(logContext, consumerNetworkClient, this.metadata, this.subscriptions, (Time)this.time, 100L, 30000L, isolationLevel, this.apiVersions);
    }

    private void buildDependencies(MetricConfig metricConfig, long metadataExpireMs, SubscriptionState subscriptionState, LogContext logContext) {
        this.time = new MockTime(1L, 0L, 0L);
        this.subscriptions = subscriptionState;
        this.metadata = new ConsumerMetadata(0L, 0L, metadataExpireMs, false, false, this.subscriptions, logContext, new ClusterResourceListeners());
        this.client = new MockClient((Time)this.time, (Metadata)this.metadata);
        this.metrics = new Metrics(metricConfig, (Time)this.time);
        this.metricsRegistry = new FetchMetricsRegistry(metricConfig.tags().keySet(), "consumertest-group");
        this.metricsManager = new FetchMetricsManager(this.metrics, this.metricsRegistry);
        Properties properties = new Properties();
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        properties.setProperty("request.timeout.ms", String.valueOf(30000L));
        properties.setProperty("retry.backoff.ms", String.valueOf(100L));
        ConsumerConfig config = new ConsumerConfig(properties);
        this.networkClientDelegate = (TestableNetworkClientDelegate)((Object)Mockito.spy((Object)((Object)new TestableNetworkClientDelegate(this.time, config, logContext, this.client))));
    }

    private <T> List<Long> collectRecordOffsets(List<ConsumerRecord<T, T>> records) {
        return records.stream().map(ConsumerRecord::offset).collect(Collectors.toList());
    }

    private class TestableNetworkClientDelegate
    extends NetworkClientDelegate {
        private final Logger log;
        private final ConcurrentLinkedQueue<Node> pendingDisconnects;

        public TestableNetworkClientDelegate(Time time, ConsumerConfig config, LogContext logContext, KafkaClient client) {
            super(time, config, logContext, client);
            this.log = LoggerFactory.getLogger(NetworkClientDelegate.class);
            this.pendingDisconnects = new ConcurrentLinkedQueue();
        }

        public void poll(long timeoutMs, long currentTimeMs) {
            this.handlePendingDisconnects();
            super.poll(timeoutMs, currentTimeMs);
        }

        public void pollNoWakeup() {
            this.poll(FetchRequestManagerTest.this.time.timer(0L));
        }

        public int pendingRequestCount() {
            return this.unsentRequests().size() + FetchRequestManagerTest.this.client.inFlightRequestCount();
        }

        public void poll(Timer timer) {
            long pollTimeout = Math.min(timer.remainingMs(), 30000L);
            if (FetchRequestManagerTest.this.client.inFlightRequestCount() == 0) {
                pollTimeout = Math.min(pollTimeout, 100L);
            }
            this.poll(pollTimeout, timer.currentTimeMs());
        }

        private Set<Node> unsentRequestNodes() {
            HashSet<Node> set = new HashSet<Node>();
            for (NetworkClientDelegate.UnsentRequest u : this.unsentRequests()) {
                u.node().ifPresent(set::add);
            }
            return set;
        }

        private List<NetworkClientDelegate.UnsentRequest> removeUnsentRequestByNode(Node node) {
            ArrayList<NetworkClientDelegate.UnsentRequest> list = new ArrayList<NetworkClientDelegate.UnsentRequest>();
            Iterator iter = this.unsentRequests().iterator();
            while (iter.hasNext()) {
                NetworkClientDelegate.UnsentRequest u = (NetworkClientDelegate.UnsentRequest)iter.next();
                if (!node.equals(u.node().orElse(null))) continue;
                iter.remove();
                list.add(u);
            }
            return list;
        }

        protected void checkDisconnects(long currentTimeMs) {
            for (Node node : this.unsentRequestNodes()) {
                if (!FetchRequestManagerTest.this.client.connectionFailed(node)) continue;
                for (NetworkClientDelegate.UnsentRequest unsentRequest : this.removeUnsentRequestByNode(node)) {
                    this.log.error("checkDisconnects - please update! unsentRequest: {}", (Object)unsentRequest);
                }
            }
        }

        private void handlePendingDisconnects() {
            Node node;
            while ((node = this.pendingDisconnects.poll()) != null) {
                this.failUnsentRequests(node, (RuntimeException)DisconnectException.INSTANCE);
                FetchRequestManagerTest.this.client.disconnect(node.idString());
            }
        }

        public void disconnectAsync(Node node) {
            this.pendingDisconnects.offer(node);
            FetchRequestManagerTest.this.client.wakeup();
        }

        private void failUnsentRequests(Node node, RuntimeException e) {
            for (NetworkClientDelegate.UnsentRequest unsentRequest : this.removeUnsentRequestByNode(node)) {
                NetworkClientDelegate.FutureCompletionHandler handler = unsentRequest.handler();
                handler.onFailure(FetchRequestManagerTest.this.time.milliseconds(), e);
            }
        }
    }

    private class TestableFetchRequestManager<K, V>
    extends FetchRequestManager {
        private final FetchCollector<K, V> fetchCollector;

        public TestableFetchRequestManager(LogContext logContext, Time time, ConsumerMetadata metadata, SubscriptionState subscriptions, FetchConfig fetchConfig, FetchBuffer fetchBuffer, FetchMetricsManager metricsManager, NetworkClientDelegate networkClientDelegate, FetchCollector<K, V> fetchCollector, ApiVersions apiVersions) {
            super(logContext, time, metadata, subscriptions, fetchConfig, fetchBuffer, metricsManager, networkClientDelegate, apiVersions);
            this.fetchCollector = fetchCollector;
        }

        private Fetch<K, V> collectFetch() {
            return this.fetchCollector.collectFetch(this.fetchBuffer);
        }

        private int sendFetches() {
            NetworkClientDelegate.PollResult pollResult = this.poll(this.time.milliseconds());
            FetchRequestManagerTest.this.networkClientDelegate.addAll(pollResult.unsentRequests);
            return pollResult.unsentRequests.size();
        }

        private void clearBufferedDataForUnassignedPartitions(Set<TopicPartition> partitions) {
            this.fetchBuffer.retainAll(partitions);
        }
    }
}

