/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import org.apache.syncope.common.lib.command.CommandOutput;
import org.apache.syncope.common.lib.command.CommandTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.rest.api.beans.AbstractQuery;
import org.apache.syncope.common.rest.api.beans.CommandQuery;
import org.apache.syncope.common.rest.api.service.CommandService;
import org.apache.syncope.core.logic.CommandLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.data.domain.Page;

public class CommandServiceImpl
extends AbstractService
implements CommandService {
    protected final CommandLogic logic;

    public CommandServiceImpl(CommandLogic logic) {
        this.logic = logic;
    }

    public PagedResult<CommandTO> search(CommandQuery query) {
        String keyword = query.getKeyword() == null ? null : query.getKeyword().replace('*', '%');
        Page result = this.logic.search(keyword, CommandServiceImpl.pageable((AbstractQuery)query));
        return this.buildPagedResult(result);
    }

    public CommandTO read(String key) {
        return this.logic.read(key);
    }

    public CommandOutput run(CommandTO command) {
        return new CommandOutput.Builder(command).output(this.logic.run(command)).build();
    }
}

