/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.spring.boot.autoconfigure.jaxws;

import jakarta.annotation.Resource;
import jakarta.xml.ws.WebServiceContext;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Resource.class, WebServiceContext.class})
public class CxfJaxwsAutoConfiguration {
    @Bean
    static BeanFactoryPostProcessor jaxwsBeanFactoryPostProcessor() {
        return new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                Map beans = beanFactory.getBeansOfType(CommonAnnotationBeanPostProcessor.class, true, false);
                beans.forEach((name, bean) -> bean.ignoreResourceType(WebServiceContext.class.getName()));
            }
        };
    }
}

