/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.list;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggle;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggleConfig;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPasswordFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.MultiFieldPanel;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnConfPropertyListView
extends ListView<ConnConfProperty> {
    private static final long serialVersionUID = -5239334900329150316L;
    private static final Logger LOG = LoggerFactory.getLogger(ConnConfPropertyListView.class);
    private final boolean withOverridable;

    public ConnConfPropertyListView(String id, IModel<? extends List<ConnConfProperty>> model, boolean withOverridable) {
        super(id, model);
        this.withOverridable = withOverridable;
    }

    protected void populateItem(ListItem<ConnConfProperty> item) {
        AjaxPasswordFieldPanel fieldPanel;
        AjaxPasswordFieldPanel field;
        ConnConfProperty property = (ConnConfProperty)item.getModelObject();
        String label = StringUtils.isBlank((CharSequence)property.getSchema().getDisplayName()) ? property.getSchema().getName() : property.getSchema().getDisplayName();
        boolean required = false;
        boolean isArray = false;
        if (property.getSchema().isConfidential() || "org.identityconnectors.common.security.GuardedString".equalsIgnoreCase(property.getSchema().getType()) || "org.identityconnectors.common.security.GuardedByteArray".equalsIgnoreCase(property.getSchema().getType())) {
            field = new AjaxPasswordFieldPanel("panel", label, (IModel)Model.of(), false);
            ((PasswordTextField)field.getField()).setResetPassword(false);
            required = property.getSchema().isRequired();
        } else {
            Class propertySchemaClass;
            try {
                propertySchemaClass = ClassUtils.getClass((String)property.getSchema().getType());
                if (ClassUtils.isPrimitiveOrWrapper((Class)propertySchemaClass)) {
                    propertySchemaClass = ClassUtils.primitiveToWrapper(propertySchemaClass);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error("Error parsing attribute type", (Throwable)e);
                propertySchemaClass = String.class;
            }
            if (ClassUtils.isAssignable(Number.class, (Class)propertySchemaClass)) {
                field = new AjaxNumberFieldPanel.Builder().build("panel", label, AjaxNumberFieldPanel.cast((Class)propertySchemaClass), (IModel)new Model());
                required = property.getSchema().isRequired();
            } else if (ClassUtils.isAssignable(Boolean.class, (Class)propertySchemaClass)) {
                field = new AjaxCheckBoxPanel("panel", label, (IModel)new Model());
            } else {
                field = new AjaxTextFieldPanel("panel", label, (IModel)new Model());
                required = property.getSchema().isRequired();
            }
            if (propertySchemaClass.isArray()) {
                isArray = true;
            }
        }
        field.setIndex(item.getIndex());
        field.setTitle(property.getSchema().getHelpMessage(), true);
        if (isArray) {
            MultiFieldPanel multiFieldPanel = new MultiFieldPanel.Builder((IModel)new PropertyModel((Object)property, "values")).setEventTemplate(true).build("panel", label, (FieldPanel)field);
            item.add(new Component[]{multiFieldPanel});
            fieldPanel = multiFieldPanel;
        } else {
            ConnConfPropertyListView.setNewFieldModel((FieldPanel)field, property.getValues());
            item.add(new Component[]{field});
            fieldPanel = field;
        }
        if (required) {
            fieldPanel.addRequiredLabel();
        }
        if (this.withOverridable) {
            fieldPanel.showExternAction(ConnConfPropertyListView.addCheckboxToggle(property));
        }
    }

    private static void setNewFieldModel(FieldPanel field, List<Object> values) {
        field.setNewModel(values);
    }

    private static FormComponent<?> addCheckboxToggle(ConnConfProperty property) {
        BootstrapToggleConfig config = new BootstrapToggleConfig().withOnStyle(BootstrapToggleConfig.Style.success).withOffStyle(BootstrapToggleConfig.Style.danger).withSize(BootstrapToggleConfig.Size.mini);
        return new BootstrapToggle("externalAction", (IModel)new PropertyModel((Object)property, "overridable"), config){
            private static final long serialVersionUID = -875219845189261873L;

            protected CheckBox newCheckBox(String id, IModel<Boolean> model) {
                CheckBox checkBox = super.newCheckBox(id, model);
                checkBox.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                    }
                }});
                return checkBox;
            }

            protected IModel<String> getOnLabel() {
                return Model.of((Serializable)((Object)"Override"));
            }

            protected IModel<String> getOffLabel() {
                return Model.of((Serializable)((Object)"Override?"));
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.append("class", (CharSequence)"overridable", " ");
            }
        };
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.getModelObject().isEmpty()) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("$('#emptyPlaceholder').append(\"%s\")", this.getString("property.empty.list"))));
        }
    }
}

