/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test;

import java.util.Date;
import junit.framework.TestCase;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.impl.ProcessEngineImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.test.TestHelper;
import org.flowable.engine.test.mock.FlowableMockSupport;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;

@Deprecated(forRemoval=true, since="7.2.0")
public abstract class FlowableTestCase
extends TestCase {
    protected String configurationResource = "flowable.cfg.xml";
    protected String deploymentId;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historicDataService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected FormService formService;
    private FlowableMockSupport mockSupport;

    public void assertProcessEnded(String processInstanceId) {
        TestHelper.assertProcessEnded(this.processEngine, processInstanceId);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.processEngine == null) {
            this.initializeProcessEngine();
        }
        this.initializeServices();
        this.initializeMockSupport();
    }

    protected void runTest() throws Throwable {
        TestHelper.annotationMockSupportSetup(((Object)((Object)this)).getClass(), this.getName(), this.mockSupport);
        this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName());
        super.runTest();
        TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, ((Object)((Object)this)).getClass(), this.getName());
        TestHelper.annotationMockSupportTeardown(this.mockSupport);
    }

    protected void initializeProcessEngine() {
        this.processEngine = TestHelper.getProcessEngine(this.getConfigurationResource());
    }

    protected void initializeServices() {
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historicDataService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.formService = this.processEngine.getFormService();
    }

    protected void initializeMockSupport() {
        if (FlowableMockSupport.isMockSupportPossible(this.processEngine)) {
            this.mockSupport = new FlowableMockSupport(this.processEngine);
        }
    }

    protected EventRepositoryService getEventRepositoryService() {
        return this.getEventRegistryEngineConfiguration().getEventRepositoryService();
    }

    protected EventRegistry getEventRegistry() {
        return this.getEventRegistryEngineConfiguration().getEventRegistry();
    }

    protected EventRegistryEngineConfiguration getEventRegistryEngineConfiguration() {
        return (EventRegistryEngineConfiguration)this.processEngineConfiguration.getEngineConfigurations().get("cfg.eventRegistry");
    }

    protected void tearDown() throws Exception {
        this.processEngineConfiguration.getClock().reset();
        if (this.mockSupport != null) {
            this.mockSupport.reset();
        }
        super.tearDown();
    }

    public static void closeProcessEngines() {
        TestHelper.closeProcessEngines();
    }

    public void setCurrentTime(Date currentTime) {
        this.processEngineConfiguration.getClock().setCurrentTime(currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public FlowableMockSupport getMockSupport() {
        return this.mockSupport;
    }

    public FlowableMockSupport mockSupport() {
        return this.mockSupport;
    }
}

