/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.audit;

import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;

public class SamlRequestAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    public String[] resolveFrom(JoinPoint joinPoint, Object returnValue) {
        if (returnValue instanceof Pair) {
            Pair context = (Pair)returnValue;
            return this.getAuditResourceFromSamlRequest((XMLObject)context.getLeft());
        }
        if (returnValue instanceof XMLObject) {
            XMLObject xmlObject = (XMLObject)returnValue;
            return this.getAuditResourceFromSamlRequest(xmlObject);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    protected String[] getAuditResourceFromSamlRequest(XMLObject returnValue) {
        if (returnValue instanceof AuthnRequest) {
            AuthnRequest authnRequest = (AuthnRequest)returnValue;
            return this.getAuditResourceFromSamlAuthnRequest(authnRequest);
        }
        if (returnValue instanceof LogoutRequest) {
            LogoutRequest logoutRequest = (LogoutRequest)returnValue;
            return this.getAuditResourceFromSamlLogoutRequest(logoutRequest);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    protected String[] getAuditResourceFromSamlLogoutRequest(LogoutRequest returnValue) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("issuer", returnValue.getIssuer().getValue());
        return new String[]{this.auditFormat.serialize(values)};
    }

    protected String[] getAuditResourceFromSamlAuthnRequest(AuthnRequest returnValue) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("issuer", returnValue.getIssuer().getValue());
        values.put("binding", returnValue.getProtocolBinding());
        values.put("destination", returnValue.getDestination());
        return new String[]{this.auditFormat.serialize(values)};
    }
}

