/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.saml2;

import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientsEndpointContributor;
import org.apereo.cas.util.CollectionUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.SAML2MetadataResolver;

public class DelegatedClientsSaml2EndpointContributor
implements DelegatedClientsEndpointContributor {
    public boolean supports(BaseClient client) {
        return client instanceof SAML2Client;
    }

    public Map<String, Object> contribute(BaseClient client) {
        SAML2Client saml2Client = (SAML2Client)client;
        saml2Client.init();
        SAML2Configuration configuration = saml2Client.getConfiguration();
        String identityProviderEntityId = configuration.getIdentityProviderEntityId();
        if (StringUtils.isBlank((CharSequence)identityProviderEntityId)) {
            SAML2MetadataResolver identityProviderMetadataResolver = configuration.getIdentityProviderMetadataResolver();
            identityProviderMetadataResolver.resolve();
            identityProviderEntityId = identityProviderMetadataResolver.getEntityId();
        }
        Map payload = CollectionUtils.wrap((String)"maximumAuthenticationLifetime", (Object)configuration.getMaximumAuthenticationLifetime(), (String)"acceptedSkew", (Object)configuration.getAcceptedSkew(), (String)"mappedAttributes", (Object)configuration.getMappedAttributes(), (String)"nameIdAttribute", (Object)configuration.getNameIdAttribute(), (String)"attributeAsId", (Object)configuration.getAttributeAsId(), (String)"nameIdPolicyFormat", (Object)configuration.getNameIdPolicyFormat(), (String)"serviceProviderEntityId", (Object)configuration.getServiceProviderEntityId(), (String)"identityProviderEntityId", (Object)identityProviderEntityId, (String)"identityProviderMetadata", (Object)configuration.getIdentityProviderMetadataResource().toString());
        payload.put("wantsAssertionsSigned", BooleanUtils.toStringTrueFalse((boolean)configuration.isWantsAssertionsSigned()));
        payload.put("wantsResponsesSigned", BooleanUtils.toStringTrueFalse((boolean)configuration.isWantsResponsesSigned()));
        payload.put("type", "saml2");
        return payload;
    }
}

