/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.servlet.Filter;
import java.util.Collection;
import org.apereo.cas.config.CasCoreActuatorsConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.inspektr.common.web.ClientInfoExtractionOptions;
import org.apereo.inspektr.common.web.ClientInfoThreadLocalFilter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.DispatcherServlet;

@ManagementContextConfiguration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={DispatcherServlet.class})
@ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Import(value={CasCoreActuatorsConfiguration.class})
class CasCoreWebManagementContextConfiguration {
    CasCoreWebManagementContextConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(name={"casClientInfoLoggingFilterManagementContext"})
    public FilterRegistrationBean<ClientInfoThreadLocalFilter> casClientInfoLoggingFilterManagementContext(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, CasConfigurationProperties casProperties) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        AuditEngineProperties audit = casProperties.getAudit().getEngine();
        ClientInfoExtractionOptions options = ClientInfoExtractionOptions.builder().alternateLocalAddrHeaderName(audit.getAlternateClientAddrHeaderName()).alternateServerAddrHeaderName(audit.getAlternateServerAddrHeaderName()).useServerHostAddress(audit.isUseServerHostAddress()).httpRequestHeaders(audit.getHttpRequestHeaders()).build();
        bean.setFilter((Filter)new ClientInfoThreadLocalFilter(options, tenantExtractor));
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("CAS Client Info Logging Filter");
        bean.setAsyncSupported(true);
        bean.setOrder(-2147483647);
        return bean;
    }
}

