/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import lombok.Generated;
import org.apereo.cas.config.CasConfigurationModifiedEvent;
import org.apereo.cas.services.ServiceRegistryInitializer;
import org.apereo.cas.services.ServiceRegistryInitializerEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;

public class DefaultServiceRegistryInitializerEventListener
implements ServiceRegistryInitializerEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceRegistryInitializerEventListener.class);
    private final ObjectProvider<ServiceRegistryInitializer> serviceRegistryInitializer;

    @Override
    public void handleRefreshScopeRefreshedEvent(RefreshScopeRefreshedEvent event) {
        LOGGER.info("Refreshing application context beans eagerly...");
        this.rebind();
    }

    @Override
    public void handleEnvironmentChangeEvent(EnvironmentChangeEvent event) {
        LOGGER.trace("Received event [{}]", (Object)event);
        this.rebind();
    }

    @Override
    public void handleConfigurationModifiedEvent(CasConfigurationModifiedEvent event) {
        if (event.isEligibleForContextRefresh()) {
            this.rebind();
        }
    }

    private void rebind() {
        LOGGER.info("Refreshing CAS service registry configuration. Stand by...");
        ((ServiceRegistryInitializer)this.serviceRegistryInitializer.getObject()).initialize();
    }

    @Generated
    public DefaultServiceRegistryInitializerEventListener(ObjectProvider<ServiceRegistryInitializer> serviceRegistryInitializer) {
        this.serviceRegistryInitializer = serviceRegistryInitializer;
    }
}

