/*
 * Decompiled with CFR 0.152.
 */
package com.duosecurity.service;

import com.duosecurity.Utils;
import com.duosecurity.exception.DuoException;
import com.duosecurity.model.HealthCheckResponse;
import com.duosecurity.model.TokenResponse;
import com.duosecurity.service.DuoService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import okhttp3.CertificatePinner;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class DuoConnector {
    protected Retrofit retrofit;
    private static final int SUCCESS_STATUS_CODE = 200;

    public DuoConnector(String apiHost, String[] caCerts) throws DuoException {
        this(apiHost, null, null, caCerts);
    }

    public DuoConnector(String apiHost, String proxyHost, Integer proxyPort, String[] caCerts) throws DuoException {
        OkHttpClient client;
        CertificatePinner duoCertificatePinner = new CertificatePinner.Builder().add(apiHost, caCerts).build();
        if (proxyHost != null && proxyPort != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort));
            client = new OkHttpClient.Builder().certificatePinner(duoCertificatePinner).proxy(proxy).build();
        } else {
            client = new OkHttpClient.Builder().certificatePinner(duoCertificatePinner).build();
        }
        this.retrofit = new Retrofit.Builder().baseUrl(Utils.getAndValidateUrl(apiHost, "").toString()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).client(client).build();
    }

    public HealthCheckResponse duoHealthcheck(String clientId, String clientAssertion) throws DuoException {
        DuoService service = (DuoService)this.retrofit.create(DuoService.class);
        Call<HealthCheckResponse> callSync = service.duoHealthCheck(clientId, clientAssertion);
        try {
            Response response = callSync.execute();
            return (HealthCheckResponse)response.body();
        }
        catch (IOException e) {
            throw new DuoException(e.getMessage(), e);
        }
    }

    public TokenResponse exchangeAuthorizationCodeFor2FAResult(String userAgent, String grantType, String duoCode, String redirectUri, String clientAssertionType, String clientAssertion) throws DuoException {
        DuoService service = (DuoService)this.retrofit.create(DuoService.class);
        Call<TokenResponse> callSync = service.exchangeAuthorizationCodeFor2FAResult(userAgent, grantType, duoCode, redirectUri, clientAssertionType, clientAssertion);
        try {
            Response response = callSync.execute();
            if (response.code() != 200 || response.body() == null) {
                String message = response.message();
                if (response.errorBody() != null) {
                    throw new DuoException(String.format("msg=%s, msg_detail=%s", message, response.errorBody().string()));
                }
                throw new DuoException(message);
            }
            return (TokenResponse)response.body();
        }
        catch (IOException e) {
            throw new DuoException(e.getMessage(), e);
        }
    }
}

