/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.server.FailedPartitions;
import kafka.server.FetcherThreadTestUtils$;
import kafka.server.Fetching$;
import kafka.server.MockFetcherThread;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockLeaderEndPoint$;
import kafka.server.MockTierStateMachine;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionState;
import kafka.server.PartitionState$;
import kafka.server.Truncating$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005A4Aa\u0003\u0007\u0001#!)\u0001\u0004\u0001C\u00013!9A\u0004\u0001b\u0001\n\u0003i\u0002BB\u001c\u0001A\u0003%a\u0004C\u00049\u0001\t\u0007I\u0011A\u001d\t\ru\u0002\u0001\u0015!\u0003;\u0011\u001dq\u0004A1A\u0005\n}Baa\u0011\u0001!\u0002\u0013\u0001\u0005\"\u0002#\u0001\t\u0003)\u0005\"\u00023\u0001\t\u0003)\u0007\"\u00026\u0001\t\u0003Y'\u0001\u0006+jKJ\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f)\u0016\u001cHO\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0001\"a\u0007\u0001\u000e\u00031\t\u0001\u0002^8qS\u000eLEm]\u000b\u0002=A!qD\t\u0013-\u001b\u0005\u0001#BA\u0011\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003G\u0001\u00121!T1q!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0003mC:<'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\u0019\u0012aa\u0015;sS:<\u0007CA\u00176\u001b\u0005q#BA\u00181\u0003\u0019\u0019w.\\7p]*\u0011q\"\r\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014x-\u0003\u00027]\t!Q+^5e\u0003%!x\u000e]5d\u0013\u0012\u001c\b%A\u0004wKJ\u001c\u0018n\u001c8\u0016\u0003i\u0002\"aE\u001e\n\u0005q\"\"!B*i_J$\u0018\u0001\u0003<feNLwN\u001c\u0011\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001cX#\u0001!\u0011\u0005m\t\u0015B\u0001\"\r\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/A\tgC&dW\r\u001a)beRLG/[8og\u0002\n1\u0005^3ti\u001a{G\u000e\\8xKJ4U\r^2i\u001b>4X\r\u001a+p)&,'/\u001a3Ti>\u0014X\r\u0006\u0002G\u0013B\u00111cR\u0005\u0003\u0011R\u0011A!\u00168ji\")!\n\u0003a\u0001\u0017\u0006yAO];oG\u0006$Xm\u00148GKR\u001c\u0007\u000e\u0005\u0002\u0014\u0019&\u0011Q\n\u0006\u0002\b\u0005>|G.Z1oQ\tAq\n\u0005\u0002Q/6\t\u0011K\u0003\u0002S'\u00061\u0001/\u0019:b[NT!\u0001V+\u0002\u000f),\b/\u001b;fe*\u0011akM\u0001\u0006UVt\u0017\u000e^\u0005\u00031F\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u0011A!\fY1\u0011\u0005msV\"\u0001/\u000b\u0005u\u000b\u0016\u0001\u00039s_ZLG-\u001a:\n\u0005}c&a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0003E\u000eL\u0012!A\r\u0002\u0001\u0005\u0001D/Z:u\r>dGn\\<fe\u001a+Go\u00195PM\u001a\u001cX\r^(vi>3'+\u00198hK^KG\u000f\u001b+jKJ,Gm\u0015;pe\u0016$\"A\u00124\t\u000b)K\u0001\u0019A&)\u0005%y\u0005\u0006B\u0005[A&d#AY2\u0002WQ,7\u000f\u001e$f]\u000e,Gm\u00144gg\u0016$(+Z:fi\u00063G/\u001a:N_Z,G\rV8SK6|G/\u001a+jKJ$\"A\u00127\t\u000b)S\u0001\u0019A&)\u0005)y\u0005\u0006\u0002\u0006[A>d#AY2")
public class TierStateMachineTest {
    private final Map<String, Uuid> topicIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)Uuid.randomUuid())}));
    private final short version = ApiKeys.FETCH.latestVersion();
    private final FailedPartitions failedPartitions = new FailedPartitions();

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public short version() {
        return this.version;
    }

    private FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testFollowerFetchMovedToTieredStore(boolean truncateOnFetch) {
        TopicPartition partition = new TopicPartition("topic", 0);
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 0L, true);
        short x$22 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, truncateOnFetch, x$22);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(5L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("f".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(6L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("g".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(7L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("h".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(8L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("i".getBytes())})), (List)Nil$.MODULE$))));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 8L, true);
        leaderState.logStartOffset_$eq(0L);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)(truncateOnFetch ? Option$.MODULE$.apply((Object)Fetching$.MODULE$) : Option$.MODULE$.apply((Object)Truncating$.MODULE$)), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$1 -> x$1.state()));
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)5L, (long)replicaState.localLogStartOffset());
        Assertions.assertEquals((long)5L, (long)replicaState.highWatermark());
        Assertions.assertEquals((long)5L, (long)replicaState.logEndOffset());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> fetcher.doWork());
        Assertions.assertEquals((int)4, (int)replicaState.log().size());
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)5L, (long)replicaState.localLogStartOffset());
        Assertions.assertEquals((long)8L, (long)replicaState.highWatermark());
        Assertions.assertEquals((long)9L, (long)replicaState.logEndOffset());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testFollowerFetchOffsetOutOfRangeWithTieredStore(boolean truncateOnFetch) {
        TopicPartition partition = new TopicPartition("topic", 0);
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 7, 0L, true);
        short x$2 = this.version();
        BrokerEndPoint x$32 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$32, truncateOnFetch, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 7))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(7L, 7, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("h".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(8L, 7, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("i".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(9L, 7, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("j".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(10L, 7, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k".getBytes())})), (List)Nil$.MODULE$))));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 7, 10L, true);
        leaderState.logStartOffset_$eq(5L);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)(truncateOnFetch ? Option$.MODULE$.apply((Object)Fetching$.MODULE$) : Option$.MODULE$.apply((Object)Truncating$.MODULE$)), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$3 -> x$3.state()));
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)5L, (long)replicaState.localLogStartOffset());
        Assertions.assertEquals((long)5L, (long)replicaState.highWatermark());
        Assertions.assertEquals((long)5L, (long)replicaState.logEndOffset());
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)7L, (long)replicaState.localLogStartOffset());
        Assertions.assertEquals((long)7L, (long)replicaState.highWatermark());
        Assertions.assertEquals((long)7L, (long)replicaState.logEndOffset());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> fetcher.doWork());
        Assertions.assertEquals((int)4, (int)replicaState.log().size());
        Assertions.assertEquals((long)5L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)7L, (long)replicaState.localLogStartOffset());
        Assertions.assertEquals((long)10L, (long)replicaState.highWatermark());
        Assertions.assertEquals((long)11L, (long)replicaState.logEndOffset());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testFencedOffsetResetAfterMovedToRemoteTier(boolean truncateOnFetch) {
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef isErrorHandled = BooleanRef.create((boolean)false);
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, truncateOnFetch, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(null, mockLeaderEndpoint, isErrorHandled){
            private final BooleanRef isErrorHandled$1;

            public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
                this.isErrorHandled$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(currentFetchState.currentLeaderEpoch()).append(" is fenced").toString());
            }
            {
                this.isErrorHandled$1 = isErrorHandled$1;
                super(mockLeaderEndpoint$1);
            }
        };
        FailedPartitions x$6 = this.failedPartitions();
        int x$7 = 0;
        int x$8 = 1;
        int x$9 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 2L, true);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 5))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(5L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(6L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 6L, true);
        leaderState.logStartOffset_$eq(0L);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertTrue((boolean)isErrorHandled.elem);
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.failedPartitions().contains(partition));
    }
}

