/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed;

import io.github.bucket4j.distributed.expiration.BasedOnTimeForRefillingBucketUpToMaxExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.expiration.FixedTtlExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.expiration.NoneExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.serialization.SerializationHandles;
import io.github.bucket4j.distributed.versioning.Version;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;

public interface ExpirationAfterWriteStrategy {
    public long calculateTimeToLiveMillis(RemoteBucketState var1, long var2);

    public static ExpirationAfterWriteStrategy none() {
        return NoneExpirationAfterWriteStrategy.INSTANCE;
    }

    public static ExpirationAfterWriteStrategy fixedTimeToLive(Duration ttl) {
        return new FixedTtlExpirationAfterWriteStrategy(ttl);
    }

    public static ExpirationAfterWriteStrategy basedOnTimeForRefillingBucketUpToMax(Duration keepAfterRefillDuration) {
        return new BasedOnTimeForRefillingBucketUpToMaxExpirationAfterWriteStrategy(keepAfterRefillDuration);
    }

    public static <O> void serialize(SerializationAdapter<O> adapter, O output, ExpirationAfterWriteStrategy expirationStrategy, Version backwardCompatibilityVersion, Scope scope) throws IOException {
        SerializationHandle<ExpirationAfterWriteStrategy> serializer = expirationStrategy.getSerializationHandle();
        adapter.writeInt(output, serializer.getTypeId());
        serializer.serialize(adapter, output, expirationStrategy, backwardCompatibilityVersion, scope);
    }

    public static <S> ExpirationAfterWriteStrategy deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
        int typeId = adapter.readInt(input);
        SerializationHandle serializer = SerializationHandles.CORE_HANDLES.getHandleByTypeId(typeId);
        return (ExpirationAfterWriteStrategy)serializer.deserialize(adapter, input);
    }

    public static ExpirationAfterWriteStrategy fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
        String typeName = (String)snapshot.get("type");
        SerializationHandle<?> serializer = SerializationHandles.CORE_HANDLES.getHandleByTypeName(typeName);
        return (ExpirationAfterWriteStrategy)serializer.fromJsonCompatibleSnapshot(snapshot);
    }

    public static Map<String, Object> toJsonCompatibleSnapshot(ExpirationAfterWriteStrategy expirationStrategy, Version backwardCompatibilityVersion, Scope scope) throws IOException {
        SerializationHandle<ExpirationAfterWriteStrategy> serializer = expirationStrategy.getSerializationHandle();
        Map<String, Object> result = expirationStrategy.getSerializationHandle().toJsonCompatibleSnapshot(expirationStrategy, backwardCompatibilityVersion, scope);
        result.put("type", serializer.getTypeName());
        return result;
    }

    public SerializationHandle<ExpirationAfterWriteStrategy> getSerializationHandle();
}

