/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.MissingSourceTopicException;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.ApplicationState;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.assignment.KafkaStreamsAssignment;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.assignment.TaskAssignmentUtils;
import org.apache.kafka.streams.processor.assignment.TaskAssignor;
import org.apache.kafka.streams.processor.assignment.TaskInfo;
import org.apache.kafka.streams.processor.internals.ChangelogTopics;
import org.apache.kafka.streams.processor.internals.ClientUtils;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.PartitionGrouper;
import org.apache.kafka.streams.processor.internals.RepartitionTopics;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentInfo;
import org.apache.kafka.streams.processor.internals.assignment.AssignorConfiguration;
import org.apache.kafka.streams.processor.internals.assignment.AssignorError;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.CopartitionedTopicsEnforcer;
import org.apache.kafka.streams.processor.internals.assignment.DefaultApplicationState;
import org.apache.kafka.streams.processor.internals.assignment.DefaultTaskInfo;
import org.apache.kafka.streams.processor.internals.assignment.DefaultTaskTopicPartition;
import org.apache.kafka.streams.processor.internals.assignment.FallbackPriorTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.LegacyStickyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.LegacyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.RackUtils;
import org.apache.kafka.streams.processor.internals.assignment.ReferenceContainer;
import org.apache.kafka.streams.processor.internals.assignment.SubscriptionInfo;
import org.apache.kafka.streams.state.HostInfo;
import org.slf4j.Logger;

public class StreamsPartitionAssignor
implements ConsumerPartitionAssignor,
Configurable {
    private Logger log;
    private String logPrefix;
    private static final ProcessId FUTURE_ID = ProcessId.randomProcessId();
    protected static final Comparator<TopicPartition> PARTITION_COMPARATOR = Comparator.comparing(TopicPartition::topic).thenComparingInt(TopicPartition::partition);
    private String userEndPoint;
    private AssignmentConfigs assignmentConfigs;
    private Supplier<Consumer<byte[], byte[]>> mainConsumerSupplier;
    private Admin adminClient;
    private TaskManager taskManager;
    private StreamsMetadataState streamsMetadataState;
    private PartitionGrouper partitionGrouper;
    private AtomicInteger assignmentErrorCode;
    private AtomicLong nextScheduledRebalanceMs;
    private Queue<StreamsException> nonFatalExceptionsToHandle;
    private Time time;
    protected int usedSubscriptionMetadataVersion = 11;
    private InternalTopicManager internalTopicManager;
    private CopartitionedTopicsEnforcer copartitionedTopicsEnforcer;
    private ConsumerPartitionAssignor.RebalanceProtocol rebalanceProtocol;
    private AssignorConfiguration.AssignmentListener assignmentListener;
    private Supplier<Optional<TaskAssignor>> customTaskAssignorSupplier;
    private Supplier<LegacyTaskAssignor> legacyTaskAssignorSupplier;
    private byte uniqueField;
    private Map<String, String> clientTags;

    public void configure(Map<String, ?> configs) {
        AssignorConfiguration assignorConfiguration = new AssignorConfiguration(configs);
        this.logPrefix = assignorConfiguration.logPrefix();
        this.log = new LogContext(this.logPrefix).logger(this.getClass());
        this.usedSubscriptionMetadataVersion = assignorConfiguration.configuredMetadataVersion(this.usedSubscriptionMetadataVersion);
        ReferenceContainer referenceContainer = assignorConfiguration.referenceContainer();
        this.mainConsumerSupplier = () -> Objects.requireNonNull(referenceContainer.mainConsumer, "Main consumer was not specified");
        this.adminClient = Objects.requireNonNull(referenceContainer.adminClient, "Admin client was not specified");
        this.taskManager = Objects.requireNonNull(referenceContainer.taskManager, "TaskManager was not specified");
        this.streamsMetadataState = Objects.requireNonNull(referenceContainer.streamsMetadataState, "StreamsMetadataState was not specified");
        this.assignmentErrorCode = referenceContainer.assignmentErrorCode;
        this.nextScheduledRebalanceMs = referenceContainer.nextScheduledRebalanceMs;
        this.nonFatalExceptionsToHandle = referenceContainer.nonFatalExceptionsToHandle;
        this.time = Objects.requireNonNull(referenceContainer.time, "Time was not specified");
        this.assignmentConfigs = assignorConfiguration.assignmentConfigs();
        this.partitionGrouper = new PartitionGrouper();
        this.userEndPoint = assignorConfiguration.userEndPoint();
        this.internalTopicManager = assignorConfiguration.internalTopicManager();
        this.copartitionedTopicsEnforcer = assignorConfiguration.copartitionedTopicsEnforcer();
        this.rebalanceProtocol = assignorConfiguration.rebalanceProtocol();
        this.customTaskAssignorSupplier = assignorConfiguration::customTaskAssignor;
        this.legacyTaskAssignorSupplier = assignorConfiguration::taskAssignor;
        this.assignmentListener = assignorConfiguration.assignmentListener();
        this.uniqueField = 0;
        this.clientTags = referenceContainer.clientTags;
    }

    public String name() {
        return "stream";
    }

    public List<ConsumerPartitionAssignor.RebalanceProtocol> supportedProtocols() {
        ArrayList<ConsumerPartitionAssignor.RebalanceProtocol> supportedProtocols = new ArrayList<ConsumerPartitionAssignor.RebalanceProtocol>();
        supportedProtocols.add(ConsumerPartitionAssignor.RebalanceProtocol.EAGER);
        if (this.rebalanceProtocol == ConsumerPartitionAssignor.RebalanceProtocol.COOPERATIVE) {
            supportedProtocols.add(this.rebalanceProtocol);
        }
        return supportedProtocols;
    }

    public ByteBuffer subscriptionUserData(Set<String> topics) {
        this.handleRebalanceStart(topics);
        this.uniqueField = (byte)(this.uniqueField + 1);
        Set<String> currentNamedTopologies = this.taskManager.topologyMetadata().namedTopologiesView();
        Map taskOffsetSums = this.taskManager.topologyMetadata().hasNamedTopologies() ? Utils.filterMap(this.taskManager.getTaskOffsetSums(), t -> currentNamedTopologies.contains(((TaskId)t.getKey()).topologyName())) : this.taskManager.getTaskOffsetSums();
        return new SubscriptionInfo(this.usedSubscriptionMetadataVersion, 11, this.taskManager.processId(), this.userEndPoint, taskOffsetSums, this.uniqueField, this.assignmentErrorCode.get(), this.clientTags).encode();
    }

    private Map<String, ConsumerPartitionAssignor.Assignment> errorAssignment(Map<ProcessId, ClientMetadata> clientsMetadata, int errorCode) {
        HashMap<String, ConsumerPartitionAssignor.Assignment> assignment = new HashMap<String, ConsumerPartitionAssignor.Assignment>();
        for (ClientMetadata clientMetadata : clientsMetadata.values()) {
            for (String consumerId : clientMetadata.consumers) {
                assignment.put(consumerId, new ConsumerPartitionAssignor.Assignment(Collections.emptyList(), new AssignmentInfo(11, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), errorCode).encode()));
            }
        }
        return assignment;
    }

    /*
     * WARNING - void declaration
     */
    public ConsumerPartitionAssignor.GroupAssignment assign(Cluster metadata, ConsumerPartitionAssignor.GroupSubscription groupSubscription) {
        Map subscriptions = groupSubscription.groupSubscription();
        HashMap<ProcessId, ClientMetadata> clientMetadataMap = new HashMap<ProcessId, ClientMetadata>();
        HashSet<TopicPartition> allOwnedPartitions = new HashSet<TopicPartition>();
        HashMap<ProcessId, Map<String, Optional<String>>> racksForProcessConsumer = new HashMap<ProcessId, Map<String, Optional<String>>>();
        int minReceivedMetadataVersion = 11;
        int minSupportedMetadataVersion = 11;
        boolean shutdownRequested = false;
        boolean assignmentErrorFound = false;
        int futureMetadataVersion = -1;
        for (Map.Entry entry : subscriptions.entrySet()) {
            void var19_22;
            Object processId;
            String consumerId = (String)entry.getKey();
            ConsumerPartitionAssignor.Subscription subscription = (ConsumerPartitionAssignor.Subscription)entry.getValue();
            SubscriptionInfo info = SubscriptionInfo.decode(subscription.userData());
            int usedVersion = info.version();
            if (info.errorCode() == AssignorError.SHUTDOWN_REQUESTED.code()) {
                shutdownRequested = true;
            }
            minReceivedMetadataVersion = this.updateMinReceivedVersion(usedVersion, minReceivedMetadataVersion);
            minSupportedMetadataVersion = this.updateMinSupportedVersion(info.latestSupportedVersion(), minSupportedMetadataVersion);
            if (usedVersion > 11) {
                futureMetadataVersion = usedVersion;
                processId = FUTURE_ID;
                if (!clientMetadataMap.containsKey(FUTURE_ID)) {
                    clientMetadataMap.put(FUTURE_ID, new ClientMetadata(FUTURE_ID, null, Collections.emptyMap(), subscription.rackId()));
                }
            } else {
                processId = info.processId();
            }
            racksForProcessConsumer.computeIfAbsent((ProcessId)processId, (Function<ProcessId, Map<String, Optional<String>>>)((Function<ProcessId, Map>)kv -> new HashMap())).put(consumerId, subscription.rackId());
            ClientMetadata clientMetadata = (ClientMetadata)clientMetadataMap.get(processId);
            if (clientMetadata == null) {
                ClientMetadata clientMetadata2 = new ClientMetadata(info.processId(), info.userEndPoint(), info.clientTags(), subscription.rackId());
                clientMetadataMap.put(info.processId(), clientMetadata2);
            }
            var19_22.addConsumer(consumerId, subscription.ownedPartitions());
            int prevSize = allOwnedPartitions.size();
            allOwnedPartitions.addAll(subscription.ownedPartitions());
            if (allOwnedPartitions.size() < prevSize + subscription.ownedPartitions().size()) {
                assignmentErrorFound = true;
            }
            var19_22.addPreviousTasksAndOffsetSums(consumerId, info.taskOffsetSums());
        }
        if (assignmentErrorFound) {
            this.log.warn("The previous assignment contains a partition more than once. \t Mapping: {}", (Object)subscriptions);
        }
        try {
            this.log.debug("Constructed client metadata {} from the member subscriptions.", clientMetadataMap);
            if (shutdownRequested) {
                return new ConsumerPartitionAssignor.GroupAssignment(this.errorAssignment(clientMetadataMap, AssignorError.SHUTDOWN_REQUESTED.code()));
            }
            RepartitionTopics repartitionTopics = this.prepareRepartitionTopics(metadata);
            Map<TopicPartition, PartitionInfo> allRepartitionTopicPartitions = repartitionTopics.topicPartitionsInfo();
            Cluster fullMetadata = metadata.withPartitions(allRepartitionTopicPartitions);
            this.log.debug("Created repartition topics {} from the parsed topology.", allRepartitionTopicPartitions.values());
            Map<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> topicGroups = this.taskManager.topologyMetadata().subtopologyTopicsInfoMapExcluding(repartitionTopics.topologiesWithMissingInputTopics());
            HashSet<String> allSourceTopics = new HashSet<String>();
            HashMap<TopologyMetadata.Subtopology, Set<String>> sourceTopicsByGroup = new HashMap<TopologyMetadata.Subtopology, Set<String>>();
            for (Map.Entry entry : topicGroups.entrySet()) {
                allSourceTopics.addAll(((InternalTopologyBuilder.TopicsInfo)entry.getValue()).sourceTopics);
                sourceTopicsByGroup.put((TopologyMetadata.Subtopology)entry.getKey(), ((InternalTopologyBuilder.TopicsInfo)entry.getValue()).sourceTopics);
            }
            Map<TaskId, Set<TopicPartition>> partitionsForTask = this.partitionGrouper.partitionGroups(sourceTopicsByGroup, fullMetadata);
            HashSet<TaskId> hashSet = new HashSet<TaskId>();
            boolean versionProbing = this.checkMetadataVersions(minReceivedMetadataVersion, minSupportedMetadataVersion, futureMetadataVersion);
            UserTaskAssignmentListener userTaskAssignmentListener = this.assignTasksToClients(fullMetadata, groupSubscription, allSourceTopics, topicGroups, clientMetadataMap, partitionsForTask, racksForProcessConsumer, hashSet);
            HashMap<HostInfo, Set<TopicPartition>> partitionsByHost = new HashMap<HostInfo, Set<TopicPartition>>();
            HashMap<HostInfo, Set<TopicPartition>> standbyPartitionsByHost = new HashMap<HostInfo, Set<TopicPartition>>();
            if (minReceivedMetadataVersion >= 2) {
                this.populatePartitionsByHostMaps(partitionsByHost, standbyPartitionsByHost, partitionsForTask, clientMetadataMap);
            }
            Map<String, ConsumerPartitionAssignor.Assignment> assignment = this.computeNewAssignment(hashSet, clientMetadataMap, partitionsForTask, partitionsByHost, standbyPartitionsByHost, allOwnedPartitions, minReceivedMetadataVersion, minSupportedMetadataVersion, versionProbing);
            ConsumerPartitionAssignor.GroupAssignment groupAssignment = new ConsumerPartitionAssignor.GroupAssignment(assignment);
            userTaskAssignmentListener.onAssignmentComputed(groupAssignment, groupSubscription);
            return groupAssignment;
        }
        catch (MissingSourceTopicException e) {
            this.log.error("Caught an error in the task assignment. Returning an error assignment.", (Throwable)((Object)e));
            return new ConsumerPartitionAssignor.GroupAssignment(this.errorAssignment(clientMetadataMap, AssignorError.INCOMPLETE_SOURCE_TOPIC_METADATA.code()));
        }
        catch (TaskAssignmentException e) {
            this.log.error("Caught an error in the task assignment. Returning an error assignment.", (Throwable)((Object)e));
            return new ConsumerPartitionAssignor.GroupAssignment(this.errorAssignment(clientMetadataMap, AssignorError.ASSIGNMENT_ERROR.code()));
        }
    }

    private ApplicationState buildApplicationState(TopologyMetadata topologyMetadata, Map<ProcessId, ClientMetadata> clientMetadataMap, Map<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> topicGroups, Cluster cluster) {
        HashMap<TopologyMetadata.Subtopology, Set<String>> sourceTopicsByGroup = new HashMap<TopologyMetadata.Subtopology, Set<String>>();
        HashMap<TopologyMetadata.Subtopology, Set<String>> changelogTopicsByGroup = new HashMap<TopologyMetadata.Subtopology, Set<String>>();
        for (Map.Entry<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> entry : topicGroups.entrySet()) {
            Set<String> sourceTopics = entry.getValue().sourceTopics;
            Set<String> changelogTopics = entry.getValue().changelogTopics();
            sourceTopicsByGroup.put(entry.getKey(), sourceTopics);
            changelogTopicsByGroup.put(entry.getKey(), changelogTopics);
        }
        HashMap<TaskId, Set<TopicPartition>> changelogPartitionsForTask = new HashMap<TaskId, Set<TopicPartition>>();
        Map<TaskId, Set<TopicPartition>> sourcePartitionsForTask = this.partitionGrouper.partitionGroups(sourceTopicsByGroup, changelogTopicsByGroup, changelogPartitionsForTask, cluster);
        if (!sourcePartitionsForTask.keySet().equals(changelogPartitionsForTask.keySet())) {
            this.log.error("Partition grouper returned {} tasks for source topics but {} tasks for changelog topics", (Object)sourcePartitionsForTask.size(), (Object)changelogPartitionsForTask.size());
            throw new TaskAssignmentException("Partition grouper returned conflicting information about the tasks for source topics vs changelog topics.");
        }
        HashSet topicsRequiringRackInfo = new HashSet();
        AtomicBoolean rackInformationFetched = new AtomicBoolean(false);
        Runnable fetchRackInformation = () -> {
            if (!rackInformationFetched.get()) {
                RackUtils.annotateTopicPartitionsWithRackInfo(cluster, this.internalTopicManager, topicsRequiringRackInfo);
                rackInformationFetched.set(true);
            }
        };
        HashMap topicPartitionsForTask = new HashMap();
        Set<TaskId> logicalTaskIds = Collections.unmodifiableSet(sourcePartitionsForTask.keySet());
        logicalTaskIds.forEach(taskId -> {
            DefaultTaskTopicPartition racklessTopicPartition;
            boolean isChangelog;
            boolean isSource;
            HashSet<DefaultTaskTopicPartition> topicPartitions = new HashSet<DefaultTaskTopicPartition>();
            for (TopicPartition topicPartition : (Set)sourcePartitionsForTask.get(taskId)) {
                isSource = true;
                isChangelog = ((Set)changelogPartitionsForTask.get(taskId)).contains(topicPartition);
                racklessTopicPartition = new DefaultTaskTopicPartition(topicPartition, true, isChangelog, fetchRackInformation);
                topicsRequiringRackInfo.add(racklessTopicPartition);
                topicPartitions.add(racklessTopicPartition);
            }
            for (TopicPartition topicPartition : (Set)changelogPartitionsForTask.get(taskId)) {
                isSource = ((Set)sourcePartitionsForTask.get(taskId)).contains(topicPartition);
                isChangelog = true;
                racklessTopicPartition = new DefaultTaskTopicPartition(topicPartition, isSource, true, fetchRackInformation);
                topicsRequiringRackInfo.add(racklessTopicPartition);
                topicPartitions.add(racklessTopicPartition);
            }
            topicPartitionsForTask.put(taskId, topicPartitions);
        });
        Map<TaskId, TaskInfo> logicalTasks = logicalTaskIds.stream().collect(Collectors.toMap(Function.identity(), taskId -> {
            Set<String> stateStoreNames = topologyMetadata.stateStoreNamesForSubtopology(taskId.topologyName(), taskId.subtopology());
            Set topicPartitions = (Set)topicPartitionsForTask.get(taskId);
            return new DefaultTaskInfo((TaskId)taskId, !stateStoreNames.isEmpty(), stateStoreNames, topicPartitions);
        }));
        return new DefaultApplicationState(this.assignmentConfigs, logicalTasks, clientMetadataMap);
    }

    private void processStreamsPartitionAssignment(TaskAssignor assignor, TaskAssignor.TaskAssignment taskAssignment, TaskAssignor.AssignmentError assignmentError, Map<ProcessId, ClientMetadata> clientMetadataMap, ConsumerPartitionAssignor.GroupSubscription groupSubscription) {
        if (assignmentError == TaskAssignor.AssignmentError.UNKNOWN_PROCESS_ID || assignmentError == TaskAssignor.AssignmentError.UNKNOWN_TASK_ID) {
            assignor.onAssignmentComputed(new ConsumerPartitionAssignor.GroupAssignment(Collections.emptyMap()), groupSubscription, assignmentError);
            this.log.error("Rebalance failed due to task assignor returning assignment with error {}, assignor callback will receive empty GroupAssignment due to this error", (Object)assignmentError);
            throw new StreamsException("Task assignment with " + assignor.getClass().getName() + " returned a fatal error: " + (Object)((Object)assignmentError));
        }
        taskAssignment.assignment().forEach(kafkaStreamsAssignment -> {
            ProcessId processId = kafkaStreamsAssignment.processId();
            ClientMetadata clientMetadata = (ClientMetadata)clientMetadataMap.get(processId);
            clientMetadata.state.setAssignedTasks((KafkaStreamsAssignment)kafkaStreamsAssignment);
            if (kafkaStreamsAssignment.followupRebalanceDeadline().isPresent()) {
                clientMetadata.state.setFollowupRebalanceDeadline(kafkaStreamsAssignment.followupRebalanceDeadline().get());
            }
        });
    }

    private boolean checkMetadataVersions(int minReceivedMetadataVersion, int minSupportedMetadataVersion, int futureMetadataVersion) {
        boolean versionProbing;
        if (futureMetadataVersion == -1) {
            versionProbing = false;
        } else if (minReceivedMetadataVersion >= 3) {
            versionProbing = true;
            this.log.info("Received a future (version probing) subscription (version: {}). Sending assignment back (with supported version {}).", (Object)futureMetadataVersion, (Object)minSupportedMetadataVersion);
        } else {
            throw new TaskAssignmentException("Received a future (version probing) subscription (version: " + futureMetadataVersion + ") and an incompatible pre Kafka 2.0 subscription (version: " + minReceivedMetadataVersion + ") at the same time.");
        }
        if (minReceivedMetadataVersion < 11) {
            this.log.info("Downgrade metadata to version {}. Latest supported version is {}.", (Object)minReceivedMetadataVersion, (Object)11);
        }
        if (minSupportedMetadataVersion < 11) {
            this.log.info("Downgrade latest supported metadata to version {}. Latest supported version is {}.", (Object)minSupportedMetadataVersion, (Object)11);
        }
        return versionProbing;
    }

    private RepartitionTopics prepareRepartitionTopics(Cluster metadata) {
        boolean isMissingInputTopics;
        RepartitionTopics repartitionTopics = new RepartitionTopics(this.taskManager.topologyMetadata(), this.internalTopicManager, this.copartitionedTopicsEnforcer, metadata, this.logPrefix);
        repartitionTopics.setup();
        boolean bl = isMissingInputTopics = !repartitionTopics.missingSourceTopicExceptions().isEmpty();
        if (isMissingInputTopics) {
            if (!this.taskManager.topologyMetadata().hasNamedTopologies()) {
                String errorMsg = String.format("Missing source topics. %s", repartitionTopics.missingSourceTopics());
                this.log.error(errorMsg);
                throw new MissingSourceTopicException(errorMsg);
            }
            this.nonFatalExceptionsToHandle.addAll(repartitionTopics.missingSourceTopicExceptions());
        }
        return repartitionTopics;
    }

    private void populateTasksForMaps(Map<TopicPartition, TaskId> taskForPartition, Map<TopologyMetadata.Subtopology, Set<TaskId>> tasksForTopicGroup, Set<String> allSourceTopics, Map<TaskId, Set<TopicPartition>> partitionsForTask, Cluster fullMetadata) {
        HashSet<TopicPartition> allAssignedPartitions = new HashSet<TopicPartition>();
        for (Map.Entry<TaskId, Set<TopicPartition>> entry : partitionsForTask.entrySet()) {
            TaskId id = entry.getKey();
            Set<TopicPartition> partitions = entry.getValue();
            for (TopicPartition partition : partitions) {
                taskForPartition.put(partition, id);
                if (!allAssignedPartitions.contains(partition)) continue;
                this.log.warn("Partition {} is assigned to more than one tasks: {}", (Object)partition, partitionsForTask);
            }
            allAssignedPartitions.addAll(partitions);
            tasksForTopicGroup.computeIfAbsent(new TopologyMetadata.Subtopology(id.subtopology(), id.topologyName()), k -> new HashSet()).add(id);
        }
        this.checkAllPartitions(allSourceTopics, partitionsForTask, allAssignedPartitions, fullMetadata);
    }

    private void checkAllPartitions(Set<String> allSourceTopics, Map<TaskId, Set<TopicPartition>> partitionsForTask, Set<TopicPartition> allAssignedPartitions, Cluster fullMetadata) {
        for (String topic : allSourceTopics) {
            List partitionInfoList = fullMetadata.partitionsForTopic(topic);
            if (partitionInfoList.isEmpty()) {
                this.log.warn("No partitions found for topic {}", (Object)topic);
                continue;
            }
            for (PartitionInfo partitionInfo : partitionInfoList) {
                TopicPartition partition = new TopicPartition(partitionInfo.topic(), partitionInfo.partition());
                if (allAssignedPartitions.contains(partition)) continue;
                this.log.warn("Partition {} is not assigned to any tasks: {} Possible causes of a partition not getting assigned is that another topic defined in the topology has not been created when starting your streams application, resulting in no tasks created for this topology at all.", (Object)partition, partitionsForTask);
            }
        }
    }

    private UserTaskAssignmentListener assignTasksToClients(Cluster fullMetadata, ConsumerPartitionAssignor.GroupSubscription groupSubscription, Set<String> allSourceTopics, Map<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> topicGroups, Map<ProcessId, ClientMetadata> clientMetadataMap, Map<TaskId, Set<TopicPartition>> partitionsForTask, Map<ProcessId, Map<String, Optional<String>>> racksForProcessConsumer, Set<TaskId> statefulTasks) {
        UserTaskAssignmentListener customTaskAssignmentListener;
        if (!statefulTasks.isEmpty()) {
            throw new TaskAssignmentException("The stateful tasks should not be populated before assigning tasks to clients");
        }
        HashMap<TopicPartition, TaskId> taskForPartition = new HashMap<TopicPartition, TaskId>();
        HashMap<TopologyMetadata.Subtopology, Set<TaskId>> tasksForTopicGroup = new HashMap<TopologyMetadata.Subtopology, Set<TaskId>>();
        this.populateTasksForMaps(taskForPartition, tasksForTopicGroup, allSourceTopics, partitionsForTask, fullMetadata);
        ChangelogTopics changelogTopics = new ChangelogTopics(this.internalTopicManager, topicGroups, tasksForTopicGroup, this.logPrefix);
        changelogTopics.setup();
        HashMap<ProcessId, ClientState> clientStates = new HashMap<ProcessId, ClientState>();
        boolean lagComputationSuccessful = this.populateClientStatesMap(clientStates, clientMetadataMap, taskForPartition, changelogTopics);
        this.log.info("{} client nodes and {} consumers participating in this rebalance: \n{}.", new Object[]{clientStates.size(), clientStates.values().stream().map(ClientState::capacity).reduce(Integer::sum).orElse(0), clientStates.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> entry.getKey() + ": " + ((ClientState)entry.getValue()).consumers()).collect(Collectors.joining(Utils.NL))});
        Set<TaskId> allTasks = partitionsForTask.keySet();
        statefulTasks.addAll(changelogTopics.statefulTaskIds());
        this.log.info("Assigning stateful tasks: {}\nand stateless tasks: {}", statefulTasks, allTasks.stream().filter(t -> !statefulTasks.contains(t)).collect(Collectors.toSet()));
        this.log.debug("Assigning tasks and {} standby replicas to client nodes {}", (Object)this.numStandbyReplicas(), clientStates);
        Optional<TaskAssignor> userTaskAssignor = this.customTaskAssignorSupplier.get();
        if (userTaskAssignor.isPresent()) {
            ApplicationState applicationState = this.buildApplicationState(this.taskManager.topologyMetadata(), clientMetadataMap, topicGroups, fullMetadata);
            TaskAssignor assignor = userTaskAssignor.get();
            TaskAssignor.TaskAssignment taskAssignment = assignor.assign(applicationState);
            TaskAssignor.AssignmentError assignmentError = TaskAssignmentUtils.validateTaskAssignment(applicationState, taskAssignment);
            this.processStreamsPartitionAssignment(assignor, taskAssignment, assignmentError, clientMetadataMap, groupSubscription);
            customTaskAssignmentListener = (assignment, subscription) -> {
                assignor.onAssignmentComputed(assignment, subscription, assignmentError);
                if (assignmentError != TaskAssignor.AssignmentError.NONE) {
                    this.log.error("Rebalance failed due to task assignor returning assignment with error {}", (Object)assignmentError);
                    throw new StreamsException("Task assignment with " + assignor.getClass().getName() + " returned an error: " + (Object)((Object)assignmentError));
                }
            };
        } else {
            ClientMetadata rebalanceClientMetadata;
            RackAwareTaskAssignor rackAwareTaskAssignor;
            customTaskAssignmentListener = (assignment, subscription) -> {};
            LegacyTaskAssignor taskAssignor = this.createTaskAssignor(lagComputationSuccessful);
            boolean probingRebalanceNeeded = taskAssignor.assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor = new RackAwareTaskAssignor(fullMetadata, partitionsForTask, changelogTopics.changelogPartionsForTask(), tasksForTopicGroup, racksForProcessConsumer, this.internalTopicManager, this.assignmentConfigs, this.time), this.assignmentConfigs);
            if (probingRebalanceNeeded && (rebalanceClientMetadata = clientMetadataMap.get(this.taskManager.processId())) != null) {
                Instant rebalanceDeadline = Instant.ofEpochMilli(this.time.milliseconds() + this.probingRebalanceIntervalMs());
                rebalanceClientMetadata.state.setFollowupRebalanceDeadline(rebalanceDeadline);
            }
        }
        this.log.info("Assigned {} total tasks including {} stateful tasks to {} client nodes.", new Object[]{allTasks.size(), statefulTasks.size(), clientStates.size()});
        this.log.info("Assignment of tasks to nodes: {}", (Object)clientStates.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> entry.getKey() + "=" + ((ClientState)entry.getValue()).currentAssignment()).collect(Collectors.joining(Utils.NL)));
        return customTaskAssignmentListener;
    }

    private LegacyTaskAssignor createTaskAssignor(boolean lagComputationSuccessful) {
        LegacyTaskAssignor taskAssignor = this.legacyTaskAssignorSupplier.get();
        if (taskAssignor instanceof LegacyStickyTaskAssignor) {
            return taskAssignor;
        }
        if (lagComputationSuccessful) {
            return taskAssignor;
        }
        this.log.info("Failed to fetch end offsets for changelogs, will return previous assignment to clients and trigger another rebalance to retry.");
        return new FallbackPriorTaskAssignor();
    }

    private boolean populateClientStatesMap(Map<ProcessId, ClientState> clientStates, Map<ProcessId, ClientMetadata> clientMetadataMap, Map<TopicPartition, TaskId> taskForPartition, ChangelogTopics changelogTopics) {
        boolean fetchEndOffsetsSuccessful;
        Map<TaskId, Long> allTaskEndOffsetSums;
        try {
            ListOffsetsResult endOffsetsResult = ClientUtils.fetchEndOffsetsResult(changelogTopics.preExistingNonSourceTopicBasedPartitions(), this.adminClient);
            Map<TopicPartition, Long> sourceChangelogEndOffsets = ClientUtils.fetchCommittedOffsets(changelogTopics.preExistingSourceTopicBasedPartitions(), this.mainConsumerSupplier.get());
            Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> endOffsets = ClientUtils.getEndOffsets(endOffsetsResult, changelogTopics.preExistingNonSourceTopicBasedPartitions());
            allTaskEndOffsetSums = this.computeEndOffsetSumsByTask(endOffsets, sourceChangelogEndOffsets, changelogTopics);
            fetchEndOffsetsSuccessful = true;
        }
        catch (TimeoutException | StreamsException e) {
            this.log.info("Failed to retrieve all end offsets for changelogs, and hence could not calculate the per-task lag; this is not a fatal error but would cause the assignor to fallback to a naive algorithm", (Throwable)e);
            allTaskEndOffsetSums = changelogTopics.statefulTaskIds().stream().collect(Collectors.toMap(t -> t, t -> -3L));
            fetchEndOffsetsSuccessful = false;
        }
        for (Map.Entry<ProcessId, ClientMetadata> entry : clientMetadataMap.entrySet()) {
            ProcessId processId = entry.getKey();
            ClientState state = entry.getValue().state;
            state.initializePrevTasks(taskForPartition, this.taskManager.topologyMetadata().hasNamedTopologies());
            state.computeTaskLags(processId, allTaskEndOffsetSums);
            clientStates.put(processId, state);
        }
        return fetchEndOffsetsSuccessful;
    }

    private Map<TaskId, Long> computeEndOffsetSumsByTask(Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> endOffsets, Map<TopicPartition, Long> sourceChangelogEndOffsets, ChangelogTopics changelogTopics) {
        HashMap<TaskId, Long> taskEndOffsetSums = new HashMap<TaskId, Long>();
        block0: for (TaskId taskId : changelogTopics.statefulTaskIds()) {
            taskEndOffsetSums.put(taskId, 0L);
            for (TopicPartition changelogPartition : changelogTopics.preExistingPartitionsFor(taskId)) {
                long changelogPartitionEndOffset;
                if (sourceChangelogEndOffsets.containsKey(changelogPartition)) {
                    changelogPartitionEndOffset = sourceChangelogEndOffsets.get(changelogPartition);
                } else if (endOffsets.containsKey(changelogPartition)) {
                    changelogPartitionEndOffset = endOffsets.get(changelogPartition).offset();
                } else {
                    this.log.debug("Fetched offsets did not contain the changelog {} of task {}", (Object)changelogPartition, (Object)taskId);
                    throw new IllegalStateException("Could not get end offset for " + changelogPartition);
                }
                long newEndOffsetSum = (Long)taskEndOffsetSums.get(taskId) + changelogPartitionEndOffset;
                if (newEndOffsetSum < 0L) {
                    taskEndOffsetSums.put(taskId, Long.MAX_VALUE);
                    continue block0;
                }
                taskEndOffsetSums.put(taskId, newEndOffsetSum);
            }
        }
        return taskEndOffsetSums;
    }

    private void populatePartitionsByHostMaps(Map<HostInfo, Set<TopicPartition>> partitionsByHost, Map<HostInfo, Set<TopicPartition>> standbyPartitionsByHost, Map<TaskId, Set<TopicPartition>> partitionsForTask, Map<ProcessId, ClientMetadata> clientMetadataMap) {
        for (Map.Entry<ProcessId, ClientMetadata> entry : clientMetadataMap.entrySet()) {
            HostInfo hostInfo = entry.getValue().hostInfo;
            if (hostInfo == null) continue;
            HashSet topicPartitions = new HashSet();
            HashSet standbyPartitions = new HashSet();
            ClientState state = entry.getValue().state;
            for (TaskId id : state.activeTasks()) {
                topicPartitions.addAll(partitionsForTask.get(id));
            }
            for (TaskId id : state.standbyTasks()) {
                standbyPartitions.addAll(partitionsForTask.get(id));
            }
            partitionsByHost.put(hostInfo, topicPartitions);
            standbyPartitionsByHost.put(hostInfo, standbyPartitions);
        }
    }

    private Map<String, ConsumerPartitionAssignor.Assignment> computeNewAssignment(Set<TaskId> statefulTasks, Map<ProcessId, ClientMetadata> clientsMetadata, Map<TaskId, Set<TopicPartition>> partitionsForTask, Map<HostInfo, Set<TopicPartition>> partitionsByHostState, Map<HostInfo, Set<TopicPartition>> standbyPartitionsByHost, Set<TopicPartition> allOwnedPartitions, int minUserMetadataVersion, int minSupportedMetadataVersion, boolean versionProbing) {
        boolean rebalanceRequired = versionProbing;
        HashMap<String, ConsumerPartitionAssignor.Assignment> assignment = new HashMap<String, ConsumerPartitionAssignor.Assignment>();
        for (Map.Entry<ProcessId, ClientMetadata> clientEntry : clientsMetadata.entrySet()) {
            ProcessId clientId = clientEntry.getKey();
            ClientMetadata clientMetadata = clientEntry.getValue();
            ClientState state = clientMetadata.state;
            SortedSet consumers = clientMetadata.consumers;
            HashMap<String, Integer> threadTaskCounts = new HashMap<String, Integer>();
            Map<String, List<TaskId>> activeTaskStatefulAssignment = StreamsPartitionAssignor.assignTasksToThreads(state.statefulActiveTasks(), true, consumers, state, threadTaskCounts);
            Map<String, List<TaskId>> standbyTaskAssignment = StreamsPartitionAssignor.assignTasksToThreads(state.standbyTasks(), true, consumers, state, threadTaskCounts);
            Map<String, List<TaskId>> activeTaskStatelessAssignment = StreamsPartitionAssignor.assignTasksToThreads(state.statelessActiveTasks(), false, consumers, state, threadTaskCounts);
            Map<String, List<TaskId>> activeTaskAssignment = activeTaskStatefulAssignment;
            for (Map.Entry<String, List<TaskId>> threadEntry : activeTaskStatelessAssignment.entrySet()) {
                activeTaskAssignment.get(threadEntry.getKey()).addAll((Collection<TaskId>)threadEntry.getValue());
            }
            boolean isNextProbingRebalanceEncoded = clientMetadata.state.followupRebalanceDeadline().isPresent();
            boolean tasksRevoked = this.addClientAssignments(statefulTasks, assignment, clientMetadata, partitionsForTask, partitionsByHostState, standbyPartitionsByHost, allOwnedPartitions, activeTaskAssignment, standbyTaskAssignment, minUserMetadataVersion, minSupportedMetadataVersion);
            if (tasksRevoked || isNextProbingRebalanceEncoded) {
                rebalanceRequired = true;
                this.log.debug("Requested client {} to schedule a followup rebalance", (Object)clientId);
            }
            this.log.info("Client {} per-consumer assignment:\n\tprev owned active {}\n\tprev owned standby {}\n\tassigned active {}\n\trevoking active {}\n\tassigned standby {}\n", new Object[]{clientId, clientMetadata.state.prevOwnedActiveTasksByConsumer(), clientMetadata.state.prevOwnedStandbyByConsumer(), clientMetadata.state.assignedActiveTasksByConsumer(), clientMetadata.state.revokingActiveTasksByConsumer(), clientMetadata.state.assignedStandbyTasksByConsumer()});
        }
        if (rebalanceRequired) {
            this.assignmentListener.onAssignmentComplete(false);
            this.log.info("Finished unstable assignment of tasks, a followup rebalance will be scheduled.");
        } else {
            this.assignmentListener.onAssignmentComplete(true);
            this.log.info("Finished stable assignment of tasks, no followup rebalances required.");
        }
        return assignment;
    }

    private boolean addClientAssignments(Set<TaskId> statefulTasks, Map<String, ConsumerPartitionAssignor.Assignment> assignment, ClientMetadata clientMetadata, Map<TaskId, Set<TopicPartition>> partitionsForTask, Map<HostInfo, Set<TopicPartition>> partitionsByHostState, Map<HostInfo, Set<TopicPartition>> standbyPartitionsByHost, Set<TopicPartition> allOwnedPartitions, Map<String, List<TaskId>> activeTaskAssignments, Map<String, List<TaskId>> standbyTaskAssignments, int minUserMetadataVersion, int minSupportedMetadataVersion) {
        boolean followupRebalanceRequiredForRevokedTasks = false;
        Optional<Instant> followupRebalanceDeadline = clientMetadata.state.followupRebalanceDeadline();
        boolean shouldEncodeProbingRebalance = followupRebalanceDeadline.isPresent();
        for (String consumer : clientMetadata.consumers) {
            List<TaskId> activeTasksForConsumer = activeTaskAssignments.get(consumer);
            ArrayList<TopicPartition> activePartitionsList = new ArrayList<TopicPartition>();
            ArrayList<TaskId> assignedActiveList = new ArrayList<TaskId>();
            Set<TaskId> activeTasksRemovedPendingRevokation = this.populateActiveTaskAndPartitionsLists(activePartitionsList, assignedActiveList, consumer, clientMetadata.state, activeTasksForConsumer, partitionsForTask, allOwnedPartitions);
            Map<TaskId, Set<TopicPartition>> standbyTaskMap = this.buildStandbyTaskMap(consumer, (Iterable<TaskId>)standbyTaskAssignments.get(consumer), activeTasksRemovedPendingRevokation, statefulTasks, partitionsForTask, clientMetadata.state);
            AssignmentInfo info = new AssignmentInfo(minUserMetadataVersion, minSupportedMetadataVersion, assignedActiveList, standbyTaskMap, partitionsByHostState, standbyPartitionsByHost, AssignorError.NONE.code());
            if (!activeTasksRemovedPendingRevokation.isEmpty()) {
                this.log.info("Requesting followup rebalance be scheduled immediately by {} due to tasks changing ownership.", (Object)consumer);
                info.setNextRebalanceTime(0L);
                followupRebalanceRequiredForRevokedTasks = true;
                shouldEncodeProbingRebalance = false;
            } else if (shouldEncodeProbingRebalance) {
                long nextRebalanceTimeMs = followupRebalanceDeadline.get().toEpochMilli();
                this.log.info("Requesting followup rebalance be scheduled by {} for {} to probe for caught-up replica tasks.", (Object)consumer, (Object)Utils.toLogDateTimeFormat((long)nextRebalanceTimeMs));
                info.setNextRebalanceTime(nextRebalanceTimeMs);
                shouldEncodeProbingRebalance = false;
            }
            assignment.put(consumer, new ConsumerPartitionAssignor.Assignment(activePartitionsList, info.encode()));
        }
        return followupRebalanceRequiredForRevokedTasks;
    }

    private Set<TaskId> populateActiveTaskAndPartitionsLists(List<TopicPartition> activePartitionsList, List<TaskId> assignedActiveList, String consumer, ClientState clientState, List<TaskId> activeTasksForConsumer, Map<TaskId, Set<TopicPartition>> partitionsForTask, Set<TopicPartition> allOwnedPartitions) {
        ArrayList assignedPartitions = new ArrayList();
        TreeSet<TaskId> removedActiveTasks = new TreeSet<TaskId>();
        for (TaskId taskId : activeTasksForConsumer) {
            clientState.assignActiveToConsumer(taskId, consumer);
            ArrayList<AssignedPartition> assignedPartitionsForTask = new ArrayList<AssignedPartition>();
            for (TopicPartition partition : partitionsForTask.get(taskId)) {
                boolean newPartitionForConsumer;
                String oldOwner = clientState.previousOwnerForPartition(partition);
                boolean bl = newPartitionForConsumer = oldOwner == null || !oldOwner.equals(consumer);
                if (newPartitionForConsumer && allOwnedPartitions.contains(partition)) {
                    this.log.info("Removing task {} from {} active assignment until it is safely revoked in followup rebalance", (Object)taskId, (Object)consumer);
                    removedActiveTasks.add(taskId);
                    clientState.revokeActiveFromConsumer(taskId, consumer);
                    assignedPartitionsForTask.clear();
                    clientState.unassignActive(taskId);
                    break;
                }
                assignedPartitionsForTask.add(new AssignedPartition(taskId, partition));
            }
            assignedPartitions.addAll(assignedPartitionsForTask);
        }
        Collections.sort(assignedPartitions);
        for (AssignedPartition partition : assignedPartitions) {
            assignedActiveList.add(partition.taskId);
            activePartitionsList.add(partition.partition);
        }
        return removedActiveTasks;
    }

    private Map<TaskId, Set<TopicPartition>> buildStandbyTaskMap(String consumer, Iterable<TaskId> standbyTasks, Iterable<TaskId> revokedTasks, Set<TaskId> allStatefulTasks, Map<TaskId, Set<TopicPartition>> partitionsForTask, ClientState clientState) {
        HashMap<TaskId, Set<TopicPartition>> standbyTaskMap = new HashMap<TaskId, Set<TopicPartition>>();
        for (TaskId task : standbyTasks) {
            clientState.assignStandbyToConsumer(task, consumer);
            standbyTaskMap.put(task, partitionsForTask.get(task));
        }
        for (TaskId task : revokedTasks) {
            if (!clientState.previouslyOwnedStandby(task) || !allStatefulTasks.contains(task)) continue;
            this.log.info("Adding removed stateful active task {} as a standby for {} until it is revoked and can be transitioned to active in a followup rebalance", (Object)task, (Object)consumer);
            clientState.assignStandbyToConsumer(task, consumer);
            clientState.assignStandby(task);
            standbyTaskMap.put(task, partitionsForTask.get(task));
        }
        return standbyTaskMap;
    }

    static Map<String, List<TaskId>> assignTasksToThreads(Collection<TaskId> tasksToAssign, boolean isStateful, SortedSet<String> consumers, ClientState state, Map<String, Integer> threadLoad) {
        HashMap<String, List<TaskId>> assignment = new HashMap<String, List<TaskId>>();
        for (String consumer : consumers) {
            assignment.put(consumer, new ArrayList());
        }
        int totalTasks = threadLoad.values().stream().reduce(tasksToAssign.size(), Integer::sum);
        int minTasksPerThread = (int)Math.floor((double)totalTasks / (double)consumers.size());
        PriorityQueue<TaskId> unassignedTasks = new PriorityQueue<TaskId>(tasksToAssign);
        LinkedList<String> consumersToFill = new LinkedList<String>();
        TreeMap<TaskId, String> unassignedTaskToPreviousOwner = new TreeMap<TaskId, String>();
        if (!unassignedTasks.isEmpty()) {
            List threadAssignment;
            for (String string : consumers) {
                threadAssignment = (List)assignment.get(string);
                int tasksTargetCount = minTasksPerThread - threadLoad.getOrDefault(string, 0);
                if (isStateful) {
                    for (TaskId task : state.prevTasksByLag(string)) {
                        if (!unassignedTasks.contains(task)) continue;
                        if (threadAssignment.size() < tasksTargetCount) {
                            threadAssignment.add(task);
                            unassignedTasks.remove(task);
                            continue;
                        }
                        unassignedTaskToPreviousOwner.put(task, string);
                    }
                }
                if (threadAssignment.size() >= tasksTargetCount) continue;
                consumersToFill.offer(string);
            }
            while (!consumersToFill.isEmpty()) {
                TaskId task = unassignedTasks.poll();
                if (task != null) {
                    String string = (String)consumersToFill.poll();
                    threadAssignment = (List)assignment.get(string);
                    threadAssignment.add(task);
                    int threadTaskCount = threadAssignment.size() + threadLoad.getOrDefault(string, 0);
                    if (threadTaskCount >= minTasksPerThread) continue;
                    consumersToFill.offer(string);
                    continue;
                }
                throw new TaskAssignmentException("Ran out of unassigned stateful tasks but some members were not at capacity");
            }
            if (!unassignedTasks.isEmpty()) {
                for (String string : consumers) {
                    int taskCount = ((List)assignment.get(string)).size() + threadLoad.getOrDefault(string, 0);
                    if (taskCount != minTasksPerThread) continue;
                    consumersToFill.add(string);
                }
                for (Map.Entry entry : unassignedTaskToPreviousOwner.entrySet()) {
                    TaskId task = (TaskId)entry.getKey();
                    String consumer = (String)entry.getValue();
                    if (!consumersToFill.contains(consumer) || !unassignedTasks.contains(task)) continue;
                    ((List)assignment.get(consumer)).add(task);
                    unassignedTasks.remove(task);
                    consumersToFill.remove(consumer);
                }
                for (TaskId taskId : unassignedTasks) {
                    String consumer = (String)consumersToFill.poll();
                    List threadAssignment2 = (List)assignment.get(consumer);
                    threadAssignment2.add(taskId);
                }
            }
        }
        for (Map.Entry entry : assignment.entrySet()) {
            String consumer = (String)entry.getKey();
            int totalCount = threadLoad.getOrDefault(consumer, 0) + ((List)entry.getValue()).size();
            threadLoad.put(consumer, totalCount);
        }
        return assignment;
    }

    private void validateMetadataVersions(int receivedAssignmentMetadataVersion, int latestCommonlySupportedVersion) {
        if (receivedAssignmentMetadataVersion > this.usedSubscriptionMetadataVersion) {
            this.log.error("Leader sent back an assignment with version {} which was greater than our used version {}", (Object)receivedAssignmentMetadataVersion, (Object)this.usedSubscriptionMetadataVersion);
            throw new TaskAssignmentException("Sent a version " + this.usedSubscriptionMetadataVersion + " subscription but got an assignment with higher version " + receivedAssignmentMetadataVersion + ".");
        }
        if (latestCommonlySupportedVersion > 11) {
            this.log.error("Leader sent back assignment with commonly supported version {} that is greater than our actual latest supported version {}", (Object)latestCommonlySupportedVersion, (Object)11);
            throw new TaskAssignmentException("Can't upgrade to metadata version greater than we support");
        }
    }

    protected boolean maybeUpdateSubscriptionVersion(int receivedAssignmentMetadataVersion, int latestCommonlySupportedVersion) {
        if (receivedAssignmentMetadataVersion >= 3) {
            if (latestCommonlySupportedVersion > this.usedSubscriptionMetadataVersion) {
                this.log.info("Sent a version {} subscription and group's latest commonly supported version is {} (successful version probing and end of rolling upgrade). Upgrading subscription metadata version to {} for next rebalance.", new Object[]{this.usedSubscriptionMetadataVersion, latestCommonlySupportedVersion, latestCommonlySupportedVersion});
                this.usedSubscriptionMetadataVersion = latestCommonlySupportedVersion;
                return true;
            }
            if (receivedAssignmentMetadataVersion < this.usedSubscriptionMetadataVersion) {
                this.log.info("Sent a version {} subscription and got version {} assignment back (successful version probing). Downgrade subscription metadata to commonly supported version {} and trigger new rebalance.", new Object[]{this.usedSubscriptionMetadataVersion, receivedAssignmentMetadataVersion, latestCommonlySupportedVersion});
                this.usedSubscriptionMetadataVersion = latestCommonlySupportedVersion;
                return true;
            }
        } else {
            this.log.debug("Received an assignment version {} that is less than the earliest version that allows version probing {}. If this is not during a rolling upgrade from version 2.0 or below, this is an error.", (Object)receivedAssignmentMetadataVersion, (Object)3);
        }
        return false;
    }

    public void onAssignment(ConsumerPartitionAssignor.Assignment assignment, ConsumerGroupMetadata metadata) {
        long encodedNextScheduledRebalanceMs;
        Map<TopicPartition, PartitionInfo> topicToPartitionInfo;
        Map<HostInfo, Set<TopicPartition>> standbyPartitionsByHost;
        Map<HostInfo, Set<TopicPartition>> partitionsByHost;
        Map<TaskId, Set<TopicPartition>> activeTasks;
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>(assignment.partitions());
        partitions.sort(PARTITION_COMPARATOR);
        AssignmentInfo info = AssignmentInfo.decode(assignment.userData());
        if (info.errCode() != AssignorError.NONE.code()) {
            this.assignmentErrorCode.set(info.errCode());
            return;
        }
        int receivedAssignmentMetadataVersion = info.version();
        int latestCommonlySupportedVersion = info.commonlySupportedVersion();
        this.validateMetadataVersions(receivedAssignmentMetadataVersion, latestCommonlySupportedVersion);
        switch (receivedAssignmentMetadataVersion) {
            case 1: {
                StreamsPartitionAssignor.validateActiveTaskEncoding(partitions, info, this.logPrefix);
                activeTasks = StreamsPartitionAssignor.getActiveTasks(partitions, info);
                partitionsByHost = Collections.emptyMap();
                standbyPartitionsByHost = Collections.emptyMap();
                topicToPartitionInfo = Collections.emptyMap();
                encodedNextScheduledRebalanceMs = Long.MAX_VALUE;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                StreamsPartitionAssignor.validateActiveTaskEncoding(partitions, info, this.logPrefix);
                activeTasks = StreamsPartitionAssignor.getActiveTasks(partitions, info);
                partitionsByHost = info.partitionsByHost();
                standbyPartitionsByHost = Collections.emptyMap();
                topicToPartitionInfo = StreamsPartitionAssignor.getTopicPartitionInfo(partitionsByHost);
                encodedNextScheduledRebalanceMs = Long.MAX_VALUE;
                break;
            }
            case 6: {
                StreamsPartitionAssignor.validateActiveTaskEncoding(partitions, info, this.logPrefix);
                activeTasks = StreamsPartitionAssignor.getActiveTasks(partitions, info);
                partitionsByHost = info.partitionsByHost();
                standbyPartitionsByHost = info.standbyPartitionByHost();
                topicToPartitionInfo = StreamsPartitionAssignor.getTopicPartitionInfo(partitionsByHost);
                encodedNextScheduledRebalanceMs = Long.MAX_VALUE;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                StreamsPartitionAssignor.validateActiveTaskEncoding(partitions, info, this.logPrefix);
                activeTasks = StreamsPartitionAssignor.getActiveTasks(partitions, info);
                partitionsByHost = info.partitionsByHost();
                standbyPartitionsByHost = info.standbyPartitionByHost();
                topicToPartitionInfo = StreamsPartitionAssignor.getTopicPartitionInfo(partitionsByHost);
                encodedNextScheduledRebalanceMs = info.nextRebalanceMs();
                break;
            }
            default: {
                throw new IllegalStateException("This code should never be reached. Please file a bug report at https://issues.apache.org/jira/projects/KAFKA/");
            }
        }
        this.maybeScheduleFollowupRebalance(encodedNextScheduledRebalanceMs, receivedAssignmentMetadataVersion, latestCommonlySupportedVersion, partitionsByHost.keySet());
        this.streamsMetadataState.onChange(partitionsByHost, standbyPartitionsByHost, topicToPartitionInfo);
        this.taskManager.handleAssignment(activeTasks, info.standbyTasks());
    }

    private void maybeScheduleFollowupRebalance(long encodedNextScheduledRebalanceMs, int receivedAssignmentMetadataVersion, int latestCommonlySupportedVersion, Set<HostInfo> groupHostInfo) {
        if (this.maybeUpdateSubscriptionVersion(receivedAssignmentMetadataVersion, latestCommonlySupportedVersion)) {
            this.log.info("Requested to schedule immediate rebalance due to version probing.");
            this.nextScheduledRebalanceMs.set(0L);
        } else if (!this.verifyHostInfo(groupHostInfo)) {
            this.log.info("Requested to schedule immediate rebalance to update group with new host endpoint = {}.", (Object)this.userEndPoint);
            this.nextScheduledRebalanceMs.set(0L);
        } else if (encodedNextScheduledRebalanceMs == 0L) {
            this.log.info("Requested to schedule immediate rebalance for new tasks to be safely revoked from current owner.");
            this.nextScheduledRebalanceMs.set(0L);
        } else if (encodedNextScheduledRebalanceMs < Long.MAX_VALUE) {
            this.log.info("Requested to schedule next probing rebalance at {} to try for a more balanced assignment.", (Object)Utils.toLogDateTimeFormat((long)encodedNextScheduledRebalanceMs));
            this.nextScheduledRebalanceMs.set(encodedNextScheduledRebalanceMs);
        } else {
            this.log.info("No followup rebalance was requested, resetting the rebalance schedule.");
            this.nextScheduledRebalanceMs.set(Long.MAX_VALUE);
        }
    }

    private boolean verifyHostInfo(Set<HostInfo> groupHostInfo) {
        if (this.userEndPoint != null && !groupHostInfo.isEmpty()) {
            HostInfo myHostInfo = HostInfo.buildFromEndpoint(this.userEndPoint);
            return groupHostInfo.contains(myHostInfo);
        }
        return true;
    }

    protected static Map<TaskId, Set<TopicPartition>> getActiveTasks(List<TopicPartition> partitions, AssignmentInfo info) {
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        for (int i = 0; i < partitions.size(); ++i) {
            TopicPartition partition = partitions.get(i);
            TaskId id = info.activeTasks().get(i);
            activeTasks.computeIfAbsent(id, k1 -> new HashSet()).add(partition);
        }
        return activeTasks;
    }

    static Map<TopicPartition, PartitionInfo> getTopicPartitionInfo(Map<HostInfo, Set<TopicPartition>> partitionsByHost) {
        HashMap<TopicPartition, PartitionInfo> topicToPartitionInfo = new HashMap<TopicPartition, PartitionInfo>();
        for (Set<TopicPartition> value : partitionsByHost.values()) {
            for (TopicPartition topicPartition : value) {
                topicToPartitionInfo.put(topicPartition, new PartitionInfo(topicPartition.topic(), topicPartition.partition(), null, new Node[0], new Node[0]));
            }
        }
        return topicToPartitionInfo;
    }

    private static void validateActiveTaskEncoding(List<TopicPartition> partitions, AssignmentInfo info, String logPrefix) {
        if (partitions.size() != info.activeTasks().size()) {
            throw new TaskAssignmentException(String.format("%sNumber of assigned partitions %d is not equal to the number of active taskIds %d, assignmentInfo=%s", logPrefix, partitions.size(), info.activeTasks().size(), info));
        }
    }

    private int updateMinReceivedVersion(int usedVersion, int minReceivedMetadataVersion) {
        return Math.min(usedVersion, minReceivedMetadataVersion);
    }

    private int updateMinSupportedVersion(int supportedVersion, int minSupportedMetadataVersion) {
        if (supportedVersion < minSupportedMetadataVersion) {
            this.log.debug("Downgrade the current minimum supported version {} to the smaller seen supported version {}", (Object)minSupportedMetadataVersion, (Object)supportedVersion);
            return supportedVersion;
        }
        this.log.debug("Current minimum supported version remains at {}, last seen supported version was {}", (Object)minSupportedMetadataVersion, (Object)supportedVersion);
        return minSupportedMetadataVersion;
    }

    void setInternalTopicManager(InternalTopicManager internalTopicManager) {
        this.internalTopicManager = internalTopicManager;
    }

    ConsumerPartitionAssignor.RebalanceProtocol rebalanceProtocol() {
        return this.rebalanceProtocol;
    }

    protected String userEndPoint() {
        return this.userEndPoint;
    }

    protected TaskManager taskManager() {
        return this.taskManager;
    }

    protected byte uniqueField() {
        return this.uniqueField;
    }

    protected Map<String, String> clientTags() {
        return this.clientTags;
    }

    protected void handleRebalanceStart(Set<String> topics) {
        this.taskManager.handleRebalanceStart(topics);
    }

    long acceptableRecoveryLag() {
        return this.assignmentConfigs.acceptableRecoveryLag();
    }

    int maxWarmupReplicas() {
        return this.assignmentConfigs.maxWarmupReplicas();
    }

    int numStandbyReplicas() {
        return this.assignmentConfigs.numStandbyReplicas();
    }

    long probingRebalanceIntervalMs() {
        return this.assignmentConfigs.probingRebalanceIntervalMs();
    }

    @FunctionalInterface
    public static interface UserTaskAssignmentListener {
        public void onAssignmentComputed(ConsumerPartitionAssignor.GroupAssignment var1, ConsumerPartitionAssignor.GroupSubscription var2);
    }

    public static class ClientMetadata {
        private final HostInfo hostInfo;
        private final ClientState state;
        private final SortedSet<String> consumers;
        private final Optional<String> rackId;

        ClientMetadata(ProcessId processId, String endPoint, Map<String, String> clientTags, Optional<String> rackId) {
            this.hostInfo = HostInfo.buildFromEndpoint(endPoint);
            this.consumers = new TreeSet<String>();
            this.state = new ClientState(processId, clientTags);
            this.rackId = rackId;
        }

        void addConsumer(String consumerMemberId, List<TopicPartition> ownedPartitions) {
            this.consumers.add(consumerMemberId);
            this.state.incrementCapacity();
            this.state.addOwnedPartitions(ownedPartitions, consumerMemberId);
        }

        void addPreviousTasksAndOffsetSums(String consumerId, Map<TaskId, Long> taskOffsetSums) {
            this.state.addPreviousTasksAndOffsetSums(consumerId, taskOffsetSums);
        }

        public ClientState state() {
            return this.state;
        }

        public HostInfo hostInfo() {
            return this.hostInfo;
        }

        public Optional<String> rackId() {
            return this.rackId;
        }

        public String toString() {
            return "ClientMetadata{hostInfo=" + this.hostInfo + ", consumers=" + this.consumers + ", state=" + this.state + '}';
        }
    }

    private static class AssignedPartition
    implements Comparable<AssignedPartition> {
        private final TaskId taskId;
        private final TopicPartition partition;

        AssignedPartition(TaskId taskId, TopicPartition partition) {
            this.taskId = taskId;
            this.partition = partition;
        }

        @Override
        public int compareTo(AssignedPartition that) {
            return PARTITION_COMPARATOR.compare(this.partition, that.partition);
        }

        public boolean equals(Object o) {
            if (!(o instanceof AssignedPartition)) {
                return false;
            }
            AssignedPartition other = (AssignedPartition)o;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            return this.partition.hashCode();
        }
    }
}

