/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.internals.graph.BaseRepartitionNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.InternalTopicProperties;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class OptimizableRepartitionNode<K, V>
extends BaseRepartitionNode<K, V> {
    private OptimizableRepartitionNode(String nodeName, String sourceName, ProcessorParameters<K, V, ?, ?> processorParameters, Serde<K> keySerde, Serde<V> valueSerde, String sinkName, String repartitionTopic, StreamPartitioner<K, V> partitioner) {
        super(nodeName, sourceName, processorParameters, keySerde, valueSerde, sinkName, repartitionTopic, partitioner, InternalTopicProperties.empty());
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    public String repartitionTopic() {
        return this.repartitionTopic;
    }

    @Override
    public String toString() {
        return "OptimizableRepartitionNode{ " + super.toString() + " }";
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        topologyBuilder.addInternalTopic(this.repartitionTopic, this.internalTopicProperties);
        this.processorParameters.addProcessorTo(topologyBuilder, this.parentNodeNames());
        topologyBuilder.addSink(this.sinkName, this.repartitionTopic, this.keySerializer(), this.valueSerializer(), this.partitioner, this.processorParameters.processorName());
        topologyBuilder.addSource(null, this.sourceName, (TimestampExtractor)new FailOnInvalidTimestamp(), this.keyDeserializer(), this.valueDeserializer(), this.repartitionTopic);
    }

    public static <K, V> OptimizableRepartitionNodeBuilder<K, V> optimizableRepartitionNodeBuilder() {
        return new OptimizableRepartitionNodeBuilder();
    }

    public static final class OptimizableRepartitionNodeBuilder<K, V>
    extends BaseRepartitionNode.BaseRepartitionNodeBuilder<K, V, OptimizableRepartitionNode<K, V>> {
        @Override
        public OptimizableRepartitionNode<K, V> build() {
            return new OptimizableRepartitionNode(this.nodeName, this.sourceName, this.processorParameters, this.keySerde, this.valueSerde, this.sinkName, this.repartitionTopic, this.partitioner);
        }
    }
}

