/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.flow;

import java.io.Serializable;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.services.DefaultRegisteredServiceUserInterfaceInfo;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OAuth20RegisteredServiceUIAction
extends BaseCasWebflowAction
implements Serializable {
    private static final long serialVersionUID = 5588216693657081923L;
    private final transient ServicesManager servicesManager;
    private final AuthenticationServiceSelectionStrategy serviceSelectionStrategy;

    protected Event doExecuteInternal(RequestContext requestContext) {
        return (Event)FunctionUtils.doUnchecked(() -> {
            WebApplicationService serviceCtx = WebUtils.getService((RequestContext)requestContext);
            if (serviceCtx != null) {
                Service service = this.serviceSelectionStrategy.resolveServiceFrom((Service)serviceCtx);
                RegisteredService registeredService = this.servicesManager.findServiceBy(service);
                RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
                if (registeredService instanceof OAuthRegisteredService) {
                    OAuthRegisteredService oauthService = (OAuthRegisteredService)registeredService;
                    WebUtils.putServiceUserInterfaceMetadata((RequestContext)requestContext, (Serializable)new DefaultRegisteredServiceUserInterfaceInfo((WebBasedRegisteredService)oauthService));
                }
            }
            return this.success();
        });
    }

    @Generated
    public OAuth20RegisteredServiceUIAction(ServicesManager servicesManager, AuthenticationServiceSelectionStrategy serviceSelectionStrategy) {
        this.servicesManager = servicesManager;
        this.serviceSelectionStrategy = serviceSelectionStrategy;
    }
}

