/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.json;

import com.fasterxml.jackson.databind.node.ArrayNode;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.IndexAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.integration.json.JsonPropertyAccessor;
import org.springframework.lang.Nullable;

public class JsonIndexAccessor
implements IndexAccessor {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{ArrayNode.class};

    public Class<?>[] getSpecificTargetClasses() {
        return SUPPORTED_CLASSES;
    }

    public boolean canRead(EvaluationContext context, Object target, Object index) {
        return target instanceof ArrayNode && index instanceof Integer;
    }

    public TypedValue read(EvaluationContext context, Object target, Object index) throws AccessException {
        ArrayNode arrayNode = (ArrayNode)target;
        Integer intIndex = (Integer)index;
        if (intIndex < 0) {
            intIndex = arrayNode.size() + intIndex;
        }
        return JsonPropertyAccessor.typedValue(arrayNode.get(intIndex.intValue()));
    }

    public boolean canWrite(EvaluationContext context, Object target, Object index) {
        return false;
    }

    public void write(EvaluationContext context, Object target, Object index, @Nullable Object newValue) {
        throw new UnsupportedOperationException("Write is not supported");
    }
}

