/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.java;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryJavaFileManager
extends ForwardingJavaFileManager {
    private static final String EXT = ".java";
    private Map<String, byte[]> classBytes = new HashMap<String, byte[]>();

    public MemoryJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
    }

    public Map<String, byte[]> getClassBytes() {
        return this.classBytes;
    }

    @Override
    public void close() throws IOException {
        this.classBytes = new HashMap<String, byte[]>();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            return new ClassOutputBuffer(className);
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    static JavaFileObject makeStringSource(String name, String code) {
        return new StringInputBuffer(name, code);
    }

    static URI toURI(String name) {
        File file = new File(name);
        if (file.exists()) {
            return file.toURI();
        }
        try {
            StringBuffer newUri = new StringBuffer();
            newUri.append("mfm:///");
            newUri.append(name.replace('.', '/'));
            if (name.endsWith(EXT)) {
                newUri.replace(newUri.length() - EXT.length(), newUri.length(), EXT);
            }
            return URI.create(newUri.toString());
        }
        catch (Exception exp) {
            return URI.create("mfm:///com/sun/script/java/java_source");
        }
    }

    static Map access$100(MemoryJavaFileManager x0) {
        return x0.classBytes;
    }

    private class ClassOutputBuffer
    extends SimpleJavaFileObject {
        private String name;

        ClassOutputBuffer(String name) {
            super(MemoryJavaFileManager.toURI(name), JavaFileObject.Kind.CLASS);
            this.name = name;
        }

        public OutputStream openOutputStream() {
            return new FilterOutputStream(new ByteArrayOutputStream()){

                public void close() throws IOException {
                    this.out.close();
                    ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                    MemoryJavaFileManager.access$100(MemoryJavaFileManager.this).put(ClassOutputBuffer.access$000(ClassOutputBuffer.this), bos.toByteArray());
                }
            };
        }

        static String access$000(ClassOutputBuffer x0) {
            return x0.name;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class StringInputBuffer
    extends SimpleJavaFileObject {
        final String code;

        StringInputBuffer(String name, String code) {
            super(MemoryJavaFileManager.toURI(name), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        public CharBuffer getCharContent(boolean ignoreEncodingErrors) {
            return CharBuffer.wrap(this.code);
        }

        public Reader openReader() {
            return new StringReader(this.code);
        }

        public CharSequence getCharContent(boolean x0) throws IOException {
            return this.getCharContent(x0);
        }
    }
}

