/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.uri.template.parser;

import java.util.Map;
import org.wso2.uri.template.URITemplateException;
import org.wso2.uri.template.parser.SimpleStringExpression;
import org.wso2.uri.template.parser.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservedStringExpression
extends SimpleStringExpression {
    public ReservedStringExpression(String token) throws URITemplateException {
        super(token);
    }

    @Override
    protected boolean isReserved(char ch) {
        return false;
    }

    @Override
    protected String encodeValue(String value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (super.isReserved(ch)) {
                builder.append(ch);
                continue;
            }
            builder.append(super.encodeValue(String.valueOf(ch)));
        }
        return builder.toString();
    }

    @Override
    protected boolean setVariables(String expressionValue, Map<String, String> variables) {
        if (this.variableList.size() == 1) {
            Variable var = (Variable)this.variableList.get(0);
            String name = var.getName();
            String finalValue = this.decodeValue(expressionValue);
            if (variables.containsKey(name) && !finalValue.equals(variables.get(name))) {
                return false;
            }
            if (var.checkModifier(finalValue)) {
                variables.put(name, finalValue);
                return true;
            }
            return false;
        }
        return super.setVariables(expressionValue, variables);
    }
}

