/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class EIPUtils {
    private static final Log log = LogFactory.getLog(EIPUtils.class);

    public static List getMatchingElements(SOAPEnvelope envelope, SynapseXPath expression) throws JaxenException {
        return EIPUtils.getMatchingElements(envelope, null, expression);
    }

    public static List getMatchingElements(SOAPEnvelope envelope, MessageContext synCtxt, SynapseXPath expression) throws JaxenException {
        Object o = expression.evaluate(envelope, synCtxt);
        if (o instanceof OMNode) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(o);
            return list;
        }
        if (o instanceof List) {
            return (List)o;
        }
        return new ArrayList();
    }

    public static List<OMNode> getDetachedMatchingElements(SOAPEnvelope envelope, MessageContext synCtxt, SynapseXPath expression) throws JaxenException {
        ArrayList<OMNode> elementList = new ArrayList<OMNode>();
        Object o = expression.evaluate(envelope, synCtxt);
        if (o instanceof OMNode) {
            elementList.add(((OMNode)o).detach());
        } else if (o instanceof List) {
            for (Object elem : (List)o) {
                if (!(elem instanceof OMNode)) continue;
                elementList.add(((OMNode)elem).detach());
            }
        }
        return elementList;
    }

    public static void enrichEnvelope(SOAPEnvelope envelope, SOAPEnvelope enricher, MessageContext synCtxt, SynapseXPath expression) throws JaxenException {
        List elementList = EIPUtils.getMatchingElements(envelope, synCtxt, expression);
        if (elementList != null && !elementList.isEmpty()) {
            Object o2 = elementList.get(0);
            Object enrichingElement = o2 instanceof OMElement && ((OMElement)o2).getParent() != null && ((OMElement)o2).getParent() instanceof OMElement ? (OMElement)((OMElement)o2).getParent() : envelope.getBody();
            List list = EIPUtils.getMatchingElements(enricher, synCtxt, expression);
            if (list != null) {
                for (Object o2 : list) {
                    if (o2 == null || !(o2 instanceof OMElement)) continue;
                    enrichingElement.addChild((OMNode)((OMElement)o2));
                }
            }
        }
    }

    public static String getTemplatePropertyMapping(String templateName, String parameter) {
        return templateName + ":" + parameter;
    }

    public static void createSynapseEIPTemplateProperty(MessageContext synCtxt, String templateName, String paramName, Object value) {
        String targetSynapsePropName = EIPUtils.getTemplatePropertyMapping(templateName, paramName);
        synCtxt.setProperty(targetSynapsePropName, value);
    }
}

