/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.rest;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.rest.ResourceSerializer;
import org.apache.synapse.config.xml.rest.VersionStrategySerializer;
import org.apache.synapse.rest.API;
import org.apache.synapse.rest.Handler;
import org.apache.synapse.rest.Resource;

public class APISerializer {
    private static final OMFactory fac = OMAbstractFactory.getOMFactory();

    public static OMElement serializeAPI(API api) {
        Resource[] resources;
        OMElement apiElt = fac.createOMElement("api", SynapseConstants.SYNAPSE_OMNAMESPACE);
        apiElt.addAttribute("name", api.getAPIName(), null);
        apiElt.addAttribute("context", api.getContext(), null);
        VersionStrategySerializer.serializeVersioningStrategy(api.getVersionStrategy(), apiElt);
        if (api.getHost() != null) {
            apiElt.addAttribute("hostname", api.getHost(), null);
        }
        if (api.getPort() != -1) {
            apiElt.addAttribute("port", String.valueOf(api.getPort()), null);
        }
        for (Resource r : resources = api.getResources()) {
            OMElement resourceElt = ResourceSerializer.serializeResource(r);
            apiElt.addChild((OMNode)resourceElt);
        }
        Handler[] handlers = api.getHandlers();
        if (handlers.length > 0) {
            OMElement handlersElt = fac.createOMElement("handlers", SynapseConstants.SYNAPSE_OMNAMESPACE);
            for (Handler handler : handlers) {
                OMElement handlerElt = fac.createOMElement("handler", SynapseConstants.SYNAPSE_OMNAMESPACE);
                handlerElt.addAttribute("class", handler.getClass().getName(), null);
                handlersElt.addChild((OMNode)handlerElt);
            }
            apiElt.addChild((OMNode)handlersElt);
        }
        if (api.getProtocol() == 1) {
            apiElt.addAttribute("transport", "http", null);
        } else if (api.getProtocol() == 2) {
            apiElt.addAttribute("transport", "https", null);
        }
        return apiElt;
    }
}

