/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask.ant;

import com.oopsconsultancy.xmltask.BufferStore;
import com.oopsconsultancy.xmltask.XmlReplace;
import com.oopsconsultancy.xmltask.XmlReplacement;
import com.oopsconsultancy.xmltask.ant.Attr;
import com.oopsconsultancy.xmltask.ant.Call;
import com.oopsconsultancy.xmltask.ant.Copy;
import com.oopsconsultancy.xmltask.ant.Cut;
import com.oopsconsultancy.xmltask.ant.Entity;
import com.oopsconsultancy.xmltask.ant.Insert;
import com.oopsconsultancy.xmltask.ant.Paste;
import com.oopsconsultancy.xmltask.ant.Print;
import com.oopsconsultancy.xmltask.ant.Remove;
import com.oopsconsultancy.xmltask.ant.Rename;
import com.oopsconsultancy.xmltask.ant.Replace;
import com.oopsconsultancy.xmltask.ant.Uncomment;
import com.oopsconsultancy.xmltask.output.FormattedDataWriter;
import com.oopsconsultancy.xmltask.output.Outputter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.StringInputStream;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.XMLCatalog;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XmlTask
extends Task {
    private static final String FMT_NONE = "default";
    private static final String FMT_SIMPLE = "simple";
    private boolean settingVersion = false;
    private String xmlVersion = "1.0";
    private boolean settingStandalone = false;
    private boolean standalone = false;
    private boolean omitHeader = false;
    private boolean todir = false;
    private boolean tobuffer = false;
    private boolean reporting = false;
    private boolean expandEntityReferences = true;
    private String doctype_public = null;
    private String doctype_system = null;
    private String dir = null;
    private LocalEntityResolver resolver = new LocalEntityResolver();
    private final XMLCatalog xmlCatalog = new XMLCatalog();
    private boolean normalize = true;
    private boolean indent = true;
    private String encoding = null;
    private String outputEncoding = null;
    private String outputter = "default";
    private boolean preservetype = false;
    private boolean failWithoutMatch = false;
    private String[] buffers = new String[0];
    private final List filesets = new ArrayList();
    private String dest = null;
    private List docs = new ArrayList();
    private List replacements = new ArrayList();

    public Project getProject() {
        return this.project;
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(this.project);
    }

    protected EntityResolver getEntityResolver() {
        return this.xmlCatalog;
    }

    public void setPublic(String p) {
        this.doctype_public = p;
    }

    public void setSystem(String s) {
        this.doctype_system = s;
    }

    public void setPreserveType(boolean p) {
        this.preservetype = p;
    }

    private String getPathPrefix() {
        if (this.dir == null) {
            File f = this.getProject().getBaseDir();
            this.dir = f.getAbsolutePath();
            if (!this.dir.endsWith("" + File.separator)) {
                this.dir = this.dir + File.separator;
            }
        }
        return this.dir;
    }

    public void setSourceBuffer(String buffer) throws Exception {
        this.docs.add(new InputBuffer(buffer));
    }

    public void setExpandEntityReferences(boolean expandEntityReferences) {
        this.expandEntityReferences = expandEntityReferences;
    }

    public void setSource(String source) throws Exception {
        if (source.indexOf("*") != -1) {
            this.log("Wildcarded source now deprecated in favour of <fileset> usage", 1);
            String basedir = null;
            DirectoryScanner ds = new DirectoryScanner();
            String includes = null;
            if (new File(source).isAbsolute()) {
                int wildcard = source.indexOf("*");
                basedir = source.substring(0, source.lastIndexOf(File.separator, wildcard));
                includes = source.substring(source.lastIndexOf(File.separator, wildcard) + 1);
                ds.setIncludes(new String[]{includes});
            } else {
                basedir = this.getPathPrefix();
                includes = source;
            }
            ds.setIncludes(new String[]{includes});
            ds.setBasedir(basedir);
            this.log("Scanning for " + includes + " from " + basedir, 3);
            ds.scan();
            for (int d = 0; d < ds.getIncludedFiles().length; ++d) {
                String included = basedir + File.separator + ds.getIncludedFiles()[d];
                this.log("Adding " + included, 3);
                this.docs.add(new InputFile(included, basedir));
            }
        } else {
            File sf = new File(source);
            this.docs = new ArrayList();
            String file = source;
            if (!sf.isAbsolute()) {
                file = this.getPathPrefix() + source;
                this.docs.add(new InputFile(file, this.getPathPrefix()));
            } else {
                this.docs.add(new InputFile(file));
            }
            this.log("Reading " + file, 3);
        }
    }

    public void addConfiguredXMLCatalog(XMLCatalog catalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(catalog);
    }

    private Document createDocument() throws Exception {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        DocumentBuilder builder = dfactory.newDocumentBuilder();
        return builder.newDocument();
    }

    private Document documentFromStream(InputStream is) throws Exception {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        dfactory.setExpandEntityReferences(this.expandEntityReferences);
        DocumentBuilder builder = dfactory.newDocumentBuilder();
        if (this.resolver.registeredEntities() > 0) {
            this.log("Using local entity references", 3);
            builder.setEntityResolver(this.resolver);
        } else {
            this.log("Using predefined xml catalog", 3);
            builder.setEntityResolver((EntityResolver)this.xmlCatalog);
        }
        InputSource in = new InputSource(is);
        try {
            Document doc = builder.parse(in);
            this.encoding = in.getEncoding();
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (UnknownHostException e) {
            this.reportNetworkError();
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        catch (ConnectException e) {
            this.reportNetworkError();
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void reportNetworkError() {
        this.log("It looks like you've got a network error. The probable cause", 0);
        this.log("is that you're trying to resolve a DTD on the internet although", 0);
        this.log("you don't know it! Check your XML for DTDs external to your network", 0);
        this.log("and read the Ant documentation for <xmlcatalog>. XMLTask will support", 0);
        this.log("usage of <xmlcatalog>. See the following:", 0);
        this.log("http://ant.apache.org/manual/CoreTypes/xmlcatalog.html", 0);
        this.log("http://www.oopsconsultancy.com/software/xmltask", 0);
        this.log("If this isn't the problem, then please report this error to the support", 0);
        this.log("mailing list. Thanks!", 0);
    }

    private Document documentFromFile(String filename) throws Exception {
        return this.documentFromStream(new FileInputStream(filename));
    }

    private Document documentFromStr(String str) throws Exception {
        return this.documentFromStream((InputStream)new StringInputStream(str));
    }

    public void setDest(String dest) {
        this.dest = dest;
        this.todir = false;
        this.tobuffer = false;
    }

    public void setDestBuffer(String dest) {
        this.dest = dest;
        this.todir = false;
        this.tobuffer = true;
    }

    public void setOutputter(String outputter) {
        this.outputter = outputter;
    }

    public void setTodir(String dest) {
        this.dest = dest;
        this.todir = true;
        this.tobuffer = false;
    }

    public void setEncoding(String enc) {
        this.outputEncoding = enc;
    }

    public void add(XmlReplace xmlr) {
        xmlr.setTask(this);
        this.replacements.add(xmlr);
    }

    public void setReport(boolean report) {
        this.reporting = report;
    }

    public void setOmitHeader(boolean omitHeader) {
        this.omitHeader = omitHeader;
    }

    public void setStandAlone(boolean standalone) {
        this.standalone = standalone;
        this.settingStandalone = true;
    }

    private void setVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
        this.settingVersion = true;
    }

    public void setNormalize(boolean norm) {
        this.normalize = norm;
    }

    public void setClearBuffers(String bufferset) {
        StringTokenizer st = new StringTokenizer(bufferset, ",");
        ArrayList<String> res = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            res.add(st.nextToken());
        }
        this.buffers = res.toArray(new String[0]);
    }

    public void setIndent(boolean in) {
        this.indent = in;
    }

    private String getVersion() {
        Properties props = new Properties();
        try {
            props.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("xmltask.properties"));
        }
        catch (Exception e) {
            // empty catch block
        }
        String version = props.getProperty("com.oopsconsultancy.xmltask.version");
        return version == null ? "[no version info]" : version;
    }

    public void execute() throws BuildException {
        File fdest;
        this.log("Executing xmltask " + this.getVersion(), 3);
        if (!this.filesets.isEmpty()) {
            if (this.docs.size() > 0) {
                throw new BuildException("Can't use filesets together with source inputs");
            }
            Iterator iter = this.filesets.iterator();
            int count = 0;
            FileSet fs = null;
            while (iter.hasNext()) {
                fs = (FileSet)iter.next();
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File srcDir = fs.getDir(this.getProject());
                String[] srcFiles = ds.getIncludedFiles();
                for (int i = 0; i < srcFiles.length; ++i) {
                    String path = srcFiles[i];
                    this.docs.add(new InputFile(srcDir.getAbsolutePath() + File.separator + path, srcDir.getAbsolutePath()));
                }
                count += srcFiles.length;
            }
            if (count == 0) {
                return;
            }
        }
        if (this.docs.size() == 0 && this.todir) {
            throw new BuildException("No input documents");
        }
        if (this.docs.size() == 0) {
            this.docs.add(null);
        }
        if (this.docs.size() > 1 && !this.todir && this.dest != null) {
            throw new BuildException("Multiple inputs (" + this.docs.size() + ") but only one output file");
        }
        if (this.dest == null && this.todir) {
            throw new BuildException("No output directory");
        }
        if (this.dest != null && !this.tobuffer && !(fdest = new File(this.dest)).isAbsolute()) {
            this.dest = this.getPathPrefix() + this.dest;
        }
        for (int b = 0; b < this.buffers.length; ++b) {
            BufferStore.clear(this.buffers[b], this);
        }
        for (int d = 0; d < this.docs.size(); ++d) {
            String destfile;
            InputSpec spec = (InputSpec)this.docs.get(d);
            this.log("Processing " + (spec == null ? "" : spec.getName()) + (this.dest == null ? " [no output document]" : " into " + this.dest), 3);
            Document document = null;
            try {
                document = spec instanceof InputSpec ? spec.getDocument() : this.createDocument();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException(e.getMessage());
            }
            String string = destfile = spec != null ? spec.getName() : null;
            if (this.todir) {
                if (spec instanceof InputFile) {
                    destfile = destfile.substring(((InputFile)spec).getBase().length());
                } else {
                    throw new BuildException("Can't write to a directory with a non-file input");
                }
            }
            this.processDoc(document, destfile);
        }
        this.docs.clear();
    }

    private void processDoc(Document doc, String name) throws BuildException {
        try {
            DocumentType dt = doc.getDoctype();
            if (dt != null && this.preservetype) {
                this.log("Pub = " + dt.getPublicId(), 3);
                this.log("Sys = " + dt.getSystemId(), 3);
            }
            XmlReplacement replacement = new XmlReplacement(doc, this);
            for (int r = 0; r < this.replacements.size(); ++r) {
                replacement.add((XmlReplace)this.replacements.get(r));
            }
            replacement.setReport(this.reporting);
            doc = replacement.apply();
            if (replacement.getFailures() > 0 && this.failWithoutMatch) {
                throw new BuildException("<xmltask> subtasks failed to find matches");
            }
            if (this.dest != null) {
                if (this.tobuffer) {
                    BufferStore.set(this.dest, doc.getDocumentElement(), false, this);
                } else {
                    Transformer serializer = TransformerFactory.newInstance().newTransformer();
                    serializer.setOutputProperty("omit-xml-declaration", this.omitHeader ? "yes" : "no");
                    if (this.settingStandalone) {
                        serializer.setOutputProperty("standalone", this.standalone ? "yes" : "no");
                    }
                    if (this.settingVersion) {
                        serializer.setOutputProperty("version", this.xmlVersion);
                    }
                    if (this.preservetype) {
                        if (dt != null) {
                            if (dt.getPublicId() != null) {
                                serializer.setOutputProperty("doctype-public", dt.getPublicId());
                            }
                            if (dt != null && dt.getSystemId() != null) {
                                serializer.setOutputProperty("doctype-system", dt.getSystemId());
                            } else {
                                serializer.setOutputProperty("doctype-system", "");
                            }
                        }
                    } else {
                        if (this.doctype_public != null) {
                            serializer.setOutputProperty("doctype-public", this.doctype_public);
                        }
                        if (this.doctype_system != null) {
                            serializer.setOutputProperty("doctype-system", this.doctype_system);
                        }
                    }
                    if (this.normalize && doc != null && doc.getDocumentElement() != null) {
                        this.log("Normalizing resultant document", 3);
                        doc.getDocumentElement().normalize();
                    }
                    if (this.indent) {
                        this.log("Indenting resultant document", 3);
                        serializer.setOutputProperty("indent", "yes");
                    } else {
                        serializer.setOutputProperty("indent", "no");
                    }
                    Writer w = null;
                    if (!this.todir) {
                        w = this.getWriter(this.dest, serializer);
                    } else {
                        String destname = this.dest + File.separator + name;
                        this.log("Writing " + destname, 3);
                        File dir = new File(destname).getParentFile();
                        if (!dir.exists() && !dir.mkdirs()) {
                            throw new Exception("Failed to make destination directory " + this.dest);
                        }
                        w = this.getWriter(destname, serializer);
                    }
                    Result res = null;
                    if (FMT_NONE.equals(this.outputter)) {
                        res = new StreamResult(w);
                    } else if (this.outputter.startsWith(FMT_SIMPLE)) {
                        FormattedDataWriter dw = new FormattedDataWriter();
                        dw.setWriter(w);
                        dw.setIndentStep(2);
                        if (this.outputter.indexOf(":") != -1) {
                            String fmt = this.outputter.substring(this.outputter.indexOf(":") + 1);
                            dw.setIndentStep(Integer.parseInt(fmt));
                        }
                        dw.setTransformer(serializer);
                        res = new SAXResult(dw);
                    } else {
                        this.log("Loading custom result writer " + this.outputter, 3);
                        Outputter op = (Outputter)Class.forName(this.outputter).newInstance();
                        op.setWriter(w);
                        op.setTransformer(serializer);
                        res = new SAXResult(op);
                    }
                    serializer.transform(new DOMSource(doc), res);
                    w.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException("Can't create " + this.dest);
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e.getMessage());
        }
    }

    private Writer getWriter(String filename, Transformer serializer) throws IOException {
        String enc = this.outputEncoding;
        if (enc == null) {
            enc = this.encoding;
        }
        if (enc != null) {
            this.log("Using output character encoding " + enc, 3);
            serializer.setOutputProperty("encoding", enc);
            return new OutputStreamWriter((OutputStream)new FileOutputStream(filename), enc);
        }
        return new FileWriter(filename);
    }

    public void addConfiguredReplace(Replace replace) {
        replace.process(this);
    }

    public void addConfiguredRemove(Remove remove) {
        remove.process(this);
    }

    public void addConfiguredAttr(Attr attr) {
        attr.process(this);
    }

    public void addConfiguredInsert(Insert insert) {
        insert.process(this);
    }

    public void addConfiguredPaste(Paste paste) {
        paste.process(this);
    }

    public void addConfiguredUncomment(Uncomment uncomment) {
        uncomment.process(this);
    }

    public void addConfiguredCopy(Copy copy) {
        copy.process(this);
    }

    public void addConfiguredCall(Call call) {
        call.process(this);
    }

    public void addConfiguredCut(Cut cut) {
        cut.process(this);
    }

    public void addConfiguredRename(Rename rename) {
        rename.process(this);
    }

    public Entity createEntity() {
        return new Entity(this);
    }

    public void addConfiguredPrint(Print print) {
        print.process(this);
    }

    public void registerEntity(String remote, String local) {
        this.resolver.registerEntity(this, remote, local);
    }

    public void setFailWithoutMatch(boolean f) {
        this.failWithoutMatch = f;
    }

    public boolean isFailWithoutMatch() {
        return this.failWithoutMatch;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public static class LocalEntityResolver
    implements EntityResolver {
        private Map entities = new HashMap();

        public InputSource resolveEntity(String publicId, String systemId) {
            String local = null;
            if (this.entities.containsKey(publicId)) {
                local = (String)this.entities.get(publicId);
            } else if (this.entities.containsKey(systemId)) {
                local = (String)this.entities.get(systemId);
            }
            if (local != null) {
                if (local.equals("")) {
                    return new InputSource(new StringReader(""));
                }
                return new InputSource(local);
            }
            return null;
        }

        public void registerEntity(XmlTask task, String remote, String local) {
            if (!local.equals("") && !new File(local).isAbsolute() && local.indexOf("://") == -1) {
                local = task.getPathPrefix() + local;
            }
            this.entities.put(remote, local);
        }

        public int registeredEntities() {
            return this.entities.keySet().size();
        }
    }

    public class InputBuffer
    extends InputSpec {
        public InputBuffer(String name) {
            super(name);
        }

        public Document getDocument() throws Exception {
            Node[] nodes = BufferStore.get(this.getName(), XmlTask.this);
            if (nodes == null) {
                return XmlTask.this.createDocument();
            }
            if (nodes.length != 1) {
                throw new BuildException("Cannot use multiple buffer nodes as an input source");
            }
            Document document = XmlTask.this.createDocument();
            Node orig = nodes[0];
            if (orig instanceof Document) {
                orig = ((Document)orig).getDocumentElement();
            }
            Node newnode = document.importNode(orig, true);
            document.appendChild(newnode);
            return document;
        }
    }

    public class InputProperty
    extends InputSpec {
        protected String base;

        public InputProperty(String name) {
            super(name);
            this.base = null;
        }

        public Document getDocument() throws Exception {
            return XmlTask.this.documentFromStr(XmlTask.this.getProject().getProperty(this.name));
        }
    }

    public class InputFile
    extends InputSpec {
        protected String base;

        public InputFile(String name) {
            super(name);
            this.base = null;
        }

        public InputFile(String name, String base) {
            super(name);
            this.base = null;
            this.base = base;
        }

        public String getBase() {
            return this.base;
        }

        public Document getDocument() throws Exception {
            return XmlTask.this.documentFromFile(this.getName());
        }
    }

    public abstract class InputSpec {
        protected String name = null;

        public InputSpec(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public abstract Document getDocument() throws Exception;
    }
}

