/*
 * Decompiled with CFR 0.152.
 */
package samples.mediators;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractMediator;

public class BinaryExtractMediator
extends AbstractMediator {
    private static final Log log = LogFactory.getLog(BinaryExtractMediator.class);
    private static final String PROP_NAME = "SearchKey";
    private int length = 1;
    private int offset = 1;
    private int dataType = 1;
    private String binaryEncoding = "utf-8";
    private String variableName = "SearchKey";

    public boolean mediate(MessageContext msgCtx) {
        try {
            log.debug((Object)("BinaryExtractMediator Process, with offset: " + this.offset + " ,length " + this.length));
            SOAPBody soapBody = msgCtx.getEnvelope().getBody();
            OMElement firstElement = soapBody.getFirstElement();
            log.debug((Object)("First Element : " + firstElement.getLocalName()));
            log.debug((Object)("First Element Text : " + firstElement.getText()));
            OMText binaryNode = (OMText)firstElement.getFirstOMChild();
            log.debug((Object)("First Element Node Text : " + binaryNode.getText()));
            DataHandler dataHandler = (DataHandler)binaryNode.getDataHandler();
            InputStream inputStream = dataHandler.getInputStream();
            byte[] searchByte = new byte[this.length];
            inputStream.skip(this.offset - 1);
            int readBytes = inputStream.read(searchByte, 0, this.length);
            String outString = new String(searchByte, this.binaryEncoding);
            msgCtx.setProperty(this.variableName, (Object)outString);
            log.debug((Object)("Set property to MsgCtx, " + this.variableName + " = " + outString));
            inputStream.close();
        }
        catch (IOException e) {
            log.error((Object)("Excepton on mediation : " + e.getMessage()));
        }
        return true;
    }

    public String getType() {
        return null;
    }

    public void setTraceState(int traceState) {
        this.traceState = traceState;
    }

    public int getTraceState() {
        return this.traceState;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getBinaryEncoding() {
        return this.binaryEncoding;
    }

    public void setBinaryEncoding(String binaryEncoding) {
        this.binaryEncoding = binaryEncoding;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }
}

