/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerState;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;
import org.apache.synapse.deployers.SynapseArtifactDeploymentException;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.util.LibDeployerUtils;

public class LibraryArtifactDeployer
extends AbstractSynapseArtifactDeployer {
    private static final Log log = LogFactory.getLog(LibraryArtifactDeployer.class);

    @Override
    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String libFilePath = FilenameUtils.normalize((String)deploymentFileData.getAbsolutePath());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deployment of the synapse library artifact from file : " + libFilePath + " : STARTED"));
        }
        if (this.getServerContextInformation().getServerState() != ServerState.STARTED) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipped the library artifact deployment (since the Synapse server doesn't seem to be started yet), from file : " + deploymentFileData.getAbsolutePath()));
            }
            return;
        }
        try {
            SynapseArtifactDeploymentStore deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore();
            Library lib = LibDeployerUtils.createSynapseLibrary(libFilePath);
            String libArtifactName = lib.getQName().toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created the Synapse Library : " + libArtifactName + "  from : " + libFilePath));
            }
            if (deploymentStore.isUpdatingArtifact(libFilePath)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating Library artifact detected with filename : " + libFilePath));
                }
                String existingArtifactName = deploymentStore.getUpdatingArtifactWithFileName(libFilePath);
                deploymentStore.removeUpdatingArtifact(libFilePath);
                this.undeploySynapseArtifact(existingArtifactName);
                this.completeDeployment(lib, libArtifactName);
            } else {
                try {
                    this.completeDeployment(lib, libArtifactName);
                }
                catch (SynapseArtifactDeploymentException sade) {
                    log.error((Object)("Deployment of the Synapse Artifact from file : " + libFilePath + " : Failed!"), (Throwable)sade);
                }
            }
            if (libArtifactName != null) {
                deploymentStore.addArtifact(libFilePath, libArtifactName);
            }
            log.info((Object)("Synapse Library named '" + lib.toString() + "' has been deployed from file : " + libFilePath));
        }
        catch (IOException ex) {
            this.handleDeploymentError("Deployment of synapse artifact failed. Error reading " + libFilePath + " : " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            this.handleDeploymentError("Deployment of synapse artifact failed for synapse libray at : " + libFilePath + " : " + ex.getMessage(), ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deployment of the synapse artifact from file : " + libFilePath + " : COMPLETED"));
        }
    }

    private void completeDeployment(Library lib, String libArtifactName) throws DeploymentException {
        SynapseImport synImport;
        this.getSynapseConfiguration().addSynapseLibrary(lib.getQName().toString(), lib);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Synapse Library Deployment for lib: " + libArtifactName + " Completed"));
        }
        if ((synImport = this.getSynapseConfiguration().getSynapseImports().get(libArtifactName)) != null) {
            LibDeployerUtils.loadLibArtifacts(synImport, lib);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading Synapse Library: " + libArtifactName + " into memory for Import"));
            }
        }
    }

    @Override
    public void undeploy(String fileName) throws DeploymentException {
        SynapseArtifactDeploymentStore deploymentStore;
        fileName = FilenameUtils.normalize((String)fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("UnDeployment of the synapse library from file : " + fileName + " : STARTED"));
        }
        if ((deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore()).containsFileName(fileName)) {
            File undeployingFile = new File(fileName);
            if (undeployingFile.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Marking artifact as updating from file : " + fileName));
                }
                if (!deploymentStore.isRestoredFile(fileName)) {
                    deploymentStore.addUpdatingArtifact(fileName, deploymentStore.getArtifactNameForFile(fileName));
                    deploymentStore.removeArtifactWithFileName(fileName);
                }
            } else {
                String artifactName = deploymentStore.getArtifactNameForFile(fileName);
                try {
                    this.undeploySynapseArtifact(artifactName);
                    deploymentStore.removeArtifactWithFileName(fileName);
                    log.info((Object)("Synapse Library named '" + artifactName + "' has been undeployed"));
                }
                catch (SynapseArtifactDeploymentException sade) {
                    log.error((Object)("Unable to undeploy the synapse library artifact from file : " + fileName), (Throwable)sade);
                }
            }
        } else {
            String msg = "Artifact representing the filename " + fileName + " is not deployed on Synapse";
            log.error((Object)msg);
            throw new DeploymentException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("UnDeployment of the synapse library artifact from file : " + fileName + " : COMPLETED"));
        }
    }

    @Override
    public void undeploySynapseArtifact(String artifactName) {
        Library existingLib = null;
        try {
            existingLib = this.getSynapseConfiguration().getSynapseLibraries().get(artifactName);
            existingLib.unLoadLibrary();
            this.getSynapseConfiguration().removeSynapseLibrary(artifactName);
        }
        catch (DeploymentException e) {
            this.handleDeploymentError(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void handleDeploymentError(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
    }

    @Override
    public void setDirectory(String directory) {
    }

    @Override
    public void setExtension(String extension) {
    }

    @Override
    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        return null;
    }

    @Override
    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        return null;
    }

    @Override
    public void restoreSynapseArtifact(String artifactName) {
    }
}

