/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.Properties;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.core.LoadBalanceMembershipHandler;
import org.apache.synapse.endpoints.DynamicLoadbalanceEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.HttpSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SimpleClientSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SoapSessionDispatcher;

public class DynamicLoadbalanceEndpointSerializer
extends EndpointSerializer {
    @Override
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof DynamicLoadbalanceEndpoint)) {
            this.handleException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        DynamicLoadbalanceEndpoint dynamicLoadbalanceEndpoint = (DynamicLoadbalanceEndpoint)endpoint;
        this.serializeProperties(dynamicLoadbalanceEndpoint, endpointElement);
        this.serializeCommonAttributes(endpoint, endpointElement);
        Dispatcher dispatcher = dynamicLoadbalanceEndpoint.getDispatcher();
        if (dispatcher != null) {
            OMElement sessionElement = this.fac.createOMElement("session", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (dispatcher instanceof SoapSessionDispatcher) {
                sessionElement.addAttribute("type", "soap", null);
            } else if (dispatcher instanceof HttpSessionDispatcher) {
                sessionElement.addAttribute("type", "http", null);
            } else if (dispatcher instanceof SimpleClientSessionDispatcher) {
                sessionElement.addAttribute("type", "simpleClientSession", null);
            } else {
                this.handleException("invalid session dispatcher : " + dispatcher.getClass().getName());
            }
            long sessionTimeout = dynamicLoadbalanceEndpoint.getSessionTimeout();
            if (sessionTimeout != -1L) {
                OMElement sessionTimeoutElement = this.fac.createOMElement("sessionTimeout", SynapseConstants.SYNAPSE_OMNAMESPACE);
                sessionTimeoutElement.setText(String.valueOf(sessionTimeout));
                sessionElement.addChild((OMNode)sessionTimeoutElement);
            }
            endpointElement.addChild((OMNode)sessionElement);
        }
        OMElement dynamicLoadbalanceElement = this.fac.createOMElement("dynamicLoadbalance", SynapseConstants.SYNAPSE_OMNAMESPACE);
        endpointElement.addChild((OMNode)dynamicLoadbalanceElement);
        if (!dynamicLoadbalanceEndpoint.isFailover()) {
            dynamicLoadbalanceElement.addAttribute("failover", "false", null);
        }
        LoadBalanceMembershipHandler loadBalanceMembershipHandler = dynamicLoadbalanceEndpoint.getLbMembershipHandler();
        dynamicLoadbalanceElement.addAttribute("algorithm", loadBalanceMembershipHandler.getLoadbalanceAlgorithm().getClass().getName(), null);
        OMElement membershipHandlerElement = this.fac.createOMElement("membershipHandler", SynapseConstants.SYNAPSE_OMNAMESPACE);
        dynamicLoadbalanceElement.addChild((OMNode)membershipHandlerElement);
        membershipHandlerElement.addAttribute("class", loadBalanceMembershipHandler.getClass().getName(), null);
        Properties membershipHandlerProperties = loadBalanceMembershipHandler.getProperties();
        for (Object property : membershipHandlerProperties.keySet()) {
            OMElement propertyElement = this.fac.createOMElement("property", SynapseConstants.SYNAPSE_OMNAMESPACE);
            membershipHandlerElement.addChild((OMNode)propertyElement);
            propertyElement.addAttribute("name", property.toString(), null);
            propertyElement.addAttribute("value", membershipHandlerProperties.getProperty((String)property), null);
        }
        return endpointElement;
    }
}

