/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class RampartException
extends Exception {
    private static final long serialVersionUID = 8674795537585339704L;
    private static ResourceBundle resources;
    private String faultCode;
    private String faultString;

    public RampartException(String faultCode, Object[] args) {
        super(RampartException.getMessage(faultCode, args));
        this.faultCode = this.getFaultCode(faultCode);
        this.faultString = RampartException.getMessage(faultCode, args);
    }

    private String getFaultCode(String code) {
        return code;
    }

    public RampartException(String faultCode) {
        this(faultCode, (Object[])null);
    }

    public RampartException(String faultCode, Object[] args, Throwable e) {
        super(RampartException.getMessage(faultCode, args), e);
        this.faultCode = faultCode;
        this.faultString = RampartException.getMessage(faultCode, args);
    }

    public RampartException(String faultCode, Throwable e) {
        this(faultCode, null, e);
    }

    protected static String getMessage(String faultCode, Object[] args) {
        String msg = null;
        try {
            msg = MessageFormat.format(resources.getString(faultCode), args);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("Undefined '" + faultCode + "' resource property");
        }
        return msg;
    }

    protected String getFaultCode() {
        return this.faultCode;
    }

    protected String getFaultString() {
        return this.faultString;
    }

    static {
        try {
            resources = ResourceBundle.getBundle("org.apache.rampart.errors");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

